# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GroupInsightsConfigurationArgs',
    'GroupInsightsConfigurationArgsDict',
    'SamplingRuleRecordArgs',
    'SamplingRuleRecordArgsDict',
    'SamplingRuleUpdateArgs',
    'SamplingRuleUpdateArgsDict',
    'SamplingRuleArgs',
    'SamplingRuleArgsDict',
]

MYPY = False

if not MYPY:
    class GroupInsightsConfigurationArgsDict(TypedDict):
        insights_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set the InsightsEnabled value to true to enable insights or false to disable insights.
        """
        notifications_enabled: NotRequired[pulumi.Input[builtins.bool]]
        """
        Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be enabled on a group with InsightsEnabled set to true.
        """
elif False:
    GroupInsightsConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class GroupInsightsConfigurationArgs:
    def __init__(__self__, *,
                 insights_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 notifications_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] insights_enabled: Set the InsightsEnabled value to true to enable insights or false to disable insights.
        :param pulumi.Input[builtins.bool] notifications_enabled: Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be enabled on a group with InsightsEnabled set to true.
        """
        if insights_enabled is not None:
            pulumi.set(__self__, "insights_enabled", insights_enabled)
        if notifications_enabled is not None:
            pulumi.set(__self__, "notifications_enabled", notifications_enabled)

    @property
    @pulumi.getter(name="insightsEnabled")
    def insights_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the InsightsEnabled value to true to enable insights or false to disable insights.
        """
        return pulumi.get(self, "insights_enabled")

    @insights_enabled.setter
    def insights_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "insights_enabled", value)

    @property
    @pulumi.getter(name="notificationsEnabled")
    def notifications_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set the NotificationsEnabled value to true to enable insights notifications. Notifications can only be enabled on a group with InsightsEnabled set to true.
        """
        return pulumi.get(self, "notifications_enabled")

    @notifications_enabled.setter
    def notifications_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "notifications_enabled", value)


if not MYPY:
    class SamplingRuleRecordArgsDict(TypedDict):
        created_at: NotRequired[pulumi.Input[builtins.str]]
        """
        When the rule was created, in Unix time seconds.
        """
        modified_at: NotRequired[pulumi.Input[builtins.str]]
        """
        When the rule was modified, in Unix time seconds.
        """
        sampling_rule: NotRequired[pulumi.Input['SamplingRuleArgsDict']]
elif False:
    SamplingRuleRecordArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamplingRuleRecordArgs:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 modified_at: Optional[pulumi.Input[builtins.str]] = None,
                 sampling_rule: Optional[pulumi.Input['SamplingRuleArgs']] = None):
        """
        :param pulumi.Input[builtins.str] created_at: When the rule was created, in Unix time seconds.
        :param pulumi.Input[builtins.str] modified_at: When the rule was modified, in Unix time seconds.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if sampling_rule is not None:
            pulumi.set(__self__, "sampling_rule", sampling_rule)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the rule was created, in Unix time seconds.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When the rule was modified, in Unix time seconds.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "modified_at", value)

    @property
    @pulumi.getter(name="samplingRule")
    def sampling_rule(self) -> Optional[pulumi.Input['SamplingRuleArgs']]:
        return pulumi.get(self, "sampling_rule")

    @sampling_rule.setter
    def sampling_rule(self, value: Optional[pulumi.Input['SamplingRuleArgs']]):
        pulumi.set(self, "sampling_rule", value)


if not MYPY:
    class SamplingRuleUpdateArgsDict(TypedDict):
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Matches attributes derived from the request.
        """
        fixed_rate: NotRequired[pulumi.Input[builtins.float]]
        """
        The percentage of matching requests to instrument, after the reservoir is exhausted.
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        Matches the hostname from a request URL.
        """
        http_method: NotRequired[pulumi.Input[builtins.str]]
        """
        Matches the HTTP method from a request URL.
        """
        priority: NotRequired[pulumi.Input[builtins.int]]
        """
        The priority of the sampling rule.
        """
        reservoir_size: NotRequired[pulumi.Input[builtins.int]]
        """
        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        """
        resource_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        Matches the ARN of the AWS resource on which the service runs.
        """
        rule_arn: NotRequired[pulumi.Input[builtins.str]]
        rule_name: NotRequired[pulumi.Input[builtins.str]]
        service_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Matches the name that the service uses to identify itself in segments.
        """
        service_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Matches the origin that the service uses to identify its type in segments.
        """
        url_path: NotRequired[pulumi.Input[builtins.str]]
        """
        Matches the path from a request URL.
        """
elif False:
    SamplingRuleUpdateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamplingRuleUpdateArgs:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fixed_rate: Optional[pulumi.Input[builtins.float]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 http_method: Optional[pulumi.Input[builtins.str]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 reservoir_size: Optional[pulumi.Input[builtins.int]] = None,
                 resource_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rule_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_name: Optional[pulumi.Input[builtins.str]] = None,
                 service_type: Optional[pulumi.Input[builtins.str]] = None,
                 url_path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attributes: Matches attributes derived from the request.
        :param pulumi.Input[builtins.float] fixed_rate: The percentage of matching requests to instrument, after the reservoir is exhausted.
        :param pulumi.Input[builtins.str] host: Matches the hostname from a request URL.
        :param pulumi.Input[builtins.str] http_method: Matches the HTTP method from a request URL.
        :param pulumi.Input[builtins.int] priority: The priority of the sampling rule.
        :param pulumi.Input[builtins.int] reservoir_size: A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        :param pulumi.Input[builtins.str] resource_arn: Matches the ARN of the AWS resource on which the service runs.
        :param pulumi.Input[builtins.str] service_name: Matches the name that the service uses to identify itself in segments.
        :param pulumi.Input[builtins.str] service_type: Matches the origin that the service uses to identify its type in segments.
        :param pulumi.Input[builtins.str] url_path: Matches the path from a request URL.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if fixed_rate is not None:
            pulumi.set(__self__, "fixed_rate", fixed_rate)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if reservoir_size is not None:
            pulumi.set(__self__, "reservoir_size", reservoir_size)
        if resource_arn is not None:
            pulumi.set(__self__, "resource_arn", resource_arn)
        if rule_arn is not None:
            pulumi.set(__self__, "rule_arn", rule_arn)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Matches attributes derived from the request.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="fixedRate")
    def fixed_rate(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The percentage of matching requests to instrument, after the reservoir is exhausted.
        """
        return pulumi.get(self, "fixed_rate")

    @fixed_rate.setter
    def fixed_rate(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "fixed_rate", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matches the hostname from a request URL.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matches the HTTP method from a request URL.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of the sampling rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="reservoirSize")
    def reservoir_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        """
        return pulumi.get(self, "reservoir_size")

    @reservoir_size.setter
    def reservoir_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "reservoir_size", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matches the ARN of the AWS resource on which the service runs.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="ruleArn")
    def rule_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "rule_arn")

    @rule_arn.setter
    def rule_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_arn", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matches the name that the service uses to identify itself in segments.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matches the origin that the service uses to identify its type in segments.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Matches the path from a request URL.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url_path", value)


if not MYPY:
    class SamplingRuleArgsDict(TypedDict):
        fixed_rate: pulumi.Input[builtins.float]
        """
        The percentage of matching requests to instrument, after the reservoir is exhausted.
        """
        host: pulumi.Input[builtins.str]
        """
        Matches the hostname from a request URL.
        """
        http_method: pulumi.Input[builtins.str]
        """
        Matches the HTTP method from a request URL.
        """
        priority: pulumi.Input[builtins.int]
        """
        The priority of the sampling rule.
        """
        reservoir_size: pulumi.Input[builtins.int]
        """
        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        """
        resource_arn: pulumi.Input[builtins.str]
        """
        Matches the ARN of the AWS resource on which the service runs.
        """
        service_name: pulumi.Input[builtins.str]
        """
        Matches the name that the service uses to identify itself in segments.
        """
        service_type: pulumi.Input[builtins.str]
        """
        Matches the origin that the service uses to identify its type in segments.
        """
        url_path: pulumi.Input[builtins.str]
        """
        Matches the path from a request URL.
        """
        attributes: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Matches attributes derived from the request.
        """
        rule_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.

        > Specifying a sampling rule by name is recommended, as specifying by ARN will be deprecated in future.
        """
        rule_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the sampling rule. Specify a rule by either name or ARN, but not both.
        """
        version: NotRequired[pulumi.Input[builtins.int]]
        """
        The version of the sampling rule format (1)
        """
elif False:
    SamplingRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SamplingRuleArgs:
    def __init__(__self__, *,
                 fixed_rate: pulumi.Input[builtins.float],
                 host: pulumi.Input[builtins.str],
                 http_method: pulumi.Input[builtins.str],
                 priority: pulumi.Input[builtins.int],
                 reservoir_size: pulumi.Input[builtins.int],
                 resource_arn: pulumi.Input[builtins.str],
                 service_name: pulumi.Input[builtins.str],
                 service_type: pulumi.Input[builtins.str],
                 url_path: pulumi.Input[builtins.str],
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 rule_arn: Optional[pulumi.Input[builtins.str]] = None,
                 rule_name: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        :param pulumi.Input[builtins.float] fixed_rate: The percentage of matching requests to instrument, after the reservoir is exhausted.
        :param pulumi.Input[builtins.str] host: Matches the hostname from a request URL.
        :param pulumi.Input[builtins.str] http_method: Matches the HTTP method from a request URL.
        :param pulumi.Input[builtins.int] priority: The priority of the sampling rule.
        :param pulumi.Input[builtins.int] reservoir_size: A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        :param pulumi.Input[builtins.str] resource_arn: Matches the ARN of the AWS resource on which the service runs.
        :param pulumi.Input[builtins.str] service_name: Matches the name that the service uses to identify itself in segments.
        :param pulumi.Input[builtins.str] service_type: Matches the origin that the service uses to identify its type in segments.
        :param pulumi.Input[builtins.str] url_path: Matches the path from a request URL.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] attributes: Matches attributes derived from the request.
        :param pulumi.Input[builtins.str] rule_arn: The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.
               
               > Specifying a sampling rule by name is recommended, as specifying by ARN will be deprecated in future.
        :param pulumi.Input[builtins.str] rule_name: The name of the sampling rule. Specify a rule by either name or ARN, but not both.
        :param pulumi.Input[builtins.int] version: The version of the sampling rule format (1)
        """
        pulumi.set(__self__, "fixed_rate", fixed_rate)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_method", http_method)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "reservoir_size", reservoir_size)
        pulumi.set(__self__, "resource_arn", resource_arn)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_type", service_type)
        pulumi.set(__self__, "url_path", url_path)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if rule_arn is not None:
            pulumi.set(__self__, "rule_arn", rule_arn)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="fixedRate")
    def fixed_rate(self) -> pulumi.Input[builtins.float]:
        """
        The percentage of matching requests to instrument, after the reservoir is exhausted.
        """
        return pulumi.get(self, "fixed_rate")

    @fixed_rate.setter
    def fixed_rate(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "fixed_rate", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        Matches the hostname from a request URL.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Input[builtins.str]:
        """
        Matches the HTTP method from a request URL.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "http_method", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        The priority of the sampling rule.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="reservoirSize")
    def reservoir_size(self) -> pulumi.Input[builtins.int]:
        """
        A fixed number of matching requests to instrument per second, prior to applying the fixed rate. The reservoir is not used directly by services, but applies to all services using the rule collectively.
        """
        return pulumi.get(self, "reservoir_size")

    @reservoir_size.setter
    def reservoir_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "reservoir_size", value)

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Input[builtins.str]:
        """
        Matches the ARN of the AWS resource on which the service runs.
        """
        return pulumi.get(self, "resource_arn")

    @resource_arn.setter
    def resource_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_arn", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[builtins.str]:
        """
        Matches the name that the service uses to identify itself in segments.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Input[builtins.str]:
        """
        Matches the origin that the service uses to identify its type in segments.
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> pulumi.Input[builtins.str]:
        """
        Matches the path from a request URL.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url_path", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Matches attributes derived from the request.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="ruleArn")
    def rule_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the sampling rule. Specify a rule by either name or ARN, but not both.

        > Specifying a sampling rule by name is recommended, as specifying by ARN will be deprecated in future.
        """
        return pulumi.get(self, "rule_arn")

    @rule_arn.setter
    def rule_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_arn", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the sampling rule. Specify a rule by either name or ARN, but not both.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the sampling rule format (1)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


