# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DataProtectionSettingsCustomPattern',
    'DataProtectionSettingsInlineRedactionConfiguration',
    'DataProtectionSettingsInlineRedactionPattern',
    'DataProtectionSettingsRedactionPlaceHolder',
    'IpAccessSettingsIpRule',
    'UserSettingsCookieSpecification',
    'UserSettingsCookieSynchronizationConfiguration',
    'UserSettingsToolbarConfiguration',
]

@pulumi.output_type
class DataProtectionSettingsCustomPattern(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "patternName":
            suggest = "pattern_name"
        elif key == "patternRegex":
            suggest = "pattern_regex"
        elif key == "keywordRegex":
            suggest = "keyword_regex"
        elif key == "patternDescription":
            suggest = "pattern_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataProtectionSettingsCustomPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataProtectionSettingsCustomPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataProtectionSettingsCustomPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pattern_name: builtins.str,
                 pattern_regex: builtins.str,
                 keyword_regex: Optional[builtins.str] = None,
                 pattern_description: Optional[builtins.str] = None):
        """
        :param builtins.str pattern_name: The pattern name for the custom pattern.
        :param builtins.str pattern_regex: The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: "/ab+c/gi".
        :param builtins.str keyword_regex: The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, "/ab+c/gi"
        :param builtins.str pattern_description: The pattern description for the customer pattern.
        """
        pulumi.set(__self__, "pattern_name", pattern_name)
        pulumi.set(__self__, "pattern_regex", pattern_regex)
        if keyword_regex is not None:
            pulumi.set(__self__, "keyword_regex", keyword_regex)
        if pattern_description is not None:
            pulumi.set(__self__, "pattern_description", pattern_description)

    @property
    @pulumi.getter(name="patternName")
    def pattern_name(self) -> builtins.str:
        """
        The pattern name for the custom pattern.
        """
        return pulumi.get(self, "pattern_name")

    @property
    @pulumi.getter(name="patternRegex")
    def pattern_regex(self) -> builtins.str:
        """
        The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: "/ab+c/gi".
        """
        return pulumi.get(self, "pattern_regex")

    @property
    @pulumi.getter(name="keywordRegex")
    def keyword_regex(self) -> Optional[builtins.str]:
        """
        The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, "/ab+c/gi"
        """
        return pulumi.get(self, "keyword_regex")

    @property
    @pulumi.getter(name="patternDescription")
    def pattern_description(self) -> Optional[builtins.str]:
        """
        The pattern description for the customer pattern.
        """
        return pulumi.get(self, "pattern_description")


@pulumi.output_type
class DataProtectionSettingsInlineRedactionConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inlineRedactionPatterns":
            suggest = "inline_redaction_patterns"
        elif key == "globalConfidenceLevel":
            suggest = "global_confidence_level"
        elif key == "globalEnforcedUrls":
            suggest = "global_enforced_urls"
        elif key == "globalExemptUrls":
            suggest = "global_exempt_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataProtectionSettingsInlineRedactionConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataProtectionSettingsInlineRedactionConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataProtectionSettingsInlineRedactionConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline_redaction_patterns: Sequence['outputs.DataProtectionSettingsInlineRedactionPattern'],
                 global_confidence_level: Optional[builtins.float] = None,
                 global_enforced_urls: Optional[Sequence[builtins.str]] = None,
                 global_exempt_urls: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence['DataProtectionSettingsInlineRedactionPattern'] inline_redaction_patterns: The inline redaction patterns to be enabled for the inline redaction configuration.
        :param builtins.float global_confidence_level: The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
        :param Sequence[builtins.str] global_enforced_urls: The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
        :param Sequence[builtins.str] global_exempt_urls: The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
        """
        pulumi.set(__self__, "inline_redaction_patterns", inline_redaction_patterns)
        if global_confidence_level is not None:
            pulumi.set(__self__, "global_confidence_level", global_confidence_level)
        if global_enforced_urls is not None:
            pulumi.set(__self__, "global_enforced_urls", global_enforced_urls)
        if global_exempt_urls is not None:
            pulumi.set(__self__, "global_exempt_urls", global_exempt_urls)

    @property
    @pulumi.getter(name="inlineRedactionPatterns")
    def inline_redaction_patterns(self) -> Sequence['outputs.DataProtectionSettingsInlineRedactionPattern']:
        """
        The inline redaction patterns to be enabled for the inline redaction configuration.
        """
        return pulumi.get(self, "inline_redaction_patterns")

    @property
    @pulumi.getter(name="globalConfidenceLevel")
    def global_confidence_level(self) -> Optional[builtins.float]:
        """
        The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
        """
        return pulumi.get(self, "global_confidence_level")

    @property
    @pulumi.getter(name="globalEnforcedUrls")
    def global_enforced_urls(self) -> Optional[Sequence[builtins.str]]:
        """
        The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
        """
        return pulumi.get(self, "global_enforced_urls")

    @property
    @pulumi.getter(name="globalExemptUrls")
    def global_exempt_urls(self) -> Optional[Sequence[builtins.str]]:
        """
        The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
        """
        return pulumi.get(self, "global_exempt_urls")


@pulumi.output_type
class DataProtectionSettingsInlineRedactionPattern(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redactionPlaceHolder":
            suggest = "redaction_place_holder"
        elif key == "builtInPatternId":
            suggest = "built_in_pattern_id"
        elif key == "confidenceLevel":
            suggest = "confidence_level"
        elif key == "customPattern":
            suggest = "custom_pattern"
        elif key == "enforcedUrls":
            suggest = "enforced_urls"
        elif key == "exemptUrls":
            suggest = "exempt_urls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataProtectionSettingsInlineRedactionPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataProtectionSettingsInlineRedactionPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataProtectionSettingsInlineRedactionPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redaction_place_holder: 'outputs.DataProtectionSettingsRedactionPlaceHolder',
                 built_in_pattern_id: Optional[builtins.str] = None,
                 confidence_level: Optional[builtins.float] = None,
                 custom_pattern: Optional['outputs.DataProtectionSettingsCustomPattern'] = None,
                 enforced_urls: Optional[Sequence[builtins.str]] = None,
                 exempt_urls: Optional[Sequence[builtins.str]] = None):
        """
        :param 'DataProtectionSettingsRedactionPlaceHolder' redaction_place_holder: The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
        :param builtins.str built_in_pattern_id: The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see [Base inline redaction](https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html) .
        :param builtins.float confidence_level: The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
        :param 'DataProtectionSettingsCustomPattern' custom_pattern: The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
        :param Sequence[builtins.str] enforced_urls: The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
        :param Sequence[builtins.str] exempt_urls: The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
        """
        pulumi.set(__self__, "redaction_place_holder", redaction_place_holder)
        if built_in_pattern_id is not None:
            pulumi.set(__self__, "built_in_pattern_id", built_in_pattern_id)
        if confidence_level is not None:
            pulumi.set(__self__, "confidence_level", confidence_level)
        if custom_pattern is not None:
            pulumi.set(__self__, "custom_pattern", custom_pattern)
        if enforced_urls is not None:
            pulumi.set(__self__, "enforced_urls", enforced_urls)
        if exempt_urls is not None:
            pulumi.set(__self__, "exempt_urls", exempt_urls)

    @property
    @pulumi.getter(name="redactionPlaceHolder")
    def redaction_place_holder(self) -> 'outputs.DataProtectionSettingsRedactionPlaceHolder':
        """
        The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
        """
        return pulumi.get(self, "redaction_place_holder")

    @property
    @pulumi.getter(name="builtInPatternId")
    def built_in_pattern_id(self) -> Optional[builtins.str]:
        """
        The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see [Base inline redaction](https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html) .
        """
        return pulumi.get(self, "built_in_pattern_id")

    @property
    @pulumi.getter(name="confidenceLevel")
    def confidence_level(self) -> Optional[builtins.float]:
        """
        The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
        """
        return pulumi.get(self, "confidence_level")

    @property
    @pulumi.getter(name="customPattern")
    def custom_pattern(self) -> Optional['outputs.DataProtectionSettingsCustomPattern']:
        """
        The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
        """
        return pulumi.get(self, "custom_pattern")

    @property
    @pulumi.getter(name="enforcedUrls")
    def enforced_urls(self) -> Optional[Sequence[builtins.str]]:
        """
        The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
        """
        return pulumi.get(self, "enforced_urls")

    @property
    @pulumi.getter(name="exemptUrls")
    def exempt_urls(self) -> Optional[Sequence[builtins.str]]:
        """
        The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
        """
        return pulumi.get(self, "exempt_urls")


@pulumi.output_type
class DataProtectionSettingsRedactionPlaceHolder(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "redactionPlaceHolderType":
            suggest = "redaction_place_holder_type"
        elif key == "redactionPlaceHolderText":
            suggest = "redaction_place_holder_text"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DataProtectionSettingsRedactionPlaceHolder. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DataProtectionSettingsRedactionPlaceHolder.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DataProtectionSettingsRedactionPlaceHolder.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 redaction_place_holder_type: 'DataProtectionSettingsRedactionPlaceHolderType',
                 redaction_place_holder_text: Optional[builtins.str] = None):
        """
        :param 'DataProtectionSettingsRedactionPlaceHolderType' redaction_place_holder_type: The redaction placeholder type that will replace the redacted text in session.
        :param builtins.str redaction_place_holder_text: The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
        """
        pulumi.set(__self__, "redaction_place_holder_type", redaction_place_holder_type)
        if redaction_place_holder_text is not None:
            pulumi.set(__self__, "redaction_place_holder_text", redaction_place_holder_text)

    @property
    @pulumi.getter(name="redactionPlaceHolderType")
    def redaction_place_holder_type(self) -> 'DataProtectionSettingsRedactionPlaceHolderType':
        """
        The redaction placeholder type that will replace the redacted text in session.
        """
        return pulumi.get(self, "redaction_place_holder_type")

    @property
    @pulumi.getter(name="redactionPlaceHolderText")
    def redaction_place_holder_text(self) -> Optional[builtins.str]:
        """
        The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
        """
        return pulumi.get(self, "redaction_place_holder_text")


@pulumi.output_type
class IpAccessSettingsIpRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipRange":
            suggest = "ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IpAccessSettingsIpRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IpAccessSettingsIpRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IpAccessSettingsIpRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_range: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str ip_range: A single IP address or an IP address range in CIDR notation
        :param builtins.str description: The description of the IP rule.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> builtins.str:
        """
        A single IP address or an IP address range in CIDR notation
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the IP rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class UserSettingsCookieSpecification(dict):
    def __init__(__self__, *,
                 domain: builtins.str,
                 name: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None):
        """
        :param builtins.str domain: The domain of the cookie.
        :param builtins.str name: The name of the cookie.
        :param builtins.str path: The path of the cookie.
        """
        pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def domain(self) -> builtins.str:
        """
        The domain of the cookie.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the cookie.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The path of the cookie.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class UserSettingsCookieSynchronizationConfiguration(dict):
    def __init__(__self__, *,
                 allowlist: Sequence['outputs.UserSettingsCookieSpecification'],
                 blocklist: Optional[Sequence['outputs.UserSettingsCookieSpecification']] = None):
        """
        :param Sequence['UserSettingsCookieSpecification'] allowlist: The list of cookie specifications that are allowed to be synchronized to the remote browser.
        :param Sequence['UserSettingsCookieSpecification'] blocklist: The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        pulumi.set(__self__, "allowlist", allowlist)
        if blocklist is not None:
            pulumi.set(__self__, "blocklist", blocklist)

    @property
    @pulumi.getter
    def allowlist(self) -> Sequence['outputs.UserSettingsCookieSpecification']:
        """
        The list of cookie specifications that are allowed to be synchronized to the remote browser.
        """
        return pulumi.get(self, "allowlist")

    @property
    @pulumi.getter
    def blocklist(self) -> Optional[Sequence['outputs.UserSettingsCookieSpecification']]:
        """
        The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        return pulumi.get(self, "blocklist")


@pulumi.output_type
class UserSettingsToolbarConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hiddenToolbarItems":
            suggest = "hidden_toolbar_items"
        elif key == "maxDisplayResolution":
            suggest = "max_display_resolution"
        elif key == "toolbarType":
            suggest = "toolbar_type"
        elif key == "visualMode":
            suggest = "visual_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSettingsToolbarConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSettingsToolbarConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSettingsToolbarConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hidden_toolbar_items: Optional[Sequence['UserSettingsToolbarItem']] = None,
                 max_display_resolution: Optional['UserSettingsMaxDisplayResolution'] = None,
                 toolbar_type: Optional['UserSettingsToolbarType'] = None,
                 visual_mode: Optional['UserSettingsVisualMode'] = None):
        """
        :param Sequence['UserSettingsToolbarItem'] hidden_toolbar_items: The list of toolbar items to be hidden.
        :param 'UserSettingsMaxDisplayResolution' max_display_resolution: The maximum display resolution that is allowed for the session.
        :param 'UserSettingsToolbarType' toolbar_type: The type of toolbar displayed during the session.
        :param 'UserSettingsVisualMode' visual_mode: The visual mode of the toolbar.
        """
        if hidden_toolbar_items is not None:
            pulumi.set(__self__, "hidden_toolbar_items", hidden_toolbar_items)
        if max_display_resolution is not None:
            pulumi.set(__self__, "max_display_resolution", max_display_resolution)
        if toolbar_type is not None:
            pulumi.set(__self__, "toolbar_type", toolbar_type)
        if visual_mode is not None:
            pulumi.set(__self__, "visual_mode", visual_mode)

    @property
    @pulumi.getter(name="hiddenToolbarItems")
    def hidden_toolbar_items(self) -> Optional[Sequence['UserSettingsToolbarItem']]:
        """
        The list of toolbar items to be hidden.
        """
        return pulumi.get(self, "hidden_toolbar_items")

    @property
    @pulumi.getter(name="maxDisplayResolution")
    def max_display_resolution(self) -> Optional['UserSettingsMaxDisplayResolution']:
        """
        The maximum display resolution that is allowed for the session.
        """
        return pulumi.get(self, "max_display_resolution")

    @property
    @pulumi.getter(name="toolbarType")
    def toolbar_type(self) -> Optional['UserSettingsToolbarType']:
        """
        The type of toolbar displayed during the session.
        """
        return pulumi.get(self, "toolbar_type")

    @property
    @pulumi.getter(name="visualMode")
    def visual_mode(self) -> Optional['UserSettingsVisualMode']:
        """
        The visual mode of the toolbar.
        """
        return pulumi.get(self, "visual_mode")


