# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['IdentityProviderArgs', 'IdentityProvider']

@pulumi.input_type
class IdentityProviderArgs:
    def __init__(__self__, *,
                 identity_provider_details: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]],
                 identity_provider_type: pulumi.Input['IdentityProviderType'],
                 identity_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 portal_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a IdentityProvider resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] identity_provider_details: The identity provider details. The following list describes the provider detail keys for each identity provider type.
               
               - For Google and Login with Amazon:
               
               - `client_id`
               - `client_secret`
               - `authorize_scopes`
               - For Facebook:
               
               - `client_id`
               - `client_secret`
               - `authorize_scopes`
               - `api_version`
               - For Sign in with Apple:
               
               - `client_id`
               - `team_id`
               - `key_id`
               - `private_key`
               - `authorize_scopes`
               - For OIDC providers:
               
               - `client_id`
               - `client_secret`
               - `attributes_request_method`
               - `oidc_issuer`
               - `authorize_scopes`
               - `authorize_url` *if not available from discovery URL specified by oidc_issuer key*
               - `token_url` *if not available from discovery URL specified by oidc_issuer key*
               - `attributes_url` *if not available from discovery URL specified by oidc_issuer key*
               - `jwks_uri` *if not available from discovery URL specified by oidc_issuer key*
               - For SAML providers:
               
               - `MetadataFile` OR `MetadataURL`
               - `IDPSignout` (boolean) *optional*
               - `IDPInit` (boolean) *optional*
               - `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
               - `EncryptedResponses` (boolean) *optional*
        :param pulumi.Input['IdentityProviderType'] identity_provider_type: The identity provider type.
        :param pulumi.Input[builtins.str] identity_provider_name: The identity provider name.
        :param pulumi.Input[builtins.str] portal_arn: The ARN of the identity provider.
        """
        pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        pulumi.set(__self__, "identity_provider_type", identity_provider_type)
        if identity_provider_name is not None:
            pulumi.set(__self__, "identity_provider_name", identity_provider_name)
        if portal_arn is not None:
            pulumi.set(__self__, "portal_arn", portal_arn)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]:
        """
        The identity provider details. The following list describes the provider detail keys for each identity provider type.

        - For Google and Login with Amazon:

        - `client_id`
        - `client_secret`
        - `authorize_scopes`
        - For Facebook:

        - `client_id`
        - `client_secret`
        - `authorize_scopes`
        - `api_version`
        - For Sign in with Apple:

        - `client_id`
        - `team_id`
        - `key_id`
        - `private_key`
        - `authorize_scopes`
        - For OIDC providers:

        - `client_id`
        - `client_secret`
        - `attributes_request_method`
        - `oidc_issuer`
        - `authorize_scopes`
        - `authorize_url` *if not available from discovery URL specified by oidc_issuer key*
        - `token_url` *if not available from discovery URL specified by oidc_issuer key*
        - `attributes_url` *if not available from discovery URL specified by oidc_issuer key*
        - `jwks_uri` *if not available from discovery URL specified by oidc_issuer key*
        - For SAML providers:

        - `MetadataFile` OR `MetadataURL`
        - `IDPSignout` (boolean) *optional*
        - `IDPInit` (boolean) *optional*
        - `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
        - `EncryptedResponses` (boolean) *optional*
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]):
        pulumi.set(self, "identity_provider_details", value)

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> pulumi.Input['IdentityProviderType']:
        """
        The identity provider type.
        """
        return pulumi.get(self, "identity_provider_type")

    @identity_provider_type.setter
    def identity_provider_type(self, value: pulumi.Input['IdentityProviderType']):
        pulumi.set(self, "identity_provider_type", value)

    @property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identity provider name.
        """
        return pulumi.get(self, "identity_provider_name")

    @identity_provider_name.setter
    def identity_provider_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "identity_provider_name", value)

    @property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN of the identity provider.
        """
        return pulumi.get(self, "portal_arn")

    @portal_arn.setter
    def portal_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "portal_arn", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:workspacesweb:IdentityProvider")
class IdentityProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_provider_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 identity_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider_type: Optional[pulumi.Input['IdentityProviderType']] = None,
                 portal_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::WorkSpacesWeb::IdentityProvider Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] identity_provider_details: The identity provider details. The following list describes the provider detail keys for each identity provider type.
               
               - For Google and Login with Amazon:
               
               - `client_id`
               - `client_secret`
               - `authorize_scopes`
               - For Facebook:
               
               - `client_id`
               - `client_secret`
               - `authorize_scopes`
               - `api_version`
               - For Sign in with Apple:
               
               - `client_id`
               - `team_id`
               - `key_id`
               - `private_key`
               - `authorize_scopes`
               - For OIDC providers:
               
               - `client_id`
               - `client_secret`
               - `attributes_request_method`
               - `oidc_issuer`
               - `authorize_scopes`
               - `authorize_url` *if not available from discovery URL specified by oidc_issuer key*
               - `token_url` *if not available from discovery URL specified by oidc_issuer key*
               - `attributes_url` *if not available from discovery URL specified by oidc_issuer key*
               - `jwks_uri` *if not available from discovery URL specified by oidc_issuer key*
               - For SAML providers:
               
               - `MetadataFile` OR `MetadataURL`
               - `IDPSignout` (boolean) *optional*
               - `IDPInit` (boolean) *optional*
               - `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
               - `EncryptedResponses` (boolean) *optional*
        :param pulumi.Input[builtins.str] identity_provider_name: The identity provider name.
        :param pulumi.Input['IdentityProviderType'] identity_provider_type: The identity provider type.
        :param pulumi.Input[builtins.str] portal_arn: The ARN of the identity provider.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::WorkSpacesWeb::IdentityProvider Resource Type

        :param str resource_name: The name of the resource.
        :param IdentityProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 identity_provider_details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 identity_provider_name: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider_type: Optional[pulumi.Input['IdentityProviderType']] = None,
                 portal_arn: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityProviderArgs.__new__(IdentityProviderArgs)

            if identity_provider_details is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_details'")
            __props__.__dict__["identity_provider_details"] = identity_provider_details
            __props__.__dict__["identity_provider_name"] = identity_provider_name
            if identity_provider_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_type'")
            __props__.__dict__["identity_provider_type"] = identity_provider_type
            __props__.__dict__["portal_arn"] = portal_arn
            __props__.__dict__["tags"] = tags
            __props__.__dict__["identity_provider_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["portalArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(IdentityProvider, __self__).__init__(
            'aws-native:workspacesweb:IdentityProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'IdentityProvider':
        """
        Get an existing IdentityProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = IdentityProviderArgs.__new__(IdentityProviderArgs)

        __props__.__dict__["identity_provider_arn"] = None
        __props__.__dict__["identity_provider_details"] = None
        __props__.__dict__["identity_provider_name"] = None
        __props__.__dict__["identity_provider_type"] = None
        __props__.__dict__["portal_arn"] = None
        __props__.__dict__["tags"] = None
        return IdentityProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="identityProviderArn")
    def identity_provider_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the identity provider.
        """
        return pulumi.get(self, "identity_provider_arn")

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The identity provider details. The following list describes the provider detail keys for each identity provider type.

        - For Google and Login with Amazon:

        - `client_id`
        - `client_secret`
        - `authorize_scopes`
        - For Facebook:

        - `client_id`
        - `client_secret`
        - `authorize_scopes`
        - `api_version`
        - For Sign in with Apple:

        - `client_id`
        - `team_id`
        - `key_id`
        - `private_key`
        - `authorize_scopes`
        - For OIDC providers:

        - `client_id`
        - `client_secret`
        - `attributes_request_method`
        - `oidc_issuer`
        - `authorize_scopes`
        - `authorize_url` *if not available from discovery URL specified by oidc_issuer key*
        - `token_url` *if not available from discovery URL specified by oidc_issuer key*
        - `attributes_url` *if not available from discovery URL specified by oidc_issuer key*
        - `jwks_uri` *if not available from discovery URL specified by oidc_issuer key*
        - For SAML providers:

        - `MetadataFile` OR `MetadataURL`
        - `IDPSignout` (boolean) *optional*
        - `IDPInit` (boolean) *optional*
        - `RequestSigningAlgorithm` (string) *optional* - Only accepts `rsa-sha256`
        - `EncryptedResponses` (boolean) *optional*
        """
        return pulumi.get(self, "identity_provider_details")

    @property
    @pulumi.getter(name="identityProviderName")
    def identity_provider_name(self) -> pulumi.Output[builtins.str]:
        """
        The identity provider name.
        """
        return pulumi.get(self, "identity_provider_name")

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> pulumi.Output['IdentityProviderType']:
        """
        The identity provider type.
        """
        return pulumi.get(self, "identity_provider_type")

    @property
    @pulumi.getter(name="portalArn")
    def portal_arn(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ARN of the identity provider.
        """
        return pulumi.get(self, "portal_arn")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        return pulumi.get(self, "tags")

