# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetDataProtectionSettingsResult',
    'AwaitableGetDataProtectionSettingsResult',
    'get_data_protection_settings',
    'get_data_protection_settings_output',
]

@pulumi.output_type
class GetDataProtectionSettingsResult:
    def __init__(__self__, associated_portal_arns=None, creation_date=None, data_protection_settings_arn=None, description=None, display_name=None, inline_redaction_configuration=None, tags=None):
        if associated_portal_arns and not isinstance(associated_portal_arns, list):
            raise TypeError("Expected argument 'associated_portal_arns' to be a list")
        pulumi.set(__self__, "associated_portal_arns", associated_portal_arns)
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if data_protection_settings_arn and not isinstance(data_protection_settings_arn, str):
            raise TypeError("Expected argument 'data_protection_settings_arn' to be a str")
        pulumi.set(__self__, "data_protection_settings_arn", data_protection_settings_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if inline_redaction_configuration and not isinstance(inline_redaction_configuration, dict):
            raise TypeError("Expected argument 'inline_redaction_configuration' to be a dict")
        pulumi.set(__self__, "inline_redaction_configuration", inline_redaction_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of web portal ARNs that this data protection settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[builtins.str]:
        """
        The creation date timestamp of the data protection settings.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="dataProtectionSettingsArn")
    def data_protection_settings_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the data protection settings resource.
        """
        return pulumi.get(self, "data_protection_settings_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the data protection settings.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The display name of the data protection settings.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inlineRedactionConfiguration")
    def inline_redaction_configuration(self) -> Optional['outputs.DataProtectionSettingsInlineRedactionConfiguration']:
        """
        The inline redaction configuration for the data protection settings.
        """
        return pulumi.get(self, "inline_redaction_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags of the data protection settings.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDataProtectionSettingsResult(GetDataProtectionSettingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataProtectionSettingsResult(
            associated_portal_arns=self.associated_portal_arns,
            creation_date=self.creation_date,
            data_protection_settings_arn=self.data_protection_settings_arn,
            description=self.description,
            display_name=self.display_name,
            inline_redaction_configuration=self.inline_redaction_configuration,
            tags=self.tags)


def get_data_protection_settings(data_protection_settings_arn: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataProtectionSettingsResult:
    """
    Definition of AWS::WorkSpacesWeb::DataProtectionSettings Resource Type


    :param builtins.str data_protection_settings_arn: The ARN of the data protection settings resource.
    """
    __args__ = dict()
    __args__['dataProtectionSettingsArn'] = data_protection_settings_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:workspacesweb:getDataProtectionSettings', __args__, opts=opts, typ=GetDataProtectionSettingsResult).value

    return AwaitableGetDataProtectionSettingsResult(
        associated_portal_arns=pulumi.get(__ret__, 'associated_portal_arns'),
        creation_date=pulumi.get(__ret__, 'creation_date'),
        data_protection_settings_arn=pulumi.get(__ret__, 'data_protection_settings_arn'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        inline_redaction_configuration=pulumi.get(__ret__, 'inline_redaction_configuration'),
        tags=pulumi.get(__ret__, 'tags'))
def get_data_protection_settings_output(data_protection_settings_arn: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataProtectionSettingsResult]:
    """
    Definition of AWS::WorkSpacesWeb::DataProtectionSettings Resource Type


    :param builtins.str data_protection_settings_arn: The ARN of the data protection settings resource.
    """
    __args__ = dict()
    __args__['dataProtectionSettingsArn'] = data_protection_settings_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:workspacesweb:getDataProtectionSettings', __args__, opts=opts, typ=GetDataProtectionSettingsResult)
    return __ret__.apply(lambda __response__: GetDataProtectionSettingsResult(
        associated_portal_arns=pulumi.get(__response__, 'associated_portal_arns'),
        creation_date=pulumi.get(__response__, 'creation_date'),
        data_protection_settings_arn=pulumi.get(__response__, 'data_protection_settings_arn'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        inline_redaction_configuration=pulumi.get(__response__, 'inline_redaction_configuration'),
        tags=pulumi.get(__response__, 'tags')))
