# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['DataProtectionSettingsArgs', 'DataProtectionSettings']

@pulumi.input_type
class DataProtectionSettingsArgs:
    def __init__(__self__, *,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a DataProtectionSettings resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: The additional encryption context of the data protection settings.
        :param pulumi.Input[builtins.str] customer_managed_key: The customer managed key used to encrypt sensitive information in the data protection settings.
        :param pulumi.Input[builtins.str] description: The description of the data protection settings.
        :param pulumi.Input[builtins.str] display_name: The display name of the data protection settings.
        :param pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs'] inline_redaction_configuration: The inline redaction configuration for the data protection settings.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags of the data protection settings.
        """
        if additional_encryption_context is not None:
            pulumi.set(__self__, "additional_encryption_context", additional_encryption_context)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inline_redaction_configuration is not None:
            pulumi.set(__self__, "inline_redaction_configuration", inline_redaction_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The additional encryption context of the data protection settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @additional_encryption_context.setter
    def additional_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "additional_encryption_context", value)

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The customer managed key used to encrypt sensitive information in the data protection settings.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_managed_key", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the data protection settings.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the data protection settings.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inlineRedactionConfiguration")
    def inline_redaction_configuration(self) -> Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']]:
        """
        The inline redaction configuration for the data protection settings.
        """
        return pulumi.get(self, "inline_redaction_configuration")

    @inline_redaction_configuration.setter
    def inline_redaction_configuration(self, value: Optional[pulumi.Input['DataProtectionSettingsInlineRedactionConfigurationArgs']]):
        pulumi.set(self, "inline_redaction_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags of the data protection settings.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:workspacesweb:DataProtectionSettings")
class DataProtectionSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::WorkSpacesWeb::DataProtectionSettings Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] additional_encryption_context: The additional encryption context of the data protection settings.
        :param pulumi.Input[builtins.str] customer_managed_key: The customer managed key used to encrypt sensitive information in the data protection settings.
        :param pulumi.Input[builtins.str] description: The description of the data protection settings.
        :param pulumi.Input[builtins.str] display_name: The display name of the data protection settings.
        :param pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']] inline_redaction_configuration: The inline redaction configuration for the data protection settings.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags of the data protection settings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DataProtectionSettingsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::WorkSpacesWeb::DataProtectionSettings Resource Type

        :param str resource_name: The name of the resource.
        :param DataProtectionSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataProtectionSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_encryption_context: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 customer_managed_key: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inline_redaction_configuration: Optional[pulumi.Input[Union['DataProtectionSettingsInlineRedactionConfigurationArgs', 'DataProtectionSettingsInlineRedactionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataProtectionSettingsArgs.__new__(DataProtectionSettingsArgs)

            __props__.__dict__["additional_encryption_context"] = additional_encryption_context
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["inline_redaction_configuration"] = inline_redaction_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["associated_portal_arns"] = None
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["data_protection_settings_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["additionalEncryptionContext.*", "customerManagedKey"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(DataProtectionSettings, __self__).__init__(
            'aws-native:workspacesweb:DataProtectionSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'DataProtectionSettings':
        """
        Get an existing DataProtectionSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DataProtectionSettingsArgs.__new__(DataProtectionSettingsArgs)

        __props__.__dict__["additional_encryption_context"] = None
        __props__.__dict__["associated_portal_arns"] = None
        __props__.__dict__["creation_date"] = None
        __props__.__dict__["customer_managed_key"] = None
        __props__.__dict__["data_protection_settings_arn"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["inline_redaction_configuration"] = None
        __props__.__dict__["tags"] = None
        return DataProtectionSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalEncryptionContext")
    def additional_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The additional encryption context of the data protection settings.
        """
        return pulumi.get(self, "additional_encryption_context")

    @property
    @pulumi.getter(name="associatedPortalArns")
    def associated_portal_arns(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A list of web portal ARNs that this data protection settings resource is associated with.
        """
        return pulumi.get(self, "associated_portal_arns")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[builtins.str]:
        """
        The creation date timestamp of the data protection settings.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The customer managed key used to encrypt sensitive information in the data protection settings.
        """
        return pulumi.get(self, "customer_managed_key")

    @property
    @pulumi.getter(name="dataProtectionSettingsArn")
    def data_protection_settings_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the data protection settings resource.
        """
        return pulumi.get(self, "data_protection_settings_arn")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the data protection settings.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The display name of the data protection settings.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inlineRedactionConfiguration")
    def inline_redaction_configuration(self) -> pulumi.Output[Optional['outputs.DataProtectionSettingsInlineRedactionConfiguration']]:
        """
        The inline redaction configuration for the data protection settings.
        """
        return pulumi.get(self, "inline_redaction_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags of the data protection settings.
        """
        return pulumi.get(self, "tags")

