# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'DataProtectionSettingsCustomPatternArgs',
    'DataProtectionSettingsCustomPatternArgsDict',
    'DataProtectionSettingsInlineRedactionConfigurationArgs',
    'DataProtectionSettingsInlineRedactionConfigurationArgsDict',
    'DataProtectionSettingsInlineRedactionPatternArgs',
    'DataProtectionSettingsInlineRedactionPatternArgsDict',
    'DataProtectionSettingsRedactionPlaceHolderArgs',
    'DataProtectionSettingsRedactionPlaceHolderArgsDict',
    'IpAccessSettingsIpRuleArgs',
    'IpAccessSettingsIpRuleArgsDict',
    'UserSettingsCookieSpecificationArgs',
    'UserSettingsCookieSpecificationArgsDict',
    'UserSettingsCookieSynchronizationConfigurationArgs',
    'UserSettingsCookieSynchronizationConfigurationArgsDict',
    'UserSettingsToolbarConfigurationArgs',
    'UserSettingsToolbarConfigurationArgsDict',
]

MYPY = False

if not MYPY:
    class DataProtectionSettingsCustomPatternArgsDict(TypedDict):
        pattern_name: pulumi.Input[builtins.str]
        """
        The pattern name for the custom pattern.
        """
        pattern_regex: pulumi.Input[builtins.str]
        """
        The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: "/ab+c/gi".
        """
        keyword_regex: NotRequired[pulumi.Input[builtins.str]]
        """
        The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, "/ab+c/gi"
        """
        pattern_description: NotRequired[pulumi.Input[builtins.str]]
        """
        The pattern description for the customer pattern.
        """
elif False:
    DataProtectionSettingsCustomPatternArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataProtectionSettingsCustomPatternArgs:
    def __init__(__self__, *,
                 pattern_name: pulumi.Input[builtins.str],
                 pattern_regex: pulumi.Input[builtins.str],
                 keyword_regex: Optional[pulumi.Input[builtins.str]] = None,
                 pattern_description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] pattern_name: The pattern name for the custom pattern.
        :param pulumi.Input[builtins.str] pattern_regex: The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: "/ab+c/gi".
        :param pulumi.Input[builtins.str] keyword_regex: The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, "/ab+c/gi"
        :param pulumi.Input[builtins.str] pattern_description: The pattern description for the customer pattern.
        """
        pulumi.set(__self__, "pattern_name", pattern_name)
        pulumi.set(__self__, "pattern_regex", pattern_regex)
        if keyword_regex is not None:
            pulumi.set(__self__, "keyword_regex", keyword_regex)
        if pattern_description is not None:
            pulumi.set(__self__, "pattern_description", pattern_description)

    @property
    @pulumi.getter(name="patternName")
    def pattern_name(self) -> pulumi.Input[builtins.str]:
        """
        The pattern name for the custom pattern.
        """
        return pulumi.get(self, "pattern_name")

    @pattern_name.setter
    def pattern_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern_name", value)

    @property
    @pulumi.getter(name="patternRegex")
    def pattern_regex(self) -> pulumi.Input[builtins.str]:
        """
        The pattern regex for the customer pattern. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example: "/ab+c/gi".
        """
        return pulumi.get(self, "pattern_regex")

    @pattern_regex.setter
    def pattern_regex(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pattern_regex", value)

    @property
    @pulumi.getter(name="keywordRegex")
    def keyword_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The keyword regex for the customer pattern. After there is a match to the pattern regex, the keyword regex is used to search within the proximity of the match. If there is a keyword match, then the match is confirmed. If no keyword regex is provided, the pattern regex match will automatically be confirmed. The format must follow JavaScript regex format. The pattern must be enclosed between slashes, and can have flags behind the second slash. For example, "/ab+c/gi"
        """
        return pulumi.get(self, "keyword_regex")

    @keyword_regex.setter
    def keyword_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keyword_regex", value)

    @property
    @pulumi.getter(name="patternDescription")
    def pattern_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The pattern description for the customer pattern.
        """
        return pulumi.get(self, "pattern_description")

    @pattern_description.setter
    def pattern_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pattern_description", value)


if not MYPY:
    class DataProtectionSettingsInlineRedactionConfigurationArgsDict(TypedDict):
        inline_redaction_patterns: pulumi.Input[Sequence[pulumi.Input['DataProtectionSettingsInlineRedactionPatternArgsDict']]]
        """
        The inline redaction patterns to be enabled for the inline redaction configuration.
        """
        global_confidence_level: NotRequired[pulumi.Input[builtins.float]]
        """
        The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
        """
        global_enforced_urls: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
        """
        global_exempt_urls: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
        """
elif False:
    DataProtectionSettingsInlineRedactionConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataProtectionSettingsInlineRedactionConfigurationArgs:
    def __init__(__self__, *,
                 inline_redaction_patterns: pulumi.Input[Sequence[pulumi.Input['DataProtectionSettingsInlineRedactionPatternArgs']]],
                 global_confidence_level: Optional[pulumi.Input[builtins.float]] = None,
                 global_enforced_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 global_exempt_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DataProtectionSettingsInlineRedactionPatternArgs']]] inline_redaction_patterns: The inline redaction patterns to be enabled for the inline redaction configuration.
        :param pulumi.Input[builtins.float] global_confidence_level: The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] global_enforced_urls: The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] global_exempt_urls: The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
        """
        pulumi.set(__self__, "inline_redaction_patterns", inline_redaction_patterns)
        if global_confidence_level is not None:
            pulumi.set(__self__, "global_confidence_level", global_confidence_level)
        if global_enforced_urls is not None:
            pulumi.set(__self__, "global_enforced_urls", global_enforced_urls)
        if global_exempt_urls is not None:
            pulumi.set(__self__, "global_exempt_urls", global_exempt_urls)

    @property
    @pulumi.getter(name="inlineRedactionPatterns")
    def inline_redaction_patterns(self) -> pulumi.Input[Sequence[pulumi.Input['DataProtectionSettingsInlineRedactionPatternArgs']]]:
        """
        The inline redaction patterns to be enabled for the inline redaction configuration.
        """
        return pulumi.get(self, "inline_redaction_patterns")

    @inline_redaction_patterns.setter
    def inline_redaction_patterns(self, value: pulumi.Input[Sequence[pulumi.Input['DataProtectionSettingsInlineRedactionPatternArgs']]]):
        pulumi.set(self, "inline_redaction_patterns", value)

    @property
    @pulumi.getter(name="globalConfidenceLevel")
    def global_confidence_level(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The global confidence level for the inline redaction configuration. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
        """
        return pulumi.get(self, "global_confidence_level")

    @global_confidence_level.setter
    def global_confidence_level(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "global_confidence_level", value)

    @property
    @pulumi.getter(name="globalEnforcedUrls")
    def global_enforced_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level enforced URL list.
        """
        return pulumi.get(self, "global_enforced_urls")

    @global_enforced_urls.setter
    def global_enforced_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "global_enforced_urls", value)

    @property
    @pulumi.getter(name="globalExemptUrls")
    def global_exempt_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do not have a pattern-level exempt URL list.
        """
        return pulumi.get(self, "global_exempt_urls")

    @global_exempt_urls.setter
    def global_exempt_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "global_exempt_urls", value)


if not MYPY:
    class DataProtectionSettingsInlineRedactionPatternArgsDict(TypedDict):
        redaction_place_holder: pulumi.Input['DataProtectionSettingsRedactionPlaceHolderArgsDict']
        """
        The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
        """
        built_in_pattern_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see [Base inline redaction](https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html) .
        """
        confidence_level: NotRequired[pulumi.Input[builtins.float]]
        """
        The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
        """
        custom_pattern: NotRequired[pulumi.Input['DataProtectionSettingsCustomPatternArgsDict']]
        """
        The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
        """
        enforced_urls: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
        """
        exempt_urls: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
        """
elif False:
    DataProtectionSettingsInlineRedactionPatternArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataProtectionSettingsInlineRedactionPatternArgs:
    def __init__(__self__, *,
                 redaction_place_holder: pulumi.Input['DataProtectionSettingsRedactionPlaceHolderArgs'],
                 built_in_pattern_id: Optional[pulumi.Input[builtins.str]] = None,
                 confidence_level: Optional[pulumi.Input[builtins.float]] = None,
                 custom_pattern: Optional[pulumi.Input['DataProtectionSettingsCustomPatternArgs']] = None,
                 enforced_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 exempt_urls: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input['DataProtectionSettingsRedactionPlaceHolderArgs'] redaction_place_holder: The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
        :param pulumi.Input[builtins.str] built_in_pattern_id: The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see [Base inline redaction](https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html) .
        :param pulumi.Input[builtins.float] confidence_level: The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
        :param pulumi.Input['DataProtectionSettingsCustomPatternArgs'] custom_pattern: The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] enforced_urls: The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exempt_urls: The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
        """
        pulumi.set(__self__, "redaction_place_holder", redaction_place_holder)
        if built_in_pattern_id is not None:
            pulumi.set(__self__, "built_in_pattern_id", built_in_pattern_id)
        if confidence_level is not None:
            pulumi.set(__self__, "confidence_level", confidence_level)
        if custom_pattern is not None:
            pulumi.set(__self__, "custom_pattern", custom_pattern)
        if enforced_urls is not None:
            pulumi.set(__self__, "enforced_urls", enforced_urls)
        if exempt_urls is not None:
            pulumi.set(__self__, "exempt_urls", exempt_urls)

    @property
    @pulumi.getter(name="redactionPlaceHolder")
    def redaction_place_holder(self) -> pulumi.Input['DataProtectionSettingsRedactionPlaceHolderArgs']:
        """
        The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
        """
        return pulumi.get(self, "redaction_place_holder")

    @redaction_place_holder.setter
    def redaction_place_holder(self, value: pulumi.Input['DataProtectionSettingsRedactionPlaceHolderArgs']):
        pulumi.set(self, "redaction_place_holder", value)

    @property
    @pulumi.getter(name="builtInPatternId")
    def built_in_pattern_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is required. To view the entire list of data types and their corresponding built-in pattern IDs, see [Base inline redaction](https://docs.aws.amazon.com/workspaces-web/latest/adminguide/base-inline-redaction.html) .
        """
        return pulumi.get(self, "built_in_pattern_id")

    @built_in_pattern_id.setter
    def built_in_pattern_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "built_in_pattern_id", value)

    @property
    @pulumi.getter(name="confidenceLevel")
    def confidence_level(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global confidence level.
        """
        return pulumi.get(self, "confidence_level")

    @confidence_level.setter
    def confidence_level(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "confidence_level", value)

    @property
    @pulumi.getter(name="customPattern")
    def custom_pattern(self) -> Optional[pulumi.Input['DataProtectionSettingsCustomPatternArgs']]:
        """
        The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
        """
        return pulumi.get(self, "custom_pattern")

    @custom_pattern.setter
    def custom_pattern(self, value: Optional[pulumi.Input['DataProtectionSettingsCustomPatternArgs']]):
        pulumi.set(self, "custom_pattern", value)

    @property
    @pulumi.getter(name="enforcedUrls")
    def enforced_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL configuration.
        """
        return pulumi.get(self, "enforced_urls")

    @enforced_urls.setter
    def enforced_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "enforced_urls", value)

    @property
    @pulumi.getter(name="exemptUrls")
    def exempt_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL configuration for the inline redaction pattern.
        """
        return pulumi.get(self, "exempt_urls")

    @exempt_urls.setter
    def exempt_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exempt_urls", value)


if not MYPY:
    class DataProtectionSettingsRedactionPlaceHolderArgsDict(TypedDict):
        redaction_place_holder_type: pulumi.Input['DataProtectionSettingsRedactionPlaceHolderType']
        """
        The redaction placeholder type that will replace the redacted text in session.
        """
        redaction_place_holder_text: NotRequired[pulumi.Input[builtins.str]]
        """
        The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
        """
elif False:
    DataProtectionSettingsRedactionPlaceHolderArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DataProtectionSettingsRedactionPlaceHolderArgs:
    def __init__(__self__, *,
                 redaction_place_holder_type: pulumi.Input['DataProtectionSettingsRedactionPlaceHolderType'],
                 redaction_place_holder_text: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['DataProtectionSettingsRedactionPlaceHolderType'] redaction_place_holder_type: The redaction placeholder type that will replace the redacted text in session.
        :param pulumi.Input[builtins.str] redaction_place_holder_text: The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
        """
        pulumi.set(__self__, "redaction_place_holder_type", redaction_place_holder_type)
        if redaction_place_holder_text is not None:
            pulumi.set(__self__, "redaction_place_holder_text", redaction_place_holder_text)

    @property
    @pulumi.getter(name="redactionPlaceHolderType")
    def redaction_place_holder_type(self) -> pulumi.Input['DataProtectionSettingsRedactionPlaceHolderType']:
        """
        The redaction placeholder type that will replace the redacted text in session.
        """
        return pulumi.get(self, "redaction_place_holder_type")

    @redaction_place_holder_type.setter
    def redaction_place_holder_type(self, value: pulumi.Input['DataProtectionSettingsRedactionPlaceHolderType']):
        pulumi.set(self, "redaction_place_holder_type", value)

    @property
    @pulumi.getter(name="redactionPlaceHolderText")
    def redaction_place_holder_text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The redaction placeholder text that will replace the redacted text in session for the custom text redaction placeholder type.
        """
        return pulumi.get(self, "redaction_place_holder_text")

    @redaction_place_holder_text.setter
    def redaction_place_holder_text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "redaction_place_holder_text", value)


if not MYPY:
    class IpAccessSettingsIpRuleArgsDict(TypedDict):
        ip_range: pulumi.Input[builtins.str]
        """
        A single IP address or an IP address range in CIDR notation
        """
        description: NotRequired[pulumi.Input[builtins.str]]
        """
        The description of the IP rule.
        """
elif False:
    IpAccessSettingsIpRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IpAccessSettingsIpRuleArgs:
    def __init__(__self__, *,
                 ip_range: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ip_range: A single IP address or an IP address range in CIDR notation
        :param pulumi.Input[builtins.str] description: The description of the IP rule.
        """
        pulumi.set(__self__, "ip_range", ip_range)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> pulumi.Input[builtins.str]:
        """
        A single IP address or an IP address range in CIDR notation
        """
        return pulumi.get(self, "ip_range")

    @ip_range.setter
    def ip_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ip_range", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the IP rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class UserSettingsCookieSpecificationArgsDict(TypedDict):
        domain: pulumi.Input[builtins.str]
        """
        The domain of the cookie.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the cookie.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The path of the cookie.
        """
elif False:
    UserSettingsCookieSpecificationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserSettingsCookieSpecificationArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] domain: The domain of the cookie.
        :param pulumi.Input[builtins.str] name: The name of the cookie.
        :param pulumi.Input[builtins.str] path: The path of the cookie.
        """
        pulumi.set(__self__, "domain", domain)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[builtins.str]:
        """
        The domain of the cookie.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the cookie.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the cookie.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class UserSettingsCookieSynchronizationConfigurationArgsDict(TypedDict):
        allowlist: pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgsDict']]]
        """
        The list of cookie specifications that are allowed to be synchronized to the remote browser.
        """
        blocklist: NotRequired[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgsDict']]]]
        """
        The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
elif False:
    UserSettingsCookieSynchronizationConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserSettingsCookieSynchronizationConfigurationArgs:
    def __init__(__self__, *,
                 allowlist: pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]],
                 blocklist: Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]] allowlist: The list of cookie specifications that are allowed to be synchronized to the remote browser.
        :param pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]] blocklist: The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        pulumi.set(__self__, "allowlist", allowlist)
        if blocklist is not None:
            pulumi.set(__self__, "blocklist", blocklist)

    @property
    @pulumi.getter
    def allowlist(self) -> pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]:
        """
        The list of cookie specifications that are allowed to be synchronized to the remote browser.
        """
        return pulumi.get(self, "allowlist")

    @allowlist.setter
    def allowlist(self, value: pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]):
        pulumi.set(self, "allowlist", value)

    @property
    @pulumi.getter
    def blocklist(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]]:
        """
        The list of cookie specifications that are blocked from being synchronized to the remote browser.
        """
        return pulumi.get(self, "blocklist")

    @blocklist.setter
    def blocklist(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsCookieSpecificationArgs']]]]):
        pulumi.set(self, "blocklist", value)


if not MYPY:
    class UserSettingsToolbarConfigurationArgsDict(TypedDict):
        hidden_toolbar_items: NotRequired[pulumi.Input[Sequence[pulumi.Input['UserSettingsToolbarItem']]]]
        """
        The list of toolbar items to be hidden.
        """
        max_display_resolution: NotRequired[pulumi.Input['UserSettingsMaxDisplayResolution']]
        """
        The maximum display resolution that is allowed for the session.
        """
        toolbar_type: NotRequired[pulumi.Input['UserSettingsToolbarType']]
        """
        The type of toolbar displayed during the session.
        """
        visual_mode: NotRequired[pulumi.Input['UserSettingsVisualMode']]
        """
        The visual mode of the toolbar.
        """
elif False:
    UserSettingsToolbarConfigurationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserSettingsToolbarConfigurationArgs:
    def __init__(__self__, *,
                 hidden_toolbar_items: Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsToolbarItem']]]] = None,
                 max_display_resolution: Optional[pulumi.Input['UserSettingsMaxDisplayResolution']] = None,
                 toolbar_type: Optional[pulumi.Input['UserSettingsToolbarType']] = None,
                 visual_mode: Optional[pulumi.Input['UserSettingsVisualMode']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['UserSettingsToolbarItem']]] hidden_toolbar_items: The list of toolbar items to be hidden.
        :param pulumi.Input['UserSettingsMaxDisplayResolution'] max_display_resolution: The maximum display resolution that is allowed for the session.
        :param pulumi.Input['UserSettingsToolbarType'] toolbar_type: The type of toolbar displayed during the session.
        :param pulumi.Input['UserSettingsVisualMode'] visual_mode: The visual mode of the toolbar.
        """
        if hidden_toolbar_items is not None:
            pulumi.set(__self__, "hidden_toolbar_items", hidden_toolbar_items)
        if max_display_resolution is not None:
            pulumi.set(__self__, "max_display_resolution", max_display_resolution)
        if toolbar_type is not None:
            pulumi.set(__self__, "toolbar_type", toolbar_type)
        if visual_mode is not None:
            pulumi.set(__self__, "visual_mode", visual_mode)

    @property
    @pulumi.getter(name="hiddenToolbarItems")
    def hidden_toolbar_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsToolbarItem']]]]:
        """
        The list of toolbar items to be hidden.
        """
        return pulumi.get(self, "hidden_toolbar_items")

    @hidden_toolbar_items.setter
    def hidden_toolbar_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UserSettingsToolbarItem']]]]):
        pulumi.set(self, "hidden_toolbar_items", value)

    @property
    @pulumi.getter(name="maxDisplayResolution")
    def max_display_resolution(self) -> Optional[pulumi.Input['UserSettingsMaxDisplayResolution']]:
        """
        The maximum display resolution that is allowed for the session.
        """
        return pulumi.get(self, "max_display_resolution")

    @max_display_resolution.setter
    def max_display_resolution(self, value: Optional[pulumi.Input['UserSettingsMaxDisplayResolution']]):
        pulumi.set(self, "max_display_resolution", value)

    @property
    @pulumi.getter(name="toolbarType")
    def toolbar_type(self) -> Optional[pulumi.Input['UserSettingsToolbarType']]:
        """
        The type of toolbar displayed during the session.
        """
        return pulumi.get(self, "toolbar_type")

    @toolbar_type.setter
    def toolbar_type(self, value: Optional[pulumi.Input['UserSettingsToolbarType']]):
        pulumi.set(self, "toolbar_type", value)

    @property
    @pulumi.getter(name="visualMode")
    def visual_mode(self) -> Optional[pulumi.Input['UserSettingsVisualMode']]:
        """
        The visual mode of the toolbar.
        """
        return pulumi.get(self, "visual_mode")

    @visual_mode.setter
    def visual_mode(self, value: Optional[pulumi.Input['UserSettingsVisualMode']]):
        pulumi.set(self, "visual_mode", value)


