# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['MessageTemplateArgs', 'MessageTemplate']

@pulumi.input_type
class MessageTemplateArgs:
    def __init__(__self__, *,
                 channel_subtype: pulumi.Input['MessageTemplateChannelSubtype'],
                 content: pulumi.Input['MessageTemplateContentArgs'],
                 knowledge_base_arn: pulumi.Input[builtins.str],
                 default_attributes: Optional[pulumi.Input['MessageTemplateAttributesArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 grouping_configuration: Optional[pulumi.Input['MessageTemplateGroupingConfigurationArgs']] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a MessageTemplate resource.
        :param pulumi.Input['MessageTemplateChannelSubtype'] channel_subtype: The channel subtype this message template applies to.
        :param pulumi.Input['MessageTemplateContentArgs'] content: The content of the message template.
        :param pulumi.Input[builtins.str] knowledge_base_arn: The Amazon Resource Name (ARN) of the knowledge base to which the message template belongs.
        :param pulumi.Input['MessageTemplateAttributesArgs'] default_attributes: An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
        :param pulumi.Input[builtins.str] description: The description of the message template.
        :param pulumi.Input['MessageTemplateGroupingConfigurationArgs'] grouping_configuration: The configuration information of the external data source.
        :param pulumi.Input[builtins.str] language: The language code value for the language in which the message template is written. The supported language codes include de_DE, en_US, es_ES, fr_FR, id_ID, it_IT, ja_JP, ko_KR, pt_BR, zh_CN, zh_TW
        :param pulumi.Input[builtins.str] name: The name of the message template.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        pulumi.set(__self__, "channel_subtype", channel_subtype)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "knowledge_base_arn", knowledge_base_arn)
        if default_attributes is not None:
            pulumi.set(__self__, "default_attributes", default_attributes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if grouping_configuration is not None:
            pulumi.set(__self__, "grouping_configuration", grouping_configuration)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="channelSubtype")
    def channel_subtype(self) -> pulumi.Input['MessageTemplateChannelSubtype']:
        """
        The channel subtype this message template applies to.
        """
        return pulumi.get(self, "channel_subtype")

    @channel_subtype.setter
    def channel_subtype(self, value: pulumi.Input['MessageTemplateChannelSubtype']):
        pulumi.set(self, "channel_subtype", value)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input['MessageTemplateContentArgs']:
        """
        The content of the message template.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input['MessageTemplateContentArgs']):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="knowledgeBaseArn")
    def knowledge_base_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the knowledge base to which the message template belongs.
        """
        return pulumi.get(self, "knowledge_base_arn")

    @knowledge_base_arn.setter
    def knowledge_base_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "knowledge_base_arn", value)

    @property
    @pulumi.getter(name="defaultAttributes")
    def default_attributes(self) -> Optional[pulumi.Input['MessageTemplateAttributesArgs']]:
        """
        An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
        """
        return pulumi.get(self, "default_attributes")

    @default_attributes.setter
    def default_attributes(self, value: Optional[pulumi.Input['MessageTemplateAttributesArgs']]):
        pulumi.set(self, "default_attributes", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the message template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> Optional[pulumi.Input['MessageTemplateGroupingConfigurationArgs']]:
        """
        The configuration information of the external data source.
        """
        return pulumi.get(self, "grouping_configuration")

    @grouping_configuration.setter
    def grouping_configuration(self, value: Optional[pulumi.Input['MessageTemplateGroupingConfigurationArgs']]):
        pulumi.set(self, "grouping_configuration", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The language code value for the language in which the message template is written. The supported language codes include de_DE, en_US, es_ES, fr_FR, id_ID, it_IT, ja_JP, ko_KR, pt_BR, zh_CN, zh_TW
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the message template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:wisdom:MessageTemplate")
class MessageTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_subtype: Optional[pulumi.Input['MessageTemplateChannelSubtype']] = None,
                 content: Optional[pulumi.Input[Union['MessageTemplateContentArgs', 'MessageTemplateContentArgsDict']]] = None,
                 default_attributes: Optional[pulumi.Input[Union['MessageTemplateAttributesArgs', 'MessageTemplateAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 grouping_configuration: Optional[pulumi.Input[Union['MessageTemplateGroupingConfigurationArgs', 'MessageTemplateGroupingConfigurationArgsDict']]] = None,
                 knowledge_base_arn: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Definition of AWS::Wisdom::MessageTemplate Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['MessageTemplateChannelSubtype'] channel_subtype: The channel subtype this message template applies to.
        :param pulumi.Input[Union['MessageTemplateContentArgs', 'MessageTemplateContentArgsDict']] content: The content of the message template.
        :param pulumi.Input[Union['MessageTemplateAttributesArgs', 'MessageTemplateAttributesArgsDict']] default_attributes: An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
        :param pulumi.Input[builtins.str] description: The description of the message template.
        :param pulumi.Input[Union['MessageTemplateGroupingConfigurationArgs', 'MessageTemplateGroupingConfigurationArgsDict']] grouping_configuration: The configuration information of the external data source.
        :param pulumi.Input[builtins.str] knowledge_base_arn: The Amazon Resource Name (ARN) of the knowledge base to which the message template belongs.
        :param pulumi.Input[builtins.str] language: The language code value for the language in which the message template is written. The supported language codes include de_DE, en_US, es_ES, fr_FR, id_ID, it_IT, ja_JP, ko_KR, pt_BR, zh_CN, zh_TW
        :param pulumi.Input[builtins.str] name: The name of the message template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MessageTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Wisdom::MessageTemplate Resource Type

        :param str resource_name: The name of the resource.
        :param MessageTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MessageTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channel_subtype: Optional[pulumi.Input['MessageTemplateChannelSubtype']] = None,
                 content: Optional[pulumi.Input[Union['MessageTemplateContentArgs', 'MessageTemplateContentArgsDict']]] = None,
                 default_attributes: Optional[pulumi.Input[Union['MessageTemplateAttributesArgs', 'MessageTemplateAttributesArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 grouping_configuration: Optional[pulumi.Input[Union['MessageTemplateGroupingConfigurationArgs', 'MessageTemplateGroupingConfigurationArgsDict']]] = None,
                 knowledge_base_arn: Optional[pulumi.Input[builtins.str]] = None,
                 language: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MessageTemplateArgs.__new__(MessageTemplateArgs)

            if channel_subtype is None and not opts.urn:
                raise TypeError("Missing required property 'channel_subtype'")
            __props__.__dict__["channel_subtype"] = channel_subtype
            if content is None and not opts.urn:
                raise TypeError("Missing required property 'content'")
            __props__.__dict__["content"] = content
            __props__.__dict__["default_attributes"] = default_attributes
            __props__.__dict__["description"] = description
            __props__.__dict__["grouping_configuration"] = grouping_configuration
            if knowledge_base_arn is None and not opts.urn:
                raise TypeError("Missing required property 'knowledge_base_arn'")
            __props__.__dict__["knowledge_base_arn"] = knowledge_base_arn
            __props__.__dict__["language"] = language
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["message_template_arn"] = None
            __props__.__dict__["message_template_content_sha256"] = None
            __props__.__dict__["message_template_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["channelSubtype", "knowledgeBaseArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(MessageTemplate, __self__).__init__(
            'aws-native:wisdom:MessageTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'MessageTemplate':
        """
        Get an existing MessageTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = MessageTemplateArgs.__new__(MessageTemplateArgs)

        __props__.__dict__["channel_subtype"] = None
        __props__.__dict__["content"] = None
        __props__.__dict__["default_attributes"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["grouping_configuration"] = None
        __props__.__dict__["knowledge_base_arn"] = None
        __props__.__dict__["language"] = None
        __props__.__dict__["message_template_arn"] = None
        __props__.__dict__["message_template_content_sha256"] = None
        __props__.__dict__["message_template_id"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return MessageTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="channelSubtype")
    def channel_subtype(self) -> pulumi.Output['MessageTemplateChannelSubtype']:
        """
        The channel subtype this message template applies to.
        """
        return pulumi.get(self, "channel_subtype")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output['outputs.MessageTemplateContent']:
        """
        The content of the message template.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="defaultAttributes")
    def default_attributes(self) -> pulumi.Output[Optional['outputs.MessageTemplateAttributes']]:
        """
        An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
        """
        return pulumi.get(self, "default_attributes")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the message template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> pulumi.Output[Optional['outputs.MessageTemplateGroupingConfiguration']]:
        """
        The configuration information of the external data source.
        """
        return pulumi.get(self, "grouping_configuration")

    @property
    @pulumi.getter(name="knowledgeBaseArn")
    def knowledge_base_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the knowledge base to which the message template belongs.
        """
        return pulumi.get(self, "knowledge_base_arn")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The language code value for the language in which the message template is written. The supported language codes include de_DE, en_US, es_ES, fr_FR, id_ID, it_IT, ja_JP, ko_KR, pt_BR, zh_CN, zh_TW
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="messageTemplateArn")
    def message_template_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the message template.
        """
        return pulumi.get(self, "message_template_arn")

    @property
    @pulumi.getter(name="messageTemplateContentSha256")
    def message_template_content_sha256(self) -> pulumi.Output[builtins.str]:
        """
        The content SHA256 of the message template.
        """
        return pulumi.get(self, "message_template_content_sha256")

    @property
    @pulumi.getter(name="messageTemplateId")
    def message_template_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier of the message template.
        """
        return pulumi.get(self, "message_template_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the message template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")

