# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetMessageTemplateVersionResult',
    'AwaitableGetMessageTemplateVersionResult',
    'get_message_template_version',
    'get_message_template_version_output',
]

@pulumi.output_type
class GetMessageTemplateVersionResult:
    def __init__(__self__, message_template_content_sha256=None, message_template_version_arn=None, message_template_version_number=None):
        if message_template_content_sha256 and not isinstance(message_template_content_sha256, str):
            raise TypeError("Expected argument 'message_template_content_sha256' to be a str")
        pulumi.set(__self__, "message_template_content_sha256", message_template_content_sha256)
        if message_template_version_arn and not isinstance(message_template_version_arn, str):
            raise TypeError("Expected argument 'message_template_version_arn' to be a str")
        pulumi.set(__self__, "message_template_version_arn", message_template_version_arn)
        if message_template_version_number and not isinstance(message_template_version_number, float):
            raise TypeError("Expected argument 'message_template_version_number' to be a float")
        pulumi.set(__self__, "message_template_version_number", message_template_version_number)

    @property
    @pulumi.getter(name="messageTemplateContentSha256")
    def message_template_content_sha256(self) -> Optional[builtins.str]:
        """
        The content SHA256 of the message template.
        """
        return pulumi.get(self, "message_template_content_sha256")

    @property
    @pulumi.getter(name="messageTemplateVersionArn")
    def message_template_version_arn(self) -> Optional[builtins.str]:
        """
        The unqualified Amazon Resource Name (ARN) of the message template version.
        """
        return pulumi.get(self, "message_template_version_arn")

    @property
    @pulumi.getter(name="messageTemplateVersionNumber")
    def message_template_version_number(self) -> Optional[builtins.float]:
        """
        Current version number of the message template.
        """
        return pulumi.get(self, "message_template_version_number")


class AwaitableGetMessageTemplateVersionResult(GetMessageTemplateVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMessageTemplateVersionResult(
            message_template_content_sha256=self.message_template_content_sha256,
            message_template_version_arn=self.message_template_version_arn,
            message_template_version_number=self.message_template_version_number)


def get_message_template_version(message_template_version_arn: Optional[builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMessageTemplateVersionResult:
    """
    A version for the specified customer-managed message template within the specified knowledge base.


    :param builtins.str message_template_version_arn: The unqualified Amazon Resource Name (ARN) of the message template version.
    """
    __args__ = dict()
    __args__['messageTemplateVersionArn'] = message_template_version_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getMessageTemplateVersion', __args__, opts=opts, typ=GetMessageTemplateVersionResult).value

    return AwaitableGetMessageTemplateVersionResult(
        message_template_content_sha256=pulumi.get(__ret__, 'message_template_content_sha256'),
        message_template_version_arn=pulumi.get(__ret__, 'message_template_version_arn'),
        message_template_version_number=pulumi.get(__ret__, 'message_template_version_number'))
def get_message_template_version_output(message_template_version_arn: Optional[pulumi.Input[builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMessageTemplateVersionResult]:
    """
    A version for the specified customer-managed message template within the specified knowledge base.


    :param builtins.str message_template_version_arn: The unqualified Amazon Resource Name (ARN) of the message template version.
    """
    __args__ = dict()
    __args__['messageTemplateVersionArn'] = message_template_version_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getMessageTemplateVersion', __args__, opts=opts, typ=GetMessageTemplateVersionResult)
    return __ret__.apply(lambda __response__: GetMessageTemplateVersionResult(
        message_template_content_sha256=pulumi.get(__response__, 'message_template_content_sha256'),
        message_template_version_arn=pulumi.get(__response__, 'message_template_version_arn'),
        message_template_version_number=pulumi.get(__response__, 'message_template_version_number')))
