# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetMessageTemplateResult',
    'AwaitableGetMessageTemplateResult',
    'get_message_template',
    'get_message_template_output',
]

@pulumi.output_type
class GetMessageTemplateResult:
    def __init__(__self__, content=None, default_attributes=None, description=None, grouping_configuration=None, language=None, message_template_arn=None, message_template_content_sha256=None, message_template_id=None, name=None, tags=None):
        if content and not isinstance(content, dict):
            raise TypeError("Expected argument 'content' to be a dict")
        pulumi.set(__self__, "content", content)
        if default_attributes and not isinstance(default_attributes, dict):
            raise TypeError("Expected argument 'default_attributes' to be a dict")
        pulumi.set(__self__, "default_attributes", default_attributes)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if grouping_configuration and not isinstance(grouping_configuration, dict):
            raise TypeError("Expected argument 'grouping_configuration' to be a dict")
        pulumi.set(__self__, "grouping_configuration", grouping_configuration)
        if language and not isinstance(language, str):
            raise TypeError("Expected argument 'language' to be a str")
        pulumi.set(__self__, "language", language)
        if message_template_arn and not isinstance(message_template_arn, str):
            raise TypeError("Expected argument 'message_template_arn' to be a str")
        pulumi.set(__self__, "message_template_arn", message_template_arn)
        if message_template_content_sha256 and not isinstance(message_template_content_sha256, str):
            raise TypeError("Expected argument 'message_template_content_sha256' to be a str")
        pulumi.set(__self__, "message_template_content_sha256", message_template_content_sha256)
        if message_template_id and not isinstance(message_template_id, str):
            raise TypeError("Expected argument 'message_template_id' to be a str")
        pulumi.set(__self__, "message_template_id", message_template_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def content(self) -> Optional['outputs.MessageTemplateContent']:
        """
        The content of the message template.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="defaultAttributes")
    def default_attributes(self) -> Optional['outputs.MessageTemplateAttributes']:
        """
        An object that specifies the default values to use for variables in the message template. This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the message template. The corresponding value defines the default value for that variable.
        """
        return pulumi.get(self, "default_attributes")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the message template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="groupingConfiguration")
    def grouping_configuration(self) -> Optional['outputs.MessageTemplateGroupingConfiguration']:
        """
        The configuration information of the external data source.
        """
        return pulumi.get(self, "grouping_configuration")

    @property
    @pulumi.getter
    def language(self) -> Optional[builtins.str]:
        """
        The language code value for the language in which the message template is written. The supported language codes include de_DE, en_US, es_ES, fr_FR, id_ID, it_IT, ja_JP, ko_KR, pt_BR, zh_CN, zh_TW
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="messageTemplateArn")
    def message_template_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the message template.
        """
        return pulumi.get(self, "message_template_arn")

    @property
    @pulumi.getter(name="messageTemplateContentSha256")
    def message_template_content_sha256(self) -> Optional[builtins.str]:
        """
        The content SHA256 of the message template.
        """
        return pulumi.get(self, "message_template_content_sha256")

    @property
    @pulumi.getter(name="messageTemplateId")
    def message_template_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the message template.
        """
        return pulumi.get(self, "message_template_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the message template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.
        """
        return pulumi.get(self, "tags")


class AwaitableGetMessageTemplateResult(GetMessageTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMessageTemplateResult(
            content=self.content,
            default_attributes=self.default_attributes,
            description=self.description,
            grouping_configuration=self.grouping_configuration,
            language=self.language,
            message_template_arn=self.message_template_arn,
            message_template_content_sha256=self.message_template_content_sha256,
            message_template_id=self.message_template_id,
            name=self.name,
            tags=self.tags)


def get_message_template(message_template_arn: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMessageTemplateResult:
    """
    Definition of AWS::Wisdom::MessageTemplate Resource Type


    :param builtins.str message_template_arn: The Amazon Resource Name (ARN) of the message template.
    """
    __args__ = dict()
    __args__['messageTemplateArn'] = message_template_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getMessageTemplate', __args__, opts=opts, typ=GetMessageTemplateResult).value

    return AwaitableGetMessageTemplateResult(
        content=pulumi.get(__ret__, 'content'),
        default_attributes=pulumi.get(__ret__, 'default_attributes'),
        description=pulumi.get(__ret__, 'description'),
        grouping_configuration=pulumi.get(__ret__, 'grouping_configuration'),
        language=pulumi.get(__ret__, 'language'),
        message_template_arn=pulumi.get(__ret__, 'message_template_arn'),
        message_template_content_sha256=pulumi.get(__ret__, 'message_template_content_sha256'),
        message_template_id=pulumi.get(__ret__, 'message_template_id'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_message_template_output(message_template_arn: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetMessageTemplateResult]:
    """
    Definition of AWS::Wisdom::MessageTemplate Resource Type


    :param builtins.str message_template_arn: The Amazon Resource Name (ARN) of the message template.
    """
    __args__ = dict()
    __args__['messageTemplateArn'] = message_template_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getMessageTemplate', __args__, opts=opts, typ=GetMessageTemplateResult)
    return __ret__.apply(lambda __response__: GetMessageTemplateResult(
        content=pulumi.get(__response__, 'content'),
        default_attributes=pulumi.get(__response__, 'default_attributes'),
        description=pulumi.get(__response__, 'description'),
        grouping_configuration=pulumi.get(__response__, 'grouping_configuration'),
        language=pulumi.get(__response__, 'language'),
        message_template_arn=pulumi.get(__response__, 'message_template_arn'),
        message_template_content_sha256=pulumi.get(__response__, 'message_template_content_sha256'),
        message_template_id=pulumi.get(__response__, 'message_template_id'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags')))
