# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetKnowledgeBaseResult',
    'AwaitableGetKnowledgeBaseResult',
    'get_knowledge_base',
    'get_knowledge_base_output',
]

@pulumi.output_type
class GetKnowledgeBaseResult:
    def __init__(__self__, knowledge_base_arn=None, knowledge_base_id=None, rendering_configuration=None, vector_ingestion_configuration=None):
        if knowledge_base_arn and not isinstance(knowledge_base_arn, str):
            raise TypeError("Expected argument 'knowledge_base_arn' to be a str")
        pulumi.set(__self__, "knowledge_base_arn", knowledge_base_arn)
        if knowledge_base_id and not isinstance(knowledge_base_id, str):
            raise TypeError("Expected argument 'knowledge_base_id' to be a str")
        pulumi.set(__self__, "knowledge_base_id", knowledge_base_id)
        if rendering_configuration and not isinstance(rendering_configuration, dict):
            raise TypeError("Expected argument 'rendering_configuration' to be a dict")
        pulumi.set(__self__, "rendering_configuration", rendering_configuration)
        if vector_ingestion_configuration and not isinstance(vector_ingestion_configuration, dict):
            raise TypeError("Expected argument 'vector_ingestion_configuration' to be a dict")
        pulumi.set(__self__, "vector_ingestion_configuration", vector_ingestion_configuration)

    @property
    @pulumi.getter(name="knowledgeBaseArn")
    def knowledge_base_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_arn")

    @property
    @pulumi.getter(name="knowledgeBaseId")
    def knowledge_base_id(self) -> Optional[builtins.str]:
        """
        The ID of the knowledge base.
        """
        return pulumi.get(self, "knowledge_base_id")

    @property
    @pulumi.getter(name="renderingConfiguration")
    def rendering_configuration(self) -> Optional['outputs.KnowledgeBaseRenderingConfiguration']:
        """
        Information about how to render the content.
        """
        return pulumi.get(self, "rendering_configuration")

    @property
    @pulumi.getter(name="vectorIngestionConfiguration")
    def vector_ingestion_configuration(self) -> Optional['outputs.KnowledgeBaseVectorIngestionConfiguration']:
        """
        Contains details about how to ingest the documents in a data source.
        """
        return pulumi.get(self, "vector_ingestion_configuration")


class AwaitableGetKnowledgeBaseResult(GetKnowledgeBaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKnowledgeBaseResult(
            knowledge_base_arn=self.knowledge_base_arn,
            knowledge_base_id=self.knowledge_base_id,
            rendering_configuration=self.rendering_configuration,
            vector_ingestion_configuration=self.vector_ingestion_configuration)


def get_knowledge_base(knowledge_base_id: Optional[builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKnowledgeBaseResult:
    """
    Definition of AWS::Wisdom::KnowledgeBase Resource Type


    :param builtins.str knowledge_base_id: The ID of the knowledge base.
    """
    __args__ = dict()
    __args__['knowledgeBaseId'] = knowledge_base_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getKnowledgeBase', __args__, opts=opts, typ=GetKnowledgeBaseResult).value

    return AwaitableGetKnowledgeBaseResult(
        knowledge_base_arn=pulumi.get(__ret__, 'knowledge_base_arn'),
        knowledge_base_id=pulumi.get(__ret__, 'knowledge_base_id'),
        rendering_configuration=pulumi.get(__ret__, 'rendering_configuration'),
        vector_ingestion_configuration=pulumi.get(__ret__, 'vector_ingestion_configuration'))
def get_knowledge_base_output(knowledge_base_id: Optional[pulumi.Input[builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKnowledgeBaseResult]:
    """
    Definition of AWS::Wisdom::KnowledgeBase Resource Type


    :param builtins.str knowledge_base_id: The ID of the knowledge base.
    """
    __args__ = dict()
    __args__['knowledgeBaseId'] = knowledge_base_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getKnowledgeBase', __args__, opts=opts, typ=GetKnowledgeBaseResult)
    return __ret__.apply(lambda __response__: GetKnowledgeBaseResult(
        knowledge_base_arn=pulumi.get(__response__, 'knowledge_base_arn'),
        knowledge_base_id=pulumi.get(__response__, 'knowledge_base_id'),
        rendering_configuration=pulumi.get(__response__, 'rendering_configuration'),
        vector_ingestion_configuration=pulumi.get(__response__, 'vector_ingestion_configuration')))
