# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAssistantAssociationResult',
    'AwaitableGetAssistantAssociationResult',
    'get_assistant_association',
    'get_assistant_association_output',
]

@pulumi.output_type
class GetAssistantAssociationResult:
    def __init__(__self__, assistant_arn=None, assistant_association_arn=None, assistant_association_id=None):
        if assistant_arn and not isinstance(assistant_arn, str):
            raise TypeError("Expected argument 'assistant_arn' to be a str")
        pulumi.set(__self__, "assistant_arn", assistant_arn)
        if assistant_association_arn and not isinstance(assistant_association_arn, str):
            raise TypeError("Expected argument 'assistant_association_arn' to be a str")
        pulumi.set(__self__, "assistant_association_arn", assistant_association_arn)
        if assistant_association_id and not isinstance(assistant_association_id, str):
            raise TypeError("Expected argument 'assistant_association_id' to be a str")
        pulumi.set(__self__, "assistant_association_id", assistant_association_id)

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Wisdom assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="assistantAssociationArn")
    def assistant_association_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the assistant association.
        """
        return pulumi.get(self, "assistant_association_arn")

    @property
    @pulumi.getter(name="assistantAssociationId")
    def assistant_association_id(self) -> Optional[builtins.str]:
        """
        The ID of the association.
        """
        return pulumi.get(self, "assistant_association_id")


class AwaitableGetAssistantAssociationResult(GetAssistantAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAssistantAssociationResult(
            assistant_arn=self.assistant_arn,
            assistant_association_arn=self.assistant_association_arn,
            assistant_association_id=self.assistant_association_id)


def get_assistant_association(assistant_association_id: Optional[builtins.str] = None,
                              assistant_id: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAssistantAssociationResult:
    """
    Definition of AWS::Wisdom::AssistantAssociation Resource Type


    :param builtins.str assistant_association_id: The ID of the association.
    :param builtins.str assistant_id: The identifier of the Wisdom assistant.
    """
    __args__ = dict()
    __args__['assistantAssociationId'] = assistant_association_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getAssistantAssociation', __args__, opts=opts, typ=GetAssistantAssociationResult).value

    return AwaitableGetAssistantAssociationResult(
        assistant_arn=pulumi.get(__ret__, 'assistant_arn'),
        assistant_association_arn=pulumi.get(__ret__, 'assistant_association_arn'),
        assistant_association_id=pulumi.get(__ret__, 'assistant_association_id'))
def get_assistant_association_output(assistant_association_id: Optional[pulumi.Input[builtins.str]] = None,
                                     assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAssistantAssociationResult]:
    """
    Definition of AWS::Wisdom::AssistantAssociation Resource Type


    :param builtins.str assistant_association_id: The ID of the association.
    :param builtins.str assistant_id: The identifier of the Wisdom assistant.
    """
    __args__ = dict()
    __args__['assistantAssociationId'] = assistant_association_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getAssistantAssociation', __args__, opts=opts, typ=GetAssistantAssociationResult)
    return __ret__.apply(lambda __response__: GetAssistantAssociationResult(
        assistant_arn=pulumi.get(__response__, 'assistant_arn'),
        assistant_association_arn=pulumi.get(__response__, 'assistant_association_arn'),
        assistant_association_id=pulumi.get(__response__, 'assistant_association_id')))
