# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAiPromptResult',
    'AwaitableGetAiPromptResult',
    'get_ai_prompt',
    'get_ai_prompt_output',
]

@pulumi.output_type
class GetAiPromptResult:
    def __init__(__self__, ai_prompt_arn=None, ai_prompt_id=None, assistant_arn=None, description=None, modified_time_seconds=None, template_configuration=None):
        if ai_prompt_arn and not isinstance(ai_prompt_arn, str):
            raise TypeError("Expected argument 'ai_prompt_arn' to be a str")
        pulumi.set(__self__, "ai_prompt_arn", ai_prompt_arn)
        if ai_prompt_id and not isinstance(ai_prompt_id, str):
            raise TypeError("Expected argument 'ai_prompt_id' to be a str")
        pulumi.set(__self__, "ai_prompt_id", ai_prompt_id)
        if assistant_arn and not isinstance(assistant_arn, str):
            raise TypeError("Expected argument 'assistant_arn' to be a str")
        pulumi.set(__self__, "assistant_arn", assistant_arn)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if modified_time_seconds and not isinstance(modified_time_seconds, float):
            raise TypeError("Expected argument 'modified_time_seconds' to be a float")
        pulumi.set(__self__, "modified_time_seconds", modified_time_seconds)
        if template_configuration and not isinstance(template_configuration, dict):
            raise TypeError("Expected argument 'template_configuration' to be a dict")
        pulumi.set(__self__, "template_configuration", template_configuration)

    @property
    @pulumi.getter(name="aiPromptArn")
    def ai_prompt_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AI Prompt.
        """
        return pulumi.get(self, "ai_prompt_arn")

    @property
    @pulumi.getter(name="aiPromptId")
    def ai_prompt_id(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon Q in Connect AI prompt.
        """
        return pulumi.get(self, "ai_prompt_id")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the AI Prompt.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="modifiedTimeSeconds")
    def modified_time_seconds(self) -> Optional[builtins.float]:
        return pulumi.get(self, "modified_time_seconds")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> Optional['outputs.AiPromptAiPromptTemplateConfiguration']:
        """
        The configuration of the prompt template for this AI Prompt.
        """
        return pulumi.get(self, "template_configuration")


class AwaitableGetAiPromptResult(GetAiPromptResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiPromptResult(
            ai_prompt_arn=self.ai_prompt_arn,
            ai_prompt_id=self.ai_prompt_id,
            assistant_arn=self.assistant_arn,
            description=self.description,
            modified_time_seconds=self.modified_time_seconds,
            template_configuration=self.template_configuration)


def get_ai_prompt(ai_prompt_id: Optional[builtins.str] = None,
                  assistant_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiPromptResult:
    """
    Definition of AWS::Wisdom::AIPrompt Resource Type


    :param builtins.str ai_prompt_id: The identifier of the Amazon Q in Connect AI prompt.
    :param builtins.str assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
    """
    __args__ = dict()
    __args__['aiPromptId'] = ai_prompt_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getAiPrompt', __args__, opts=opts, typ=GetAiPromptResult).value

    return AwaitableGetAiPromptResult(
        ai_prompt_arn=pulumi.get(__ret__, 'ai_prompt_arn'),
        ai_prompt_id=pulumi.get(__ret__, 'ai_prompt_id'),
        assistant_arn=pulumi.get(__ret__, 'assistant_arn'),
        description=pulumi.get(__ret__, 'description'),
        modified_time_seconds=pulumi.get(__ret__, 'modified_time_seconds'),
        template_configuration=pulumi.get(__ret__, 'template_configuration'))
def get_ai_prompt_output(ai_prompt_id: Optional[pulumi.Input[builtins.str]] = None,
                         assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAiPromptResult]:
    """
    Definition of AWS::Wisdom::AIPrompt Resource Type


    :param builtins.str ai_prompt_id: The identifier of the Amazon Q in Connect AI prompt.
    :param builtins.str assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
    """
    __args__ = dict()
    __args__['aiPromptId'] = ai_prompt_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getAiPrompt', __args__, opts=opts, typ=GetAiPromptResult)
    return __ret__.apply(lambda __response__: GetAiPromptResult(
        ai_prompt_arn=pulumi.get(__response__, 'ai_prompt_arn'),
        ai_prompt_id=pulumi.get(__response__, 'ai_prompt_id'),
        assistant_arn=pulumi.get(__response__, 'assistant_arn'),
        description=pulumi.get(__response__, 'description'),
        modified_time_seconds=pulumi.get(__response__, 'modified_time_seconds'),
        template_configuration=pulumi.get(__response__, 'template_configuration')))
