# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAiGuardrailVersionResult',
    'AwaitableGetAiGuardrailVersionResult',
    'get_ai_guardrail_version',
    'get_ai_guardrail_version_output',
]

@pulumi.output_type
class GetAiGuardrailVersionResult:
    def __init__(__self__, ai_guardrail_arn=None, ai_guardrail_version_id=None, assistant_arn=None, version_number=None):
        if ai_guardrail_arn and not isinstance(ai_guardrail_arn, str):
            raise TypeError("Expected argument 'ai_guardrail_arn' to be a str")
        pulumi.set(__self__, "ai_guardrail_arn", ai_guardrail_arn)
        if ai_guardrail_version_id and not isinstance(ai_guardrail_version_id, str):
            raise TypeError("Expected argument 'ai_guardrail_version_id' to be a str")
        pulumi.set(__self__, "ai_guardrail_version_id", ai_guardrail_version_id)
        if assistant_arn and not isinstance(assistant_arn, str):
            raise TypeError("Expected argument 'assistant_arn' to be a str")
        pulumi.set(__self__, "assistant_arn", assistant_arn)
        if version_number and not isinstance(version_number, float):
            raise TypeError("Expected argument 'version_number' to be a float")
        pulumi.set(__self__, "version_number", version_number)

    @property
    @pulumi.getter(name="aiGuardrailArn")
    def ai_guardrail_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the AI guardrail version.
        """
        return pulumi.get(self, "ai_guardrail_arn")

    @property
    @pulumi.getter(name="aiGuardrailVersionId")
    def ai_guardrail_version_id(self) -> Optional[builtins.str]:
        """
        The ID of the AI guardrail version.
        """
        return pulumi.get(self, "ai_guardrail_version_id")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the AI guardrail version assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> Optional[builtins.float]:
        """
        The version number for this AI Guardrail version.
        """
        return pulumi.get(self, "version_number")


class AwaitableGetAiGuardrailVersionResult(GetAiGuardrailVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiGuardrailVersionResult(
            ai_guardrail_arn=self.ai_guardrail_arn,
            ai_guardrail_version_id=self.ai_guardrail_version_id,
            assistant_arn=self.assistant_arn,
            version_number=self.version_number)


def get_ai_guardrail_version(ai_guardrail_id: Optional[builtins.str] = None,
                             assistant_id: Optional[builtins.str] = None,
                             version_number: Optional[builtins.float] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiGuardrailVersionResult:
    """
    Definition of AWS::Wisdom::AIGuardrailVersion Resource Type


    :param builtins.str ai_guardrail_id: The ID of the AI guardrail version.
    :param builtins.str assistant_id: The ID of the AI guardrail version assistant.
    :param builtins.float version_number: The version number for this AI Guardrail version.
    """
    __args__ = dict()
    __args__['aiGuardrailId'] = ai_guardrail_id
    __args__['assistantId'] = assistant_id
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getAiGuardrailVersion', __args__, opts=opts, typ=GetAiGuardrailVersionResult).value

    return AwaitableGetAiGuardrailVersionResult(
        ai_guardrail_arn=pulumi.get(__ret__, 'ai_guardrail_arn'),
        ai_guardrail_version_id=pulumi.get(__ret__, 'ai_guardrail_version_id'),
        assistant_arn=pulumi.get(__ret__, 'assistant_arn'),
        version_number=pulumi.get(__ret__, 'version_number'))
def get_ai_guardrail_version_output(ai_guardrail_id: Optional[pulumi.Input[builtins.str]] = None,
                                    assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                                    version_number: Optional[pulumi.Input[builtins.float]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAiGuardrailVersionResult]:
    """
    Definition of AWS::Wisdom::AIGuardrailVersion Resource Type


    :param builtins.str ai_guardrail_id: The ID of the AI guardrail version.
    :param builtins.str assistant_id: The ID of the AI guardrail version assistant.
    :param builtins.float version_number: The version number for this AI Guardrail version.
    """
    __args__ = dict()
    __args__['aiGuardrailId'] = ai_guardrail_id
    __args__['assistantId'] = assistant_id
    __args__['versionNumber'] = version_number
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getAiGuardrailVersion', __args__, opts=opts, typ=GetAiGuardrailVersionResult)
    return __ret__.apply(lambda __response__: GetAiGuardrailVersionResult(
        ai_guardrail_arn=pulumi.get(__response__, 'ai_guardrail_arn'),
        ai_guardrail_version_id=pulumi.get(__response__, 'ai_guardrail_version_id'),
        assistant_arn=pulumi.get(__response__, 'assistant_arn'),
        version_number=pulumi.get(__response__, 'version_number')))
