# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAiGuardrailResult',
    'AwaitableGetAiGuardrailResult',
    'get_ai_guardrail',
    'get_ai_guardrail_output',
]

@pulumi.output_type
class GetAiGuardrailResult:
    def __init__(__self__, ai_guardrail_arn=None, ai_guardrail_id=None, assistant_arn=None, blocked_input_messaging=None, blocked_outputs_messaging=None, content_policy_config=None, contextual_grounding_policy_config=None, description=None, sensitive_information_policy_config=None, topic_policy_config=None, word_policy_config=None):
        if ai_guardrail_arn and not isinstance(ai_guardrail_arn, str):
            raise TypeError("Expected argument 'ai_guardrail_arn' to be a str")
        pulumi.set(__self__, "ai_guardrail_arn", ai_guardrail_arn)
        if ai_guardrail_id and not isinstance(ai_guardrail_id, str):
            raise TypeError("Expected argument 'ai_guardrail_id' to be a str")
        pulumi.set(__self__, "ai_guardrail_id", ai_guardrail_id)
        if assistant_arn and not isinstance(assistant_arn, str):
            raise TypeError("Expected argument 'assistant_arn' to be a str")
        pulumi.set(__self__, "assistant_arn", assistant_arn)
        if blocked_input_messaging and not isinstance(blocked_input_messaging, str):
            raise TypeError("Expected argument 'blocked_input_messaging' to be a str")
        pulumi.set(__self__, "blocked_input_messaging", blocked_input_messaging)
        if blocked_outputs_messaging and not isinstance(blocked_outputs_messaging, str):
            raise TypeError("Expected argument 'blocked_outputs_messaging' to be a str")
        pulumi.set(__self__, "blocked_outputs_messaging", blocked_outputs_messaging)
        if content_policy_config and not isinstance(content_policy_config, dict):
            raise TypeError("Expected argument 'content_policy_config' to be a dict")
        pulumi.set(__self__, "content_policy_config", content_policy_config)
        if contextual_grounding_policy_config and not isinstance(contextual_grounding_policy_config, dict):
            raise TypeError("Expected argument 'contextual_grounding_policy_config' to be a dict")
        pulumi.set(__self__, "contextual_grounding_policy_config", contextual_grounding_policy_config)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if sensitive_information_policy_config and not isinstance(sensitive_information_policy_config, dict):
            raise TypeError("Expected argument 'sensitive_information_policy_config' to be a dict")
        pulumi.set(__self__, "sensitive_information_policy_config", sensitive_information_policy_config)
        if topic_policy_config and not isinstance(topic_policy_config, dict):
            raise TypeError("Expected argument 'topic_policy_config' to be a dict")
        pulumi.set(__self__, "topic_policy_config", topic_policy_config)
        if word_policy_config and not isinstance(word_policy_config, dict):
            raise TypeError("Expected argument 'word_policy_config' to be a dict")
        pulumi.set(__self__, "word_policy_config", word_policy_config)

    @property
    @pulumi.getter(name="aiGuardrailArn")
    def ai_guardrail_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AI Guardrail.
        """
        return pulumi.get(self, "ai_guardrail_arn")

    @property
    @pulumi.getter(name="aiGuardrailId")
    def ai_guardrail_id(self) -> Optional[builtins.str]:
        """
        The identifier of the Amazon Q in Connect AI Guardrail.
        """
        return pulumi.get(self, "ai_guardrail_id")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="blockedInputMessaging")
    def blocked_input_messaging(self) -> Optional[builtins.str]:
        """
        Messaging for when violations are detected in text
        """
        return pulumi.get(self, "blocked_input_messaging")

    @property
    @pulumi.getter(name="blockedOutputsMessaging")
    def blocked_outputs_messaging(self) -> Optional[builtins.str]:
        """
        Messaging for when violations are detected in text
        """
        return pulumi.get(self, "blocked_outputs_messaging")

    @property
    @pulumi.getter(name="contentPolicyConfig")
    def content_policy_config(self) -> Optional['outputs.AiGuardrailAiGuardrailContentPolicyConfig']:
        """
        Contains details about how to handle harmful content.
        """
        return pulumi.get(self, "content_policy_config")

    @property
    @pulumi.getter(name="contextualGroundingPolicyConfig")
    def contextual_grounding_policy_config(self) -> Optional['outputs.AiGuardrailAiGuardrailContextualGroundingPolicyConfig']:
        """
        The policy configuration details for the AI Guardrail's contextual grounding policy.
        """
        return pulumi.get(self, "contextual_grounding_policy_config")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of the guardrail or its version
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="sensitiveInformationPolicyConfig")
    def sensitive_information_policy_config(self) -> Optional['outputs.AiGuardrailAiGuardrailSensitiveInformationPolicyConfig']:
        """
        Contains details about PII entities and regular expressions to configure for the AI Guardrail.
        """
        return pulumi.get(self, "sensitive_information_policy_config")

    @property
    @pulumi.getter(name="topicPolicyConfig")
    def topic_policy_config(self) -> Optional['outputs.AiGuardrailAiGuardrailTopicPolicyConfig']:
        """
        Contains details about topics that the AI Guardrail should identify and deny.
        """
        return pulumi.get(self, "topic_policy_config")

    @property
    @pulumi.getter(name="wordPolicyConfig")
    def word_policy_config(self) -> Optional['outputs.AiGuardrailAiGuardrailWordPolicyConfig']:
        """
        Contains details about the word policy to configured for the AI Guardrail.
        """
        return pulumi.get(self, "word_policy_config")


class AwaitableGetAiGuardrailResult(GetAiGuardrailResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiGuardrailResult(
            ai_guardrail_arn=self.ai_guardrail_arn,
            ai_guardrail_id=self.ai_guardrail_id,
            assistant_arn=self.assistant_arn,
            blocked_input_messaging=self.blocked_input_messaging,
            blocked_outputs_messaging=self.blocked_outputs_messaging,
            content_policy_config=self.content_policy_config,
            contextual_grounding_policy_config=self.contextual_grounding_policy_config,
            description=self.description,
            sensitive_information_policy_config=self.sensitive_information_policy_config,
            topic_policy_config=self.topic_policy_config,
            word_policy_config=self.word_policy_config)


def get_ai_guardrail(ai_guardrail_id: Optional[builtins.str] = None,
                     assistant_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiGuardrailResult:
    """
    Definition of AWS::Wisdom::AIGuardrail Resource Type


    :param builtins.str ai_guardrail_id: The identifier of the Amazon Q in Connect AI Guardrail.
    :param builtins.str assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
    """
    __args__ = dict()
    __args__['aiGuardrailId'] = ai_guardrail_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getAiGuardrail', __args__, opts=opts, typ=GetAiGuardrailResult).value

    return AwaitableGetAiGuardrailResult(
        ai_guardrail_arn=pulumi.get(__ret__, 'ai_guardrail_arn'),
        ai_guardrail_id=pulumi.get(__ret__, 'ai_guardrail_id'),
        assistant_arn=pulumi.get(__ret__, 'assistant_arn'),
        blocked_input_messaging=pulumi.get(__ret__, 'blocked_input_messaging'),
        blocked_outputs_messaging=pulumi.get(__ret__, 'blocked_outputs_messaging'),
        content_policy_config=pulumi.get(__ret__, 'content_policy_config'),
        contextual_grounding_policy_config=pulumi.get(__ret__, 'contextual_grounding_policy_config'),
        description=pulumi.get(__ret__, 'description'),
        sensitive_information_policy_config=pulumi.get(__ret__, 'sensitive_information_policy_config'),
        topic_policy_config=pulumi.get(__ret__, 'topic_policy_config'),
        word_policy_config=pulumi.get(__ret__, 'word_policy_config'))
def get_ai_guardrail_output(ai_guardrail_id: Optional[pulumi.Input[builtins.str]] = None,
                            assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAiGuardrailResult]:
    """
    Definition of AWS::Wisdom::AIGuardrail Resource Type


    :param builtins.str ai_guardrail_id: The identifier of the Amazon Q in Connect AI Guardrail.
    :param builtins.str assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
    """
    __args__ = dict()
    __args__['aiGuardrailId'] = ai_guardrail_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getAiGuardrail', __args__, opts=opts, typ=GetAiGuardrailResult)
    return __ret__.apply(lambda __response__: GetAiGuardrailResult(
        ai_guardrail_arn=pulumi.get(__response__, 'ai_guardrail_arn'),
        ai_guardrail_id=pulumi.get(__response__, 'ai_guardrail_id'),
        assistant_arn=pulumi.get(__response__, 'assistant_arn'),
        blocked_input_messaging=pulumi.get(__response__, 'blocked_input_messaging'),
        blocked_outputs_messaging=pulumi.get(__response__, 'blocked_outputs_messaging'),
        content_policy_config=pulumi.get(__response__, 'content_policy_config'),
        contextual_grounding_policy_config=pulumi.get(__response__, 'contextual_grounding_policy_config'),
        description=pulumi.get(__response__, 'description'),
        sensitive_information_policy_config=pulumi.get(__response__, 'sensitive_information_policy_config'),
        topic_policy_config=pulumi.get(__response__, 'topic_policy_config'),
        word_policy_config=pulumi.get(__response__, 'word_policy_config')))
