# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetAiAgentResult',
    'AwaitableGetAiAgentResult',
    'get_ai_agent',
    'get_ai_agent_output',
]

@pulumi.output_type
class GetAiAgentResult:
    def __init__(__self__, ai_agent_arn=None, ai_agent_id=None, assistant_arn=None, configuration=None, description=None, modified_time_seconds=None):
        if ai_agent_arn and not isinstance(ai_agent_arn, str):
            raise TypeError("Expected argument 'ai_agent_arn' to be a str")
        pulumi.set(__self__, "ai_agent_arn", ai_agent_arn)
        if ai_agent_id and not isinstance(ai_agent_id, str):
            raise TypeError("Expected argument 'ai_agent_id' to be a str")
        pulumi.set(__self__, "ai_agent_id", ai_agent_id)
        if assistant_arn and not isinstance(assistant_arn, str):
            raise TypeError("Expected argument 'assistant_arn' to be a str")
        pulumi.set(__self__, "assistant_arn", assistant_arn)
        if configuration and not isinstance(configuration, dict):
            raise TypeError("Expected argument 'configuration' to be a dict")
        pulumi.set(__self__, "configuration", configuration)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if modified_time_seconds and not isinstance(modified_time_seconds, float):
            raise TypeError("Expected argument 'modified_time_seconds' to be a float")
        pulumi.set(__self__, "modified_time_seconds", modified_time_seconds)

    @property
    @pulumi.getter(name="aiAgentArn")
    def ai_agent_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AI agent.
        """
        return pulumi.get(self, "ai_agent_arn")

    @property
    @pulumi.getter(name="aiAgentId")
    def ai_agent_id(self) -> Optional[builtins.str]:
        """
        The identifier of the AI Agent.
        """
        return pulumi.get(self, "ai_agent_id")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter
    def configuration(self) -> Optional[Any]:
        """
        Configuration for the AI Agent.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the AI Agent.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="modifiedTimeSeconds")
    def modified_time_seconds(self) -> Optional[builtins.float]:
        return pulumi.get(self, "modified_time_seconds")


class AwaitableGetAiAgentResult(GetAiAgentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAiAgentResult(
            ai_agent_arn=self.ai_agent_arn,
            ai_agent_id=self.ai_agent_id,
            assistant_arn=self.assistant_arn,
            configuration=self.configuration,
            description=self.description,
            modified_time_seconds=self.modified_time_seconds)


def get_ai_agent(ai_agent_id: Optional[builtins.str] = None,
                 assistant_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAiAgentResult:
    """
    Definition of AWS::Wisdom::AIAgent Resource Type


    :param builtins.str ai_agent_id: The identifier of the AI Agent.
    :param builtins.str assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
    """
    __args__ = dict()
    __args__['aiAgentId'] = ai_agent_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wisdom:getAiAgent', __args__, opts=opts, typ=GetAiAgentResult).value

    return AwaitableGetAiAgentResult(
        ai_agent_arn=pulumi.get(__ret__, 'ai_agent_arn'),
        ai_agent_id=pulumi.get(__ret__, 'ai_agent_id'),
        assistant_arn=pulumi.get(__ret__, 'assistant_arn'),
        configuration=pulumi.get(__ret__, 'configuration'),
        description=pulumi.get(__ret__, 'description'),
        modified_time_seconds=pulumi.get(__ret__, 'modified_time_seconds'))
def get_ai_agent_output(ai_agent_id: Optional[pulumi.Input[builtins.str]] = None,
                        assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAiAgentResult]:
    """
    Definition of AWS::Wisdom::AIAgent Resource Type


    :param builtins.str ai_agent_id: The identifier of the AI Agent.
    :param builtins.str assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
    """
    __args__ = dict()
    __args__['aiAgentId'] = ai_agent_id
    __args__['assistantId'] = assistant_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wisdom:getAiAgent', __args__, opts=opts, typ=GetAiAgentResult)
    return __ret__.apply(lambda __response__: GetAiAgentResult(
        ai_agent_arn=pulumi.get(__response__, 'ai_agent_arn'),
        ai_agent_id=pulumi.get(__response__, 'ai_agent_id'),
        assistant_arn=pulumi.get(__response__, 'assistant_arn'),
        configuration=pulumi.get(__response__, 'configuration'),
        description=pulumi.get(__response__, 'description'),
        modified_time_seconds=pulumi.get(__response__, 'modified_time_seconds')))
