# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AiPromptArgs', 'AiPrompt']

@pulumi.input_type
class AiPromptArgs:
    def __init__(__self__, *,
                 api_format: pulumi.Input['AiPromptAiPromptApiFormat'],
                 model_id: pulumi.Input[builtins.str],
                 template_configuration: pulumi.Input['AiPromptAiPromptTemplateConfigurationArgs'],
                 template_type: pulumi.Input['AiPromptAiPromptTemplateType'],
                 type: pulumi.Input['AiPromptAiPromptType'],
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AiPrompt resource.
        :param pulumi.Input['AiPromptAiPromptApiFormat'] api_format: The API format used for this AI Prompt.
        :param pulumi.Input[builtins.str] model_id: The identifier of the model used for this AI Prompt. The following model Ids are supported:
               
               - `anthropic.claude-3-haiku--v1:0`
               - `apac.amazon.nova-lite-v1:0`
               - `apac.amazon.nova-micro-v1:0`
               - `apac.amazon.nova-pro-v1:0`
               - `apac.anthropic.claude-3-5-sonnet--v2:0`
               - `apac.anthropic.claude-3-haiku-20240307-v1:0`
               - `eu.amazon.nova-lite-v1:0`
               - `eu.amazon.nova-micro-v1:0`
               - `eu.amazon.nova-pro-v1:0`
               - `eu.anthropic.claude-3-7-sonnet-20250219-v1:0`
               - `eu.anthropic.claude-3-haiku-20240307-v1:0`
               - `us.amazon.nova-lite-v1:0`
               - `us.amazon.nova-micro-v1:0`
               - `us.amazon.nova-pro-v1:0`
               - `us.anthropic.claude-3-5-haiku-20241022-v1:0`
               - `us.anthropic.claude-3-7-sonnet-20250219-v1:0`
               - `us.anthropic.claude-3-haiku-20240307-v1:0`
        :param pulumi.Input['AiPromptAiPromptTemplateConfigurationArgs'] template_configuration: The configuration of the prompt template for this AI Prompt.
        :param pulumi.Input['AiPromptAiPromptTemplateType'] template_type: The type of the prompt template for this AI Prompt.
        :param pulumi.Input['AiPromptAiPromptType'] type: The type of this AI Prompt.
        :param pulumi.Input[builtins.str] assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        :param pulumi.Input[builtins.str] description: The description of the AI Prompt.
        :param pulumi.Input[builtins.str] name: The name of the AI Prompt
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags used to organize, track, or control access for this resource.
        """
        pulumi.set(__self__, "api_format", api_format)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "template_configuration", template_configuration)
        pulumi.set(__self__, "template_type", template_type)
        pulumi.set(__self__, "type", type)
        if assistant_id is not None:
            pulumi.set(__self__, "assistant_id", assistant_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="apiFormat")
    def api_format(self) -> pulumi.Input['AiPromptAiPromptApiFormat']:
        """
        The API format used for this AI Prompt.
        """
        return pulumi.get(self, "api_format")

    @api_format.setter
    def api_format(self, value: pulumi.Input['AiPromptAiPromptApiFormat']):
        pulumi.set(self, "api_format", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the model used for this AI Prompt. The following model Ids are supported:

        - `anthropic.claude-3-haiku--v1:0`
        - `apac.amazon.nova-lite-v1:0`
        - `apac.amazon.nova-micro-v1:0`
        - `apac.amazon.nova-pro-v1:0`
        - `apac.anthropic.claude-3-5-sonnet--v2:0`
        - `apac.anthropic.claude-3-haiku-20240307-v1:0`
        - `eu.amazon.nova-lite-v1:0`
        - `eu.amazon.nova-micro-v1:0`
        - `eu.amazon.nova-pro-v1:0`
        - `eu.anthropic.claude-3-7-sonnet-20250219-v1:0`
        - `eu.anthropic.claude-3-haiku-20240307-v1:0`
        - `us.amazon.nova-lite-v1:0`
        - `us.amazon.nova-micro-v1:0`
        - `us.amazon.nova-pro-v1:0`
        - `us.anthropic.claude-3-5-haiku-20241022-v1:0`
        - `us.anthropic.claude-3-7-sonnet-20250219-v1:0`
        - `us.anthropic.claude-3-haiku-20240307-v1:0`
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> pulumi.Input['AiPromptAiPromptTemplateConfigurationArgs']:
        """
        The configuration of the prompt template for this AI Prompt.
        """
        return pulumi.get(self, "template_configuration")

    @template_configuration.setter
    def template_configuration(self, value: pulumi.Input['AiPromptAiPromptTemplateConfigurationArgs']):
        pulumi.set(self, "template_configuration", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Input['AiPromptAiPromptTemplateType']:
        """
        The type of the prompt template for this AI Prompt.
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: pulumi.Input['AiPromptAiPromptTemplateType']):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AiPromptAiPromptType']:
        """
        The type of this AI Prompt.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AiPromptAiPromptType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        """
        return pulumi.get(self, "assistant_id")

    @assistant_id.setter
    def assistant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "assistant_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the AI Prompt.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AI Prompt
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:wisdom:AiPrompt")
class AiPrompt(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_format: Optional[pulumi.Input['AiPromptAiPromptApiFormat']] = None,
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_configuration: Optional[pulumi.Input[Union['AiPromptAiPromptTemplateConfigurationArgs', 'AiPromptAiPromptTemplateConfigurationArgsDict']]] = None,
                 template_type: Optional[pulumi.Input['AiPromptAiPromptTemplateType']] = None,
                 type: Optional[pulumi.Input['AiPromptAiPromptType']] = None,
                 __props__=None):
        """
        Definition of AWS::Wisdom::AIPrompt Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input['AiPromptAiPromptApiFormat'] api_format: The API format used for this AI Prompt.
        :param pulumi.Input[builtins.str] assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        :param pulumi.Input[builtins.str] description: The description of the AI Prompt.
        :param pulumi.Input[builtins.str] model_id: The identifier of the model used for this AI Prompt. The following model Ids are supported:
               
               - `anthropic.claude-3-haiku--v1:0`
               - `apac.amazon.nova-lite-v1:0`
               - `apac.amazon.nova-micro-v1:0`
               - `apac.amazon.nova-pro-v1:0`
               - `apac.anthropic.claude-3-5-sonnet--v2:0`
               - `apac.anthropic.claude-3-haiku-20240307-v1:0`
               - `eu.amazon.nova-lite-v1:0`
               - `eu.amazon.nova-micro-v1:0`
               - `eu.amazon.nova-pro-v1:0`
               - `eu.anthropic.claude-3-7-sonnet-20250219-v1:0`
               - `eu.anthropic.claude-3-haiku-20240307-v1:0`
               - `us.amazon.nova-lite-v1:0`
               - `us.amazon.nova-micro-v1:0`
               - `us.amazon.nova-pro-v1:0`
               - `us.anthropic.claude-3-5-haiku-20241022-v1:0`
               - `us.anthropic.claude-3-7-sonnet-20250219-v1:0`
               - `us.anthropic.claude-3-haiku-20240307-v1:0`
        :param pulumi.Input[builtins.str] name: The name of the AI Prompt
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input[Union['AiPromptAiPromptTemplateConfigurationArgs', 'AiPromptAiPromptTemplateConfigurationArgsDict']] template_configuration: The configuration of the prompt template for this AI Prompt.
        :param pulumi.Input['AiPromptAiPromptTemplateType'] template_type: The type of the prompt template for this AI Prompt.
        :param pulumi.Input['AiPromptAiPromptType'] type: The type of this AI Prompt.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiPromptArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Wisdom::AIPrompt Resource Type

        :param str resource_name: The name of the resource.
        :param AiPromptArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiPromptArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_format: Optional[pulumi.Input['AiPromptAiPromptApiFormat']] = None,
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 model_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 template_configuration: Optional[pulumi.Input[Union['AiPromptAiPromptTemplateConfigurationArgs', 'AiPromptAiPromptTemplateConfigurationArgsDict']]] = None,
                 template_type: Optional[pulumi.Input['AiPromptAiPromptTemplateType']] = None,
                 type: Optional[pulumi.Input['AiPromptAiPromptType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiPromptArgs.__new__(AiPromptArgs)

            if api_format is None and not opts.urn:
                raise TypeError("Missing required property 'api_format'")
            __props__.__dict__["api_format"] = api_format
            __props__.__dict__["assistant_id"] = assistant_id
            __props__.__dict__["description"] = description
            if model_id is None and not opts.urn:
                raise TypeError("Missing required property 'model_id'")
            __props__.__dict__["model_id"] = model_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if template_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'template_configuration'")
            __props__.__dict__["template_configuration"] = template_configuration
            if template_type is None and not opts.urn:
                raise TypeError("Missing required property 'template_type'")
            __props__.__dict__["template_type"] = template_type
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["ai_prompt_arn"] = None
            __props__.__dict__["ai_prompt_id"] = None
            __props__.__dict__["assistant_arn"] = None
            __props__.__dict__["modified_time_seconds"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["apiFormat", "assistantId", "modelId", "name", "tags.*", "templateType", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AiPrompt, __self__).__init__(
            'aws-native:wisdom:AiPrompt',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AiPrompt':
        """
        Get an existing AiPrompt resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AiPromptArgs.__new__(AiPromptArgs)

        __props__.__dict__["ai_prompt_arn"] = None
        __props__.__dict__["ai_prompt_id"] = None
        __props__.__dict__["api_format"] = None
        __props__.__dict__["assistant_arn"] = None
        __props__.__dict__["assistant_id"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["model_id"] = None
        __props__.__dict__["modified_time_seconds"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["template_configuration"] = None
        __props__.__dict__["template_type"] = None
        __props__.__dict__["type"] = None
        return AiPrompt(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiPromptArn")
    def ai_prompt_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AI Prompt.
        """
        return pulumi.get(self, "ai_prompt_arn")

    @property
    @pulumi.getter(name="aiPromptId")
    def ai_prompt_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q in Connect AI prompt.
        """
        return pulumi.get(self, "ai_prompt_id")

    @property
    @pulumi.getter(name="apiFormat")
    def api_format(self) -> pulumi.Output['AiPromptAiPromptApiFormat']:
        """
        The API format used for this AI Prompt.
        """
        return pulumi.get(self, "api_format")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        """
        return pulumi.get(self, "assistant_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the AI Prompt.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the model used for this AI Prompt. The following model Ids are supported:

        - `anthropic.claude-3-haiku--v1:0`
        - `apac.amazon.nova-lite-v1:0`
        - `apac.amazon.nova-micro-v1:0`
        - `apac.amazon.nova-pro-v1:0`
        - `apac.anthropic.claude-3-5-sonnet--v2:0`
        - `apac.anthropic.claude-3-haiku-20240307-v1:0`
        - `eu.amazon.nova-lite-v1:0`
        - `eu.amazon.nova-micro-v1:0`
        - `eu.amazon.nova-pro-v1:0`
        - `eu.anthropic.claude-3-7-sonnet-20250219-v1:0`
        - `eu.anthropic.claude-3-haiku-20240307-v1:0`
        - `us.amazon.nova-lite-v1:0`
        - `us.amazon.nova-micro-v1:0`
        - `us.amazon.nova-pro-v1:0`
        - `us.anthropic.claude-3-5-haiku-20241022-v1:0`
        - `us.anthropic.claude-3-7-sonnet-20250219-v1:0`
        - `us.anthropic.claude-3-haiku-20240307-v1:0`
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modifiedTimeSeconds")
    def modified_time_seconds(self) -> pulumi.Output[builtins.float]:
        return pulumi.get(self, "modified_time_seconds")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the AI Prompt
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateConfiguration")
    def template_configuration(self) -> pulumi.Output['outputs.AiPromptAiPromptTemplateConfiguration']:
        """
        The configuration of the prompt template for this AI Prompt.
        """
        return pulumi.get(self, "template_configuration")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output['AiPromptAiPromptTemplateType']:
        """
        The type of the prompt template for this AI Prompt.
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['AiPromptAiPromptType']:
        """
        The type of this AI Prompt.
        """
        return pulumi.get(self, "type")

