# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AiGuardrailArgs', 'AiGuardrail']

@pulumi.input_type
class AiGuardrailArgs:
    def __init__(__self__, *,
                 assistant_id: pulumi.Input[builtins.str],
                 blocked_input_messaging: pulumi.Input[builtins.str],
                 blocked_outputs_messaging: pulumi.Input[builtins.str],
                 content_policy_config: Optional[pulumi.Input['AiGuardrailAiGuardrailContentPolicyConfigArgs']] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topic_policy_config: Optional[pulumi.Input['AiGuardrailAiGuardrailTopicPolicyConfigArgs']] = None,
                 word_policy_config: Optional[pulumi.Input['AiGuardrailAiGuardrailWordPolicyConfigArgs']] = None):
        """
        The set of arguments for constructing a AiGuardrail resource.
        :param pulumi.Input[builtins.str] assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        :param pulumi.Input[builtins.str] blocked_input_messaging: Messaging for when violations are detected in text
        :param pulumi.Input[builtins.str] blocked_outputs_messaging: Messaging for when violations are detected in text
        :param pulumi.Input['AiGuardrailAiGuardrailContentPolicyConfigArgs'] content_policy_config: Contains details about how to handle harmful content.
        :param pulumi.Input['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs'] contextual_grounding_policy_config: The policy configuration details for the AI Guardrail's contextual grounding policy.
        :param pulumi.Input[builtins.str] description: Description of the guardrail or its version
        :param pulumi.Input[builtins.str] name: The name of the AI Guardrail.
        :param pulumi.Input['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs'] sensitive_information_policy_config: Contains details about PII entities and regular expressions to configure for the AI Guardrail.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input['AiGuardrailAiGuardrailTopicPolicyConfigArgs'] topic_policy_config: Contains details about topics that the AI Guardrail should identify and deny.
        :param pulumi.Input['AiGuardrailAiGuardrailWordPolicyConfigArgs'] word_policy_config: Contains details about the word policy to configured for the AI Guardrail.
        """
        pulumi.set(__self__, "assistant_id", assistant_id)
        pulumi.set(__self__, "blocked_input_messaging", blocked_input_messaging)
        pulumi.set(__self__, "blocked_outputs_messaging", blocked_outputs_messaging)
        if content_policy_config is not None:
            pulumi.set(__self__, "content_policy_config", content_policy_config)
        if contextual_grounding_policy_config is not None:
            pulumi.set(__self__, "contextual_grounding_policy_config", contextual_grounding_policy_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sensitive_information_policy_config is not None:
            pulumi.set(__self__, "sensitive_information_policy_config", sensitive_information_policy_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if topic_policy_config is not None:
            pulumi.set(__self__, "topic_policy_config", topic_policy_config)
        if word_policy_config is not None:
            pulumi.set(__self__, "word_policy_config", word_policy_config)

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        """
        return pulumi.get(self, "assistant_id")

    @assistant_id.setter
    def assistant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "assistant_id", value)

    @property
    @pulumi.getter(name="blockedInputMessaging")
    def blocked_input_messaging(self) -> pulumi.Input[builtins.str]:
        """
        Messaging for when violations are detected in text
        """
        return pulumi.get(self, "blocked_input_messaging")

    @blocked_input_messaging.setter
    def blocked_input_messaging(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "blocked_input_messaging", value)

    @property
    @pulumi.getter(name="blockedOutputsMessaging")
    def blocked_outputs_messaging(self) -> pulumi.Input[builtins.str]:
        """
        Messaging for when violations are detected in text
        """
        return pulumi.get(self, "blocked_outputs_messaging")

    @blocked_outputs_messaging.setter
    def blocked_outputs_messaging(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "blocked_outputs_messaging", value)

    @property
    @pulumi.getter(name="contentPolicyConfig")
    def content_policy_config(self) -> Optional[pulumi.Input['AiGuardrailAiGuardrailContentPolicyConfigArgs']]:
        """
        Contains details about how to handle harmful content.
        """
        return pulumi.get(self, "content_policy_config")

    @content_policy_config.setter
    def content_policy_config(self, value: Optional[pulumi.Input['AiGuardrailAiGuardrailContentPolicyConfigArgs']]):
        pulumi.set(self, "content_policy_config", value)

    @property
    @pulumi.getter(name="contextualGroundingPolicyConfig")
    def contextual_grounding_policy_config(self) -> Optional[pulumi.Input['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs']]:
        """
        The policy configuration details for the AI Guardrail's contextual grounding policy.
        """
        return pulumi.get(self, "contextual_grounding_policy_config")

    @contextual_grounding_policy_config.setter
    def contextual_grounding_policy_config(self, value: Optional[pulumi.Input['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs']]):
        pulumi.set(self, "contextual_grounding_policy_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the guardrail or its version
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AI Guardrail.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sensitiveInformationPolicyConfig")
    def sensitive_information_policy_config(self) -> Optional[pulumi.Input['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs']]:
        """
        Contains details about PII entities and regular expressions to configure for the AI Guardrail.
        """
        return pulumi.get(self, "sensitive_information_policy_config")

    @sensitive_information_policy_config.setter
    def sensitive_information_policy_config(self, value: Optional[pulumi.Input['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs']]):
        pulumi.set(self, "sensitive_information_policy_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="topicPolicyConfig")
    def topic_policy_config(self) -> Optional[pulumi.Input['AiGuardrailAiGuardrailTopicPolicyConfigArgs']]:
        """
        Contains details about topics that the AI Guardrail should identify and deny.
        """
        return pulumi.get(self, "topic_policy_config")

    @topic_policy_config.setter
    def topic_policy_config(self, value: Optional[pulumi.Input['AiGuardrailAiGuardrailTopicPolicyConfigArgs']]):
        pulumi.set(self, "topic_policy_config", value)

    @property
    @pulumi.getter(name="wordPolicyConfig")
    def word_policy_config(self) -> Optional[pulumi.Input['AiGuardrailAiGuardrailWordPolicyConfigArgs']]:
        """
        Contains details about the word policy to configured for the AI Guardrail.
        """
        return pulumi.get(self, "word_policy_config")

    @word_policy_config.setter
    def word_policy_config(self, value: Optional[pulumi.Input['AiGuardrailAiGuardrailWordPolicyConfigArgs']]):
        pulumi.set(self, "word_policy_config", value)


@pulumi.type_token("aws-native:wisdom:AiGuardrail")
class AiGuardrail(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_input_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_outputs_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 content_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailContentPolicyConfigArgs', 'AiGuardrailAiGuardrailContentPolicyConfigArgsDict']]] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs', 'AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs', 'AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topic_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailTopicPolicyConfigArgs', 'AiGuardrailAiGuardrailTopicPolicyConfigArgsDict']]] = None,
                 word_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailWordPolicyConfigArgs', 'AiGuardrailAiGuardrailWordPolicyConfigArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::Wisdom::AIGuardrail Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        :param pulumi.Input[builtins.str] blocked_input_messaging: Messaging for when violations are detected in text
        :param pulumi.Input[builtins.str] blocked_outputs_messaging: Messaging for when violations are detected in text
        :param pulumi.Input[Union['AiGuardrailAiGuardrailContentPolicyConfigArgs', 'AiGuardrailAiGuardrailContentPolicyConfigArgsDict']] content_policy_config: Contains details about how to handle harmful content.
        :param pulumi.Input[Union['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs', 'AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgsDict']] contextual_grounding_policy_config: The policy configuration details for the AI Guardrail's contextual grounding policy.
        :param pulumi.Input[builtins.str] description: Description of the guardrail or its version
        :param pulumi.Input[builtins.str] name: The name of the AI Guardrail.
        :param pulumi.Input[Union['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs', 'AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgsDict']] sensitive_information_policy_config: Contains details about PII entities and regular expressions to configure for the AI Guardrail.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input[Union['AiGuardrailAiGuardrailTopicPolicyConfigArgs', 'AiGuardrailAiGuardrailTopicPolicyConfigArgsDict']] topic_policy_config: Contains details about topics that the AI Guardrail should identify and deny.
        :param pulumi.Input[Union['AiGuardrailAiGuardrailWordPolicyConfigArgs', 'AiGuardrailAiGuardrailWordPolicyConfigArgsDict']] word_policy_config: Contains details about the word policy to configured for the AI Guardrail.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiGuardrailArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Wisdom::AIGuardrail Resource Type

        :param str resource_name: The name of the resource.
        :param AiGuardrailArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiGuardrailArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_input_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 blocked_outputs_messaging: Optional[pulumi.Input[builtins.str]] = None,
                 content_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailContentPolicyConfigArgs', 'AiGuardrailAiGuardrailContentPolicyConfigArgsDict']]] = None,
                 contextual_grounding_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgs', 'AiGuardrailAiGuardrailContextualGroundingPolicyConfigArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 sensitive_information_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgs', 'AiGuardrailAiGuardrailSensitiveInformationPolicyConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 topic_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailTopicPolicyConfigArgs', 'AiGuardrailAiGuardrailTopicPolicyConfigArgsDict']]] = None,
                 word_policy_config: Optional[pulumi.Input[Union['AiGuardrailAiGuardrailWordPolicyConfigArgs', 'AiGuardrailAiGuardrailWordPolicyConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiGuardrailArgs.__new__(AiGuardrailArgs)

            if assistant_id is None and not opts.urn:
                raise TypeError("Missing required property 'assistant_id'")
            __props__.__dict__["assistant_id"] = assistant_id
            if blocked_input_messaging is None and not opts.urn:
                raise TypeError("Missing required property 'blocked_input_messaging'")
            __props__.__dict__["blocked_input_messaging"] = blocked_input_messaging
            if blocked_outputs_messaging is None and not opts.urn:
                raise TypeError("Missing required property 'blocked_outputs_messaging'")
            __props__.__dict__["blocked_outputs_messaging"] = blocked_outputs_messaging
            __props__.__dict__["content_policy_config"] = content_policy_config
            __props__.__dict__["contextual_grounding_policy_config"] = contextual_grounding_policy_config
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["sensitive_information_policy_config"] = sensitive_information_policy_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["topic_policy_config"] = topic_policy_config
            __props__.__dict__["word_policy_config"] = word_policy_config
            __props__.__dict__["ai_guardrail_arn"] = None
            __props__.__dict__["ai_guardrail_id"] = None
            __props__.__dict__["assistant_arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["assistantId", "name", "tags.*"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AiGuardrail, __self__).__init__(
            'aws-native:wisdom:AiGuardrail',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AiGuardrail':
        """
        Get an existing AiGuardrail resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AiGuardrailArgs.__new__(AiGuardrailArgs)

        __props__.__dict__["ai_guardrail_arn"] = None
        __props__.__dict__["ai_guardrail_id"] = None
        __props__.__dict__["assistant_arn"] = None
        __props__.__dict__["assistant_id"] = None
        __props__.__dict__["blocked_input_messaging"] = None
        __props__.__dict__["blocked_outputs_messaging"] = None
        __props__.__dict__["content_policy_config"] = None
        __props__.__dict__["contextual_grounding_policy_config"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["sensitive_information_policy_config"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["topic_policy_config"] = None
        __props__.__dict__["word_policy_config"] = None
        return AiGuardrail(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiGuardrailArn")
    def ai_guardrail_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AI Guardrail.
        """
        return pulumi.get(self, "ai_guardrail_arn")

    @property
    @pulumi.getter(name="aiGuardrailId")
    def ai_guardrail_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q in Connect AI Guardrail.
        """
        return pulumi.get(self, "ai_guardrail_id")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        """
        return pulumi.get(self, "assistant_id")

    @property
    @pulumi.getter(name="blockedInputMessaging")
    def blocked_input_messaging(self) -> pulumi.Output[builtins.str]:
        """
        Messaging for when violations are detected in text
        """
        return pulumi.get(self, "blocked_input_messaging")

    @property
    @pulumi.getter(name="blockedOutputsMessaging")
    def blocked_outputs_messaging(self) -> pulumi.Output[builtins.str]:
        """
        Messaging for when violations are detected in text
        """
        return pulumi.get(self, "blocked_outputs_messaging")

    @property
    @pulumi.getter(name="contentPolicyConfig")
    def content_policy_config(self) -> pulumi.Output[Optional['outputs.AiGuardrailAiGuardrailContentPolicyConfig']]:
        """
        Contains details about how to handle harmful content.
        """
        return pulumi.get(self, "content_policy_config")

    @property
    @pulumi.getter(name="contextualGroundingPolicyConfig")
    def contextual_grounding_policy_config(self) -> pulumi.Output[Optional['outputs.AiGuardrailAiGuardrailContextualGroundingPolicyConfig']]:
        """
        The policy configuration details for the AI Guardrail's contextual grounding policy.
        """
        return pulumi.get(self, "contextual_grounding_policy_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the guardrail or its version
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the AI Guardrail.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sensitiveInformationPolicyConfig")
    def sensitive_information_policy_config(self) -> pulumi.Output[Optional['outputs.AiGuardrailAiGuardrailSensitiveInformationPolicyConfig']]:
        """
        Contains details about PII entities and regular expressions to configure for the AI Guardrail.
        """
        return pulumi.get(self, "sensitive_information_policy_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicPolicyConfig")
    def topic_policy_config(self) -> pulumi.Output[Optional['outputs.AiGuardrailAiGuardrailTopicPolicyConfig']]:
        """
        Contains details about topics that the AI Guardrail should identify and deny.
        """
        return pulumi.get(self, "topic_policy_config")

    @property
    @pulumi.getter(name="wordPolicyConfig")
    def word_policy_config(self) -> pulumi.Output[Optional['outputs.AiGuardrailAiGuardrailWordPolicyConfig']]:
        """
        Contains details about the word policy to configured for the AI Guardrail.
        """
        return pulumi.get(self, "word_policy_config")

