# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['AiAgentArgs', 'AiAgent']

@pulumi.input_type
class AiAgentArgs:
    def __init__(__self__, *,
                 assistant_id: pulumi.Input[builtins.str],
                 configuration: pulumi.Input[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgs']],
                 type: pulumi.Input['AiAgentAiAgentType'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AiAgent resource.
        :param pulumi.Input[builtins.str] assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        :param pulumi.Input[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgs']] configuration: Configuration for the AI Agent.
        :param pulumi.Input['AiAgentAiAgentType'] type: The type of the AI Agent.
        :param pulumi.Input[builtins.str] description: The description of the AI Agent.
        :param pulumi.Input[builtins.str] name: The name of the AI Agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags used to organize, track, or control access for this resource.
        """
        pulumi.set(__self__, "assistant_id", assistant_id)
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Input[builtins.str]:
        """
        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        """
        return pulumi.get(self, "assistant_id")

    @assistant_id.setter
    def assistant_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "assistant_id", value)

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Input[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgs']]:
        """
        Configuration for the AI Agent.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: pulumi.Input[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgs']]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['AiAgentAiAgentType']:
        """
        The type of the AI Agent.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['AiAgentAiAgentType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the AI Agent.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the AI Agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:wisdom:AiAgent")
class AiAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration0PropertiesArgsDict'], Union['AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgsDict'], Union['AiAgentAiAgentConfiguration2PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgsDict']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input['AiAgentAiAgentType']] = None,
                 __props__=None):
        """
        Definition of AWS::Wisdom::AIAgent Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] assistant_id: The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        :param pulumi.Input[Union[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration0PropertiesArgsDict'], Union['AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgsDict'], Union['AiAgentAiAgentConfiguration2PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgsDict']]] configuration: Configuration for the AI Agent.
        :param pulumi.Input[builtins.str] description: The description of the AI Agent.
        :param pulumi.Input[builtins.str] name: The name of the AI Agent.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: The tags used to organize, track, or control access for this resource.
        :param pulumi.Input['AiAgentAiAgentType'] type: The type of the AI Agent.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AiAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Wisdom::AIAgent Resource Type

        :param str resource_name: The name of the resource.
        :param AiAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AiAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assistant_id: Optional[pulumi.Input[builtins.str]] = None,
                 configuration: Optional[pulumi.Input[Union[Union['AiAgentAiAgentConfiguration0PropertiesArgs', 'AiAgentAiAgentConfiguration0PropertiesArgsDict'], Union['AiAgentAiAgentConfiguration1PropertiesArgs', 'AiAgentAiAgentConfiguration1PropertiesArgsDict'], Union['AiAgentAiAgentConfiguration2PropertiesArgs', 'AiAgentAiAgentConfiguration2PropertiesArgsDict']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input['AiAgentAiAgentType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AiAgentArgs.__new__(AiAgentArgs)

            if assistant_id is None and not opts.urn:
                raise TypeError("Missing required property 'assistant_id'")
            __props__.__dict__["assistant_id"] = assistant_id
            if configuration is None and not opts.urn:
                raise TypeError("Missing required property 'configuration'")
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["ai_agent_arn"] = None
            __props__.__dict__["ai_agent_id"] = None
            __props__.__dict__["assistant_arn"] = None
            __props__.__dict__["modified_time_seconds"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["assistantId", "name", "tags.*", "type"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AiAgent, __self__).__init__(
            'aws-native:wisdom:AiAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AiAgent':
        """
        Get an existing AiAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AiAgentArgs.__new__(AiAgentArgs)

        __props__.__dict__["ai_agent_arn"] = None
        __props__.__dict__["ai_agent_id"] = None
        __props__.__dict__["assistant_arn"] = None
        __props__.__dict__["assistant_id"] = None
        __props__.__dict__["configuration"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["modified_time_seconds"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["type"] = None
        return AiAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aiAgentArn")
    def ai_agent_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AI agent.
        """
        return pulumi.get(self, "ai_agent_arn")

    @property
    @pulumi.getter(name="aiAgentId")
    def ai_agent_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the AI Agent.
        """
        return pulumi.get(self, "ai_agent_id")

    @property
    @pulumi.getter(name="assistantArn")
    def assistant_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
        """
        return pulumi.get(self, "assistant_arn")

    @property
    @pulumi.getter(name="assistantId")
    def assistant_id(self) -> pulumi.Output[builtins.str]:
        """
        The identifier of the Amazon Q in Connect assistant. Can be either the ID or the ARN. URLs cannot contain the ARN.
        """
        return pulumi.get(self, "assistant_id")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Any]:
        """
        Configuration for the AI Agent.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the AI Agent.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="modifiedTimeSeconds")
    def modified_time_seconds(self) -> pulumi.Output[builtins.float]:
        return pulumi.get(self, "modified_time_seconds")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the AI Agent.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output['AiAgentAiAgentType']:
        """
        The type of the AI Agent.
        """
        return pulumi.get(self, "type")

