# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'LoggingConfigurationCondition',
    'LoggingConfigurationConditionActionConditionProperties',
    'LoggingConfigurationConditionLabelNameConditionProperties',
    'LoggingConfigurationFieldToMatch',
    'LoggingConfigurationFieldToMatchSingleHeaderProperties',
    'LoggingConfigurationFilter',
    'LoggingFilterProperties',
    'RuleGroupAllowAction',
    'RuleGroupAndStatement',
    'RuleGroupBlockAction',
    'RuleGroupBody',
    'RuleGroupByteMatchStatement',
    'RuleGroupCaptchaAction',
    'RuleGroupCaptchaConfig',
    'RuleGroupChallengeAction',
    'RuleGroupChallengeConfig',
    'RuleGroupCookieMatchPattern',
    'RuleGroupCookies',
    'RuleGroupCountAction',
    'RuleGroupCustomHttpHeader',
    'RuleGroupCustomRequestHandling',
    'RuleGroupCustomResponse',
    'RuleGroupCustomResponseBody',
    'RuleGroupFieldToMatch',
    'RuleGroupFieldToMatchSingleHeaderProperties',
    'RuleGroupFieldToMatchSingleQueryArgumentProperties',
    'RuleGroupForwardedIpConfiguration',
    'RuleGroupGeoMatchStatement',
    'RuleGroupHeaderMatchPattern',
    'RuleGroupHeaders',
    'RuleGroupImmunityTimeProperty',
    'RuleGroupIpSetForwardedIpConfiguration',
    'RuleGroupIpSetReferenceStatement',
    'RuleGroupJa3Fingerprint',
    'RuleGroupJa4Fingerprint',
    'RuleGroupJsonBody',
    'RuleGroupJsonMatchPattern',
    'RuleGroupLabel',
    'RuleGroupLabelMatchStatement',
    'RuleGroupLabelSummary',
    'RuleGroupNotStatement',
    'RuleGroupOrStatement',
    'RuleGroupRateBasedStatement',
    'RuleGroupRateBasedStatementCustomKey',
    'RuleGroupRateLimitCookie',
    'RuleGroupRateLimitForwardedIp',
    'RuleGroupRateLimitHeader',
    'RuleGroupRateLimitHttpMethod',
    'RuleGroupRateLimitIp',
    'RuleGroupRateLimitJa3Fingerprint',
    'RuleGroupRateLimitJa4Fingerprint',
    'RuleGroupRateLimitLabelNamespace',
    'RuleGroupRateLimitQueryArgument',
    'RuleGroupRateLimitQueryString',
    'RuleGroupRateLimitUriPath',
    'RuleGroupRegexMatchStatement',
    'RuleGroupRegexPatternSetReferenceStatement',
    'RuleGroupRule',
    'RuleGroupRuleAction',
    'RuleGroupSizeConstraintStatement',
    'RuleGroupSqliMatchStatement',
    'RuleGroupStatement',
    'RuleGroupTextTransformation',
    'RuleGroupUriFragment',
    'RuleGroupVisibilityConfig',
    'RuleGroupXssMatchStatement',
    'WebAclAllowAction',
    'WebAclAndStatement',
    'WebAclAssociationConfig',
    'WebAclAwsManagedRulesAcfpRuleSet',
    'WebAclAwsManagedRulesAtpRuleSet',
    'WebAclAwsManagedRulesBotControlRuleSet',
    'WebAclBlockAction',
    'WebAclBody',
    'WebAclByteMatchStatement',
    'WebAclCaptchaAction',
    'WebAclCaptchaConfig',
    'WebAclChallengeAction',
    'WebAclChallengeConfig',
    'WebAclCookieMatchPattern',
    'WebAclCookies',
    'WebAclCountAction',
    'WebAclCustomHttpHeader',
    'WebAclCustomRequestHandling',
    'WebAclCustomResponse',
    'WebAclCustomResponseBody',
    'WebAclDataProtect',
    'WebAclDataProtectionConfig',
    'WebAclDefaultAction',
    'WebAclExcludedRule',
    'WebAclFieldIdentifier',
    'WebAclFieldToMatch',
    'WebAclFieldToMatchSingleHeaderProperties',
    'WebAclFieldToMatchSingleQueryArgumentProperties',
    'WebAclFieldToProtect',
    'WebAclForwardedIpConfiguration',
    'WebAclGeoMatchStatement',
    'WebAclHeaderMatchPattern',
    'WebAclHeaders',
    'WebAclImmunityTimeProperty',
    'WebAclIpSetForwardedIpConfiguration',
    'WebAclIpSetReferenceStatement',
    'WebAclJa3Fingerprint',
    'WebAclJa4Fingerprint',
    'WebAclJsonBody',
    'WebAclJsonMatchPattern',
    'WebAclLabel',
    'WebAclLabelMatchStatement',
    'WebAclManagedRuleGroupConfig',
    'WebAclManagedRuleGroupStatement',
    'WebAclNotStatement',
    'WebAclOrStatement',
    'WebAclOverrideAction',
    'WebAclRateBasedStatement',
    'WebAclRateBasedStatementCustomKey',
    'WebAclRateLimitCookie',
    'WebAclRateLimitForwardedIp',
    'WebAclRateLimitHeader',
    'WebAclRateLimitHttpMethod',
    'WebAclRateLimitIp',
    'WebAclRateLimitJa3Fingerprint',
    'WebAclRateLimitJa4Fingerprint',
    'WebAclRateLimitLabelNamespace',
    'WebAclRateLimitQueryArgument',
    'WebAclRateLimitQueryString',
    'WebAclRateLimitUriPath',
    'WebAclRegexMatchStatement',
    'WebAclRegexPatternSetReferenceStatement',
    'WebAclRequestBodyAssociatedResourceTypeConfig',
    'WebAclRequestInspection',
    'WebAclRequestInspectionAcfp',
    'WebAclResponseInspection',
    'WebAclResponseInspectionBodyContains',
    'WebAclResponseInspectionHeader',
    'WebAclResponseInspectionJson',
    'WebAclResponseInspectionStatusCode',
    'WebAclRule',
    'WebAclRuleAction',
    'WebAclRuleActionOverride',
    'WebAclRuleGroupReferenceStatement',
    'WebAclSizeConstraintStatement',
    'WebAclSqliMatchStatement',
    'WebAclStatement',
    'WebAclTextTransformation',
    'WebAclUriFragment',
    'WebAclVisibilityConfig',
    'WebAclXssMatchStatement',
]

@pulumi.output_type
class LoggingConfigurationCondition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionCondition":
            suggest = "action_condition"
        elif key == "labelNameCondition":
            suggest = "label_name_condition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigurationCondition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigurationCondition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigurationCondition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_condition: Optional['outputs.LoggingConfigurationConditionActionConditionProperties'] = None,
                 label_name_condition: Optional['outputs.LoggingConfigurationConditionLabelNameConditionProperties'] = None):
        """
        :param 'LoggingConfigurationConditionActionConditionProperties' action_condition: A single action condition.
        :param 'LoggingConfigurationConditionLabelNameConditionProperties' label_name_condition: A single label name condition.
        """
        if action_condition is not None:
            pulumi.set(__self__, "action_condition", action_condition)
        if label_name_condition is not None:
            pulumi.set(__self__, "label_name_condition", label_name_condition)

    @property
    @pulumi.getter(name="actionCondition")
    def action_condition(self) -> Optional['outputs.LoggingConfigurationConditionActionConditionProperties']:
        """
        A single action condition.
        """
        return pulumi.get(self, "action_condition")

    @property
    @pulumi.getter(name="labelNameCondition")
    def label_name_condition(self) -> Optional['outputs.LoggingConfigurationConditionLabelNameConditionProperties']:
        """
        A single label name condition.
        """
        return pulumi.get(self, "label_name_condition")


@pulumi.output_type
class LoggingConfigurationConditionActionConditionProperties(dict):
    """
    A single action condition.
    """
    def __init__(__self__, *,
                 action: 'LoggingConfigurationConditionActionConditionPropertiesAction'):
        """
        A single action condition.
        :param 'LoggingConfigurationConditionActionConditionPropertiesAction' action: Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.
        """
        pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter
    def action(self) -> 'LoggingConfigurationConditionActionConditionPropertiesAction':
        """
        Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.
        """
        return pulumi.get(self, "action")


@pulumi.output_type
class LoggingConfigurationConditionLabelNameConditionProperties(dict):
    """
    A single label name condition.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "labelName":
            suggest = "label_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigurationConditionLabelNameConditionProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigurationConditionLabelNameConditionProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigurationConditionLabelNameConditionProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 label_name: builtins.str):
        """
        A single label name condition.
        :param builtins.str label_name: The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. 
        """
        pulumi.set(__self__, "label_name", label_name)

    @property
    @pulumi.getter(name="labelName")
    def label_name(self) -> builtins.str:
        """
        The label name that a log record must contain in order to meet the condition. This must be a fully qualified label name. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. 
        """
        return pulumi.get(self, "label_name")


@pulumi.output_type
class LoggingConfigurationFieldToMatch(dict):
    """
    A key-value pair to associate with a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryString":
            suggest = "query_string"
        elif key == "singleHeader":
            suggest = "single_header"
        elif key == "uriPath":
            suggest = "uri_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigurationFieldToMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigurationFieldToMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigurationFieldToMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: Optional[Any] = None,
                 query_string: Optional[Any] = None,
                 single_header: Optional['outputs.LoggingConfigurationFieldToMatchSingleHeaderProperties'] = None,
                 uri_path: Optional[Any] = None):
        """
        A key-value pair to associate with a resource.
        :param Any method: Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform. 
        :param Any query_string: Inspect the query string. This is the part of a URL that appears after a ? character, if any. 
        :param 'LoggingConfigurationFieldToMatchSingleHeaderProperties' single_header: Inspect a single header. Provide the name of the header to inspect, for example, User-Agent or Referer. This setting isn't case sensitive.
        :param Any uri_path: Inspect the request URI path. This is the part of a web request that identifies a resource, for example, /images/daily-ad.jpg. 
        """
        if method is not None:
            pulumi.set(__self__, "method", method)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if single_header is not None:
            pulumi.set(__self__, "single_header", single_header)
        if uri_path is not None:
            pulumi.set(__self__, "uri_path", uri_path)

    @property
    @pulumi.getter
    def method(self) -> Optional[Any]:
        """
        Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform. 
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[Any]:
        """
        Inspect the query string. This is the part of a URL that appears after a ? character, if any. 
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="singleHeader")
    def single_header(self) -> Optional['outputs.LoggingConfigurationFieldToMatchSingleHeaderProperties']:
        """
        Inspect a single header. Provide the name of the header to inspect, for example, User-Agent or Referer. This setting isn't case sensitive.
        """
        return pulumi.get(self, "single_header")

    @property
    @pulumi.getter(name="uriPath")
    def uri_path(self) -> Optional[Any]:
        """
        Inspect the request URI path. This is the part of a web request that identifies a resource, for example, /images/daily-ad.jpg. 
        """
        return pulumi.get(self, "uri_path")


@pulumi.output_type
class LoggingConfigurationFieldToMatchSingleHeaderProperties(dict):
    """
    Inspect a single header. Provide the name of the header to inspect, for example, User-Agent or Referer. This setting isn't case sensitive.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        Inspect a single header. Provide the name of the header to inspect, for example, User-Agent or Referer. This setting isn't case sensitive.
        :param builtins.str name: The name of the query header to inspect.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the query header to inspect.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class LoggingConfigurationFilter(dict):
    def __init__(__self__, *,
                 behavior: 'LoggingConfigurationFilterBehavior',
                 conditions: Sequence['outputs.LoggingConfigurationCondition'],
                 requirement: 'LoggingConfigurationFilterRequirement'):
        """
        :param 'LoggingConfigurationFilterBehavior' behavior: How to handle logs that satisfy the filter's conditions and requirement. 
        :param Sequence['LoggingConfigurationCondition'] conditions: Match conditions for the filter.
        :param 'LoggingConfigurationFilterRequirement' requirement: Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.
        """
        pulumi.set(__self__, "behavior", behavior)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "requirement", requirement)

    @property
    @pulumi.getter
    def behavior(self) -> 'LoggingConfigurationFilterBehavior':
        """
        How to handle logs that satisfy the filter's conditions and requirement. 
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.LoggingConfigurationCondition']:
        """
        Match conditions for the filter.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def requirement(self) -> 'LoggingConfigurationFilterRequirement':
        """
        Logic to apply to the filtering conditions. You can specify that, in order to satisfy the filter, a log must match all conditions or must match at least one condition.
        """
        return pulumi.get(self, "requirement")


@pulumi.output_type
class LoggingFilterProperties(dict):
    """
    Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultBehavior":
            suggest = "default_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingFilterProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingFilterProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingFilterProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_behavior: 'LoggingConfigurationLoggingFilterPropertiesDefaultBehavior',
                 filters: Sequence['outputs.LoggingConfigurationFilter']):
        """
        Filtering that specifies which web requests are kept in the logs and which are dropped. You can filter on the rule action and on the web request labels that were applied by matching rules during web ACL evaluation.
        :param 'LoggingConfigurationLoggingFilterPropertiesDefaultBehavior' default_behavior: Default handling for logs that don't match any of the specified filtering conditions.
        :param Sequence['LoggingConfigurationFilter'] filters: The filters that you want to apply to the logs.
        """
        pulumi.set(__self__, "default_behavior", default_behavior)
        pulumi.set(__self__, "filters", filters)

    @property
    @pulumi.getter(name="defaultBehavior")
    def default_behavior(self) -> 'LoggingConfigurationLoggingFilterPropertiesDefaultBehavior':
        """
        Default handling for logs that don't match any of the specified filtering conditions.
        """
        return pulumi.get(self, "default_behavior")

    @property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.LoggingConfigurationFilter']:
        """
        The filters that you want to apply to the logs.
        """
        return pulumi.get(self, "filters")


@pulumi.output_type
class RuleGroupAllowAction(dict):
    """
    Allow traffic towards application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupAllowAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupAllowAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupAllowAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.RuleGroupCustomRequestHandling'] = None):
        """
        Allow traffic towards application.
        :param 'RuleGroupCustomRequestHandling' custom_request_handling: Defines custom handling for the web request.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.RuleGroupCustomRequestHandling']:
        """
        Defines custom handling for the web request.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class RuleGroupAndStatement(dict):
    def __init__(__self__, *,
                 statements: Sequence['outputs.RuleGroupStatement']):
        """
        :param Sequence['RuleGroupStatement'] statements: The statements to combine with AND logic. You can use any statements that can be nested.
        """
        pulumi.set(__self__, "statements", statements)

    @property
    @pulumi.getter
    def statements(self) -> Sequence['outputs.RuleGroupStatement']:
        """
        The statements to combine with AND logic. You can use any statements that can be nested.
        """
        return pulumi.get(self, "statements")


@pulumi.output_type
class RuleGroupBlockAction(dict):
    """
    Block traffic towards application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customResponse":
            suggest = "custom_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupBlockAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupBlockAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupBlockAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_response: Optional['outputs.RuleGroupCustomResponse'] = None):
        """
        Block traffic towards application.
        :param 'RuleGroupCustomResponse' custom_response: Defines a custom response for the web request.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_response is not None:
            pulumi.set(__self__, "custom_response", custom_response)

    @property
    @pulumi.getter(name="customResponse")
    def custom_response(self) -> Optional['outputs.RuleGroupCustomResponse']:
        """
        Defines a custom response for the web request.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_response")


@pulumi.output_type
class RuleGroupBody(dict):
    """
    The body of a web request. This immediately follows the request headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oversize_handling: Optional['RuleGroupOversizeHandling'] = None):
        """
        The body of a web request. This immediately follows the request headers.
        :param 'RuleGroupOversizeHandling' oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
               
               Default: `CONTINUE`
        """
        if oversize_handling is not None:
            pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> Optional['RuleGroupOversizeHandling']:
        """
        What AWS WAF should do if the body is larger than AWS WAF can inspect.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

        Default: `CONTINUE`
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class RuleGroupByteMatchStatement(dict):
    """
    Byte Match statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "positionalConstraint":
            suggest = "positional_constraint"
        elif key == "textTransformations":
            suggest = "text_transformations"
        elif key == "searchString":
            suggest = "search_string"
        elif key == "searchStringBase64":
            suggest = "search_string_base64"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupByteMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupByteMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupByteMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.RuleGroupFieldToMatch',
                 positional_constraint: 'RuleGroupPositionalConstraint',
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation'],
                 search_string: Optional[builtins.str] = None,
                 search_string_base64: Optional[builtins.str] = None):
        """
        Byte Match statement.
        :param 'RuleGroupFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param 'RuleGroupPositionalConstraint' positional_constraint: The area within the portion of the web request that you want AWS WAF to search for `SearchString` . Valid values include the following:
               
               *CONTAINS*
               
               The specified part of the web request must include the value of `SearchString` , but the location doesn't matter.
               
               *CONTAINS_WORD*
               
               The specified part of the web request must include the value of `SearchString` , and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:
               
               - `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot` .
               - `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;` .
               
               *EXACTLY*
               
               The value of the specified part of the web request must exactly match the value of `SearchString` .
               
               *STARTS_WITH*
               
               The value of `SearchString` must appear at the beginning of the specified part of the web request.
               
               *ENDS_WITH*
               
               The value of `SearchString` must appear at the end of the specified part of the web request.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        :param builtins.str search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `FieldToMatch` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.
               
               Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.
               
               For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent` . If you want to search the `User-Agent` header for the value `BadBot` , you provide the string `BadBot` in the value of `SearchString` .
               
               You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        :param builtins.str search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in `SearchString` instead.
               
               You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "positional_constraint", positional_constraint)
        pulumi.set(__self__, "text_transformations", text_transformations)
        if search_string is not None:
            pulumi.set(__self__, "search_string", search_string)
        if search_string_base64 is not None:
            pulumi.set(__self__, "search_string_base64", search_string_base64)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RuleGroupFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="positionalConstraint")
    def positional_constraint(self) -> 'RuleGroupPositionalConstraint':
        """
        The area within the portion of the web request that you want AWS WAF to search for `SearchString` . Valid values include the following:

        *CONTAINS*

        The specified part of the web request must include the value of `SearchString` , but the location doesn't matter.

        *CONTAINS_WORD*

        The specified part of the web request must include the value of `SearchString` , and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:

        - `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot` .
        - `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;` .

        *EXACTLY*

        The value of the specified part of the web request must exactly match the value of `SearchString` .

        *STARTS_WITH*

        The value of `SearchString` must appear at the beginning of the specified part of the web request.

        *ENDS_WITH*

        The value of `SearchString` must appear at the end of the specified part of the web request.
        """
        return pulumi.get(self, "positional_constraint")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[builtins.str]:
        """
        A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `FieldToMatch` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

        Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

        For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent` . If you want to search the `User-Agent` header for the value `BadBot` , you provide the string `BadBot` in the value of `SearchString` .

        You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        """
        return pulumi.get(self, "search_string")

    @property
    @pulumi.getter(name="searchStringBase64")
    def search_string_base64(self) -> Optional[builtins.str]:
        """
        String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in `SearchString` instead.

        You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        """
        return pulumi.get(self, "search_string_base64")


@pulumi.output_type
class RuleGroupCaptchaAction(dict):
    """
    Checks valid token exists with request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCaptchaAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCaptchaAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCaptchaAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.RuleGroupCustomRequestHandling'] = None):
        """
        Checks valid token exists with request.
        :param 'RuleGroupCustomRequestHandling' custom_request_handling: Defines custom handling for the web request, used when the `CAPTCHA` inspection determines that the request's token is valid and unexpired.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.RuleGroupCustomRequestHandling']:
        """
        Defines custom handling for the web request, used when the `CAPTCHA` inspection determines that the request's token is valid and unexpired.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class RuleGroupCaptchaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immunityTimeProperty":
            suggest = "immunity_time_property"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCaptchaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCaptchaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCaptchaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immunity_time_property: Optional['outputs.RuleGroupImmunityTimeProperty'] = None):
        """
        :param 'RuleGroupImmunityTimeProperty' immunity_time_property: Determines how long a `CAPTCHA` timestamp in the token remains valid after the client successfully solves a `CAPTCHA` puzzle.
        """
        if immunity_time_property is not None:
            pulumi.set(__self__, "immunity_time_property", immunity_time_property)

    @property
    @pulumi.getter(name="immunityTimeProperty")
    def immunity_time_property(self) -> Optional['outputs.RuleGroupImmunityTimeProperty']:
        """
        Determines how long a `CAPTCHA` timestamp in the token remains valid after the client successfully solves a `CAPTCHA` puzzle.
        """
        return pulumi.get(self, "immunity_time_property")


@pulumi.output_type
class RuleGroupChallengeAction(dict):
    """
    Checks that the request has a valid token with an unexpired challenge timestamp and, if not, returns a browser challenge to the client.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupChallengeAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupChallengeAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupChallengeAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.RuleGroupCustomRequestHandling'] = None):
        """
        Checks that the request has a valid token with an unexpired challenge timestamp and, if not, returns a browser challenge to the client.
        :param 'RuleGroupCustomRequestHandling' custom_request_handling: Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.RuleGroupCustomRequestHandling']:
        """
        Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class RuleGroupChallengeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immunityTimeProperty":
            suggest = "immunity_time_property"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupChallengeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupChallengeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupChallengeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immunity_time_property: Optional['outputs.RuleGroupImmunityTimeProperty'] = None):
        """
        :param 'RuleGroupImmunityTimeProperty' immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
        """
        if immunity_time_property is not None:
            pulumi.set(__self__, "immunity_time_property", immunity_time_property)

    @property
    @pulumi.getter(name="immunityTimeProperty")
    def immunity_time_property(self) -> Optional['outputs.RuleGroupImmunityTimeProperty']:
        """
        Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
        """
        return pulumi.get(self, "immunity_time_property")


@pulumi.output_type
class RuleGroupCookieMatchPattern(dict):
    """
    The pattern to look for in the request cookies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedCookies":
            suggest = "excluded_cookies"
        elif key == "includedCookies":
            suggest = "included_cookies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCookieMatchPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCookieMatchPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCookieMatchPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[Any] = None,
                 excluded_cookies: Optional[Sequence[builtins.str]] = None,
                 included_cookies: Optional[Sequence[builtins.str]] = None):
        """
        The pattern to look for in the request cookies.
        :param Any all: Inspect all parts of the web request cookies.
        :param Sequence[builtins.str] excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
        :param Sequence[builtins.str] included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if excluded_cookies is not None:
            pulumi.set(__self__, "excluded_cookies", excluded_cookies)
        if included_cookies is not None:
            pulumi.set(__self__, "included_cookies", included_cookies)

    @property
    @pulumi.getter
    def all(self) -> Optional[Any]:
        """
        Inspect all parts of the web request cookies.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="excludedCookies")
    def excluded_cookies(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the cookies whose keys don't match any of the strings specified here.
        """
        return pulumi.get(self, "excluded_cookies")

    @property
    @pulumi.getter(name="includedCookies")
    def included_cookies(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the cookies that have a key that matches one of the strings specified here.
        """
        return pulumi.get(self, "included_cookies")


@pulumi.output_type
class RuleGroupCookies(dict):
    """
    Includes cookies of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPattern":
            suggest = "match_pattern"
        elif key == "matchScope":
            suggest = "match_scope"
        elif key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_pattern: 'outputs.RuleGroupCookieMatchPattern',
                 match_scope: 'RuleGroupMapMatchScope',
                 oversize_handling: 'RuleGroupOversizeHandling'):
        """
        Includes cookies of a web request.
        :param 'RuleGroupCookieMatchPattern' match_pattern: The filter to use to identify the subset of cookies to inspect in a web request.
               
               You must specify exactly one setting: either `All` , `IncludedCookies` , or `ExcludedCookies` .
               
               Example JSON: `"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }`
        :param 'RuleGroupMapMatchScope' match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.
               
               `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        :param 'RuleGroupOversizeHandling' oversize_handling: What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available cookies normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "match_pattern", match_pattern)
        pulumi.set(__self__, "match_scope", match_scope)
        pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="matchPattern")
    def match_pattern(self) -> 'outputs.RuleGroupCookieMatchPattern':
        """
        The filter to use to identify the subset of cookies to inspect in a web request.

        You must specify exactly one setting: either `All` , `IncludedCookies` , or `ExcludedCookies` .

        Example JSON: `"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }`
        """
        return pulumi.get(self, "match_pattern")

    @property
    @pulumi.getter(name="matchScope")
    def match_scope(self) -> 'RuleGroupMapMatchScope':
        """
        The parts of the cookies to inspect with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.

        `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        """
        return pulumi.get(self, "match_scope")

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> 'RuleGroupOversizeHandling':
        """
        What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available cookies normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class RuleGroupCountAction(dict):
    """
    Count traffic towards application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCountAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCountAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCountAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.RuleGroupCustomRequestHandling'] = None):
        """
        Count traffic towards application.
        :param 'RuleGroupCustomRequestHandling' custom_request_handling: Defines custom handling for the web request.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.RuleGroupCustomRequestHandling']:
        """
        Defines custom handling for the web request.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class RuleGroupCustomHttpHeader(dict):
    """
    HTTP header.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        HTTP header.
        :param builtins.str name: The name of the custom header.
               
               For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name `x-amzn-waf-` , to avoid confusion with the headers that are already in the request. For example, for the header name `sample` , AWS WAF inserts the header `x-amzn-waf-sample` .
        :param builtins.str value: The value of the custom header.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom header.

        For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name `x-amzn-waf-` , to avoid confusion with the headers that are already in the request. For example, for the header name `sample` , AWS WAF inserts the header `x-amzn-waf-sample` .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the custom header.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleGroupCustomRequestHandling(dict):
    """
    Custom request handling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insertHeaders":
            suggest = "insert_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCustomRequestHandling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCustomRequestHandling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCustomRequestHandling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insert_headers: Sequence['outputs.RuleGroupCustomHttpHeader']):
        """
        Custom request handling.
        :param Sequence['RuleGroupCustomHttpHeader'] insert_headers: Collection of HTTP headers.
        """
        pulumi.set(__self__, "insert_headers", insert_headers)

    @property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Sequence['outputs.RuleGroupCustomHttpHeader']:
        """
        Collection of HTTP headers.
        """
        return pulumi.get(self, "insert_headers")


@pulumi.output_type
class RuleGroupCustomResponse(dict):
    """
    Custom response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseCode":
            suggest = "response_code"
        elif key == "customResponseBodyKey":
            suggest = "custom_response_body_key"
        elif key == "responseHeaders":
            suggest = "response_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCustomResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCustomResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCustomResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 response_code: builtins.int,
                 custom_response_body_key: Optional[builtins.str] = None,
                 response_headers: Optional[Sequence['outputs.RuleGroupCustomHttpHeader']] = None):
        """
        Custom response.
        :param builtins.int response_code: The HTTP status code to return to the client.
               
               For a list of status codes that you can use in your custom responses, see [Supported status codes for custom response](https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html) in the *AWS WAF Developer Guide* .
        :param builtins.str custom_response_body_key: Custom response body key.
        :param Sequence['RuleGroupCustomHttpHeader'] response_headers: Collection of HTTP headers.
        """
        pulumi.set(__self__, "response_code", response_code)
        if custom_response_body_key is not None:
            pulumi.set(__self__, "custom_response_body_key", custom_response_body_key)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> builtins.int:
        """
        The HTTP status code to return to the client.

        For a list of status codes that you can use in your custom responses, see [Supported status codes for custom response](https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "response_code")

    @property
    @pulumi.getter(name="customResponseBodyKey")
    def custom_response_body_key(self) -> Optional[builtins.str]:
        """
        Custom response body key.
        """
        return pulumi.get(self, "custom_response_body_key")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence['outputs.RuleGroupCustomHttpHeader']]:
        """
        Collection of HTTP headers.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class RuleGroupCustomResponseBody(dict):
    """
    Custom response body.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupCustomResponseBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupCustomResponseBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupCustomResponseBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: 'RuleGroupResponseContentType'):
        """
        Custom response body.
        :param builtins.str content: The payload of the custom response.
               
               You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.
               
               For information about the limits on count and size for custom request and response settings, see [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *AWS WAF Developer Guide* .
        :param 'RuleGroupResponseContentType' content_type: The type of content in the payload that you are defining in the `Content` string.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The payload of the custom response.

        You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.

        For information about the limits on count and size for custom request and response settings, see [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> 'RuleGroupResponseContentType':
        """
        The type of content in the payload that you are defining in the `Content` string.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class RuleGroupFieldToMatch(dict):
    """
    Field of the request to match.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allQueryArguments":
            suggest = "all_query_arguments"
        elif key == "ja3Fingerprint":
            suggest = "ja3_fingerprint"
        elif key == "ja4Fingerprint":
            suggest = "ja4_fingerprint"
        elif key == "jsonBody":
            suggest = "json_body"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "singleHeader":
            suggest = "single_header"
        elif key == "singleQueryArgument":
            suggest = "single_query_argument"
        elif key == "uriFragment":
            suggest = "uri_fragment"
        elif key == "uriPath":
            suggest = "uri_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupFieldToMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupFieldToMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupFieldToMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_query_arguments: Optional[Any] = None,
                 body: Optional['outputs.RuleGroupBody'] = None,
                 cookies: Optional['outputs.RuleGroupCookies'] = None,
                 headers: Optional['outputs.RuleGroupHeaders'] = None,
                 ja3_fingerprint: Optional['outputs.RuleGroupJa3Fingerprint'] = None,
                 ja4_fingerprint: Optional['outputs.RuleGroupJa4Fingerprint'] = None,
                 json_body: Optional['outputs.RuleGroupJsonBody'] = None,
                 method: Optional[Any] = None,
                 query_string: Optional[Any] = None,
                 single_header: Optional['outputs.RuleGroupFieldToMatchSingleHeaderProperties'] = None,
                 single_query_argument: Optional['outputs.RuleGroupFieldToMatchSingleQueryArgumentProperties'] = None,
                 uri_fragment: Optional['outputs.RuleGroupUriFragment'] = None,
                 uri_path: Optional[Any] = None):
        """
        Field of the request to match.
        :param Any all_query_arguments: All query arguments of a web request.
        :param 'RuleGroupBody' body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               For information about how to handle oversized request bodies, see the `Body` object configuration.
        :param 'RuleGroupCookies' cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
               
               Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        :param 'RuleGroupHeaders' headers: Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
               
               Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
        :param 'RuleGroupJa3Fingerprint' ja3_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
               
               > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 
               
               You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .
               
               Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        :param 'RuleGroupJa4Fingerprint' ja4_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
               
               > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 
               
               You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .
               
               Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        :param 'RuleGroupJsonBody' json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
        :param Any method: The HTTP method of a web request. The method indicates the type of operation that the request is asking the origin to perform.
        :param Any query_string: The query string of a web request. This is the part of a URL that appears after a ? character, if any.
        :param 'RuleGroupFieldToMatchSingleHeaderProperties' single_header: Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.
               
               Example JSON: `"SingleHeader": { "Name": "haystack" }`
               
               Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
        :param 'RuleGroupFieldToMatchSingleQueryArgumentProperties' single_query_argument: One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
        :param 'RuleGroupUriFragment' uri_fragment: Inspect fragments of the request URI. You must configure scope and pattern matching filters in the `UriFragment` object, to define the fragment of a URI that AWS WAF inspects.
               
               Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the `UriFragment` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        :param Any uri_path: The path component of the URI of a web request. This is the part of a web request that identifies a resource, for example, /images/daily-ad.jpg.
        """
        if all_query_arguments is not None:
            pulumi.set(__self__, "all_query_arguments", all_query_arguments)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ja3_fingerprint is not None:
            pulumi.set(__self__, "ja3_fingerprint", ja3_fingerprint)
        if ja4_fingerprint is not None:
            pulumi.set(__self__, "ja4_fingerprint", ja4_fingerprint)
        if json_body is not None:
            pulumi.set(__self__, "json_body", json_body)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if single_header is not None:
            pulumi.set(__self__, "single_header", single_header)
        if single_query_argument is not None:
            pulumi.set(__self__, "single_query_argument", single_query_argument)
        if uri_fragment is not None:
            pulumi.set(__self__, "uri_fragment", uri_fragment)
        if uri_path is not None:
            pulumi.set(__self__, "uri_path", uri_path)

    @property
    @pulumi.getter(name="allQueryArguments")
    def all_query_arguments(self) -> Optional[Any]:
        """
        All query arguments of a web request.
        """
        return pulumi.get(self, "all_query_arguments")

    @property
    @pulumi.getter
    def body(self) -> Optional['outputs.RuleGroupBody']:
        """
        Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        For information about how to handle oversized request bodies, see the `Body` object configuration.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def cookies(self) -> Optional['outputs.RuleGroupCookies']:
        """
        Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

        Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        """
        return pulumi.get(self, "cookies")

    @property
    @pulumi.getter
    def headers(self) -> Optional['outputs.RuleGroupHeaders']:
        """
        Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

        Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ja3Fingerprint")
    def ja3_fingerprint(self) -> Optional['outputs.RuleGroupJa3Fingerprint']:
        """
        Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.

        > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 

        You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .

        Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        """
        return pulumi.get(self, "ja3_fingerprint")

    @property
    @pulumi.getter(name="ja4Fingerprint")
    def ja4_fingerprint(self) -> Optional['outputs.RuleGroupJa4Fingerprint']:
        """
        Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.

        > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 

        You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .

        Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        """
        return pulumi.get(self, "ja4_fingerprint")

    @property
    @pulumi.getter(name="jsonBody")
    def json_body(self) -> Optional['outputs.RuleGroupJsonBody']:
        """
        Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
        """
        return pulumi.get(self, "json_body")

    @property
    @pulumi.getter
    def method(self) -> Optional[Any]:
        """
        The HTTP method of a web request. The method indicates the type of operation that the request is asking the origin to perform.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[Any]:
        """
        The query string of a web request. This is the part of a URL that appears after a ? character, if any.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="singleHeader")
    def single_header(self) -> Optional['outputs.RuleGroupFieldToMatchSingleHeaderProperties']:
        """
        Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.

        Example JSON: `"SingleHeader": { "Name": "haystack" }`

        Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
        """
        return pulumi.get(self, "single_header")

    @property
    @pulumi.getter(name="singleQueryArgument")
    def single_query_argument(self) -> Optional['outputs.RuleGroupFieldToMatchSingleQueryArgumentProperties']:
        """
        One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
        """
        return pulumi.get(self, "single_query_argument")

    @property
    @pulumi.getter(name="uriFragment")
    def uri_fragment(self) -> Optional['outputs.RuleGroupUriFragment']:
        """
        Inspect fragments of the request URI. You must configure scope and pattern matching filters in the `UriFragment` object, to define the fragment of a URI that AWS WAF inspects.

        Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the `UriFragment` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        """
        return pulumi.get(self, "uri_fragment")

    @property
    @pulumi.getter(name="uriPath")
    def uri_path(self) -> Optional[Any]:
        """
        The path component of the URI of a web request. This is the part of a web request that identifies a resource, for example, /images/daily-ad.jpg.
        """
        return pulumi.get(self, "uri_path")


@pulumi.output_type
class RuleGroupFieldToMatchSingleHeaderProperties(dict):
    """
    Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.

    Example JSON: `"SingleHeader": { "Name": "haystack" }`

    Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.

        Example JSON: `"SingleHeader": { "Name": "haystack" }`

        Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class RuleGroupFieldToMatchSingleQueryArgumentProperties(dict):
    """
    One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class RuleGroupForwardedIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupForwardedIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupForwardedIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupForwardedIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'RuleGroupForwardedIpConfigurationFallbackBehavior',
                 header_name: builtins.str):
        """
        :param 'RuleGroupForwardedIpConfigurationFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        :param builtins.str header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'RuleGroupForwardedIpConfigurationFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class RuleGroupGeoMatchStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCodes":
            suggest = "country_codes"
        elif key == "forwardedIpConfig":
            suggest = "forwarded_ip_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupGeoMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupGeoMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupGeoMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_codes: Optional[Sequence[builtins.str]] = None,
                 forwarded_ip_config: Optional['outputs.RuleGroupForwardedIpConfiguration'] = None):
        """
        :param Sequence[builtins.str] country_codes: An array of two-character country codes that you want to match against, for example, `[ "US", "CN" ]` , from the alpha-2 country ISO codes of the ISO 3166 international standard.
               
               When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
        :param 'RuleGroupForwardedIpConfiguration' forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        if country_codes is not None:
            pulumi.set(__self__, "country_codes", country_codes)
        if forwarded_ip_config is not None:
            pulumi.set(__self__, "forwarded_ip_config", forwarded_ip_config)

    @property
    @pulumi.getter(name="countryCodes")
    def country_codes(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of two-character country codes that you want to match against, for example, `[ "US", "CN" ]` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

        When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
        """
        return pulumi.get(self, "country_codes")

    @property
    @pulumi.getter(name="forwardedIpConfig")
    def forwarded_ip_config(self) -> Optional['outputs.RuleGroupForwardedIpConfiguration']:
        """
        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "forwarded_ip_config")


@pulumi.output_type
class RuleGroupHeaderMatchPattern(dict):
    """
    The pattern to look for in the request headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedHeaders":
            suggest = "excluded_headers"
        elif key == "includedHeaders":
            suggest = "included_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupHeaderMatchPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupHeaderMatchPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupHeaderMatchPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[Any] = None,
                 excluded_headers: Optional[Sequence[builtins.str]] = None,
                 included_headers: Optional[Sequence[builtins.str]] = None):
        """
        The pattern to look for in the request headers.
        :param Any all: Inspect all parts of the web request headers.
        :param Sequence[builtins.str] excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
        :param Sequence[builtins.str] included_headers: Inspect only the headers that have a key that matches one of the strings specified here.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if excluded_headers is not None:
            pulumi.set(__self__, "excluded_headers", excluded_headers)
        if included_headers is not None:
            pulumi.set(__self__, "included_headers", included_headers)

    @property
    @pulumi.getter
    def all(self) -> Optional[Any]:
        """
        Inspect all parts of the web request headers.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="excludedHeaders")
    def excluded_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the headers whose keys don't match any of the strings specified here.
        """
        return pulumi.get(self, "excluded_headers")

    @property
    @pulumi.getter(name="includedHeaders")
    def included_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the headers that have a key that matches one of the strings specified here.
        """
        return pulumi.get(self, "included_headers")


@pulumi.output_type
class RuleGroupHeaders(dict):
    """
    Includes headers of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPattern":
            suggest = "match_pattern"
        elif key == "matchScope":
            suggest = "match_scope"
        elif key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_pattern: 'outputs.RuleGroupHeaderMatchPattern',
                 match_scope: 'RuleGroupMapMatchScope',
                 oversize_handling: 'RuleGroupOversizeHandling'):
        """
        Includes headers of a web request.
        :param 'RuleGroupHeaderMatchPattern' match_pattern: The filter to use to identify the subset of headers to inspect in a web request.
               
               You must specify exactly one setting: either `All` , `IncludedHeaders` , or `ExcludedHeaders` .
               
               Example JSON: `"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }`
        :param 'RuleGroupMapMatchScope' match_scope: The parts of the headers to match with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.
               
               `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        :param 'RuleGroupOversizeHandling' oversize_handling: What AWS WAF should do if the headers determined by your match scope are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "match_pattern", match_pattern)
        pulumi.set(__self__, "match_scope", match_scope)
        pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="matchPattern")
    def match_pattern(self) -> 'outputs.RuleGroupHeaderMatchPattern':
        """
        The filter to use to identify the subset of headers to inspect in a web request.

        You must specify exactly one setting: either `All` , `IncludedHeaders` , or `ExcludedHeaders` .

        Example JSON: `"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }`
        """
        return pulumi.get(self, "match_pattern")

    @property
    @pulumi.getter(name="matchScope")
    def match_scope(self) -> 'RuleGroupMapMatchScope':
        """
        The parts of the headers to match with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.

        `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        """
        return pulumi.get(self, "match_scope")

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> 'RuleGroupOversizeHandling':
        """
        What AWS WAF should do if the headers determined by your match scope are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class RuleGroupImmunityTimeProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immunityTime":
            suggest = "immunity_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupImmunityTimeProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupImmunityTimeProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupImmunityTimeProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immunity_time: builtins.int):
        """
        :param builtins.int immunity_time: The amount of time, in seconds, that a `CAPTCHA` or challenge timestamp is considered valid by AWS WAF . The default setting is 300.
               
               For the Challenge action, the minimum setting is 300.
        """
        pulumi.set(__self__, "immunity_time", immunity_time)

    @property
    @pulumi.getter(name="immunityTime")
    def immunity_time(self) -> builtins.int:
        """
        The amount of time, in seconds, that a `CAPTCHA` or challenge timestamp is considered valid by AWS WAF . The default setting is 300.

        For the Challenge action, the minimum setting is 300.
        """
        return pulumi.get(self, "immunity_time")


@pulumi.output_type
class RuleGroupIpSetForwardedIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupIpSetForwardedIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupIpSetForwardedIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupIpSetForwardedIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'RuleGroupIpSetForwardedIpConfigurationFallbackBehavior',
                 header_name: builtins.str,
                 position: 'RuleGroupIpSetForwardedIpConfigurationPosition'):
        """
        :param 'RuleGroupIpSetForwardedIpConfigurationFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        :param builtins.str header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        :param 'RuleGroupIpSetForwardedIpConfigurationPosition' position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be `10.1.1.1, 127.0.0.0, 10.10.10.10` where the first IP address identifies the original client and the rest identify proxies that the request went through.
               
               The options for this setting are the following:
               
               - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
               - LAST - Inspect the last IP address in the list of IP addresses in the header.
               - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'RuleGroupIpSetForwardedIpConfigurationFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter
    def position(self) -> 'RuleGroupIpSetForwardedIpConfigurationPosition':
        """
        The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be `10.1.1.1, 127.0.0.0, 10.10.10.10` where the first IP address identifies the original client and the rest identify proxies that the request went through.

        The options for this setting are the following:

        - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
        - LAST - Inspect the last IP address in the list of IP addresses in the header.
        - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.
        """
        return pulumi.get(self, "position")


@pulumi.output_type
class RuleGroupIpSetReferenceStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipSetForwardedIpConfig":
            suggest = "ip_set_forwarded_ip_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupIpSetReferenceStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupIpSetReferenceStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupIpSetReferenceStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 ip_set_forwarded_ip_config: Optional['outputs.RuleGroupIpSetForwardedIpConfiguration'] = None):
        """
        :param builtins.str arn: The Amazon Resource Name (ARN) of the `IPSet` that this statement references.
        :param 'RuleGroupIpSetForwardedIpConfiguration' ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        pulumi.set(__self__, "arn", arn)
        if ip_set_forwarded_ip_config is not None:
            pulumi.set(__self__, "ip_set_forwarded_ip_config", ip_set_forwarded_ip_config)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the `IPSet` that this statement references.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="ipSetForwardedIpConfig")
    def ip_set_forwarded_ip_config(self) -> Optional['outputs.RuleGroupIpSetForwardedIpConfiguration']:
        """
        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "ip_set_forwarded_ip_config")


@pulumi.output_type
class RuleGroupJa3Fingerprint(dict):
    """
    Includes the JA3 fingerprint of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupJa3Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupJa3Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupJa3Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'RuleGroupJa3FingerprintFallbackBehavior'):
        """
        Includes the JA3 fingerprint of a web request.
        :param 'RuleGroupJa3FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'RuleGroupJa3FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a JA3 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class RuleGroupJa4Fingerprint(dict):
    """
    Includes the JA4 fingerprint of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupJa4Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupJa4Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupJa4Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'RuleGroupJa4FingerprintFallbackBehavior'):
        """
        Includes the JA4 fingerprint of a web request.
        :param 'RuleGroupJa4FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a JA4 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'RuleGroupJa4FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a JA4 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class RuleGroupJsonBody(dict):
    """
    Inspect the request body as JSON. The request body immediately follows the request headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPattern":
            suggest = "match_pattern"
        elif key == "matchScope":
            suggest = "match_scope"
        elif key == "invalidFallbackBehavior":
            suggest = "invalid_fallback_behavior"
        elif key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupJsonBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupJsonBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupJsonBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_pattern: 'outputs.RuleGroupJsonMatchPattern',
                 match_scope: 'RuleGroupJsonMatchScope',
                 invalid_fallback_behavior: Optional['RuleGroupBodyParsingFallbackBehavior'] = None,
                 oversize_handling: Optional['RuleGroupOversizeHandling'] = None):
        """
        Inspect the request body as JSON. The request body immediately follows the request headers.
        :param 'RuleGroupJsonMatchPattern' match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
        :param 'RuleGroupJsonMatchScope' match_scope: The parts of the JSON to match against using the `MatchPattern` . If you specify `ALL` , AWS WAF matches against keys and values.
               
               `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        :param 'RuleGroupBodyParsingFallbackBehavior' invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:
               
               - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
               
               > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        :param 'RuleGroupOversizeHandling' oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
               
               Default: `CONTINUE`
        """
        pulumi.set(__self__, "match_pattern", match_pattern)
        pulumi.set(__self__, "match_scope", match_scope)
        if invalid_fallback_behavior is not None:
            pulumi.set(__self__, "invalid_fallback_behavior", invalid_fallback_behavior)
        if oversize_handling is not None:
            pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="matchPattern")
    def match_pattern(self) -> 'outputs.RuleGroupJsonMatchPattern':
        """
        The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
        """
        return pulumi.get(self, "match_pattern")

    @property
    @pulumi.getter(name="matchScope")
    def match_scope(self) -> 'RuleGroupJsonMatchScope':
        """
        The parts of the JSON to match against using the `MatchPattern` . If you specify `ALL` , AWS WAF matches against keys and values.

        `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        """
        return pulumi.get(self, "match_scope")

    @property
    @pulumi.getter(name="invalidFallbackBehavior")
    def invalid_fallback_behavior(self) -> Optional['RuleGroupBodyParsingFallbackBehavior']:
        """
        What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:

        - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

        > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "invalid_fallback_behavior")

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> Optional['RuleGroupOversizeHandling']:
        """
        What AWS WAF should do if the body is larger than AWS WAF can inspect.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

        Default: `CONTINUE`
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class RuleGroupJsonMatchPattern(dict):
    """
    The pattern to look for in the JSON body.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includedPaths":
            suggest = "included_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupJsonMatchPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupJsonMatchPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupJsonMatchPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[Any] = None,
                 included_paths: Optional[Sequence[builtins.str]] = None):
        """
        The pattern to look for in the JSON body.
        :param Any all: Inspect all parts of the web request's JSON body.
        :param Sequence[builtins.str] included_paths: Match only the specified include paths. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.
               
               Provide the include paths using JSON Pointer syntax. For example, `"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               You must specify either this setting or the `All` setting, but not both.
               
               > Don't use this option to include all paths. Instead, use the `All` setting.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)

    @property
    @pulumi.getter
    def all(self) -> Optional[Any]:
        """
        Inspect all parts of the web request's JSON body.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        Match only the specified include paths. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.

        Provide the include paths using JSON Pointer syntax. For example, `"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        You must specify either this setting or the `All` setting, but not both.

        > Don't use this option to include all paths. Instead, use the `All` setting.
        """
        return pulumi.get(self, "included_paths")


@pulumi.output_type
class RuleGroupLabel(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: The label string.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The label string.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RuleGroupLabelMatchStatement(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 scope: 'RuleGroupLabelMatchScope'):
        """
        :param builtins.str key: The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:
               
               - If the `Scope` indicates `LABEL` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
               - If the `Scope` indicates `NAMESPACE` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.
               
               Labels are case sensitive and components of a label must be separated by colon, for example `NS1:NS2:name` .
        :param 'RuleGroupLabelMatchScope' scope: Specify whether you want to match using the label name or just the namespace.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:

        - If the `Scope` indicates `LABEL` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
        - If the `Scope` indicates `NAMESPACE` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

        Labels are case sensitive and components of a label must be separated by colon, for example `NS1:NS2:name` .
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> 'RuleGroupLabelMatchScope':
        """
        Specify whether you want to match using the label name or just the namespace.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class RuleGroupLabelSummary(dict):
    def __init__(__self__, *,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str name: An individual label specification.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        An individual label specification.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class RuleGroupNotStatement(dict):
    def __init__(__self__, *,
                 statement: 'outputs.RuleGroupStatement'):
        """
        :param 'RuleGroupStatement' statement: The statement to negate. You can use any statement that can be nested.
        """
        pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def statement(self) -> 'outputs.RuleGroupStatement':
        """
        The statement to negate. You can use any statement that can be nested.
        """
        return pulumi.get(self, "statement")


@pulumi.output_type
class RuleGroupOrStatement(dict):
    def __init__(__self__, *,
                 statements: Sequence['outputs.RuleGroupStatement']):
        """
        :param Sequence['RuleGroupStatement'] statements: The statements to combine with OR logic. You can use any statements that can be nested.
        """
        pulumi.set(__self__, "statements", statements)

    @property
    @pulumi.getter
    def statements(self) -> Sequence['outputs.RuleGroupStatement']:
        """
        The statements to combine with OR logic. You can use any statements that can be nested.
        """
        return pulumi.get(self, "statements")


@pulumi.output_type
class RuleGroupRateBasedStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregateKeyType":
            suggest = "aggregate_key_type"
        elif key == "customKeys":
            suggest = "custom_keys"
        elif key == "evaluationWindowSec":
            suggest = "evaluation_window_sec"
        elif key == "forwardedIpConfig":
            suggest = "forwarded_ip_config"
        elif key == "scopeDownStatement":
            suggest = "scope_down_statement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateBasedStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateBasedStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateBasedStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregate_key_type: 'RuleGroupRateBasedStatementAggregateKeyType',
                 limit: builtins.int,
                 custom_keys: Optional[Sequence['outputs.RuleGroupRateBasedStatementCustomKey']] = None,
                 evaluation_window_sec: Optional[builtins.int] = None,
                 forwarded_ip_config: Optional['outputs.RuleGroupForwardedIpConfiguration'] = None,
                 scope_down_statement: Optional['outputs.RuleGroupStatement'] = None):
        """
        :param 'RuleGroupRateBasedStatementAggregateKeyType' aggregate_key_type: Setting that indicates how to aggregate the request counts.
               
               > Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. 
               
               - `CONSTANT` - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.
               
               With this option, you must configure the `ScopeDownStatement` property.
               - `CUSTOM_KEYS` - Aggregate the request counts using one or more web request components as the aggregate keys.
               
               With this option, you must specify the aggregate keys in the `CustomKeys` property.
               
               To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to `IP` or `FORWARDED_IP` .
               - `FORWARDED_IP` - Aggregate the request counts on the first IP address in an HTTP header.
               
               With this option, you must specify the header to use in the `ForwardedIPConfig` property.
               
               To aggregate on a combination of the forwarded IP address with other aggregate keys, use `CUSTOM_KEYS` .
               - `IP` - Aggregate the request counts on the IP address from the web request origin.
               
               To aggregate on a combination of the IP address with other aggregate keys, use `CUSTOM_KEYS` .
        :param builtins.int limit: The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule. If the rate-based statement includes a `ScopeDownStatement` , this limit is applied only to the requests that match the statement.
               
               Examples:
               
               - If you aggregate on just the IP address, this is the limit on requests from any single IP address.
               - If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.
        :param Sequence['RuleGroupRateBasedStatementCustomKey'] custom_keys: Specifies the aggregate keys to use in a rate-base rule.
        :param builtins.int evaluation_window_sec: The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time. For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.
               
               This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.
               
               Default: `300` (5 minutes)
        :param 'RuleGroupForwardedIpConfiguration' forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 
               
               This is required if you specify a forwarded IP in the rule's aggregate key settings.
        :param 'RuleGroupStatement' scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement. When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
        """
        pulumi.set(__self__, "aggregate_key_type", aggregate_key_type)
        pulumi.set(__self__, "limit", limit)
        if custom_keys is not None:
            pulumi.set(__self__, "custom_keys", custom_keys)
        if evaluation_window_sec is not None:
            pulumi.set(__self__, "evaluation_window_sec", evaluation_window_sec)
        if forwarded_ip_config is not None:
            pulumi.set(__self__, "forwarded_ip_config", forwarded_ip_config)
        if scope_down_statement is not None:
            pulumi.set(__self__, "scope_down_statement", scope_down_statement)

    @property
    @pulumi.getter(name="aggregateKeyType")
    def aggregate_key_type(self) -> 'RuleGroupRateBasedStatementAggregateKeyType':
        """
        Setting that indicates how to aggregate the request counts.

        > Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. 

        - `CONSTANT` - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.

        With this option, you must configure the `ScopeDownStatement` property.
        - `CUSTOM_KEYS` - Aggregate the request counts using one or more web request components as the aggregate keys.

        With this option, you must specify the aggregate keys in the `CustomKeys` property.

        To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to `IP` or `FORWARDED_IP` .
        - `FORWARDED_IP` - Aggregate the request counts on the first IP address in an HTTP header.

        With this option, you must specify the header to use in the `ForwardedIPConfig` property.

        To aggregate on a combination of the forwarded IP address with other aggregate keys, use `CUSTOM_KEYS` .
        - `IP` - Aggregate the request counts on the IP address from the web request origin.

        To aggregate on a combination of the IP address with other aggregate keys, use `CUSTOM_KEYS` .
        """
        return pulumi.get(self, "aggregate_key_type")

    @property
    @pulumi.getter
    def limit(self) -> builtins.int:
        """
        The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule. If the rate-based statement includes a `ScopeDownStatement` , this limit is applied only to the requests that match the statement.

        Examples:

        - If you aggregate on just the IP address, this is the limit on requests from any single IP address.
        - If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="customKeys")
    def custom_keys(self) -> Optional[Sequence['outputs.RuleGroupRateBasedStatementCustomKey']]:
        """
        Specifies the aggregate keys to use in a rate-base rule.
        """
        return pulumi.get(self, "custom_keys")

    @property
    @pulumi.getter(name="evaluationWindowSec")
    def evaluation_window_sec(self) -> Optional[builtins.int]:
        """
        The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time. For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.

        This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.

        Default: `300` (5 minutes)
        """
        return pulumi.get(self, "evaluation_window_sec")

    @property
    @pulumi.getter(name="forwardedIpConfig")
    def forwarded_ip_config(self) -> Optional['outputs.RuleGroupForwardedIpConfiguration']:
        """
        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 

        This is required if you specify a forwarded IP in the rule's aggregate key settings.
        """
        return pulumi.get(self, "forwarded_ip_config")

    @property
    @pulumi.getter(name="scopeDownStatement")
    def scope_down_statement(self) -> Optional['outputs.RuleGroupStatement']:
        """
        An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement. When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
        """
        return pulumi.get(self, "scope_down_statement")


@pulumi.output_type
class RuleGroupRateBasedStatementCustomKey(dict):
    """
    Specifies a single custom aggregate key for a rate-base rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardedIp":
            suggest = "forwarded_ip"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "ja3Fingerprint":
            suggest = "ja3_fingerprint"
        elif key == "ja4Fingerprint":
            suggest = "ja4_fingerprint"
        elif key == "labelNamespace":
            suggest = "label_namespace"
        elif key == "queryArgument":
            suggest = "query_argument"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "uriPath":
            suggest = "uri_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateBasedStatementCustomKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateBasedStatementCustomKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateBasedStatementCustomKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie: Optional['outputs.RuleGroupRateLimitCookie'] = None,
                 forwarded_ip: Optional['outputs.RuleGroupRateLimitForwardedIp'] = None,
                 header: Optional['outputs.RuleGroupRateLimitHeader'] = None,
                 http_method: Optional['outputs.RuleGroupRateLimitHttpMethod'] = None,
                 ip: Optional['outputs.RuleGroupRateLimitIp'] = None,
                 ja3_fingerprint: Optional['outputs.RuleGroupRateLimitJa3Fingerprint'] = None,
                 ja4_fingerprint: Optional['outputs.RuleGroupRateLimitJa4Fingerprint'] = None,
                 label_namespace: Optional['outputs.RuleGroupRateLimitLabelNamespace'] = None,
                 query_argument: Optional['outputs.RuleGroupRateLimitQueryArgument'] = None,
                 query_string: Optional['outputs.RuleGroupRateLimitQueryString'] = None,
                 uri_path: Optional['outputs.RuleGroupRateLimitUriPath'] = None):
        """
        Specifies a single custom aggregate key for a rate-base rule.
        :param 'RuleGroupRateLimitCookie' cookie: Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
        :param 'RuleGroupRateLimitForwardedIp' forwarded_ip: Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.
               
               When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying `FORWARDED_IP` in your rate-based statement's `AggregateKeyType` .
               
               With this option, you must specify the header to use in the rate-based rule's `ForwardedIPConfig` property.
        :param 'RuleGroupRateLimitHeader' header: Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
        :param 'RuleGroupRateLimitHttpMethod' http_method: Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
        :param 'RuleGroupRateLimitIp' ip: Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.
               
               When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying `IP` in your rate-based statement's `AggregateKeyType` .
        :param 'RuleGroupRateLimitJa3Fingerprint' ja3_fingerprint: Use the request's JA3 fingerprint as an aggregate key. If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
        :param 'RuleGroupRateLimitJa4Fingerprint' ja4_fingerprint: Use the request's JA4 fingerprint as an aggregate key. If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
        :param 'RuleGroupRateLimitLabelNamespace' label_namespace: Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
               
               This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
               
               For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *AWS WAF Developer Guide* .
        :param 'RuleGroupRateLimitQueryArgument' query_argument: Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
        :param 'RuleGroupRateLimitQueryString' query_string: Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
        :param 'RuleGroupRateLimitUriPath' uri_path: Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
        """
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if forwarded_ip is not None:
            pulumi.set(__self__, "forwarded_ip", forwarded_ip)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ja3_fingerprint is not None:
            pulumi.set(__self__, "ja3_fingerprint", ja3_fingerprint)
        if ja4_fingerprint is not None:
            pulumi.set(__self__, "ja4_fingerprint", ja4_fingerprint)
        if label_namespace is not None:
            pulumi.set(__self__, "label_namespace", label_namespace)
        if query_argument is not None:
            pulumi.set(__self__, "query_argument", query_argument)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if uri_path is not None:
            pulumi.set(__self__, "uri_path", uri_path)

    @property
    @pulumi.getter
    def cookie(self) -> Optional['outputs.RuleGroupRateLimitCookie']:
        """
        Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "cookie")

    @property
    @pulumi.getter(name="forwardedIp")
    def forwarded_ip(self) -> Optional['outputs.RuleGroupRateLimitForwardedIp']:
        """
        Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.

        When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying `FORWARDED_IP` in your rate-based statement's `AggregateKeyType` .

        With this option, you must specify the header to use in the rate-based rule's `ForwardedIPConfig` property.
        """
        return pulumi.get(self, "forwarded_ip")

    @property
    @pulumi.getter
    def header(self) -> Optional['outputs.RuleGroupRateLimitHeader']:
        """
        Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional['outputs.RuleGroupRateLimitHttpMethod']:
        """
        Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.RuleGroupRateLimitIp']:
        """
        Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.

        When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying `IP` in your rate-based statement's `AggregateKeyType` .
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ja3Fingerprint")
    def ja3_fingerprint(self) -> Optional['outputs.RuleGroupRateLimitJa3Fingerprint']:
        """
        Use the request's JA3 fingerprint as an aggregate key. If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "ja3_fingerprint")

    @property
    @pulumi.getter(name="ja4Fingerprint")
    def ja4_fingerprint(self) -> Optional['outputs.RuleGroupRateLimitJa4Fingerprint']:
        """
        Use the request's JA4 fingerprint as an aggregate key. If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "ja4_fingerprint")

    @property
    @pulumi.getter(name="labelNamespace")
    def label_namespace(self) -> Optional['outputs.RuleGroupRateLimitLabelNamespace']:
        """
        Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.

        This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.

        For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "label_namespace")

    @property
    @pulumi.getter(name="queryArgument")
    def query_argument(self) -> Optional['outputs.RuleGroupRateLimitQueryArgument']:
        """
        Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "query_argument")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional['outputs.RuleGroupRateLimitQueryString']:
        """
        Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="uriPath")
    def uri_path(self) -> Optional['outputs.RuleGroupRateLimitUriPath']:
        """
        Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
        """
        return pulumi.get(self, "uri_path")


@pulumi.output_type
class RuleGroupRateLimitCookie(dict):
    """
    Specifies a cookie as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitCookie. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitCookie.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitCookie.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Specifies a cookie as an aggregate key for a rate-based rule.
        :param builtins.str name: The name of the cookie to use.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the cookie to use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRateLimitForwardedIp(dict):
    """
    Specifies the first IP address in an HTTP header as an aggregate key for a rate-based rule.
    """
    def __init__(__self__):
        """
        Specifies the first IP address in an HTTP header as an aggregate key for a rate-based rule.
        """
        pass


@pulumi.output_type
class RuleGroupRateLimitHeader(dict):
    """
    Specifies a header as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Specifies a header as an aggregate key for a rate-based rule.
        :param builtins.str name: The name of the header to use.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the header to use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRateLimitHttpMethod(dict):
    """
    Specifies the request's HTTP method as an aggregate key for a rate-based rule.
    """
    def __init__(__self__):
        """
        Specifies the request's HTTP method as an aggregate key for a rate-based rule.
        """
        pass


@pulumi.output_type
class RuleGroupRateLimitIp(dict):
    """
    Specifies the IP address in the web request as an aggregate key for a rate-based rule.
    """
    def __init__(__self__):
        """
        Specifies the IP address in the web request as an aggregate key for a rate-based rule.
        """
        pass


@pulumi.output_type
class RuleGroupRateLimitJa3Fingerprint(dict):
    """
    Specifies the request's JA3 fingerprint as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitJa3Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitJa3Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitJa3Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'RuleGroupRateLimitJa3FingerprintFallbackBehavior'):
        """
        Specifies the request's JA3 fingerprint as an aggregate key for a rate-based rule.
        :param 'RuleGroupRateLimitJa3FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'RuleGroupRateLimitJa3FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class RuleGroupRateLimitJa4Fingerprint(dict):
    """
    Specifies the request's JA4 fingerprint as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitJa4Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitJa4Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitJa4Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'RuleGroupRateLimitJa4FingerprintFallbackBehavior'):
        """
        Specifies the request's JA4 fingerprint as an aggregate key for a rate-based rule.
        :param 'RuleGroupRateLimitJa4FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'RuleGroupRateLimitJa4FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class RuleGroupRateLimitLabelNamespace(dict):
    """
    Specifies a label namespace to use as an aggregate key for a rate-based rule.
    """
    def __init__(__self__, *,
                 namespace: builtins.str):
        """
        Specifies a label namespace to use as an aggregate key for a rate-based rule.
        :param builtins.str namespace: The namespace to use for aggregation.
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace to use for aggregation.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class RuleGroupRateLimitQueryArgument(dict):
    """
    Specifies a query argument in the request as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitQueryArgument. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitQueryArgument.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitQueryArgument.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Specifies a query argument in the request as an aggregate key for a rate-based rule.
        :param builtins.str name: The name of the query argument to use.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the query argument to use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRateLimitQueryString(dict):
    """
    Specifies the request's query string as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitQueryString. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitQueryString.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitQueryString.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Specifies the request's query string as an aggregate key for a rate-based rule.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRateLimitUriPath(dict):
    """
    Specifies the request's URI Path as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRateLimitUriPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRateLimitUriPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRateLimitUriPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Specifies the request's URI Path as an aggregate key for a rate-based rule.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRegexMatchStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "regexString":
            suggest = "regex_string"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRegexMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRegexMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRegexMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.RuleGroupFieldToMatch',
                 regex_string: builtins.str,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        :param 'RuleGroupFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param builtins.str regex_string: The string representing the regular expression.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "regex_string", regex_string)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RuleGroupFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="regexString")
    def regex_string(self) -> builtins.str:
        """
        The string representing the regular expression.
        """
        return pulumi.get(self, "regex_string")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRegexPatternSetReferenceStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRegexPatternSetReferenceStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRegexPatternSetReferenceStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRegexPatternSetReferenceStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 field_to_match: 'outputs.RuleGroupFieldToMatch',
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        :param builtins.str arn: The Amazon Resource Name (ARN) of the `RegexPatternSet` that this statement references.
        :param 'RuleGroupFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the `RegexPatternSet` that this statement references.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RuleGroupFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupRule(dict):
    """
    Rule of RuleGroup that contains condition and action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "visibilityConfig":
            suggest = "visibility_config"
        elif key == "captchaConfig":
            suggest = "captcha_config"
        elif key == "challengeConfig":
            suggest = "challenge_config"
        elif key == "ruleLabels":
            suggest = "rule_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 priority: builtins.int,
                 statement: 'outputs.RuleGroupStatement',
                 visibility_config: 'outputs.RuleGroupVisibilityConfig',
                 action: Optional['outputs.RuleGroupRuleAction'] = None,
                 captcha_config: Optional['outputs.RuleGroupCaptchaConfig'] = None,
                 challenge_config: Optional['outputs.RuleGroupChallengeConfig'] = None,
                 rule_labels: Optional[Sequence['outputs.RuleGroupLabel']] = None):
        """
        Rule of RuleGroup that contains condition and action.
        :param builtins.str name: The name of the rule.
               
               If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's `VisibilityConfig` settings. AWS WAF doesn't automatically update the metric name when you update the rule name.
        :param builtins.int priority: If you define more than one `Rule` in a `WebACL` , AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
        :param 'RuleGroupStatement' statement: The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` .
        :param 'RuleGroupVisibilityConfig' visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
               
               If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. AWS WAF doesn't automatically update the metric name.
        :param 'RuleGroupRuleAction' action: The action that AWS WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
        :param 'RuleGroupCaptchaConfig' captcha_config: Specifies how AWS WAF should handle `CAPTCHA` evaluations. If you don't specify this, AWS WAF uses the `CAPTCHA` configuration that's defined for the web ACL.
        :param 'RuleGroupChallengeConfig' challenge_config: Specifies how AWS WAF should handle `Challenge` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
        :param Sequence['RuleGroupLabel'] rule_labels: Collection of Rule Labels.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "visibility_config", visibility_config)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if captcha_config is not None:
            pulumi.set(__self__, "captcha_config", captcha_config)
        if challenge_config is not None:
            pulumi.set(__self__, "challenge_config", challenge_config)
        if rule_labels is not None:
            pulumi.set(__self__, "rule_labels", rule_labels)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule.

        If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's `VisibilityConfig` settings. AWS WAF doesn't automatically update the metric name when you update the rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        If you define more than one `Rule` in a `WebACL` , AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def statement(self) -> 'outputs.RuleGroupStatement':
        """
        The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` .
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter(name="visibilityConfig")
    def visibility_config(self) -> 'outputs.RuleGroupVisibilityConfig':
        """
        Defines and enables Amazon CloudWatch metrics and web request sample collection.

        If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. AWS WAF doesn't automatically update the metric name.
        """
        return pulumi.get(self, "visibility_config")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.RuleGroupRuleAction']:
        """
        The action that AWS WAF should take on a web request when it matches the rule statement. Settings at the web ACL level can override the rule action setting.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="captchaConfig")
    def captcha_config(self) -> Optional['outputs.RuleGroupCaptchaConfig']:
        """
        Specifies how AWS WAF should handle `CAPTCHA` evaluations. If you don't specify this, AWS WAF uses the `CAPTCHA` configuration that's defined for the web ACL.
        """
        return pulumi.get(self, "captcha_config")

    @property
    @pulumi.getter(name="challengeConfig")
    def challenge_config(self) -> Optional['outputs.RuleGroupChallengeConfig']:
        """
        Specifies how AWS WAF should handle `Challenge` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
        """
        return pulumi.get(self, "challenge_config")

    @property
    @pulumi.getter(name="ruleLabels")
    def rule_labels(self) -> Optional[Sequence['outputs.RuleGroupLabel']]:
        """
        Collection of Rule Labels.
        """
        return pulumi.get(self, "rule_labels")


@pulumi.output_type
class RuleGroupRuleAction(dict):
    """
    Action taken when Rule matches its condition.
    """
    def __init__(__self__, *,
                 allow: Optional['outputs.RuleGroupAllowAction'] = None,
                 block: Optional['outputs.RuleGroupBlockAction'] = None,
                 captcha: Optional['outputs.RuleGroupCaptchaAction'] = None,
                 challenge: Optional['outputs.RuleGroupChallengeAction'] = None,
                 count: Optional['outputs.RuleGroupCountAction'] = None):
        """
        Action taken when Rule matches its condition.
        :param 'RuleGroupAllowAction' allow: Instructs AWS WAF to allow the web request.
        :param 'RuleGroupBlockAction' block: Instructs AWS WAF to block the web request.
        :param 'RuleGroupCaptchaAction' captcha: Specifies that AWS WAF should run a `CAPTCHA` check against the request:
               
               - If the request includes a valid, unexpired `CAPTCHA` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a `CountAction` .
               - If the request doesn't include a valid, unexpired `CAPTCHA` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.
               
               AWS WAF generates a response that it sends back to the client, which includes the following:
               
               - The header `x-amzn-waf-action` with a value of `captcha` .
               - The HTTP status code `405 Method Not Allowed` .
               - If the request contains an `Accept` header with a value of `text/html` , the response includes a `CAPTCHA` challenge.
               
               You can configure the expiration time in the `CaptchaConfig` `ImmunityTimeProperty` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
               
               This action option is available for rules. It isn't available for web ACL default actions.
        :param 'RuleGroupChallengeAction' challenge: Instructs AWS WAF to run a `Challenge` check against the web request.
        :param 'RuleGroupCountAction' count: Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if block is not None:
            pulumi.set(__self__, "block", block)
        if captcha is not None:
            pulumi.set(__self__, "captcha", captcha)
        if challenge is not None:
            pulumi.set(__self__, "challenge", challenge)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def allow(self) -> Optional['outputs.RuleGroupAllowAction']:
        """
        Instructs AWS WAF to allow the web request.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def block(self) -> Optional['outputs.RuleGroupBlockAction']:
        """
        Instructs AWS WAF to block the web request.
        """
        return pulumi.get(self, "block")

    @property
    @pulumi.getter
    def captcha(self) -> Optional['outputs.RuleGroupCaptchaAction']:
        """
        Specifies that AWS WAF should run a `CAPTCHA` check against the request:

        - If the request includes a valid, unexpired `CAPTCHA` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a `CountAction` .
        - If the request doesn't include a valid, unexpired `CAPTCHA` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

        AWS WAF generates a response that it sends back to the client, which includes the following:

        - The header `x-amzn-waf-action` with a value of `captcha` .
        - The HTTP status code `405 Method Not Allowed` .
        - If the request contains an `Accept` header with a value of `text/html` , the response includes a `CAPTCHA` challenge.

        You can configure the expiration time in the `CaptchaConfig` `ImmunityTimeProperty` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

        This action option is available for rules. It isn't available for web ACL default actions.
        """
        return pulumi.get(self, "captcha")

    @property
    @pulumi.getter
    def challenge(self) -> Optional['outputs.RuleGroupChallengeAction']:
        """
        Instructs AWS WAF to run a `Challenge` check against the web request.
        """
        return pulumi.get(self, "challenge")

    @property
    @pulumi.getter
    def count(self) -> Optional['outputs.RuleGroupCountAction']:
        """
        Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class RuleGroupSizeConstraintStatement(dict):
    """
    Size Constraint statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupSizeConstraintStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupSizeConstraintStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupSizeConstraintStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: 'RuleGroupSizeConstraintStatementComparisonOperator',
                 field_to_match: 'outputs.RuleGroupFieldToMatch',
                 size: builtins.float,
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Size Constraint statement.
        :param 'RuleGroupSizeConstraintStatementComparisonOperator' comparison_operator: The operator to use to compare the request part to the size setting.
        :param 'RuleGroupFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param builtins.float size: The size, in byte, to compare to the request part, after any transformations.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> 'RuleGroupSizeConstraintStatementComparisonOperator':
        """
        The operator to use to compare the request part to the size setting.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RuleGroupFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter
    def size(self) -> builtins.float:
        """
        The size, in byte, to compare to the request part, after any transformations.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class RuleGroupSqliMatchStatement(dict):
    """
    Sqli Match Statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"
        elif key == "sensitivityLevel":
            suggest = "sensitivity_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupSqliMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupSqliMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupSqliMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.RuleGroupFieldToMatch',
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation'],
                 sensitivity_level: Optional['RuleGroupSensitivityLevel'] = None):
        """
        Sqli Match Statement.
        :param 'RuleGroupFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        :param 'RuleGroupSensitivityLevel' sensitivity_level: The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.
               
               `HIGH` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see [Testing and tuning](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html) in the *AWS WAF Developer Guide* .
               
               `LOW` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.
               
               Default: `LOW`
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformations", text_transformations)
        if sensitivity_level is not None:
            pulumi.set(__self__, "sensitivity_level", sensitivity_level)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RuleGroupFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")

    @property
    @pulumi.getter(name="sensitivityLevel")
    def sensitivity_level(self) -> Optional['RuleGroupSensitivityLevel']:
        """
        The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.

        `HIGH` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see [Testing and tuning](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html) in the *AWS WAF Developer Guide* .

        `LOW` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.

        Default: `LOW`
        """
        return pulumi.get(self, "sensitivity_level")


@pulumi.output_type
class RuleGroupStatement(dict):
    """
    First level statement that contains conditions, such as ByteMatch, SizeConstraint, etc
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "andStatement":
            suggest = "and_statement"
        elif key == "byteMatchStatement":
            suggest = "byte_match_statement"
        elif key == "geoMatchStatement":
            suggest = "geo_match_statement"
        elif key == "ipSetReferenceStatement":
            suggest = "ip_set_reference_statement"
        elif key == "labelMatchStatement":
            suggest = "label_match_statement"
        elif key == "notStatement":
            suggest = "not_statement"
        elif key == "orStatement":
            suggest = "or_statement"
        elif key == "rateBasedStatement":
            suggest = "rate_based_statement"
        elif key == "regexMatchStatement":
            suggest = "regex_match_statement"
        elif key == "regexPatternSetReferenceStatement":
            suggest = "regex_pattern_set_reference_statement"
        elif key == "sizeConstraintStatement":
            suggest = "size_constraint_statement"
        elif key == "sqliMatchStatement":
            suggest = "sqli_match_statement"
        elif key == "xssMatchStatement":
            suggest = "xss_match_statement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_statement: Optional['outputs.RuleGroupAndStatement'] = None,
                 byte_match_statement: Optional['outputs.RuleGroupByteMatchStatement'] = None,
                 geo_match_statement: Optional['outputs.RuleGroupGeoMatchStatement'] = None,
                 ip_set_reference_statement: Optional['outputs.RuleGroupIpSetReferenceStatement'] = None,
                 label_match_statement: Optional['outputs.RuleGroupLabelMatchStatement'] = None,
                 not_statement: Optional['outputs.RuleGroupNotStatement'] = None,
                 or_statement: Optional['outputs.RuleGroupOrStatement'] = None,
                 rate_based_statement: Optional['outputs.RuleGroupRateBasedStatement'] = None,
                 regex_match_statement: Optional['outputs.RuleGroupRegexMatchStatement'] = None,
                 regex_pattern_set_reference_statement: Optional['outputs.RuleGroupRegexPatternSetReferenceStatement'] = None,
                 size_constraint_statement: Optional['outputs.RuleGroupSizeConstraintStatement'] = None,
                 sqli_match_statement: Optional['outputs.RuleGroupSqliMatchStatement'] = None,
                 xss_match_statement: Optional['outputs.RuleGroupXssMatchStatement'] = None):
        """
        First level statement that contains conditions, such as ByteMatch, SizeConstraint, etc
        :param 'RuleGroupAndStatement' and_statement: A logical rule statement used to combine other rule statements with AND logic. You provide more than one `Statement` within the `AndStatement` .
        :param 'RuleGroupByteMatchStatement' byte_match_statement: A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
        :param 'RuleGroupGeoMatchStatement' geo_match_statement: A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.
               
               - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
               - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.
               
               AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig` .
               
               If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>` .
               
               If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>` .
               
               For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) .
        :param 'RuleGroupIpSetReferenceStatement' ip_set_reference_statement: A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an `IPSet` that specifies the addresses you want to detect, then use the ARN of that set in this statement.
               
               Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        :param 'RuleGroupLabelMatchStatement' label_match_statement: A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.
               
               The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
        :param 'RuleGroupNotStatement' not_statement: A logical rule statement used to negate the results of another rule statement. You provide one `Statement` within the `NotStatement` .
        :param 'RuleGroupOrStatement' or_statement: A logical rule statement used to combine other rule statements with OR logic. You provide more than one `Statement` within the `OrStatement` .
        :param 'RuleGroupRateBasedStatement' rate_based_statement: A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
               
               > If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute. 
               
               You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.
               
               Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.
               
               For example, assume the rule evaluates web requests with the following IP address and HTTP method values:
               
               - IP address 10.1.1.1, HTTP method POST
               - IP address 10.1.1.1, HTTP method GET
               - IP address 127.0.0.0, HTTP method POST
               - IP address 10.1.1.1, HTTP method GET
               
               The rule would create different aggregation instances according to your aggregation criteria, for example:
               
               - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:
               
               - IP address 10.1.1.1: count 3
               - IP address 127.0.0.0: count 1
               - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:
               
               - HTTP method POST: count 2
               - HTTP method GET: count 2
               - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:
               
               - IP address 10.1.1.1, HTTP method POST: count 1
               - IP address 10.1.1.1, HTTP method GET: count 2
               - IP address 127.0.0.0, HTTP method POST: count 1
               
               For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.
               
               You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.
               
               You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement` . You can define a `RateBasedStatement` inside a web ACL and inside a rule group.
               
               For additional information about the options, see [Rate limiting web requests using rate-based rules](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html) in the *AWS WAF Developer Guide* .
               
               If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call `GetRateBasedStatementManagedKeys` . This option is not available for other aggregation configurations.
               
               AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
        :param 'RuleGroupRegexMatchStatement' regex_match_statement: A rule statement used to search web request components for a match against a single regular expression.
        :param 'RuleGroupRegexPatternSetReferenceStatement' regex_pattern_set_reference_statement: A rule statement used to search web request components for matches with regular expressions. To use this, create a `RegexPatternSet` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
               
               Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        :param 'RuleGroupSizeConstraintStatement' size_constraint_statement: A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
               
               If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see `Body` and `JsonBody` settings for the `FieldToMatch` data type.
               
               If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
        :param 'RuleGroupSqliMatchStatement' sqli_match_statement: A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
        :param 'RuleGroupXssMatchStatement' xss_match_statement: A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
        """
        if and_statement is not None:
            pulumi.set(__self__, "and_statement", and_statement)
        if byte_match_statement is not None:
            pulumi.set(__self__, "byte_match_statement", byte_match_statement)
        if geo_match_statement is not None:
            pulumi.set(__self__, "geo_match_statement", geo_match_statement)
        if ip_set_reference_statement is not None:
            pulumi.set(__self__, "ip_set_reference_statement", ip_set_reference_statement)
        if label_match_statement is not None:
            pulumi.set(__self__, "label_match_statement", label_match_statement)
        if not_statement is not None:
            pulumi.set(__self__, "not_statement", not_statement)
        if or_statement is not None:
            pulumi.set(__self__, "or_statement", or_statement)
        if rate_based_statement is not None:
            pulumi.set(__self__, "rate_based_statement", rate_based_statement)
        if regex_match_statement is not None:
            pulumi.set(__self__, "regex_match_statement", regex_match_statement)
        if regex_pattern_set_reference_statement is not None:
            pulumi.set(__self__, "regex_pattern_set_reference_statement", regex_pattern_set_reference_statement)
        if size_constraint_statement is not None:
            pulumi.set(__self__, "size_constraint_statement", size_constraint_statement)
        if sqli_match_statement is not None:
            pulumi.set(__self__, "sqli_match_statement", sqli_match_statement)
        if xss_match_statement is not None:
            pulumi.set(__self__, "xss_match_statement", xss_match_statement)

    @property
    @pulumi.getter(name="andStatement")
    def and_statement(self) -> Optional['outputs.RuleGroupAndStatement']:
        """
        A logical rule statement used to combine other rule statements with AND logic. You provide more than one `Statement` within the `AndStatement` .
        """
        return pulumi.get(self, "and_statement")

    @property
    @pulumi.getter(name="byteMatchStatement")
    def byte_match_statement(self) -> Optional['outputs.RuleGroupByteMatchStatement']:
        """
        A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
        """
        return pulumi.get(self, "byte_match_statement")

    @property
    @pulumi.getter(name="geoMatchStatement")
    def geo_match_statement(self) -> Optional['outputs.RuleGroupGeoMatchStatement']:
        """
        A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.

        - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
        - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

        AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig` .

        If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>` .

        If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>` .

        For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) .
        """
        return pulumi.get(self, "geo_match_statement")

    @property
    @pulumi.getter(name="ipSetReferenceStatement")
    def ip_set_reference_statement(self) -> Optional['outputs.RuleGroupIpSetReferenceStatement']:
        """
        A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an `IPSet` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

        Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        """
        return pulumi.get(self, "ip_set_reference_statement")

    @property
    @pulumi.getter(name="labelMatchStatement")
    def label_match_statement(self) -> Optional['outputs.RuleGroupLabelMatchStatement']:
        """
        A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

        The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
        """
        return pulumi.get(self, "label_match_statement")

    @property
    @pulumi.getter(name="notStatement")
    def not_statement(self) -> Optional['outputs.RuleGroupNotStatement']:
        """
        A logical rule statement used to negate the results of another rule statement. You provide one `Statement` within the `NotStatement` .
        """
        return pulumi.get(self, "not_statement")

    @property
    @pulumi.getter(name="orStatement")
    def or_statement(self) -> Optional['outputs.RuleGroupOrStatement']:
        """
        A logical rule statement used to combine other rule statements with OR logic. You provide more than one `Statement` within the `OrStatement` .
        """
        return pulumi.get(self, "or_statement")

    @property
    @pulumi.getter(name="rateBasedStatement")
    def rate_based_statement(self) -> Optional['outputs.RuleGroupRateBasedStatement']:
        """
        A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.

        > If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute. 

        You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.

        Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.

        For example, assume the rule evaluates web requests with the following IP address and HTTP method values:

        - IP address 10.1.1.1, HTTP method POST
        - IP address 10.1.1.1, HTTP method GET
        - IP address 127.0.0.0, HTTP method POST
        - IP address 10.1.1.1, HTTP method GET

        The rule would create different aggregation instances according to your aggregation criteria, for example:

        - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:

        - IP address 10.1.1.1: count 3
        - IP address 127.0.0.0: count 1
        - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:

        - HTTP method POST: count 2
        - HTTP method GET: count 2
        - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:

        - IP address 10.1.1.1, HTTP method POST: count 1
        - IP address 10.1.1.1, HTTP method GET: count 2
        - IP address 127.0.0.0, HTTP method POST: count 1

        For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.

        You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.

        You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement` . You can define a `RateBasedStatement` inside a web ACL and inside a rule group.

        For additional information about the options, see [Rate limiting web requests using rate-based rules](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html) in the *AWS WAF Developer Guide* .

        If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call `GetRateBasedStatementManagedKeys` . This option is not available for other aggregation configurations.

        AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
        """
        return pulumi.get(self, "rate_based_statement")

    @property
    @pulumi.getter(name="regexMatchStatement")
    def regex_match_statement(self) -> Optional['outputs.RuleGroupRegexMatchStatement']:
        """
        A rule statement used to search web request components for a match against a single regular expression.
        """
        return pulumi.get(self, "regex_match_statement")

    @property
    @pulumi.getter(name="regexPatternSetReferenceStatement")
    def regex_pattern_set_reference_statement(self) -> Optional['outputs.RuleGroupRegexPatternSetReferenceStatement']:
        """
        A rule statement used to search web request components for matches with regular expressions. To use this, create a `RegexPatternSet` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

        Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        """
        return pulumi.get(self, "regex_pattern_set_reference_statement")

    @property
    @pulumi.getter(name="sizeConstraintStatement")
    def size_constraint_statement(self) -> Optional['outputs.RuleGroupSizeConstraintStatement']:
        """
        A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

        If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see `Body` and `JsonBody` settings for the `FieldToMatch` data type.

        If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
        """
        return pulumi.get(self, "size_constraint_statement")

    @property
    @pulumi.getter(name="sqliMatchStatement")
    def sqli_match_statement(self) -> Optional['outputs.RuleGroupSqliMatchStatement']:
        """
        A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
        """
        return pulumi.get(self, "sqli_match_statement")

    @property
    @pulumi.getter(name="xssMatchStatement")
    def xss_match_statement(self) -> Optional['outputs.RuleGroupXssMatchStatement']:
        """
        A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
        """
        return pulumi.get(self, "xss_match_statement")


@pulumi.output_type
class RuleGroupTextTransformation(dict):
    """
    Text Transformation on the Search String before match.
    """
    def __init__(__self__, *,
                 priority: builtins.int,
                 type: 'RuleGroupTextTransformationType'):
        """
        Text Transformation on the Search String before match.
        :param builtins.int priority: Sets the relative processing order for multiple transformations. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
        :param 'RuleGroupTextTransformationType' type: For detailed descriptions of each of the transformation types, see [Text transformations](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html) in the *AWS WAF Developer Guide* .
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        Sets the relative processing order for multiple transformations. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def type(self) -> 'RuleGroupTextTransformationType':
        """
        For detailed descriptions of each of the transformation types, see [Text transformations](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuleGroupUriFragment(dict):
    """
    The path component of the URI Fragment. This is the part of a web request that identifies a fragment uri, for example, /abcd#introduction
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupUriFragment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupUriFragment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupUriFragment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: Optional['RuleGroupUriFragmentFallbackBehavior'] = None):
        """
        The path component of the URI Fragment. This is the part of a web request that identifies a fragment uri, for example, /abcd#introduction
        :param 'RuleGroupUriFragmentFallbackBehavior' fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:
               
               - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
               
               Example JSON: `{ "UriFragment": { "FallbackBehavior": "MATCH"} }`
               
               > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        """
        if fallback_behavior is not None:
            pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> Optional['RuleGroupUriFragmentFallbackBehavior']:
        """
        What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:

        - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

        Example JSON: `{ "UriFragment": { "FallbackBehavior": "MATCH"} }`

        > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class RuleGroupVisibilityConfig(dict):
    """
    Visibility Metric of the RuleGroup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchMetricsEnabled":
            suggest = "cloud_watch_metrics_enabled"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "sampledRequestsEnabled":
            suggest = "sampled_requests_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupVisibilityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupVisibilityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupVisibilityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_metrics_enabled: builtins.bool,
                 metric_name: builtins.str,
                 sampled_requests_enabled: builtins.bool):
        """
        Visibility Metric of the RuleGroup.
        :param builtins.bool cloud_watch_metrics_enabled: Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics) in the *AWS WAF Developer Guide* .
               
               For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information,
               see [The web ACL default action](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html) in the *AWS WAF Developer Guide* .
        :param builtins.str metric_name: A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example `All` and `Default_Action` .
        :param builtins.bool sampled_requests_enabled: Indicates whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
               
               If you configure data protection for the web ACL, the protection applies to the web ACL's sampled web request data.
               
               > Request sampling doesn't provide a field redaction option, and any field redaction that you specify in your logging configuration doesn't affect sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.
        """
        pulumi.set(__self__, "cloud_watch_metrics_enabled", cloud_watch_metrics_enabled)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "sampled_requests_enabled", sampled_requests_enabled)

    @property
    @pulumi.getter(name="cloudWatchMetricsEnabled")
    def cloud_watch_metrics_enabled(self) -> builtins.bool:
        """
        Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics) in the *AWS WAF Developer Guide* .

        For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information,
        see [The web ACL default action](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "cloud_watch_metrics_enabled")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example `All` and `Default_Action` .
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="sampledRequestsEnabled")
    def sampled_requests_enabled(self) -> builtins.bool:
        """
        Indicates whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.

        If you configure data protection for the web ACL, the protection applies to the web ACL's sampled web request data.

        > Request sampling doesn't provide a field redaction option, and any field redaction that you specify in your logging configuration doesn't affect sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.
        """
        return pulumi.get(self, "sampled_requests_enabled")


@pulumi.output_type
class RuleGroupXssMatchStatement(dict):
    """
    Xss Match Statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleGroupXssMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleGroupXssMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleGroupXssMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.RuleGroupFieldToMatch',
                 text_transformations: Sequence['outputs.RuleGroupTextTransformation']):
        """
        Xss Match Statement.
        :param 'RuleGroupFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param Sequence['RuleGroupTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.RuleGroupFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.RuleGroupTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclAllowAction(dict):
    """
    Allow traffic towards application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclAllowAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclAllowAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclAllowAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.WebAclCustomRequestHandling'] = None):
        """
        Allow traffic towards application.
        :param 'WebAclCustomRequestHandling' custom_request_handling: Defines custom handling for the web request.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.WebAclCustomRequestHandling']:
        """
        Defines custom handling for the web request.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class WebAclAndStatement(dict):
    def __init__(__self__, *,
                 statements: Sequence['outputs.WebAclStatement']):
        """
        :param Sequence['WebAclStatement'] statements: The statements to combine with AND logic. You can use any statements that can be nested.
        """
        pulumi.set(__self__, "statements", statements)

    @property
    @pulumi.getter
    def statements(self) -> Sequence['outputs.WebAclStatement']:
        """
        The statements to combine with AND logic. You can use any statements that can be nested.
        """
        return pulumi.get(self, "statements")


@pulumi.output_type
class WebAclAssociationConfig(dict):
    """
    AssociationConfig for body inspection
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "requestBody":
            suggest = "request_body"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclAssociationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclAssociationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclAssociationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 request_body: Optional[Mapping[str, 'outputs.WebAclRequestBodyAssociatedResourceTypeConfig']] = None):
        """
        AssociationConfig for body inspection
        :param Mapping[str, 'WebAclRequestBodyAssociatedResourceTypeConfig'] request_body: Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
               
               > You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [AWS WAF Pricing](https://docs.aws.amazon.com/waf/pricing/) . 
               
               Example JSON: `{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }`
               
               For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        """
        if request_body is not None:
            pulumi.set(__self__, "request_body", request_body)

    @property
    @pulumi.getter(name="requestBody")
    def request_body(self) -> Optional[Mapping[str, 'outputs.WebAclRequestBodyAssociatedResourceTypeConfig']]:
        """
        Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection. The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.

        > You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see [AWS WAF Pricing](https://docs.aws.amazon.com/waf/pricing/) . 

        Example JSON: `{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }`

        For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        """
        return pulumi.get(self, "request_body")


@pulumi.output_type
class WebAclAwsManagedRulesAcfpRuleSet(dict):
    """
    Configures how to use the Account creation fraud prevention managed rule group in the web ACL
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationPath":
            suggest = "creation_path"
        elif key == "registrationPagePath":
            suggest = "registration_page_path"
        elif key == "requestInspection":
            suggest = "request_inspection"
        elif key == "enableRegexInPath":
            suggest = "enable_regex_in_path"
        elif key == "responseInspection":
            suggest = "response_inspection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclAwsManagedRulesAcfpRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclAwsManagedRulesAcfpRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclAwsManagedRulesAcfpRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_path: builtins.str,
                 registration_page_path: builtins.str,
                 request_inspection: 'outputs.WebAclRequestInspectionAcfp',
                 enable_regex_in_path: Optional[builtins.bool] = None,
                 response_inspection: Optional['outputs.WebAclResponseInspection'] = None):
        """
        Configures how to use the Account creation fraud prevention managed rule group in the web ACL
        :param builtins.str creation_path: The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept `POST` requests.
               
               For example, for the URL `https://example.com/web/newaccount` , you would provide the path `/web/newaccount` . Account creation page paths that start with the path that you provide are considered a match. For example `/web/newaccount` matches the account creation paths `/web/newaccount` , `/web/newaccount/` , `/web/newaccountPage` , and `/web/newaccount/thisPage` , but doesn't match the path `/home/web/newaccount` or `/website/newaccount` .
        :param builtins.str registration_page_path: The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users.
               
               > This page must accept `GET` text/html requests. 
               
               For example, for the URL `https://example.com/web/registration` , you would provide the path `/web/registration` . Registration page paths that start with the path that you provide are considered a match. For example `/web/registration` matches the registration paths `/web/registration` , `/web/registration/` , `/web/registrationPage` , and `/web/registration/thisPage` , but doesn't match the path `/home/web/registration` or `/website/registration` .
        :param 'WebAclRequestInspectionAcfp' request_inspection: The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
        :param builtins.bool enable_regex_in_path: Allow the use of regular expressions in the registration page path and the account creation path.
        :param 'WebAclResponseInspection' response_inspection: The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.
               
               > Response inspection is available only in web ACLs that protect Amazon CloudFront distributions. 
               
               The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
        """
        pulumi.set(__self__, "creation_path", creation_path)
        pulumi.set(__self__, "registration_page_path", registration_page_path)
        pulumi.set(__self__, "request_inspection", request_inspection)
        if enable_regex_in_path is not None:
            pulumi.set(__self__, "enable_regex_in_path", enable_regex_in_path)
        if response_inspection is not None:
            pulumi.set(__self__, "response_inspection", response_inspection)

    @property
    @pulumi.getter(name="creationPath")
    def creation_path(self) -> builtins.str:
        """
        The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept `POST` requests.

        For example, for the URL `https://example.com/web/newaccount` , you would provide the path `/web/newaccount` . Account creation page paths that start with the path that you provide are considered a match. For example `/web/newaccount` matches the account creation paths `/web/newaccount` , `/web/newaccount/` , `/web/newaccountPage` , and `/web/newaccount/thisPage` , but doesn't match the path `/home/web/newaccount` or `/website/newaccount` .
        """
        return pulumi.get(self, "creation_path")

    @property
    @pulumi.getter(name="registrationPagePath")
    def registration_page_path(self) -> builtins.str:
        """
        The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users.

        > This page must accept `GET` text/html requests. 

        For example, for the URL `https://example.com/web/registration` , you would provide the path `/web/registration` . Registration page paths that start with the path that you provide are considered a match. For example `/web/registration` matches the registration paths `/web/registration` , `/web/registration/` , `/web/registrationPage` , and `/web/registration/thisPage` , but doesn't match the path `/home/web/registration` or `/website/registration` .
        """
        return pulumi.get(self, "registration_page_path")

    @property
    @pulumi.getter(name="requestInspection")
    def request_inspection(self) -> 'outputs.WebAclRequestInspectionAcfp':
        """
        The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
        """
        return pulumi.get(self, "request_inspection")

    @property
    @pulumi.getter(name="enableRegexInPath")
    def enable_regex_in_path(self) -> Optional[builtins.bool]:
        """
        Allow the use of regular expressions in the registration page path and the account creation path.
        """
        return pulumi.get(self, "enable_regex_in_path")

    @property
    @pulumi.getter(name="responseInspection")
    def response_inspection(self) -> Optional['outputs.WebAclResponseInspection']:
        """
        The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.

        > Response inspection is available only in web ACLs that protect Amazon CloudFront distributions. 

        The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
        """
        return pulumi.get(self, "response_inspection")


@pulumi.output_type
class WebAclAwsManagedRulesAtpRuleSet(dict):
    """
    Configures how to use the Account Takeover Prevention managed rule group in the web ACL
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loginPath":
            suggest = "login_path"
        elif key == "enableRegexInPath":
            suggest = "enable_regex_in_path"
        elif key == "requestInspection":
            suggest = "request_inspection"
        elif key == "responseInspection":
            suggest = "response_inspection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclAwsManagedRulesAtpRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclAwsManagedRulesAtpRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclAwsManagedRulesAtpRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 login_path: builtins.str,
                 enable_regex_in_path: Optional[builtins.bool] = None,
                 request_inspection: Optional['outputs.WebAclRequestInspection'] = None,
                 response_inspection: Optional['outputs.WebAclResponseInspection'] = None):
        """
        Configures how to use the Account Takeover Prevention managed rule group in the web ACL
        :param builtins.str login_path: The path of the login endpoint for your application. For example, for the URL `https://example.com/web/login` , you would provide the path `/web/login` . Login paths that start with the path that you provide are considered a match. For example `/web/login` matches the login paths `/web/login` , `/web/login/` , `/web/loginPage` , and `/web/login/thisPage` , but doesn't match the login path `/home/web/login` or `/website/login` .
               
               The rule group inspects only HTTP `POST` requests to your specified login endpoint.
        :param builtins.bool enable_regex_in_path: Allow the use of regular expressions in the login page path.
        :param 'WebAclRequestInspection' request_inspection: The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
        :param 'WebAclResponseInspection' response_inspection: The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.
               
               > Response inspection is available only in web ACLs that protect Amazon CloudFront distributions. 
               
               The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.
        """
        pulumi.set(__self__, "login_path", login_path)
        if enable_regex_in_path is not None:
            pulumi.set(__self__, "enable_regex_in_path", enable_regex_in_path)
        if request_inspection is not None:
            pulumi.set(__self__, "request_inspection", request_inspection)
        if response_inspection is not None:
            pulumi.set(__self__, "response_inspection", response_inspection)

    @property
    @pulumi.getter(name="loginPath")
    def login_path(self) -> builtins.str:
        """
        The path of the login endpoint for your application. For example, for the URL `https://example.com/web/login` , you would provide the path `/web/login` . Login paths that start with the path that you provide are considered a match. For example `/web/login` matches the login paths `/web/login` , `/web/login/` , `/web/loginPage` , and `/web/login/thisPage` , but doesn't match the login path `/home/web/login` or `/website/login` .

        The rule group inspects only HTTP `POST` requests to your specified login endpoint.
        """
        return pulumi.get(self, "login_path")

    @property
    @pulumi.getter(name="enableRegexInPath")
    def enable_regex_in_path(self) -> Optional[builtins.bool]:
        """
        Allow the use of regular expressions in the login page path.
        """
        return pulumi.get(self, "enable_regex_in_path")

    @property
    @pulumi.getter(name="requestInspection")
    def request_inspection(self) -> Optional['outputs.WebAclRequestInspection']:
        """
        The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
        """
        return pulumi.get(self, "request_inspection")

    @property
    @pulumi.getter(name="responseInspection")
    def response_inspection(self) -> Optional['outputs.WebAclResponseInspection']:
        """
        The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.

        > Response inspection is available only in web ACLs that protect Amazon CloudFront distributions. 

        The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.
        """
        return pulumi.get(self, "response_inspection")


@pulumi.output_type
class WebAclAwsManagedRulesBotControlRuleSet(dict):
    """
    Configures how to use the Bot Control managed rule group in the web ACL
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inspectionLevel":
            suggest = "inspection_level"
        elif key == "enableMachineLearning":
            suggest = "enable_machine_learning"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclAwsManagedRulesBotControlRuleSet. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclAwsManagedRulesBotControlRuleSet.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclAwsManagedRulesBotControlRuleSet.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inspection_level: 'WebAclAwsManagedRulesBotControlRuleSetInspectionLevel',
                 enable_machine_learning: Optional[builtins.bool] = None):
        """
        Configures how to use the Bot Control managed rule group in the web ACL
        :param 'WebAclAwsManagedRulesBotControlRuleSetInspectionLevel' inspection_level: The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see [AWS WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) in the *AWS WAF Developer Guide* .
        :param builtins.bool enable_machine_learning: Applies only to the targeted inspection level.
               
               Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules `TGT_ML_CoordinatedActivityLow` and `TGT_ML_CoordinatedActivityMedium` , which
               inspect for anomalous behavior that might indicate distributed, coordinated bot activity.
               
               For more information about this choice, see the listing for these rules in the table at [Bot Control rules listing](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules) in the *AWS WAF Developer Guide* .
               
               Default: `TRUE`
        """
        pulumi.set(__self__, "inspection_level", inspection_level)
        if enable_machine_learning is not None:
            pulumi.set(__self__, "enable_machine_learning", enable_machine_learning)

    @property
    @pulumi.getter(name="inspectionLevel")
    def inspection_level(self) -> 'WebAclAwsManagedRulesBotControlRuleSetInspectionLevel':
        """
        The inspection level to use for the Bot Control rule group. The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see [AWS WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "inspection_level")

    @property
    @pulumi.getter(name="enableMachineLearning")
    def enable_machine_learning(self) -> Optional[builtins.bool]:
        """
        Applies only to the targeted inspection level.

        Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules `TGT_ML_CoordinatedActivityLow` and `TGT_ML_CoordinatedActivityMedium` , which
        inspect for anomalous behavior that might indicate distributed, coordinated bot activity.

        For more information about this choice, see the listing for these rules in the table at [Bot Control rules listing](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules) in the *AWS WAF Developer Guide* .

        Default: `TRUE`
        """
        return pulumi.get(self, "enable_machine_learning")


@pulumi.output_type
class WebAclBlockAction(dict):
    """
    Block traffic towards application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customResponse":
            suggest = "custom_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclBlockAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclBlockAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclBlockAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_response: Optional['outputs.WebAclCustomResponse'] = None):
        """
        Block traffic towards application.
        :param 'WebAclCustomResponse' custom_response: Defines a custom response for the web request.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_response is not None:
            pulumi.set(__self__, "custom_response", custom_response)

    @property
    @pulumi.getter(name="customResponse")
    def custom_response(self) -> Optional['outputs.WebAclCustomResponse']:
        """
        Defines a custom response for the web request.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_response")


@pulumi.output_type
class WebAclBody(dict):
    """
    The body of a web request. This immediately follows the request headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oversize_handling: Optional['WebAclOversizeHandling'] = None):
        """
        The body of a web request. This immediately follows the request headers.
        :param 'WebAclOversizeHandling' oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
               
               Default: `CONTINUE`
        """
        if oversize_handling is not None:
            pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> Optional['WebAclOversizeHandling']:
        """
        What AWS WAF should do if the body is larger than AWS WAF can inspect.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

        Default: `CONTINUE`
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class WebAclByteMatchStatement(dict):
    """
    Byte Match statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "positionalConstraint":
            suggest = "positional_constraint"
        elif key == "textTransformations":
            suggest = "text_transformations"
        elif key == "searchString":
            suggest = "search_string"
        elif key == "searchStringBase64":
            suggest = "search_string_base64"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclByteMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclByteMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclByteMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.WebAclFieldToMatch',
                 positional_constraint: 'WebAclPositionalConstraint',
                 text_transformations: Sequence['outputs.WebAclTextTransformation'],
                 search_string: Optional[builtins.str] = None,
                 search_string_base64: Optional[builtins.str] = None):
        """
        Byte Match statement.
        :param 'WebAclFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param 'WebAclPositionalConstraint' positional_constraint: The area within the portion of the web request that you want AWS WAF to search for `SearchString` . Valid values include the following:
               
               *CONTAINS*
               
               The specified part of the web request must include the value of `SearchString` , but the location doesn't matter.
               
               *CONTAINS_WORD*
               
               The specified part of the web request must include the value of `SearchString` , and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:
               
               - `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot` .
               - `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;` .
               
               *EXACTLY*
               
               The value of the specified part of the web request must exactly match the value of `SearchString` .
               
               *STARTS_WITH*
               
               The value of `SearchString` must appear at the beginning of the specified part of the web request.
               
               *ENDS_WITH*
               
               The value of `SearchString` must appear at the end of the specified part of the web request.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        :param builtins.str search_string: A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `FieldToMatch` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.
               
               Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.
               
               For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent` . If you want to search the `User-Agent` header for the value `BadBot` , you provide the string `BadBot` in the value of `SearchString` .
               
               You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        :param builtins.str search_string_base64: String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in `SearchString` instead.
               
               You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "positional_constraint", positional_constraint)
        pulumi.set(__self__, "text_transformations", text_transformations)
        if search_string is not None:
            pulumi.set(__self__, "search_string", search_string)
        if search_string_base64 is not None:
            pulumi.set(__self__, "search_string_base64", search_string_base64)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.WebAclFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="positionalConstraint")
    def positional_constraint(self) -> 'WebAclPositionalConstraint':
        """
        The area within the portion of the web request that you want AWS WAF to search for `SearchString` . Valid values include the following:

        *CONTAINS*

        The specified part of the web request must include the value of `SearchString` , but the location doesn't matter.

        *CONTAINS_WORD*

        The specified part of the web request must include the value of `SearchString` , and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:

        - `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot` .
        - `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;` .

        *EXACTLY*

        The value of the specified part of the web request must exactly match the value of `SearchString` .

        *STARTS_WITH*

        The value of `SearchString` must appear at the beginning of the specified part of the web request.

        *ENDS_WITH*

        The value of `SearchString` must appear at the end of the specified part of the web request.
        """
        return pulumi.get(self, "positional_constraint")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")

    @property
    @pulumi.getter(name="searchString")
    def search_string(self) -> Optional[builtins.str]:
        """
        A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `FieldToMatch` . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.

        Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.

        For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent` . If you want to search the `User-Agent` header for the value `BadBot` , you provide the string `BadBot` in the value of `SearchString` .

        You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        """
        return pulumi.get(self, "search_string")

    @property
    @pulumi.getter(name="searchStringBase64")
    def search_string_base64(self) -> Optional[builtins.str]:
        """
        String to search for in a web request component, base64-encoded. If you don't want to encode the string, specify the unencoded value in `SearchString` instead.

        You must specify either `SearchString` or `SearchStringBase64` in a `ByteMatchStatement` .
        """
        return pulumi.get(self, "search_string_base64")


@pulumi.output_type
class WebAclCaptchaAction(dict):
    """
    Checks valid token exists with request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCaptchaAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCaptchaAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCaptchaAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.WebAclCustomRequestHandling'] = None):
        """
        Checks valid token exists with request.
        :param 'WebAclCustomRequestHandling' custom_request_handling: Defines custom handling for the web request, used when the `CAPTCHA` inspection determines that the request's token is valid and unexpired.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.WebAclCustomRequestHandling']:
        """
        Defines custom handling for the web request, used when the `CAPTCHA` inspection determines that the request's token is valid and unexpired.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class WebAclCaptchaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immunityTimeProperty":
            suggest = "immunity_time_property"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCaptchaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCaptchaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCaptchaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immunity_time_property: Optional['outputs.WebAclImmunityTimeProperty'] = None):
        """
        :param 'WebAclImmunityTimeProperty' immunity_time_property: Determines how long a `CAPTCHA` timestamp in the token remains valid after the client successfully solves a `CAPTCHA` puzzle.
        """
        if immunity_time_property is not None:
            pulumi.set(__self__, "immunity_time_property", immunity_time_property)

    @property
    @pulumi.getter(name="immunityTimeProperty")
    def immunity_time_property(self) -> Optional['outputs.WebAclImmunityTimeProperty']:
        """
        Determines how long a `CAPTCHA` timestamp in the token remains valid after the client successfully solves a `CAPTCHA` puzzle.
        """
        return pulumi.get(self, "immunity_time_property")


@pulumi.output_type
class WebAclChallengeAction(dict):
    """
    Checks that the request has a valid token with an unexpired challenge timestamp and, if not, returns a browser challenge to the client.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclChallengeAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclChallengeAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclChallengeAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.WebAclCustomRequestHandling'] = None):
        """
        Checks that the request has a valid token with an unexpired challenge timestamp and, if not, returns a browser challenge to the client.
        :param 'WebAclCustomRequestHandling' custom_request_handling: Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [AWS WAF developer guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.WebAclCustomRequestHandling']:
        """
        Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [AWS WAF developer guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class WebAclChallengeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immunityTimeProperty":
            suggest = "immunity_time_property"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclChallengeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclChallengeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclChallengeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immunity_time_property: Optional['outputs.WebAclImmunityTimeProperty'] = None):
        """
        :param 'WebAclImmunityTimeProperty' immunity_time_property: Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
        """
        if immunity_time_property is not None:
            pulumi.set(__self__, "immunity_time_property", immunity_time_property)

    @property
    @pulumi.getter(name="immunityTimeProperty")
    def immunity_time_property(self) -> Optional['outputs.WebAclImmunityTimeProperty']:
        """
        Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
        """
        return pulumi.get(self, "immunity_time_property")


@pulumi.output_type
class WebAclCookieMatchPattern(dict):
    """
    The pattern to look for in the request cookies.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedCookies":
            suggest = "excluded_cookies"
        elif key == "includedCookies":
            suggest = "included_cookies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCookieMatchPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCookieMatchPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCookieMatchPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[Any] = None,
                 excluded_cookies: Optional[Sequence[builtins.str]] = None,
                 included_cookies: Optional[Sequence[builtins.str]] = None):
        """
        The pattern to look for in the request cookies.
        :param Any all: Inspect all parts of the web request cookies.
        :param Sequence[builtins.str] excluded_cookies: Inspect only the cookies whose keys don't match any of the strings specified here.
        :param Sequence[builtins.str] included_cookies: Inspect only the cookies that have a key that matches one of the strings specified here.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if excluded_cookies is not None:
            pulumi.set(__self__, "excluded_cookies", excluded_cookies)
        if included_cookies is not None:
            pulumi.set(__self__, "included_cookies", included_cookies)

    @property
    @pulumi.getter
    def all(self) -> Optional[Any]:
        """
        Inspect all parts of the web request cookies.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="excludedCookies")
    def excluded_cookies(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the cookies whose keys don't match any of the strings specified here.
        """
        return pulumi.get(self, "excluded_cookies")

    @property
    @pulumi.getter(name="includedCookies")
    def included_cookies(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the cookies that have a key that matches one of the strings specified here.
        """
        return pulumi.get(self, "included_cookies")


@pulumi.output_type
class WebAclCookies(dict):
    """
    Includes cookies of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPattern":
            suggest = "match_pattern"
        elif key == "matchScope":
            suggest = "match_scope"
        elif key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCookies. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCookies.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCookies.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_pattern: 'outputs.WebAclCookieMatchPattern',
                 match_scope: 'WebAclMapMatchScope',
                 oversize_handling: 'WebAclOversizeHandling'):
        """
        Includes cookies of a web request.
        :param 'WebAclCookieMatchPattern' match_pattern: The filter to use to identify the subset of cookies to inspect in a web request.
               
               You must specify exactly one setting: either `All` , `IncludedCookies` , or `ExcludedCookies` .
               
               Example JSON: `"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }`
        :param 'WebAclMapMatchScope' match_scope: The parts of the cookies to inspect with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.
               
               `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        :param 'WebAclOversizeHandling' oversize_handling: What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available cookies normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "match_pattern", match_pattern)
        pulumi.set(__self__, "match_scope", match_scope)
        pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="matchPattern")
    def match_pattern(self) -> 'outputs.WebAclCookieMatchPattern':
        """
        The filter to use to identify the subset of cookies to inspect in a web request.

        You must specify exactly one setting: either `All` , `IncludedCookies` , or `ExcludedCookies` .

        Example JSON: `"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }`
        """
        return pulumi.get(self, "match_pattern")

    @property
    @pulumi.getter(name="matchScope")
    def match_scope(self) -> 'WebAclMapMatchScope':
        """
        The parts of the cookies to inspect with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.

        `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        """
        return pulumi.get(self, "match_scope")

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> 'WebAclOversizeHandling':
        """
        What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available cookies normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class WebAclCountAction(dict):
    """
    Allow traffic towards application.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customRequestHandling":
            suggest = "custom_request_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCountAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCountAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCountAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_request_handling: Optional['outputs.WebAclCustomRequestHandling'] = None):
        """
        Allow traffic towards application.
        :param 'WebAclCustomRequestHandling' custom_request_handling: Defines custom handling for the web request.
               
               For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        if custom_request_handling is not None:
            pulumi.set(__self__, "custom_request_handling", custom_request_handling)

    @property
    @pulumi.getter(name="customRequestHandling")
    def custom_request_handling(self) -> Optional['outputs.WebAclCustomRequestHandling']:
        """
        Defines custom handling for the web request.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_request_handling")


@pulumi.output_type
class WebAclCustomHttpHeader(dict):
    """
    HTTP header.
    """
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        HTTP header.
        :param builtins.str name: The name of the custom header.
               
               For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name `x-amzn-waf-` , to avoid confusion with the headers that are already in the request. For example, for the header name `sample` , AWS WAF inserts the header `x-amzn-waf-sample` .
        :param builtins.str value: The value of the custom header.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the custom header.

        For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name `x-amzn-waf-` , to avoid confusion with the headers that are already in the request. For example, for the header name `sample` , AWS WAF inserts the header `x-amzn-waf-sample` .
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value of the custom header.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WebAclCustomRequestHandling(dict):
    """
    Custom request handling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "insertHeaders":
            suggest = "insert_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCustomRequestHandling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCustomRequestHandling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCustomRequestHandling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 insert_headers: Sequence['outputs.WebAclCustomHttpHeader']):
        """
        Custom request handling.
        :param Sequence['WebAclCustomHttpHeader'] insert_headers: Collection of HTTP headers.
        """
        pulumi.set(__self__, "insert_headers", insert_headers)

    @property
    @pulumi.getter(name="insertHeaders")
    def insert_headers(self) -> Sequence['outputs.WebAclCustomHttpHeader']:
        """
        Collection of HTTP headers.
        """
        return pulumi.get(self, "insert_headers")


@pulumi.output_type
class WebAclCustomResponse(dict):
    """
    Custom response.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "responseCode":
            suggest = "response_code"
        elif key == "customResponseBodyKey":
            suggest = "custom_response_body_key"
        elif key == "responseHeaders":
            suggest = "response_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCustomResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCustomResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCustomResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 response_code: builtins.int,
                 custom_response_body_key: Optional[builtins.str] = None,
                 response_headers: Optional[Sequence['outputs.WebAclCustomHttpHeader']] = None):
        """
        Custom response.
        :param builtins.int response_code: The HTTP status code to return to the client.
               
               For a list of status codes that you can use in your custom responses, see [Supported status codes for custom response](https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html) in the *AWS WAF Developer Guide* .
        :param builtins.str custom_response_body_key: Custom response body key.
        :param Sequence['WebAclCustomHttpHeader'] response_headers: Collection of HTTP headers.
        """
        pulumi.set(__self__, "response_code", response_code)
        if custom_response_body_key is not None:
            pulumi.set(__self__, "custom_response_body_key", custom_response_body_key)
        if response_headers is not None:
            pulumi.set(__self__, "response_headers", response_headers)

    @property
    @pulumi.getter(name="responseCode")
    def response_code(self) -> builtins.int:
        """
        The HTTP status code to return to the client.

        For a list of status codes that you can use in your custom responses, see [Supported status codes for custom response](https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "response_code")

    @property
    @pulumi.getter(name="customResponseBodyKey")
    def custom_response_body_key(self) -> Optional[builtins.str]:
        """
        Custom response body key.
        """
        return pulumi.get(self, "custom_response_body_key")

    @property
    @pulumi.getter(name="responseHeaders")
    def response_headers(self) -> Optional[Sequence['outputs.WebAclCustomHttpHeader']]:
        """
        Collection of HTTP headers.
        """
        return pulumi.get(self, "response_headers")


@pulumi.output_type
class WebAclCustomResponseBody(dict):
    """
    Custom response body.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclCustomResponseBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclCustomResponseBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclCustomResponseBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: builtins.str,
                 content_type: 'WebAclResponseContentType'):
        """
        Custom response body.
        :param builtins.str content: The payload of the custom response.
               
               You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.
               
               For information about the limits on count and size for custom request and response settings, see [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *AWS WAF Developer Guide* .
        :param 'WebAclResponseContentType' content_type: The type of content in the payload that you are defining in the `Content` string.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "content_type", content_type)

    @property
    @pulumi.getter
    def content(self) -> builtins.str:
        """
        The payload of the custom response.

        You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the `ContentType` setting.

        For information about the limits on count and size for custom request and response settings, see [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> 'WebAclResponseContentType':
        """
        The type of content in the payload that you are defining in the `Content` string.
        """
        return pulumi.get(self, "content_type")


@pulumi.output_type
class WebAclDataProtect(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeRateBasedDetails":
            suggest = "exclude_rate_based_details"
        elif key == "excludeRuleMatchDetails":
            suggest = "exclude_rule_match_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclDataProtect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclDataProtect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclDataProtect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: 'WebAclDataProtectionAction',
                 field: 'outputs.WebAclFieldToProtect',
                 exclude_rate_based_details: Optional[builtins.bool] = None,
                 exclude_rule_match_details: Optional[builtins.bool] = None):
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "field", field)
        if exclude_rate_based_details is not None:
            pulumi.set(__self__, "exclude_rate_based_details", exclude_rate_based_details)
        if exclude_rule_match_details is not None:
            pulumi.set(__self__, "exclude_rule_match_details", exclude_rule_match_details)

    @property
    @pulumi.getter
    def action(self) -> 'WebAclDataProtectionAction':
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def field(self) -> 'outputs.WebAclFieldToProtect':
        return pulumi.get(self, "field")

    @property
    @pulumi.getter(name="excludeRateBasedDetails")
    def exclude_rate_based_details(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "exclude_rate_based_details")

    @property
    @pulumi.getter(name="excludeRuleMatchDetails")
    def exclude_rule_match_details(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "exclude_rule_match_details")


@pulumi.output_type
class WebAclDataProtectionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataProtections":
            suggest = "data_protections"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclDataProtectionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclDataProtectionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclDataProtectionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_protections: Sequence['outputs.WebAclDataProtect']):
        """
        :param Sequence['WebAclDataProtect'] data_protections: An array of data protection configurations for specific web request field types. This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.
        """
        pulumi.set(__self__, "data_protections", data_protections)

    @property
    @pulumi.getter(name="dataProtections")
    def data_protections(self) -> Sequence['outputs.WebAclDataProtect']:
        """
        An array of data protection configurations for specific web request field types. This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.
        """
        return pulumi.get(self, "data_protections")


@pulumi.output_type
class WebAclDefaultAction(dict):
    """
    Default Action WebACL will take against ingress traffic when there is no matching Rule.
    """
    def __init__(__self__, *,
                 allow: Optional['outputs.WebAclAllowAction'] = None,
                 block: Optional['outputs.WebAclBlockAction'] = None):
        """
        Default Action WebACL will take against ingress traffic when there is no matching Rule.
        :param 'WebAclAllowAction' allow: Specifies that AWS WAF should allow requests by default.
        :param 'WebAclBlockAction' block: Specifies that AWS WAF should block requests by default.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if block is not None:
            pulumi.set(__self__, "block", block)

    @property
    @pulumi.getter
    def allow(self) -> Optional['outputs.WebAclAllowAction']:
        """
        Specifies that AWS WAF should allow requests by default.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def block(self) -> Optional['outputs.WebAclBlockAction']:
        """
        Specifies that AWS WAF should block requests by default.
        """
        return pulumi.get(self, "block")


@pulumi.output_type
class WebAclExcludedRule(dict):
    """
    Excluded Rule in the RuleGroup or ManagedRuleGroup will not be evaluated.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        Excluded Rule in the RuleGroup or ManagedRuleGroup will not be evaluated.
        :param builtins.str name: The name of the rule whose action you want to override to `Count` .
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule whose action you want to override to `Count` .
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WebAclFieldIdentifier(dict):
    def __init__(__self__, *,
                 identifier: builtins.str):
        """
        :param builtins.str identifier: The name of the field.
               
               When the `PayloadType` in the request inspection is `JSON` , this identifier must be in JSON pointer syntax. For example `/form/username` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               When the `PayloadType` is `FORM_ENCODED` , use the HTML form names. For example, `username` .
               
               For more information, see the descriptions for each field type in the request inspection properties.
        """
        pulumi.set(__self__, "identifier", identifier)

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        The name of the field.

        When the `PayloadType` in the request inspection is `JSON` , this identifier must be in JSON pointer syntax. For example `/form/username` . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        When the `PayloadType` is `FORM_ENCODED` , use the HTML form names. For example, `username` .

        For more information, see the descriptions for each field type in the request inspection properties.
        """
        return pulumi.get(self, "identifier")


@pulumi.output_type
class WebAclFieldToMatch(dict):
    """
    Field of the request to match.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allQueryArguments":
            suggest = "all_query_arguments"
        elif key == "ja3Fingerprint":
            suggest = "ja3_fingerprint"
        elif key == "ja4Fingerprint":
            suggest = "ja4_fingerprint"
        elif key == "jsonBody":
            suggest = "json_body"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "singleHeader":
            suggest = "single_header"
        elif key == "singleQueryArgument":
            suggest = "single_query_argument"
        elif key == "uriFragment":
            suggest = "uri_fragment"
        elif key == "uriPath":
            suggest = "uri_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclFieldToMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclFieldToMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclFieldToMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_query_arguments: Optional[Any] = None,
                 body: Optional['outputs.WebAclBody'] = None,
                 cookies: Optional['outputs.WebAclCookies'] = None,
                 headers: Optional['outputs.WebAclHeaders'] = None,
                 ja3_fingerprint: Optional['outputs.WebAclJa3Fingerprint'] = None,
                 ja4_fingerprint: Optional['outputs.WebAclJa4Fingerprint'] = None,
                 json_body: Optional['outputs.WebAclJsonBody'] = None,
                 method: Optional[Any] = None,
                 query_string: Optional[Any] = None,
                 single_header: Optional['outputs.WebAclFieldToMatchSingleHeaderProperties'] = None,
                 single_query_argument: Optional['outputs.WebAclFieldToMatchSingleQueryArgumentProperties'] = None,
                 uri_fragment: Optional['outputs.WebAclUriFragment'] = None,
                 uri_path: Optional[Any] = None):
        """
        Field of the request to match.
        :param Any all_query_arguments: All query arguments of a web request.
        :param 'WebAclBody' body: Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               For information about how to handle oversized request bodies, see the `Body` object configuration.
        :param 'WebAclCookies' cookies: Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
               
               Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        :param 'WebAclHeaders' headers: Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
               
               Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
        :param 'WebAclJa3Fingerprint' ja3_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
               
               > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 
               
               You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .
               
               Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        :param 'WebAclJa4Fingerprint' ja4_fingerprint: Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
               
               > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 
               
               You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .
               
               Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        :param 'WebAclJsonBody' json_body: Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
        :param Any method: The HTTP method of a web request. The method indicates the type of operation that the request is asking the origin to perform.
        :param Any query_string: The query string of a web request. This is the part of a URL that appears after a ? character, if any.
        :param 'WebAclFieldToMatchSingleHeaderProperties' single_header: Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.
               
               Example JSON: `"SingleHeader": { "Name": "haystack" }`
               
               Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
        :param 'WebAclFieldToMatchSingleQueryArgumentProperties' single_query_argument: One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
        :param 'WebAclUriFragment' uri_fragment: Inspect fragments of the request URI. You must configure scope and pattern matching filters in the `UriFragment` object, to define the fragment of a URI that AWS WAF inspects.
               
               Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the `UriFragment` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        :param Any uri_path: The path component of the URI of a web request. This is the part of a web request that identifies a resource, for example, /images/daily-ad.jpg.
        """
        if all_query_arguments is not None:
            pulumi.set(__self__, "all_query_arguments", all_query_arguments)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cookies is not None:
            pulumi.set(__self__, "cookies", cookies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ja3_fingerprint is not None:
            pulumi.set(__self__, "ja3_fingerprint", ja3_fingerprint)
        if ja4_fingerprint is not None:
            pulumi.set(__self__, "ja4_fingerprint", ja4_fingerprint)
        if json_body is not None:
            pulumi.set(__self__, "json_body", json_body)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if single_header is not None:
            pulumi.set(__self__, "single_header", single_header)
        if single_query_argument is not None:
            pulumi.set(__self__, "single_query_argument", single_query_argument)
        if uri_fragment is not None:
            pulumi.set(__self__, "uri_fragment", uri_fragment)
        if uri_path is not None:
            pulumi.set(__self__, "uri_path", uri_path)

    @property
    @pulumi.getter(name="allQueryArguments")
    def all_query_arguments(self) -> Optional[Any]:
        """
        All query arguments of a web request.
        """
        return pulumi.get(self, "all_query_arguments")

    @property
    @pulumi.getter
    def body(self) -> Optional['outputs.WebAclBody']:
        """
        Inspect the request body as plain text. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        For information about how to handle oversized request bodies, see the `Body` object configuration.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def cookies(self) -> Optional['outputs.WebAclCookies']:
        """
        Inspect the request cookies. You must configure scope and pattern matching filters in the `Cookies` object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.

        Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the `Cookies` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        """
        return pulumi.get(self, "cookies")

    @property
    @pulumi.getter
    def headers(self) -> Optional['outputs.WebAclHeaders']:
        """
        Inspect the request headers. You must configure scope and pattern matching filters in the `Headers` object, to define the set of headers to and the parts of the headers that AWS WAF inspects.

        Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the `Headers` object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ja3Fingerprint")
    def ja3_fingerprint(self) -> Optional['outputs.WebAclJa3Fingerprint']:
        """
        Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.

        > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 

        You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .

        Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        """
        return pulumi.get(self, "ja3_fingerprint")

    @property
    @pulumi.getter(name="ja4Fingerprint")
    def ja4_fingerprint(self) -> Optional['outputs.WebAclJa4Fingerprint']:
        """
        Available for use with Amazon CloudFront distributions and Application Load Balancers. Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.

        > You can use this choice only with a string match `ByteMatchStatement` with the `PositionalConstraint` set to `EXACTLY` . 

        You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see [Log fields](https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html) in the *AWS WAF Developer Guide* .

        Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
        """
        return pulumi.get(self, "ja4_fingerprint")

    @property
    @pulumi.getter(name="jsonBody")
    def json_body(self) -> Optional['outputs.WebAclJsonBody']:
        """
        Inspect the request body as JSON. The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        For information about how to handle oversized request bodies, see the `JsonBody` object configuration.
        """
        return pulumi.get(self, "json_body")

    @property
    @pulumi.getter
    def method(self) -> Optional[Any]:
        """
        The HTTP method of a web request. The method indicates the type of operation that the request is asking the origin to perform.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional[Any]:
        """
        The query string of a web request. This is the part of a URL that appears after a ? character, if any.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="singleHeader")
    def single_header(self) -> Optional['outputs.WebAclFieldToMatchSingleHeaderProperties']:
        """
        Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.

        Example JSON: `"SingleHeader": { "Name": "haystack" }`

        Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
        """
        return pulumi.get(self, "single_header")

    @property
    @pulumi.getter(name="singleQueryArgument")
    def single_query_argument(self) -> Optional['outputs.WebAclFieldToMatchSingleQueryArgumentProperties']:
        """
        One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
        """
        return pulumi.get(self, "single_query_argument")

    @property
    @pulumi.getter(name="uriFragment")
    def uri_fragment(self) -> Optional['outputs.WebAclUriFragment']:
        """
        Inspect fragments of the request URI. You must configure scope and pattern matching filters in the `UriFragment` object, to define the fragment of a URI that AWS WAF inspects.

        Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the `UriFragment` object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
        """
        return pulumi.get(self, "uri_fragment")

    @property
    @pulumi.getter(name="uriPath")
    def uri_path(self) -> Optional[Any]:
        """
        The path component of the URI of a web request. This is the part of a web request that identifies a resource, for example, /images/daily-ad.jpg.
        """
        return pulumi.get(self, "uri_path")


@pulumi.output_type
class WebAclFieldToMatchSingleHeaderProperties(dict):
    """
    Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.

    Example JSON: `"SingleHeader": { "Name": "haystack" }`

    Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        Inspect a single header. Provide the name of the header to inspect, for example, `User-Agent` or `Referer` . This setting isn't case sensitive.

        Example JSON: `"SingleHeader": { "Name": "haystack" }`

        Alternately, you can filter and inspect all headers with the `Headers` `FieldToMatch` setting.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class WebAclFieldToMatchSingleQueryArgumentProperties(dict):
    """
    One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
    """
    def __init__(__self__, *,
                 name: builtins.str):
        """
        One query argument in a web request, identified by name, for example UserName or SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class WebAclFieldToProtect(dict):
    """
    Field in log to protect.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldType":
            suggest = "field_type"
        elif key == "fieldKeys":
            suggest = "field_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclFieldToProtect. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclFieldToProtect.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclFieldToProtect.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_type: 'WebAclFieldToProtectFieldType',
                 field_keys: Optional[Sequence[builtins.str]] = None):
        """
        Field in log to protect.
        :param 'WebAclFieldToProtectFieldType' field_type: Field type to protect
        :param Sequence[builtins.str] field_keys: List of field keys to protect
        """
        pulumi.set(__self__, "field_type", field_type)
        if field_keys is not None:
            pulumi.set(__self__, "field_keys", field_keys)

    @property
    @pulumi.getter(name="fieldType")
    def field_type(self) -> 'WebAclFieldToProtectFieldType':
        """
        Field type to protect
        """
        return pulumi.get(self, "field_type")

    @property
    @pulumi.getter(name="fieldKeys")
    def field_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        List of field keys to protect
        """
        return pulumi.get(self, "field_keys")


@pulumi.output_type
class WebAclForwardedIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclForwardedIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclForwardedIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclForwardedIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'WebAclForwardedIpConfigurationFallbackBehavior',
                 header_name: builtins.str):
        """
        :param 'WebAclForwardedIpConfigurationFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        :param builtins.str header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)
        pulumi.set(__self__, "header_name", header_name)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'WebAclForwardedIpConfigurationFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "header_name")


@pulumi.output_type
class WebAclGeoMatchStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "countryCodes":
            suggest = "country_codes"
        elif key == "forwardedIpConfig":
            suggest = "forwarded_ip_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclGeoMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclGeoMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclGeoMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 country_codes: Optional[Sequence[builtins.str]] = None,
                 forwarded_ip_config: Optional['outputs.WebAclForwardedIpConfiguration'] = None):
        """
        :param Sequence[builtins.str] country_codes: An array of two-character country codes that you want to match against, for example, `[ "US", "CN" ]` , from the alpha-2 country ISO codes of the ISO 3166 international standard.
               
               When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
        :param 'WebAclForwardedIpConfiguration' forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        if country_codes is not None:
            pulumi.set(__self__, "country_codes", country_codes)
        if forwarded_ip_config is not None:
            pulumi.set(__self__, "forwarded_ip_config", forwarded_ip_config)

    @property
    @pulumi.getter(name="countryCodes")
    def country_codes(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of two-character country codes that you want to match against, for example, `[ "US", "CN" ]` , from the alpha-2 country ISO codes of the ISO 3166 international standard.

        When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
        """
        return pulumi.get(self, "country_codes")

    @property
    @pulumi.getter(name="forwardedIpConfig")
    def forwarded_ip_config(self) -> Optional['outputs.WebAclForwardedIpConfiguration']:
        """
        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "forwarded_ip_config")


@pulumi.output_type
class WebAclHeaderMatchPattern(dict):
    """
    The pattern to look for in the request headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedHeaders":
            suggest = "excluded_headers"
        elif key == "includedHeaders":
            suggest = "included_headers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclHeaderMatchPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclHeaderMatchPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclHeaderMatchPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[Any] = None,
                 excluded_headers: Optional[Sequence[builtins.str]] = None,
                 included_headers: Optional[Sequence[builtins.str]] = None):
        """
        The pattern to look for in the request headers.
        :param Any all: Inspect all parts of the web request headers.
        :param Sequence[builtins.str] excluded_headers: Inspect only the headers whose keys don't match any of the strings specified here.
        :param Sequence[builtins.str] included_headers: Inspect only the headers that have a key that matches one of the strings specified here.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if excluded_headers is not None:
            pulumi.set(__self__, "excluded_headers", excluded_headers)
        if included_headers is not None:
            pulumi.set(__self__, "included_headers", included_headers)

    @property
    @pulumi.getter
    def all(self) -> Optional[Any]:
        """
        Inspect all parts of the web request headers.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="excludedHeaders")
    def excluded_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the headers whose keys don't match any of the strings specified here.
        """
        return pulumi.get(self, "excluded_headers")

    @property
    @pulumi.getter(name="includedHeaders")
    def included_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        Inspect only the headers that have a key that matches one of the strings specified here.
        """
        return pulumi.get(self, "included_headers")


@pulumi.output_type
class WebAclHeaders(dict):
    """
    Includes headers of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPattern":
            suggest = "match_pattern"
        elif key == "matchScope":
            suggest = "match_scope"
        elif key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_pattern: 'outputs.WebAclHeaderMatchPattern',
                 match_scope: 'WebAclMapMatchScope',
                 oversize_handling: 'WebAclOversizeHandling'):
        """
        Includes headers of a web request.
        :param 'WebAclHeaderMatchPattern' match_pattern: The filter to use to identify the subset of headers to inspect in a web request.
               
               You must specify exactly one setting: either `All` , `IncludedHeaders` , or `ExcludedHeaders` .
               
               Example JSON: `"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }`
        :param 'WebAclMapMatchScope' match_scope: The parts of the headers to match with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.
               
               `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        :param 'WebAclOversizeHandling' oversize_handling: What AWS WAF should do if the headers determined by your match scope are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "match_pattern", match_pattern)
        pulumi.set(__self__, "match_scope", match_scope)
        pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="matchPattern")
    def match_pattern(self) -> 'outputs.WebAclHeaderMatchPattern':
        """
        The filter to use to identify the subset of headers to inspect in a web request.

        You must specify exactly one setting: either `All` , `IncludedHeaders` , or `ExcludedHeaders` .

        Example JSON: `"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }`
        """
        return pulumi.get(self, "match_pattern")

    @property
    @pulumi.getter(name="matchScope")
    def match_scope(self) -> 'WebAclMapMatchScope':
        """
        The parts of the headers to match with the rule inspection criteria. If you specify `ALL` , AWS WAF inspects both keys and values.

        `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        """
        return pulumi.get(self, "match_scope")

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> 'WebAclOversizeHandling':
        """
        What AWS WAF should do if the headers determined by your match scope are more numerous or larger than AWS WAF can inspect. AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available headers normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class WebAclImmunityTimeProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "immunityTime":
            suggest = "immunity_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclImmunityTimeProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclImmunityTimeProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclImmunityTimeProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 immunity_time: builtins.int):
        """
        :param builtins.int immunity_time: The amount of time, in seconds, that a `CAPTCHA` or challenge timestamp is considered valid by AWS WAF . The default setting is 300.
               
               For the Challenge action, the minimum setting is 300.
        """
        pulumi.set(__self__, "immunity_time", immunity_time)

    @property
    @pulumi.getter(name="immunityTime")
    def immunity_time(self) -> builtins.int:
        """
        The amount of time, in seconds, that a `CAPTCHA` or challenge timestamp is considered valid by AWS WAF . The default setting is 300.

        For the Challenge action, the minimum setting is 300.
        """
        return pulumi.get(self, "immunity_time")


@pulumi.output_type
class WebAclIpSetForwardedIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"
        elif key == "headerName":
            suggest = "header_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclIpSetForwardedIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclIpSetForwardedIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclIpSetForwardedIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'WebAclIpSetForwardedIpConfigurationFallbackBehavior',
                 header_name: builtins.str,
                 position: 'WebAclIpSetForwardedIpConfigurationPosition'):
        """
        :param 'WebAclIpSetForwardedIpConfigurationFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        :param builtins.str header_name: The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        :param 'WebAclIpSetForwardedIpConfigurationPosition' position: The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be `10.1.1.1, 127.0.0.0, 10.10.10.10` where the first IP address identifies the original client and the rest identify proxies that the request went through.
               
               The options for this setting are the following:
               
               - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
               - LAST - Inspect the last IP address in the list of IP addresses in the header.
               - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)
        pulumi.set(__self__, "header_name", header_name)
        pulumi.set(__self__, "position", position)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'WebAclIpSetForwardedIpConfigurationFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> builtins.str:
        """
        The name of the HTTP header to use for the IP address. For example, to use the X-Forwarded-For (XFF) header, set this to `X-Forwarded-For` .

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter
    def position(self) -> 'WebAclIpSetForwardedIpConfigurationPosition':
        """
        The position in the header to search for the IP address. The header can contain IP addresses of the original client and also of proxies. For example, the header value could be `10.1.1.1, 127.0.0.0, 10.10.10.10` where the first IP address identifies the original client and the rest identify proxies that the request went through.

        The options for this setting are the following:

        - FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.
        - LAST - Inspect the last IP address in the list of IP addresses in the header.
        - ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.
        """
        return pulumi.get(self, "position")


@pulumi.output_type
class WebAclIpSetReferenceStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipSetForwardedIpConfig":
            suggest = "ip_set_forwarded_ip_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclIpSetReferenceStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclIpSetReferenceStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclIpSetReferenceStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 ip_set_forwarded_ip_config: Optional['outputs.WebAclIpSetForwardedIpConfiguration'] = None):
        """
        :param builtins.str arn: The Amazon Resource Name (ARN) of the `IPSet` that this statement references.
        :param 'WebAclIpSetForwardedIpConfiguration' ip_set_forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        pulumi.set(__self__, "arn", arn)
        if ip_set_forwarded_ip_config is not None:
            pulumi.set(__self__, "ip_set_forwarded_ip_config", ip_set_forwarded_ip_config)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the `IPSet` that this statement references.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="ipSetForwardedIpConfig")
    def ip_set_forwarded_ip_config(self) -> Optional['outputs.WebAclIpSetForwardedIpConfiguration']:
        """
        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
        """
        return pulumi.get(self, "ip_set_forwarded_ip_config")


@pulumi.output_type
class WebAclJa3Fingerprint(dict):
    """
    Includes the JA3 fingerprint of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclJa3Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclJa3Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclJa3Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'WebAclJa3FingerprintFallbackBehavior'):
        """
        Includes the JA3 fingerprint of a web request.
        :param 'WebAclJa3FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'WebAclJa3FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a JA3 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class WebAclJa4Fingerprint(dict):
    """
    Includes the JA4 fingerprint of a web request.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclJa4Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclJa4Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclJa4Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'WebAclJa4FingerprintFallbackBehavior'):
        """
        Includes the JA4 fingerprint of a web request.
        :param 'WebAclJa4FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if the request doesn't have a JA4 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'WebAclJa4FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if the request doesn't have a JA4 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class WebAclJsonBody(dict):
    """
    Inspect the request body as JSON. The request body immediately follows the request headers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matchPattern":
            suggest = "match_pattern"
        elif key == "matchScope":
            suggest = "match_scope"
        elif key == "invalidFallbackBehavior":
            suggest = "invalid_fallback_behavior"
        elif key == "oversizeHandling":
            suggest = "oversize_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclJsonBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclJsonBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclJsonBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match_pattern: 'outputs.WebAclJsonMatchPattern',
                 match_scope: 'WebAclJsonMatchScope',
                 invalid_fallback_behavior: Optional['WebAclBodyParsingFallbackBehavior'] = None,
                 oversize_handling: Optional['WebAclOversizeHandling'] = None):
        """
        Inspect the request body as JSON. The request body immediately follows the request headers.
        :param 'WebAclJsonMatchPattern' match_pattern: The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
        :param 'WebAclJsonMatchScope' match_scope: The parts of the JSON to match against using the `MatchPattern` . If you specify `ALL` , AWS WAF matches against keys and values.
               
               `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        :param 'WebAclBodyParsingFallbackBehavior' invalid_fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:
               
               - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
               
               > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        :param 'WebAclOversizeHandling' oversize_handling: What AWS WAF should do if the body is larger than AWS WAF can inspect.
               
               AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
               
               - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
               - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
               - For AWS Amplify , use the CloudFront limit.
               
               The options for oversize handling are the following:
               
               - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
               
               Default: `CONTINUE`
        """
        pulumi.set(__self__, "match_pattern", match_pattern)
        pulumi.set(__self__, "match_scope", match_scope)
        if invalid_fallback_behavior is not None:
            pulumi.set(__self__, "invalid_fallback_behavior", invalid_fallback_behavior)
        if oversize_handling is not None:
            pulumi.set(__self__, "oversize_handling", oversize_handling)

    @property
    @pulumi.getter(name="matchPattern")
    def match_pattern(self) -> 'outputs.WebAclJsonMatchPattern':
        """
        The patterns to look for in the JSON body. AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
        """
        return pulumi.get(self, "match_pattern")

    @property
    @pulumi.getter(name="matchScope")
    def match_scope(self) -> 'WebAclJsonMatchScope':
        """
        The parts of the JSON to match against using the `MatchPattern` . If you specify `ALL` , AWS WAF matches against keys and values.

        `All` does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical `AND` statement to combine two match rules, one that inspects the keys and another that inspects the values.
        """
        return pulumi.get(self, "match_scope")

    @property
    @pulumi.getter(name="invalidFallbackBehavior")
    def invalid_fallback_behavior(self) -> Optional['WebAclBodyParsingFallbackBehavior']:
        """
        What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:

        - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

        > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "invalid_fallback_behavior")

    @property
    @pulumi.getter(name="oversizeHandling")
    def oversize_handling(self) -> Optional['WebAclOversizeHandling']:
        """
        What AWS WAF should do if the body is larger than AWS WAF can inspect.

        AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.

        - For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
        - For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL `AssociationConfig` , for additional processing fees.
        - For AWS Amplify , use the CloudFront limit.

        The options for oversize handling are the following:

        - `CONTINUE` - Inspect the available body contents normally, according to the rule inspection criteria.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        You can combine the `MATCH` or `NO_MATCH` settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.

        Default: `CONTINUE`
        """
        return pulumi.get(self, "oversize_handling")


@pulumi.output_type
class WebAclJsonMatchPattern(dict):
    """
    The pattern to look for in the JSON body.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includedPaths":
            suggest = "included_paths"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclJsonMatchPattern. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclJsonMatchPattern.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclJsonMatchPattern.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all: Optional[Any] = None,
                 included_paths: Optional[Sequence[builtins.str]] = None):
        """
        The pattern to look for in the JSON body.
        :param Any all: Inspect all parts of the web request's JSON body.
        :param Sequence[builtins.str] included_paths: Match only the specified include paths. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.
               
               Provide the include paths using JSON Pointer syntax. For example, `"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               You must specify either this setting or the `All` setting, but not both.
               
               > Don't use this option to include all paths. Instead, use the `All` setting.
        """
        if all is not None:
            pulumi.set(__self__, "all", all)
        if included_paths is not None:
            pulumi.set(__self__, "included_paths", included_paths)

    @property
    @pulumi.getter
    def all(self) -> Optional[Any]:
        """
        Inspect all parts of the web request's JSON body.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="includedPaths")
    def included_paths(self) -> Optional[Sequence[builtins.str]]:
        """
        Match only the specified include paths. See also `MatchScope` in the `JsonBody` `FieldToMatch` specification.

        Provide the include paths using JSON Pointer syntax. For example, `"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]` . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        You must specify either this setting or the `All` setting, but not both.

        > Don't use this option to include all paths. Instead, use the `All` setting.
        """
        return pulumi.get(self, "included_paths")


@pulumi.output_type
class WebAclLabel(dict):
    def __init__(__self__, *,
                 name: builtins.str):
        """
        :param builtins.str name: The label string.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The label string.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WebAclLabelMatchStatement(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 scope: 'WebAclLabelMatchScope'):
        """
        :param builtins.str key: The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:
               
               - If the `Scope` indicates `LABEL` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
               - If the `Scope` indicates `NAMESPACE` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.
               
               Labels are case sensitive and components of a label must be separated by colon, for example `NS1:NS2:name` .
        :param 'WebAclLabelMatchScope' scope: Specify whether you want to match using the label name or just the namespace.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The string to match against. The setting you provide for this depends on the match statement's `Scope` setting:

        - If the `Scope` indicates `LABEL` , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.
        - If the `Scope` indicates `NAMESPACE` , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.

        Labels are case sensitive and components of a label must be separated by colon, for example `NS1:NS2:name` .
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> 'WebAclLabelMatchScope':
        """
        Specify whether you want to match using the label name or just the namespace.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class WebAclManagedRuleGroupConfig(dict):
    """
    ManagedRuleGroupConfig.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "awsManagedRulesAcfpRuleSet":
            suggest = "aws_managed_rules_acfp_rule_set"
        elif key == "awsManagedRulesAtpRuleSet":
            suggest = "aws_managed_rules_atp_rule_set"
        elif key == "awsManagedRulesBotControlRuleSet":
            suggest = "aws_managed_rules_bot_control_rule_set"
        elif key == "loginPath":
            suggest = "login_path"
        elif key == "passwordField":
            suggest = "password_field"
        elif key == "payloadType":
            suggest = "payload_type"
        elif key == "usernameField":
            suggest = "username_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclManagedRuleGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclManagedRuleGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclManagedRuleGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aws_managed_rules_acfp_rule_set: Optional['outputs.WebAclAwsManagedRulesAcfpRuleSet'] = None,
                 aws_managed_rules_atp_rule_set: Optional['outputs.WebAclAwsManagedRulesAtpRuleSet'] = None,
                 aws_managed_rules_bot_control_rule_set: Optional['outputs.WebAclAwsManagedRulesBotControlRuleSet'] = None,
                 login_path: Optional[builtins.str] = None,
                 password_field: Optional['outputs.WebAclFieldIdentifier'] = None,
                 payload_type: Optional['WebAclManagedRuleGroupConfigPayloadType'] = None,
                 username_field: Optional['outputs.WebAclFieldIdentifier'] = None):
        """
        ManagedRuleGroupConfig.
        :param 'WebAclAwsManagedRulesAcfpRuleSet' aws_managed_rules_acfp_rule_set: Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, `AWSManagedRulesACFPRuleSet` . Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.
               
               For information about using the ACFP managed rule group, see [AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html) and [AWS WAF Fraud Control account creation fraud prevention (ACFP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html) in the *AWS WAF Developer Guide* .
        :param 'WebAclAwsManagedRulesAtpRuleSet' aws_managed_rules_atp_rule_set: Additional configuration for using the account takeover prevention (ATP) managed rule group, `AWSManagedRulesATPRuleSet` . Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.
               
               This configuration replaces the individual configuration fields in `ManagedRuleGroupConfig` and provides additional feature configuration.
               
               For information about using the ATP managed rule group, see [AWS WAF Fraud Control account takeover prevention (ATP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html) and [AWS WAF Fraud Control account takeover prevention (ATP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html) in the *AWS WAF Developer Guide* .
        :param 'WebAclAwsManagedRulesBotControlRuleSet' aws_managed_rules_bot_control_rule_set: Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see [AWS WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) and [AWS WAF Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html) in the *AWS WAF Developer Guide* .
        :param builtins.str login_path: > Instead of this setting, provide your configuration under `AWSManagedRulesATPRuleSet` .
        :param 'WebAclFieldIdentifier' password_field: > Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet` .
        :param 'WebAclManagedRuleGroupConfigPayloadType' payload_type: > Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet` .
        :param 'WebAclFieldIdentifier' username_field: > Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet` .
        """
        if aws_managed_rules_acfp_rule_set is not None:
            pulumi.set(__self__, "aws_managed_rules_acfp_rule_set", aws_managed_rules_acfp_rule_set)
        if aws_managed_rules_atp_rule_set is not None:
            pulumi.set(__self__, "aws_managed_rules_atp_rule_set", aws_managed_rules_atp_rule_set)
        if aws_managed_rules_bot_control_rule_set is not None:
            pulumi.set(__self__, "aws_managed_rules_bot_control_rule_set", aws_managed_rules_bot_control_rule_set)
        if login_path is not None:
            pulumi.set(__self__, "login_path", login_path)
        if password_field is not None:
            pulumi.set(__self__, "password_field", password_field)
        if payload_type is not None:
            pulumi.set(__self__, "payload_type", payload_type)
        if username_field is not None:
            pulumi.set(__self__, "username_field", username_field)

    @property
    @pulumi.getter(name="awsManagedRulesAcfpRuleSet")
    def aws_managed_rules_acfp_rule_set(self) -> Optional['outputs.WebAclAwsManagedRulesAcfpRuleSet']:
        """
        Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, `AWSManagedRulesACFPRuleSet` . Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.

        For information about using the ACFP managed rule group, see [AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html) and [AWS WAF Fraud Control account creation fraud prevention (ACFP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "aws_managed_rules_acfp_rule_set")

    @property
    @pulumi.getter(name="awsManagedRulesAtpRuleSet")
    def aws_managed_rules_atp_rule_set(self) -> Optional['outputs.WebAclAwsManagedRulesAtpRuleSet']:
        """
        Additional configuration for using the account takeover prevention (ATP) managed rule group, `AWSManagedRulesATPRuleSet` . Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.

        This configuration replaces the individual configuration fields in `ManagedRuleGroupConfig` and provides additional feature configuration.

        For information about using the ATP managed rule group, see [AWS WAF Fraud Control account takeover prevention (ATP) rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html) and [AWS WAF Fraud Control account takeover prevention (ATP)](https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "aws_managed_rules_atp_rule_set")

    @property
    @pulumi.getter(name="awsManagedRulesBotControlRuleSet")
    def aws_managed_rules_bot_control_rule_set(self) -> Optional['outputs.WebAclAwsManagedRulesBotControlRuleSet']:
        """
        Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see [AWS WAF Bot Control rule group](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html) and [AWS WAF Bot Control](https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "aws_managed_rules_bot_control_rule_set")

    @property
    @pulumi.getter(name="loginPath")
    def login_path(self) -> Optional[builtins.str]:
        """
        > Instead of this setting, provide your configuration under `AWSManagedRulesATPRuleSet` .
        """
        return pulumi.get(self, "login_path")

    @property
    @pulumi.getter(name="passwordField")
    def password_field(self) -> Optional['outputs.WebAclFieldIdentifier']:
        """
        > Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet` .
        """
        return pulumi.get(self, "password_field")

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> Optional['WebAclManagedRuleGroupConfigPayloadType']:
        """
        > Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet` .
        """
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter(name="usernameField")
    def username_field(self) -> Optional['outputs.WebAclFieldIdentifier']:
        """
        > Instead of this setting, provide your configuration under the request inspection configuration for `AWSManagedRulesATPRuleSet` or `AWSManagedRulesACFPRuleSet` .
        """
        return pulumi.get(self, "username_field")


@pulumi.output_type
class WebAclManagedRuleGroupStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vendorName":
            suggest = "vendor_name"
        elif key == "excludedRules":
            suggest = "excluded_rules"
        elif key == "managedRuleGroupConfigs":
            suggest = "managed_rule_group_configs"
        elif key == "ruleActionOverrides":
            suggest = "rule_action_overrides"
        elif key == "scopeDownStatement":
            suggest = "scope_down_statement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclManagedRuleGroupStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclManagedRuleGroupStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclManagedRuleGroupStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 vendor_name: builtins.str,
                 excluded_rules: Optional[Sequence['outputs.WebAclExcludedRule']] = None,
                 managed_rule_group_configs: Optional[Sequence['outputs.WebAclManagedRuleGroupConfig']] = None,
                 rule_action_overrides: Optional[Sequence['outputs.WebAclRuleActionOverride']] = None,
                 scope_down_statement: Optional['outputs.WebAclStatement'] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str name: The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
        :param builtins.str vendor_name: The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
        :param Sequence['WebAclExcludedRule'] excluded_rules: Rules in the referenced rule group whose actions are set to `Count` .
               
               > Instead of this option, use `RuleActionOverrides` . It accepts any valid action setting, including `Count` .
        :param Sequence['WebAclManagedRuleGroupConfig'] managed_rule_group_configs: Collection of ManagedRuleGroupConfig.
        :param Sequence['WebAclRuleActionOverride'] rule_action_overrides: Action overrides for rules in the rule group.
        :param 'WebAclStatement' scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
        :param builtins.str version: The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vendor_name", vendor_name)
        if excluded_rules is not None:
            pulumi.set(__self__, "excluded_rules", excluded_rules)
        if managed_rule_group_configs is not None:
            pulumi.set(__self__, "managed_rule_group_configs", managed_rule_group_configs)
        if rule_action_overrides is not None:
            pulumi.set(__self__, "rule_action_overrides", rule_action_overrides)
        if scope_down_statement is not None:
            pulumi.set(__self__, "scope_down_statement", scope_down_statement)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the managed rule group. You use this, along with the vendor name, to identify the rule group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> builtins.str:
        """
        The name of the managed rule group vendor. You use this, along with the rule group name, to identify a rule group.
        """
        return pulumi.get(self, "vendor_name")

    @property
    @pulumi.getter(name="excludedRules")
    def excluded_rules(self) -> Optional[Sequence['outputs.WebAclExcludedRule']]:
        """
        Rules in the referenced rule group whose actions are set to `Count` .

        > Instead of this option, use `RuleActionOverrides` . It accepts any valid action setting, including `Count` .
        """
        return pulumi.get(self, "excluded_rules")

    @property
    @pulumi.getter(name="managedRuleGroupConfigs")
    def managed_rule_group_configs(self) -> Optional[Sequence['outputs.WebAclManagedRuleGroupConfig']]:
        """
        Collection of ManagedRuleGroupConfig.
        """
        return pulumi.get(self, "managed_rule_group_configs")

    @property
    @pulumi.getter(name="ruleActionOverrides")
    def rule_action_overrides(self) -> Optional[Sequence['outputs.WebAclRuleActionOverride']]:
        """
        Action overrides for rules in the rule group.
        """
        return pulumi.get(self, "rule_action_overrides")

    @property
    @pulumi.getter(name="scopeDownStatement")
    def scope_down_statement(self) -> Optional['outputs.WebAclStatement']:
        """
        An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group. Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
        """
        return pulumi.get(self, "scope_down_statement")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        The version of the managed rule group to use. If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WebAclNotStatement(dict):
    def __init__(__self__, *,
                 statement: 'outputs.WebAclStatement'):
        """
        :param 'WebAclStatement' statement: The statement to negate. You can use any statement that can be nested.
        """
        pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def statement(self) -> 'outputs.WebAclStatement':
        """
        The statement to negate. You can use any statement that can be nested.
        """
        return pulumi.get(self, "statement")


@pulumi.output_type
class WebAclOrStatement(dict):
    def __init__(__self__, *,
                 statements: Sequence['outputs.WebAclStatement']):
        """
        :param Sequence['WebAclStatement'] statements: The statements to combine with OR logic. You can use any statements that can be nested.
        """
        pulumi.set(__self__, "statements", statements)

    @property
    @pulumi.getter
    def statements(self) -> Sequence['outputs.WebAclStatement']:
        """
        The statements to combine with OR logic. You can use any statements that can be nested.
        """
        return pulumi.get(self, "statements")


@pulumi.output_type
class WebAclOverrideAction(dict):
    """
    Override a RuleGroup or ManagedRuleGroup behavior. This can only be applied to Rule that has RuleGroupReferenceStatement or ManagedRuleGroupReferenceStatement.
    """
    def __init__(__self__, *,
                 count: Optional[Any] = None,
                 none: Optional[Any] = None):
        """
        Override a RuleGroup or ManagedRuleGroup behavior. This can only be applied to Rule that has RuleGroupReferenceStatement or ManagedRuleGroupReferenceStatement.
        :param Any count: Count traffic towards application.
        :param Any none: Keep the RuleGroup or ManagedRuleGroup behavior as is.
        """
        if count is not None:
            pulumi.set(__self__, "count", count)
        if none is not None:
            pulumi.set(__self__, "none", none)

    @property
    @pulumi.getter
    def count(self) -> Optional[Any]:
        """
        Count traffic towards application.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter
    def none(self) -> Optional[Any]:
        """
        Keep the RuleGroup or ManagedRuleGroup behavior as is.
        """
        return pulumi.get(self, "none")


@pulumi.output_type
class WebAclRateBasedStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aggregateKeyType":
            suggest = "aggregate_key_type"
        elif key == "customKeys":
            suggest = "custom_keys"
        elif key == "evaluationWindowSec":
            suggest = "evaluation_window_sec"
        elif key == "forwardedIpConfig":
            suggest = "forwarded_ip_config"
        elif key == "scopeDownStatement":
            suggest = "scope_down_statement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateBasedStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateBasedStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateBasedStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 aggregate_key_type: 'WebAclRateBasedStatementAggregateKeyType',
                 limit: builtins.int,
                 custom_keys: Optional[Sequence['outputs.WebAclRateBasedStatementCustomKey']] = None,
                 evaluation_window_sec: Optional[builtins.int] = None,
                 forwarded_ip_config: Optional['outputs.WebAclForwardedIpConfiguration'] = None,
                 scope_down_statement: Optional['outputs.WebAclStatement'] = None):
        """
        :param 'WebAclRateBasedStatementAggregateKeyType' aggregate_key_type: Setting that indicates how to aggregate the request counts.
               
               > Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. 
               
               - `CONSTANT` - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.
               
               With this option, you must configure the `ScopeDownStatement` property.
               - `CUSTOM_KEYS` - Aggregate the request counts using one or more web request components as the aggregate keys.
               
               With this option, you must specify the aggregate keys in the `CustomKeys` property.
               
               To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to `IP` or `FORWARDED_IP` .
               - `FORWARDED_IP` - Aggregate the request counts on the first IP address in an HTTP header.
               
               With this option, you must specify the header to use in the `ForwardedIPConfig` property.
               
               To aggregate on a combination of the forwarded IP address with other aggregate keys, use `CUSTOM_KEYS` .
               - `IP` - Aggregate the request counts on the IP address from the web request origin.
               
               To aggregate on a combination of the IP address with other aggregate keys, use `CUSTOM_KEYS` .
        :param builtins.int limit: The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule. If the rate-based statement includes a `ScopeDownStatement` , this limit is applied only to the requests that match the statement.
               
               Examples:
               
               - If you aggregate on just the IP address, this is the limit on requests from any single IP address.
               - If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.
        :param Sequence['WebAclRateBasedStatementCustomKey'] custom_keys: Specifies the aggregate keys to use in a rate-base rule.
        :param builtins.int evaluation_window_sec: The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time. For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.
               
               This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.
               
               Default: `300` (5 minutes)
        :param 'WebAclForwardedIpConfiguration' forwarded_ip_config: The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
               
               > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 
               
               This is required if you specify a forwarded IP in the rule's aggregate key settings.
        :param 'WebAclStatement' scope_down_statement: An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement. When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
        """
        pulumi.set(__self__, "aggregate_key_type", aggregate_key_type)
        pulumi.set(__self__, "limit", limit)
        if custom_keys is not None:
            pulumi.set(__self__, "custom_keys", custom_keys)
        if evaluation_window_sec is not None:
            pulumi.set(__self__, "evaluation_window_sec", evaluation_window_sec)
        if forwarded_ip_config is not None:
            pulumi.set(__self__, "forwarded_ip_config", forwarded_ip_config)
        if scope_down_statement is not None:
            pulumi.set(__self__, "scope_down_statement", scope_down_statement)

    @property
    @pulumi.getter(name="aggregateKeyType")
    def aggregate_key_type(self) -> 'WebAclRateBasedStatementAggregateKeyType':
        """
        Setting that indicates how to aggregate the request counts.

        > Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling. 

        - `CONSTANT` - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.

        With this option, you must configure the `ScopeDownStatement` property.
        - `CUSTOM_KEYS` - Aggregate the request counts using one or more web request components as the aggregate keys.

        With this option, you must specify the aggregate keys in the `CustomKeys` property.

        To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to `IP` or `FORWARDED_IP` .
        - `FORWARDED_IP` - Aggregate the request counts on the first IP address in an HTTP header.

        With this option, you must specify the header to use in the `ForwardedIPConfig` property.

        To aggregate on a combination of the forwarded IP address with other aggregate keys, use `CUSTOM_KEYS` .
        - `IP` - Aggregate the request counts on the IP address from the web request origin.

        To aggregate on a combination of the IP address with other aggregate keys, use `CUSTOM_KEYS` .
        """
        return pulumi.get(self, "aggregate_key_type")

    @property
    @pulumi.getter
    def limit(self) -> builtins.int:
        """
        The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule. If the rate-based statement includes a `ScopeDownStatement` , this limit is applied only to the requests that match the statement.

        Examples:

        - If you aggregate on just the IP address, this is the limit on requests from any single IP address.
        - If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter(name="customKeys")
    def custom_keys(self) -> Optional[Sequence['outputs.WebAclRateBasedStatementCustomKey']]:
        """
        Specifies the aggregate keys to use in a rate-base rule.
        """
        return pulumi.get(self, "custom_keys")

    @property
    @pulumi.getter(name="evaluationWindowSec")
    def evaluation_window_sec(self) -> Optional[builtins.int]:
        """
        The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time. For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.

        This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.

        Default: `300` (5 minutes)
        """
        return pulumi.get(self, "evaluation_window_sec")

    @property
    @pulumi.getter(name="forwardedIpConfig")
    def forwarded_ip_config(self) -> Optional['outputs.WebAclForwardedIpConfiguration']:
        """
        The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.

        > If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all. 

        This is required if you specify a forwarded IP in the rule's aggregate key settings.
        """
        return pulumi.get(self, "forwarded_ip_config")

    @property
    @pulumi.getter(name="scopeDownStatement")
    def scope_down_statement(self) -> Optional['outputs.WebAclStatement']:
        """
        An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement. When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable `Statement` in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
        """
        return pulumi.get(self, "scope_down_statement")


@pulumi.output_type
class WebAclRateBasedStatementCustomKey(dict):
    """
    Specifies a single custom aggregate key for a rate-base rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardedIp":
            suggest = "forwarded_ip"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "ja3Fingerprint":
            suggest = "ja3_fingerprint"
        elif key == "ja4Fingerprint":
            suggest = "ja4_fingerprint"
        elif key == "labelNamespace":
            suggest = "label_namespace"
        elif key == "queryArgument":
            suggest = "query_argument"
        elif key == "queryString":
            suggest = "query_string"
        elif key == "uriPath":
            suggest = "uri_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateBasedStatementCustomKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateBasedStatementCustomKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateBasedStatementCustomKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie: Optional['outputs.WebAclRateLimitCookie'] = None,
                 forwarded_ip: Optional['outputs.WebAclRateLimitForwardedIp'] = None,
                 header: Optional['outputs.WebAclRateLimitHeader'] = None,
                 http_method: Optional['outputs.WebAclRateLimitHttpMethod'] = None,
                 ip: Optional['outputs.WebAclRateLimitIp'] = None,
                 ja3_fingerprint: Optional['outputs.WebAclRateLimitJa3Fingerprint'] = None,
                 ja4_fingerprint: Optional['outputs.WebAclRateLimitJa4Fingerprint'] = None,
                 label_namespace: Optional['outputs.WebAclRateLimitLabelNamespace'] = None,
                 query_argument: Optional['outputs.WebAclRateLimitQueryArgument'] = None,
                 query_string: Optional['outputs.WebAclRateLimitQueryString'] = None,
                 uri_path: Optional['outputs.WebAclRateLimitUriPath'] = None):
        """
        Specifies a single custom aggregate key for a rate-base rule.
        :param 'WebAclRateLimitCookie' cookie: Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
        :param 'WebAclRateLimitForwardedIp' forwarded_ip: Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.
               
               When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying `FORWARDED_IP` in your rate-based statement's `AggregateKeyType` .
               
               With this option, you must specify the header to use in the rate-based rule's `ForwardedIPConfig` property.
        :param 'WebAclRateLimitHeader' header: Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
        :param 'WebAclRateLimitHttpMethod' http_method: Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
        :param 'WebAclRateLimitIp' ip: Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.
               
               When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying `IP` in your rate-based statement's `AggregateKeyType` .
        :param 'WebAclRateLimitJa3Fingerprint' ja3_fingerprint: Use the request's JA3 fingerprint as an aggregate key. If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
        :param 'WebAclRateLimitJa4Fingerprint' ja4_fingerprint: Use the request's JA4 fingerprint as an aggregate key. If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
        :param 'WebAclRateLimitLabelNamespace' label_namespace: Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
               
               This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
               
               For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *AWS WAF Developer Guide* .
        :param 'WebAclRateLimitQueryArgument' query_argument: Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
        :param 'WebAclRateLimitQueryString' query_string: Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
        :param 'WebAclRateLimitUriPath' uri_path: Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
        """
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if forwarded_ip is not None:
            pulumi.set(__self__, "forwarded_ip", forwarded_ip)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)
        if ja3_fingerprint is not None:
            pulumi.set(__self__, "ja3_fingerprint", ja3_fingerprint)
        if ja4_fingerprint is not None:
            pulumi.set(__self__, "ja4_fingerprint", ja4_fingerprint)
        if label_namespace is not None:
            pulumi.set(__self__, "label_namespace", label_namespace)
        if query_argument is not None:
            pulumi.set(__self__, "query_argument", query_argument)
        if query_string is not None:
            pulumi.set(__self__, "query_string", query_string)
        if uri_path is not None:
            pulumi.set(__self__, "uri_path", uri_path)

    @property
    @pulumi.getter
    def cookie(self) -> Optional['outputs.WebAclRateLimitCookie']:
        """
        Use the value of a cookie in the request as an aggregate key. Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "cookie")

    @property
    @pulumi.getter(name="forwardedIp")
    def forwarded_ip(self) -> Optional['outputs.WebAclRateLimitForwardedIp']:
        """
        Use the first IP address in an HTTP header as an aggregate key. Each distinct forwarded IP address contributes to the aggregation instance.

        When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying `FORWARDED_IP` in your rate-based statement's `AggregateKeyType` .

        With this option, you must specify the header to use in the rate-based rule's `ForwardedIPConfig` property.
        """
        return pulumi.get(self, "forwarded_ip")

    @property
    @pulumi.getter
    def header(self) -> Optional['outputs.WebAclRateLimitHeader']:
        """
        Use the value of a header in the request as an aggregate key. Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional['outputs.WebAclRateLimitHttpMethod']:
        """
        Use the request's HTTP method as an aggregate key. Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter
    def ip(self) -> Optional['outputs.WebAclRateLimitIp']:
        """
        Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.

        When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying `IP` in your rate-based statement's `AggregateKeyType` .
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="ja3Fingerprint")
    def ja3_fingerprint(self) -> Optional['outputs.WebAclRateLimitJa3Fingerprint']:
        """
        Use the request's JA3 fingerprint as an aggregate key. If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "ja3_fingerprint")

    @property
    @pulumi.getter(name="ja4Fingerprint")
    def ja4_fingerprint(self) -> Optional['outputs.WebAclRateLimitJa4Fingerprint']:
        """
        Use the request's JA4 fingerprint as an aggregate key. If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "ja4_fingerprint")

    @property
    @pulumi.getter(name="labelNamespace")
    def label_namespace(self) -> Optional['outputs.WebAclRateLimitLabelNamespace']:
        """
        Use the specified label namespace as an aggregate key. Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.

        This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.

        For information about label namespaces and names, see [Label syntax and naming requirements](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "label_namespace")

    @property
    @pulumi.getter(name="queryArgument")
    def query_argument(self) -> Optional['outputs.WebAclRateLimitQueryArgument']:
        """
        Use the specified query argument as an aggregate key. Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
        """
        return pulumi.get(self, "query_argument")

    @property
    @pulumi.getter(name="queryString")
    def query_string(self) -> Optional['outputs.WebAclRateLimitQueryString']:
        """
        Use the request's query string as an aggregate key. Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
        """
        return pulumi.get(self, "query_string")

    @property
    @pulumi.getter(name="uriPath")
    def uri_path(self) -> Optional['outputs.WebAclRateLimitUriPath']:
        """
        Use the request's URI path as an aggregate key. Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
        """
        return pulumi.get(self, "uri_path")


@pulumi.output_type
class WebAclRateLimitCookie(dict):
    """
    Specifies a cookie as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitCookie. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitCookie.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitCookie.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Specifies a cookie as an aggregate key for a rate-based rule.
        :param builtins.str name: The name of the cookie to use.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the cookie to use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRateLimitForwardedIp(dict):
    """
    Specifies the first IP address in an HTTP header as an aggregate key for a rate-based rule.
    """
    def __init__(__self__):
        """
        Specifies the first IP address in an HTTP header as an aggregate key for a rate-based rule.
        """
        pass


@pulumi.output_type
class WebAclRateLimitHeader(dict):
    """
    Specifies a header as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Specifies a header as an aggregate key for a rate-based rule.
        :param builtins.str name: The name of the header to use.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the header to use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRateLimitHttpMethod(dict):
    """
    Specifies the request's HTTP method as an aggregate key for a rate-based rule.
    """
    def __init__(__self__):
        """
        Specifies the request's HTTP method as an aggregate key for a rate-based rule.
        """
        pass


@pulumi.output_type
class WebAclRateLimitIp(dict):
    """
    Specifies the IP address in the web request as an aggregate key for a rate-based rule.
    """
    def __init__(__self__):
        """
        Specifies the IP address in the web request as an aggregate key for a rate-based rule.
        """
        pass


@pulumi.output_type
class WebAclRateLimitJa3Fingerprint(dict):
    """
    Specifies the request's JA3 fingerprint as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitJa3Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitJa3Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitJa3Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'WebAclRateLimitJa3FingerprintFallbackBehavior'):
        """
        Specifies the request's JA3 fingerprint as an aggregate key for a rate-based rule.
        :param 'WebAclRateLimitJa3FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'WebAclRateLimitJa3FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class WebAclRateLimitJa4Fingerprint(dict):
    """
    Specifies the request's JA4 fingerprint as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitJa4Fingerprint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitJa4Fingerprint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitJa4Fingerprint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: 'WebAclRateLimitJa4FingerprintFallbackBehavior'):
        """
        Specifies the request's JA4 fingerprint as an aggregate key for a rate-based rule.
        :param 'WebAclRateLimitJa4FingerprintFallbackBehavior' fallback_behavior: The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint.
               
               You can specify the following fallback behaviors:
               
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> 'WebAclRateLimitJa4FingerprintFallbackBehavior':
        """
        The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint.

        You can specify the following fallback behaviors:

        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class WebAclRateLimitLabelNamespace(dict):
    """
    Specifies a label namespace to use as an aggregate key for a rate-based rule.
    """
    def __init__(__self__, *,
                 namespace: builtins.str):
        """
        Specifies a label namespace to use as an aggregate key for a rate-based rule.
        :param builtins.str namespace: The namespace to use for aggregation.
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        """
        The namespace to use for aggregation.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class WebAclRateLimitQueryArgument(dict):
    """
    Specifies a query argument in the request as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitQueryArgument. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitQueryArgument.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitQueryArgument.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Specifies a query argument in the request as an aggregate key for a rate-based rule.
        :param builtins.str name: The name of the query argument to use.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the query argument to use.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRateLimitQueryString(dict):
    """
    Specifies the request's query string as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitQueryString. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitQueryString.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitQueryString.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Specifies the request's query string as an aggregate key for a rate-based rule.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRateLimitUriPath(dict):
    """
    Specifies the request's URI Path as an aggregate key for a rate-based rule.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRateLimitUriPath. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRateLimitUriPath.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRateLimitUriPath.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Specifies the request's URI Path as an aggregate key for a rate-based rule.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. Text transformations are used in rule match statements, to transform the `FieldToMatch` request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRegexMatchStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "regexString":
            suggest = "regex_string"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRegexMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRegexMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRegexMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.WebAclFieldToMatch',
                 regex_string: builtins.str,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        :param 'WebAclFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param builtins.str regex_string: The string representing the regular expression.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "regex_string", regex_string)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.WebAclFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="regexString")
    def regex_string(self) -> builtins.str:
        """
        The string representing the regular expression.
        """
        return pulumi.get(self, "regex_string")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRegexPatternSetReferenceStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRegexPatternSetReferenceStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRegexPatternSetReferenceStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRegexPatternSetReferenceStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 field_to_match: 'outputs.WebAclFieldToMatch',
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        :param builtins.str arn: The Amazon Resource Name (ARN) of the `RegexPatternSet` that this statement references.
        :param 'WebAclFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "arn", arn)
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the `RegexPatternSet` that this statement references.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.WebAclFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclRequestBodyAssociatedResourceTypeConfig(dict):
    """
    Configures the inspection size in the request body.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultSizeInspectionLimit":
            suggest = "default_size_inspection_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRequestBodyAssociatedResourceTypeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRequestBodyAssociatedResourceTypeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRequestBodyAssociatedResourceTypeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_size_inspection_limit: 'WebAclSizeInspectionLimit'):
        """
        Configures the inspection size in the request body.
        :param 'WebAclSizeInspectionLimit' default_size_inspection_limit: Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body.
               
               Default: `16 KB (16,384 bytes)`
        """
        pulumi.set(__self__, "default_size_inspection_limit", default_size_inspection_limit)

    @property
    @pulumi.getter(name="defaultSizeInspectionLimit")
    def default_size_inspection_limit(self) -> 'WebAclSizeInspectionLimit':
        """
        Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body.

        Default: `16 KB (16,384 bytes)`
        """
        return pulumi.get(self, "default_size_inspection_limit")


@pulumi.output_type
class WebAclRequestInspection(dict):
    """
    Configures the inspection of login requests
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "passwordField":
            suggest = "password_field"
        elif key == "payloadType":
            suggest = "payload_type"
        elif key == "usernameField":
            suggest = "username_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRequestInspection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRequestInspection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRequestInspection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password_field: 'outputs.WebAclFieldIdentifier',
                 payload_type: 'WebAclRequestInspectionPayloadType',
                 username_field: 'outputs.WebAclFieldIdentifier'):
        """
        Configures the inspection of login requests
        :param 'WebAclFieldIdentifier' password_field: The name of the field in the request payload that contains your customer's password.
               
               How you specify this depends on the request inspection payload type.
               
               - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }` , the password field specification is `/form/password` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with the input element named `password1` , the password field specification is `password1` .
        :param 'WebAclRequestInspectionPayloadType' payload_type: The payload type for your login endpoint, either JSON or form encoded.
        :param 'WebAclFieldIdentifier' username_field: The name of the field in the request payload that contains your customer's username.
               
               How you specify this depends on the request inspection payload type.
               
               - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }` , the username field specification is `/form/username` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with the input element named `username1` , the username field specification is `username1`
        """
        pulumi.set(__self__, "password_field", password_field)
        pulumi.set(__self__, "payload_type", payload_type)
        pulumi.set(__self__, "username_field", username_field)

    @property
    @pulumi.getter(name="passwordField")
    def password_field(self) -> 'outputs.WebAclFieldIdentifier':
        """
        The name of the field in the request payload that contains your customer's password.

        How you specify this depends on the request inspection payload type.

        - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }` , the password field specification is `/form/password` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with the input element named `password1` , the password field specification is `password1` .
        """
        return pulumi.get(self, "password_field")

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> 'WebAclRequestInspectionPayloadType':
        """
        The payload type for your login endpoint, either JSON or form encoded.
        """
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter(name="usernameField")
    def username_field(self) -> 'outputs.WebAclFieldIdentifier':
        """
        The name of the field in the request payload that contains your customer's username.

        How you specify this depends on the request inspection payload type.

        - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }` , the username field specification is `/form/username` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with the input element named `username1` , the username field specification is `username1`
        """
        return pulumi.get(self, "username_field")


@pulumi.output_type
class WebAclRequestInspectionAcfp(dict):
    """
    Configures the inspection of sign-up requests
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payloadType":
            suggest = "payload_type"
        elif key == "addressFields":
            suggest = "address_fields"
        elif key == "emailField":
            suggest = "email_field"
        elif key == "passwordField":
            suggest = "password_field"
        elif key == "phoneNumberFields":
            suggest = "phone_number_fields"
        elif key == "usernameField":
            suggest = "username_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRequestInspectionAcfp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRequestInspectionAcfp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRequestInspectionAcfp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payload_type: 'WebAclRequestInspectionAcfpPayloadType',
                 address_fields: Optional[Sequence['outputs.WebAclFieldIdentifier']] = None,
                 email_field: Optional['outputs.WebAclFieldIdentifier'] = None,
                 password_field: Optional['outputs.WebAclFieldIdentifier'] = None,
                 phone_number_fields: Optional[Sequence['outputs.WebAclFieldIdentifier']] = None,
                 username_field: Optional['outputs.WebAclFieldIdentifier'] = None):
        """
        Configures the inspection of sign-up requests
        :param 'WebAclRequestInspectionAcfpPayloadType' payload_type: The payload type for your account creation endpoint, either JSON or form encoded.
        :param Sequence['WebAclFieldIdentifier'] address_fields: The names of the fields in the request payload that contain your customer's primary physical address.
               
               Order the address fields in the array exactly as they are ordered in the request payload.
               
               How you specify the address fields depends on the request inspection payload type.
               
               - For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }` , the address field idenfiers are `/form/primaryaddressline1` , `/form/primaryaddressline2` , and `/form/primaryaddressline3` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with input elements named `primaryaddressline1` , `primaryaddressline2` , and `primaryaddressline3` , the address fields identifiers are `primaryaddressline1` , `primaryaddressline2` , and `primaryaddressline3` .
        :param 'WebAclFieldIdentifier' email_field: The name of the field in the request payload that contains your customer's email.
               
               How you specify this depends on the request inspection payload type.
               
               - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "email": "THE_EMAIL" } }` , the email field specification is `/form/email` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with the input element named `email1` , the email field specification is `email1` .
        :param 'WebAclFieldIdentifier' password_field: The name of the field in the request payload that contains your customer's password.
               
               How you specify this depends on the request inspection payload type.
               
               - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }` , the password field specification is `/form/password` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with the input element named `password1` , the password field specification is `password1` .
        :param Sequence['WebAclFieldIdentifier'] phone_number_fields: The names of the fields in the request payload that contain your customer's primary phone number.
               
               Order the phone number fields in the array exactly as they are ordered in the request payload.
               
               How you specify the phone number fields depends on the request inspection payload type.
               
               - For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }` , the phone number field identifiers are `/form/primaryphoneline1` , `/form/primaryphoneline2` , and `/form/primaryphoneline3` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with input elements named `primaryphoneline1` , `primaryphoneline2` , and `primaryphoneline3` , the phone number field identifiers are `primaryphoneline1` , `primaryphoneline2` , and `primaryphoneline3` .
        :param 'WebAclFieldIdentifier' username_field: The name of the field in the request payload that contains your customer's username.
               
               How you specify this depends on the request inspection payload type.
               
               - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .
               
               For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }` , the username field specification is `/form/username` .
               - For form encoded payload types, use the HTML form names.
               
               For example, for an HTML form with the input element named `username1` , the username field specification is `username1`
        """
        pulumi.set(__self__, "payload_type", payload_type)
        if address_fields is not None:
            pulumi.set(__self__, "address_fields", address_fields)
        if email_field is not None:
            pulumi.set(__self__, "email_field", email_field)
        if password_field is not None:
            pulumi.set(__self__, "password_field", password_field)
        if phone_number_fields is not None:
            pulumi.set(__self__, "phone_number_fields", phone_number_fields)
        if username_field is not None:
            pulumi.set(__self__, "username_field", username_field)

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> 'WebAclRequestInspectionAcfpPayloadType':
        """
        The payload type for your account creation endpoint, either JSON or form encoded.
        """
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter(name="addressFields")
    def address_fields(self) -> Optional[Sequence['outputs.WebAclFieldIdentifier']]:
        """
        The names of the fields in the request payload that contain your customer's primary physical address.

        Order the address fields in the array exactly as they are ordered in the request payload.

        How you specify the address fields depends on the request inspection payload type.

        - For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }` , the address field idenfiers are `/form/primaryaddressline1` , `/form/primaryaddressline2` , and `/form/primaryaddressline3` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with input elements named `primaryaddressline1` , `primaryaddressline2` , and `primaryaddressline3` , the address fields identifiers are `primaryaddressline1` , `primaryaddressline2` , and `primaryaddressline3` .
        """
        return pulumi.get(self, "address_fields")

    @property
    @pulumi.getter(name="emailField")
    def email_field(self) -> Optional['outputs.WebAclFieldIdentifier']:
        """
        The name of the field in the request payload that contains your customer's email.

        How you specify this depends on the request inspection payload type.

        - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "email": "THE_EMAIL" } }` , the email field specification is `/form/email` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with the input element named `email1` , the email field specification is `email1` .
        """
        return pulumi.get(self, "email_field")

    @property
    @pulumi.getter(name="passwordField")
    def password_field(self) -> Optional['outputs.WebAclFieldIdentifier']:
        """
        The name of the field in the request payload that contains your customer's password.

        How you specify this depends on the request inspection payload type.

        - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "password": "THE_PASSWORD" } }` , the password field specification is `/form/password` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with the input element named `password1` , the password field specification is `password1` .
        """
        return pulumi.get(self, "password_field")

    @property
    @pulumi.getter(name="phoneNumberFields")
    def phone_number_fields(self) -> Optional[Sequence['outputs.WebAclFieldIdentifier']]:
        """
        The names of the fields in the request payload that contain your customer's primary phone number.

        Order the phone number fields in the array exactly as they are ordered in the request payload.

        How you specify the phone number fields depends on the request inspection payload type.

        - For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }` , the phone number field identifiers are `/form/primaryphoneline1` , `/form/primaryphoneline2` , and `/form/primaryphoneline3` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with input elements named `primaryphoneline1` , `primaryphoneline2` , and `primaryphoneline3` , the phone number field identifiers are `primaryphoneline1` , `primaryphoneline2` , and `primaryphoneline3` .
        """
        return pulumi.get(self, "phone_number_fields")

    @property
    @pulumi.getter(name="usernameField")
    def username_field(self) -> Optional['outputs.WebAclFieldIdentifier']:
        """
        The name of the field in the request payload that contains your customer's username.

        How you specify this depends on the request inspection payload type.

        - For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation [JavaScript Object Notation (JSON) Pointer](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901) .

        For example, for the JSON payload `{ "form": { "username": "THE_USERNAME" } }` , the username field specification is `/form/username` .
        - For form encoded payload types, use the HTML form names.

        For example, for an HTML form with the input element named `username1` , the username field specification is `username1`
        """
        return pulumi.get(self, "username_field")


@pulumi.output_type
class WebAclResponseInspection(dict):
    """
    Configures the inspection of login responses
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyContains":
            suggest = "body_contains"
        elif key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclResponseInspection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclResponseInspection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclResponseInspection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_contains: Optional['outputs.WebAclResponseInspectionBodyContains'] = None,
                 header: Optional['outputs.WebAclResponseInspectionHeader'] = None,
                 json: Optional['outputs.WebAclResponseInspectionJson'] = None,
                 status_code: Optional['outputs.WebAclResponseInspectionStatusCode'] = None):
        """
        Configures the inspection of login responses
        :param 'WebAclResponseInspectionBodyContains' body_contains: Configures inspection of the response body for success and failure indicators. AWS WAF can inspect the first 65,536 bytes (64 KB) of the response body.
        :param 'WebAclResponseInspectionHeader' header: Configures inspection of the response header for success and failure indicators.
        :param 'WebAclResponseInspectionJson' json: Configures inspection of the response JSON for success and failure indicators. AWS WAF can inspect the first 65,536 bytes (64 KB) of the response JSON.
        :param 'WebAclResponseInspectionStatusCode' status_code: Configures inspection of the response status code for success and failure indicators.
        """
        if body_contains is not None:
            pulumi.set(__self__, "body_contains", body_contains)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if json is not None:
            pulumi.set(__self__, "json", json)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="bodyContains")
    def body_contains(self) -> Optional['outputs.WebAclResponseInspectionBodyContains']:
        """
        Configures inspection of the response body for success and failure indicators. AWS WAF can inspect the first 65,536 bytes (64 KB) of the response body.
        """
        return pulumi.get(self, "body_contains")

    @property
    @pulumi.getter
    def header(self) -> Optional['outputs.WebAclResponseInspectionHeader']:
        """
        Configures inspection of the response header for success and failure indicators.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def json(self) -> Optional['outputs.WebAclResponseInspectionJson']:
        """
        Configures inspection of the response JSON for success and failure indicators. AWS WAF can inspect the first 65,536 bytes (64 KB) of the response JSON.
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional['outputs.WebAclResponseInspectionStatusCode']:
        """
        Configures inspection of the response status code for success and failure indicators.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class WebAclResponseInspectionBodyContains(dict):
    """
    Response body contents that indicate success or failure of a login request
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureStrings":
            suggest = "failure_strings"
        elif key == "successStrings":
            suggest = "success_strings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclResponseInspectionBodyContains. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclResponseInspectionBodyContains.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclResponseInspectionBodyContains.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_strings: Sequence[builtins.str],
                 success_strings: Sequence[builtins.str]):
        """
        Response body contents that indicate success or failure of a login request
        :param Sequence[builtins.str] failure_strings: Strings in the body of the response that indicate a failed login or account creation attempt. To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
               
               JSON example: `"FailureStrings": [ "Request failed" ]`
        :param Sequence[builtins.str] success_strings: Strings in the body of the response that indicate a successful login or account creation attempt. To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
               
               JSON examples: `"SuccessStrings": [ "Login successful" ]` and `"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]`
        """
        pulumi.set(__self__, "failure_strings", failure_strings)
        pulumi.set(__self__, "success_strings", success_strings)

    @property
    @pulumi.getter(name="failureStrings")
    def failure_strings(self) -> Sequence[builtins.str]:
        """
        Strings in the body of the response that indicate a failed login or account creation attempt. To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.

        JSON example: `"FailureStrings": [ "Request failed" ]`
        """
        return pulumi.get(self, "failure_strings")

    @property
    @pulumi.getter(name="successStrings")
    def success_strings(self) -> Sequence[builtins.str]:
        """
        Strings in the body of the response that indicate a successful login or account creation attempt. To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.

        JSON examples: `"SuccessStrings": [ "Login successful" ]` and `"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]`
        """
        return pulumi.get(self, "success_strings")


@pulumi.output_type
class WebAclResponseInspectionHeader(dict):
    """
    Response headers that indicate success or failure of a login request
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureValues":
            suggest = "failure_values"
        elif key == "successValues":
            suggest = "success_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclResponseInspectionHeader. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclResponseInspectionHeader.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclResponseInspectionHeader.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_values: Sequence[builtins.str],
                 name: builtins.str,
                 success_values: Sequence[builtins.str]):
        """
        Response headers that indicate success or failure of a login request
        :param Sequence[builtins.str] failure_values: Values in the response header with the specified name that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.
               
               JSON examples: `"FailureValues": [ "LoginFailed", "Failed login" ]` and `"FailureValues": [ "AccountCreationFailed" ]`
        :param builtins.str name: The name of the header to match against. The name must be an exact match, including case.
               
               JSON example: `"Name": [ "RequestResult" ]`
        :param Sequence[builtins.str] success_values: Values in the response header with the specified name that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.
               
               JSON examples: `"SuccessValues": [ "LoginPassed", "Successful login" ]` and `"SuccessValues": [ "AccountCreated", "Successful account creation" ]`
        """
        pulumi.set(__self__, "failure_values", failure_values)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "success_values", success_values)

    @property
    @pulumi.getter(name="failureValues")
    def failure_values(self) -> Sequence[builtins.str]:
        """
        Values in the response header with the specified name that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.

        JSON examples: `"FailureValues": [ "LoginFailed", "Failed login" ]` and `"FailureValues": [ "AccountCreationFailed" ]`
        """
        return pulumi.get(self, "failure_values")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the header to match against. The name must be an exact match, including case.

        JSON example: `"Name": [ "RequestResult" ]`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="successValues")
    def success_values(self) -> Sequence[builtins.str]:
        """
        Values in the response header with the specified name that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.

        JSON examples: `"SuccessValues": [ "LoginPassed", "Successful login" ]` and `"SuccessValues": [ "AccountCreated", "Successful account creation" ]`
        """
        return pulumi.get(self, "success_values")


@pulumi.output_type
class WebAclResponseInspectionJson(dict):
    """
    Response JSON that indicate success or failure of a login request
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureValues":
            suggest = "failure_values"
        elif key == "successValues":
            suggest = "success_values"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclResponseInspectionJson. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclResponseInspectionJson.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclResponseInspectionJson.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_values: Sequence[builtins.str],
                 identifier: builtins.str,
                 success_values: Sequence[builtins.str]):
        """
        Response JSON that indicate success or failure of a login request
        :param Sequence[builtins.str] failure_values: Values for the specified identifier in the response JSON that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.
               
               JSON example: `"FailureValues": [ "False", "Failed" ]`
        :param builtins.str identifier: The identifier for the value to match against in the JSON. The identifier must be an exact match, including case.
               
               JSON examples: `"Identifier": [ "/login/success" ]` and `"Identifier": [ "/sign-up/success" ]`
        :param Sequence[builtins.str] success_values: Values for the specified identifier in the response JSON that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.
               
               JSON example: `"SuccessValues": [ "True", "Succeeded" ]`
        """
        pulumi.set(__self__, "failure_values", failure_values)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "success_values", success_values)

    @property
    @pulumi.getter(name="failureValues")
    def failure_values(self) -> Sequence[builtins.str]:
        """
        Values for the specified identifier in the response JSON that indicate a failed login or account creation attempt. To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.

        JSON example: `"FailureValues": [ "False", "Failed" ]`
        """
        return pulumi.get(self, "failure_values")

    @property
    @pulumi.getter
    def identifier(self) -> builtins.str:
        """
        The identifier for the value to match against in the JSON. The identifier must be an exact match, including case.

        JSON examples: `"Identifier": [ "/login/success" ]` and `"Identifier": [ "/sign-up/success" ]`
        """
        return pulumi.get(self, "identifier")

    @property
    @pulumi.getter(name="successValues")
    def success_values(self) -> Sequence[builtins.str]:
        """
        Values for the specified identifier in the response JSON that indicate a successful login or account creation attempt. To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.

        JSON example: `"SuccessValues": [ "True", "Succeeded" ]`
        """
        return pulumi.get(self, "success_values")


@pulumi.output_type
class WebAclResponseInspectionStatusCode(dict):
    """
    Response status codes that indicate success or failure of a login request
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureCodes":
            suggest = "failure_codes"
        elif key == "successCodes":
            suggest = "success_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclResponseInspectionStatusCode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclResponseInspectionStatusCode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclResponseInspectionStatusCode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_codes: Sequence[builtins.int],
                 success_codes: Sequence[builtins.int]):
        """
        Response status codes that indicate success or failure of a login request
        :param Sequence[builtins.int] failure_codes: Status codes in the response that indicate a failed login or account creation attempt. To be counted as a failure, the response status code must match one of these. Each code must be unique among the success and failure status codes.
               
               JSON example: `"FailureCodes": [ 400, 404 ]`
        :param Sequence[builtins.int] success_codes: Status codes in the response that indicate a successful login or account creation attempt. To be counted as a success, the response status code must match one of these. Each code must be unique among the success and failure status codes.
               
               JSON example: `"SuccessCodes": [ 200, 201 ]`
        """
        pulumi.set(__self__, "failure_codes", failure_codes)
        pulumi.set(__self__, "success_codes", success_codes)

    @property
    @pulumi.getter(name="failureCodes")
    def failure_codes(self) -> Sequence[builtins.int]:
        """
        Status codes in the response that indicate a failed login or account creation attempt. To be counted as a failure, the response status code must match one of these. Each code must be unique among the success and failure status codes.

        JSON example: `"FailureCodes": [ 400, 404 ]`
        """
        return pulumi.get(self, "failure_codes")

    @property
    @pulumi.getter(name="successCodes")
    def success_codes(self) -> Sequence[builtins.int]:
        """
        Status codes in the response that indicate a successful login or account creation attempt. To be counted as a success, the response status code must match one of these. Each code must be unique among the success and failure status codes.

        JSON example: `"SuccessCodes": [ 200, 201 ]`
        """
        return pulumi.get(self, "success_codes")


@pulumi.output_type
class WebAclRule(dict):
    """
    Rule of WebACL that contains condition and action.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "visibilityConfig":
            suggest = "visibility_config"
        elif key == "captchaConfig":
            suggest = "captcha_config"
        elif key == "challengeConfig":
            suggest = "challenge_config"
        elif key == "overrideAction":
            suggest = "override_action"
        elif key == "ruleLabels":
            suggest = "rule_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: builtins.str,
                 priority: builtins.int,
                 statement: 'outputs.WebAclStatement',
                 visibility_config: 'outputs.WebAclVisibilityConfig',
                 action: Optional['outputs.WebAclRuleAction'] = None,
                 captcha_config: Optional['outputs.WebAclCaptchaConfig'] = None,
                 challenge_config: Optional['outputs.WebAclChallengeConfig'] = None,
                 override_action: Optional['outputs.WebAclOverrideAction'] = None,
                 rule_labels: Optional[Sequence['outputs.WebAclLabel']] = None):
        """
        Rule of WebACL that contains condition and action.
        :param builtins.str name: The name of the rule.
               
               If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's `VisibilityConfig` settings. AWS WAF doesn't automatically update the metric name when you update the rule name.
        :param builtins.int priority: If you define more than one `Rule` in a `WebACL` , AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
        :param 'WebAclStatement' statement: The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` .
        :param 'WebAclVisibilityConfig' visibility_config: Defines and enables Amazon CloudWatch metrics and web request sample collection.
               
               If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. AWS WAF doesn't automatically update the metric name.
        :param 'WebAclRuleAction' action: The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the web ACL level can override the rule action setting.
               
               This is used only for rules whose statements don't reference a rule group. Rule statements that reference a rule group are `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement` .
               
               You must set either this `Action` setting or the rule's `OverrideAction` , but not both:
               
               - If the rule statement doesn't reference a rule group, you must set this rule action setting and you must not set the rule's override action setting.
               - If the rule statement references a rule group, you must not set this action setting, because the actions are already set on the rules inside the rule group. You must set the rule's override action setting to indicate specifically whether to override the actions that are set on the rules in the rule group.
        :param 'WebAclCaptchaConfig' captcha_config: Specifies how AWS WAF should handle `CAPTCHA` evaluations. If you don't specify this, AWS WAF uses the `CAPTCHA` configuration that's defined for the web ACL.
        :param 'WebAclChallengeConfig' challenge_config: Specifies how AWS WAF should handle `Challenge` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
        :param 'WebAclOverrideAction' override_action: The override action to apply to the rules in a rule group, instead of the individual rule action settings. This is used only for rules whose statements reference a rule group. Rule statements that reference a rule group are `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement` .
               
               Set the override action to none to leave the rule group rule actions in effect. Set it to count to only count matches, regardless of the rule action settings.
               
               You must set either this `OverrideAction` setting or the `Action` setting, but not both:
               
               - If the rule statement references a rule group, you must set this override action setting and you must not set the rule's action setting.
               - If the rule statement doesn't reference a rule group, you must set the rule action setting and you must not set the rule's override action setting.
        :param Sequence['WebAclLabel'] rule_labels: Collection of Rule Labels.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "visibility_config", visibility_config)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if captcha_config is not None:
            pulumi.set(__self__, "captcha_config", captcha_config)
        if challenge_config is not None:
            pulumi.set(__self__, "challenge_config", challenge_config)
        if override_action is not None:
            pulumi.set(__self__, "override_action", override_action)
        if rule_labels is not None:
            pulumi.set(__self__, "rule_labels", rule_labels)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule.

        If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name in the rule's `VisibilityConfig` settings. AWS WAF doesn't automatically update the metric name when you update the rule name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        If you define more than one `Rule` in a `WebACL` , AWS WAF evaluates each request against the `Rules` in order based on the value of `Priority` . AWS WAF processes rules with lower priority first. The priorities don't need to be consecutive, but they must all be different.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def statement(self) -> 'outputs.WebAclStatement':
        """
        The AWS WAF processing statement for the rule, for example `ByteMatchStatement` or `SizeConstraintStatement` .
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter(name="visibilityConfig")
    def visibility_config(self) -> 'outputs.WebAclVisibilityConfig':
        """
        Defines and enables Amazon CloudWatch metrics and web request sample collection.

        If you change the name of a `Rule` after you create it and you want the rule's metric name to reflect the change, update the metric name as well. AWS WAF doesn't automatically update the metric name.
        """
        return pulumi.get(self, "visibility_config")

    @property
    @pulumi.getter
    def action(self) -> Optional['outputs.WebAclRuleAction']:
        """
        The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the web ACL level can override the rule action setting.

        This is used only for rules whose statements don't reference a rule group. Rule statements that reference a rule group are `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement` .

        You must set either this `Action` setting or the rule's `OverrideAction` , but not both:

        - If the rule statement doesn't reference a rule group, you must set this rule action setting and you must not set the rule's override action setting.
        - If the rule statement references a rule group, you must not set this action setting, because the actions are already set on the rules inside the rule group. You must set the rule's override action setting to indicate specifically whether to override the actions that are set on the rules in the rule group.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="captchaConfig")
    def captcha_config(self) -> Optional['outputs.WebAclCaptchaConfig']:
        """
        Specifies how AWS WAF should handle `CAPTCHA` evaluations. If you don't specify this, AWS WAF uses the `CAPTCHA` configuration that's defined for the web ACL.
        """
        return pulumi.get(self, "captcha_config")

    @property
    @pulumi.getter(name="challengeConfig")
    def challenge_config(self) -> Optional['outputs.WebAclChallengeConfig']:
        """
        Specifies how AWS WAF should handle `Challenge` evaluations. If you don't specify this, AWS WAF uses the challenge configuration that's defined for the web ACL.
        """
        return pulumi.get(self, "challenge_config")

    @property
    @pulumi.getter(name="overrideAction")
    def override_action(self) -> Optional['outputs.WebAclOverrideAction']:
        """
        The override action to apply to the rules in a rule group, instead of the individual rule action settings. This is used only for rules whose statements reference a rule group. Rule statements that reference a rule group are `RuleGroupReferenceStatement` and `ManagedRuleGroupStatement` .

        Set the override action to none to leave the rule group rule actions in effect. Set it to count to only count matches, regardless of the rule action settings.

        You must set either this `OverrideAction` setting or the `Action` setting, but not both:

        - If the rule statement references a rule group, you must set this override action setting and you must not set the rule's action setting.
        - If the rule statement doesn't reference a rule group, you must set the rule action setting and you must not set the rule's override action setting.
        """
        return pulumi.get(self, "override_action")

    @property
    @pulumi.getter(name="ruleLabels")
    def rule_labels(self) -> Optional[Sequence['outputs.WebAclLabel']]:
        """
        Collection of Rule Labels.
        """
        return pulumi.get(self, "rule_labels")


@pulumi.output_type
class WebAclRuleAction(dict):
    """
    Action taken when Rule matches its condition.
    """
    def __init__(__self__, *,
                 allow: Optional['outputs.WebAclAllowAction'] = None,
                 block: Optional['outputs.WebAclBlockAction'] = None,
                 captcha: Optional['outputs.WebAclCaptchaAction'] = None,
                 challenge: Optional['outputs.WebAclChallengeAction'] = None,
                 count: Optional['outputs.WebAclCountAction'] = None):
        """
        Action taken when Rule matches its condition.
        :param 'WebAclAllowAction' allow: Instructs AWS WAF to allow the web request.
        :param 'WebAclBlockAction' block: Instructs AWS WAF to block the web request.
        :param 'WebAclCaptchaAction' captcha: Specifies that AWS WAF should run a `CAPTCHA` check against the request:
               
               - If the request includes a valid, unexpired `CAPTCHA` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a `CountAction` .
               - If the request doesn't include a valid, unexpired `CAPTCHA` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.
               
               AWS WAF generates a response that it sends back to the client, which includes the following:
               
               - The header `x-amzn-waf-action` with a value of `captcha` .
               - The HTTP status code `405 Method Not Allowed` .
               - If the request contains an `Accept` header with a value of `text/html` , the response includes a `CAPTCHA` challenge.
               
               You can configure the expiration time in the `CaptchaConfig` `ImmunityTimeProperty` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
               
               This action option is available for rules. It isn't available for web ACL default actions.
        :param 'WebAclChallengeAction' challenge: Instructs AWS WAF to run a `Challenge` check against the web request.
        :param 'WebAclCountAction' count: Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.
        """
        if allow is not None:
            pulumi.set(__self__, "allow", allow)
        if block is not None:
            pulumi.set(__self__, "block", block)
        if captcha is not None:
            pulumi.set(__self__, "captcha", captcha)
        if challenge is not None:
            pulumi.set(__self__, "challenge", challenge)
        if count is not None:
            pulumi.set(__self__, "count", count)

    @property
    @pulumi.getter
    def allow(self) -> Optional['outputs.WebAclAllowAction']:
        """
        Instructs AWS WAF to allow the web request.
        """
        return pulumi.get(self, "allow")

    @property
    @pulumi.getter
    def block(self) -> Optional['outputs.WebAclBlockAction']:
        """
        Instructs AWS WAF to block the web request.
        """
        return pulumi.get(self, "block")

    @property
    @pulumi.getter
    def captcha(self) -> Optional['outputs.WebAclCaptchaAction']:
        """
        Specifies that AWS WAF should run a `CAPTCHA` check against the request:

        - If the request includes a valid, unexpired `CAPTCHA` token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a `CountAction` .
        - If the request doesn't include a valid, unexpired `CAPTCHA` token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.

        AWS WAF generates a response that it sends back to the client, which includes the following:

        - The header `x-amzn-waf-action` with a value of `captcha` .
        - The HTTP status code `405 Method Not Allowed` .
        - If the request contains an `Accept` header with a value of `text/html` , the response includes a `CAPTCHA` challenge.

        You can configure the expiration time in the `CaptchaConfig` `ImmunityTimeProperty` setting at the rule and web ACL level. The rule setting overrides the web ACL setting.

        This action option is available for rules. It isn't available for web ACL default actions.
        """
        return pulumi.get(self, "captcha")

    @property
    @pulumi.getter
    def challenge(self) -> Optional['outputs.WebAclChallengeAction']:
        """
        Instructs AWS WAF to run a `Challenge` check against the web request.
        """
        return pulumi.get(self, "challenge")

    @property
    @pulumi.getter
    def count(self) -> Optional['outputs.WebAclCountAction']:
        """
        Instructs AWS WAF to count the web request and then continue evaluating the request using the remaining rules in the web ACL.
        """
        return pulumi.get(self, "count")


@pulumi.output_type
class WebAclRuleActionOverride(dict):
    """
    Action override for rules in the rule group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionToUse":
            suggest = "action_to_use"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRuleActionOverride. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRuleActionOverride.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRuleActionOverride.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_to_use: 'outputs.WebAclRuleAction',
                 name: builtins.str):
        """
        Action override for rules in the rule group.
        :param 'WebAclRuleAction' action_to_use: The override action to use, in place of the configured action of the rule in the rule group.
        :param builtins.str name: The name of the rule to override.
        """
        pulumi.set(__self__, "action_to_use", action_to_use)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="actionToUse")
    def action_to_use(self) -> 'outputs.WebAclRuleAction':
        """
        The override action to use, in place of the configured action of the rule in the rule group.
        """
        return pulumi.get(self, "action_to_use")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the rule to override.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WebAclRuleGroupReferenceStatement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludedRules":
            suggest = "excluded_rules"
        elif key == "ruleActionOverrides":
            suggest = "rule_action_overrides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclRuleGroupReferenceStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclRuleGroupReferenceStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclRuleGroupReferenceStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn: builtins.str,
                 excluded_rules: Optional[Sequence['outputs.WebAclExcludedRule']] = None,
                 rule_action_overrides: Optional[Sequence['outputs.WebAclRuleActionOverride']] = None):
        """
        :param builtins.str arn: The Amazon Resource Name (ARN) of the entity.
        :param Sequence['WebAclExcludedRule'] excluded_rules: Rules in the referenced rule group whose actions are set to `Count` .
               
               > Instead of this option, use `RuleActionOverrides` . It accepts any valid action setting, including `Count` .
        :param Sequence['WebAclRuleActionOverride'] rule_action_overrides: Action overrides for rules in the rule group.
        """
        pulumi.set(__self__, "arn", arn)
        if excluded_rules is not None:
            pulumi.set(__self__, "excluded_rules", excluded_rules)
        if rule_action_overrides is not None:
            pulumi.set(__self__, "rule_action_overrides", rule_action_overrides)

    @property
    @pulumi.getter
    def arn(self) -> builtins.str:
        """
        The Amazon Resource Name (ARN) of the entity.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="excludedRules")
    def excluded_rules(self) -> Optional[Sequence['outputs.WebAclExcludedRule']]:
        """
        Rules in the referenced rule group whose actions are set to `Count` .

        > Instead of this option, use `RuleActionOverrides` . It accepts any valid action setting, including `Count` .
        """
        return pulumi.get(self, "excluded_rules")

    @property
    @pulumi.getter(name="ruleActionOverrides")
    def rule_action_overrides(self) -> Optional[Sequence['outputs.WebAclRuleActionOverride']]:
        """
        Action overrides for rules in the rule group.
        """
        return pulumi.get(self, "rule_action_overrides")


@pulumi.output_type
class WebAclSizeConstraintStatement(dict):
    """
    Size Constraint statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "comparisonOperator":
            suggest = "comparison_operator"
        elif key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclSizeConstraintStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclSizeConstraintStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclSizeConstraintStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 comparison_operator: 'WebAclSizeConstraintStatementComparisonOperator',
                 field_to_match: 'outputs.WebAclFieldToMatch',
                 size: builtins.float,
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Size Constraint statement.
        :param 'WebAclSizeConstraintStatementComparisonOperator' comparison_operator: The operator to use to compare the request part to the size setting.
        :param 'WebAclFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param builtins.float size: The size, in byte, to compare to the request part, after any transformations.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> 'WebAclSizeConstraintStatementComparisonOperator':
        """
        The operator to use to compare the request part to the size setting.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.WebAclFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter
    def size(self) -> builtins.float:
        """
        The size, in byte, to compare to the request part, after any transformations.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


@pulumi.output_type
class WebAclSqliMatchStatement(dict):
    """
    Sqli Match Statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"
        elif key == "sensitivityLevel":
            suggest = "sensitivity_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclSqliMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclSqliMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclSqliMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.WebAclFieldToMatch',
                 text_transformations: Sequence['outputs.WebAclTextTransformation'],
                 sensitivity_level: Optional['WebAclSensitivityLevel'] = None):
        """
        Sqli Match Statement.
        :param 'WebAclFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        :param 'WebAclSensitivityLevel' sensitivity_level: The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.
               
               `HIGH` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see [Testing and tuning](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html) in the *AWS WAF Developer Guide* .
               
               `LOW` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.
               
               Default: `LOW`
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformations", text_transformations)
        if sensitivity_level is not None:
            pulumi.set(__self__, "sensitivity_level", sensitivity_level)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.WebAclFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")

    @property
    @pulumi.getter(name="sensitivityLevel")
    def sensitivity_level(self) -> Optional['WebAclSensitivityLevel']:
        """
        The sensitivity that you want AWS WAF to use to inspect for SQL injection attacks.

        `HIGH` detects more attacks, but might generate more false positives, especially if your web requests frequently contain unusual strings. For information about identifying and mitigating false positives, see [Testing and tuning](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-testing.html) in the *AWS WAF Developer Guide* .

        `LOW` is generally a better choice for resources that already have other protections against SQL injection attacks or that have a low tolerance for false positives.

        Default: `LOW`
        """
        return pulumi.get(self, "sensitivity_level")


@pulumi.output_type
class WebAclStatement(dict):
    """
    First level statement that contains conditions, such as ByteMatch, SizeConstraint, etc
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "andStatement":
            suggest = "and_statement"
        elif key == "byteMatchStatement":
            suggest = "byte_match_statement"
        elif key == "geoMatchStatement":
            suggest = "geo_match_statement"
        elif key == "ipSetReferenceStatement":
            suggest = "ip_set_reference_statement"
        elif key == "labelMatchStatement":
            suggest = "label_match_statement"
        elif key == "managedRuleGroupStatement":
            suggest = "managed_rule_group_statement"
        elif key == "notStatement":
            suggest = "not_statement"
        elif key == "orStatement":
            suggest = "or_statement"
        elif key == "rateBasedStatement":
            suggest = "rate_based_statement"
        elif key == "regexMatchStatement":
            suggest = "regex_match_statement"
        elif key == "regexPatternSetReferenceStatement":
            suggest = "regex_pattern_set_reference_statement"
        elif key == "ruleGroupReferenceStatement":
            suggest = "rule_group_reference_statement"
        elif key == "sizeConstraintStatement":
            suggest = "size_constraint_statement"
        elif key == "sqliMatchStatement":
            suggest = "sqli_match_statement"
        elif key == "xssMatchStatement":
            suggest = "xss_match_statement"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 and_statement: Optional['outputs.WebAclAndStatement'] = None,
                 byte_match_statement: Optional['outputs.WebAclByteMatchStatement'] = None,
                 geo_match_statement: Optional['outputs.WebAclGeoMatchStatement'] = None,
                 ip_set_reference_statement: Optional['outputs.WebAclIpSetReferenceStatement'] = None,
                 label_match_statement: Optional['outputs.WebAclLabelMatchStatement'] = None,
                 managed_rule_group_statement: Optional['outputs.WebAclManagedRuleGroupStatement'] = None,
                 not_statement: Optional['outputs.WebAclNotStatement'] = None,
                 or_statement: Optional['outputs.WebAclOrStatement'] = None,
                 rate_based_statement: Optional['outputs.WebAclRateBasedStatement'] = None,
                 regex_match_statement: Optional['outputs.WebAclRegexMatchStatement'] = None,
                 regex_pattern_set_reference_statement: Optional['outputs.WebAclRegexPatternSetReferenceStatement'] = None,
                 rule_group_reference_statement: Optional['outputs.WebAclRuleGroupReferenceStatement'] = None,
                 size_constraint_statement: Optional['outputs.WebAclSizeConstraintStatement'] = None,
                 sqli_match_statement: Optional['outputs.WebAclSqliMatchStatement'] = None,
                 xss_match_statement: Optional['outputs.WebAclXssMatchStatement'] = None):
        """
        First level statement that contains conditions, such as ByteMatch, SizeConstraint, etc
        :param 'WebAclAndStatement' and_statement: A logical rule statement used to combine other rule statements with AND logic. You provide more than one `Statement` within the `AndStatement` .
        :param 'WebAclByteMatchStatement' byte_match_statement: A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
        :param 'WebAclGeoMatchStatement' geo_match_statement: A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.
               
               - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
               - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.
               
               AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig` .
               
               If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>` .
               
               If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>` .
               
               For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) .
        :param 'WebAclIpSetReferenceStatement' ip_set_reference_statement: A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an `IPSet` that specifies the addresses you want to detect, then use the ARN of that set in this statement.
               
               Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        :param 'WebAclLabelMatchStatement' label_match_statement: A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.
               
               The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
        :param 'WebAclManagedRuleGroupStatement' managed_rule_group_statement: A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names through the API call `ListAvailableManagedRuleGroups` .
               
               You cannot nest a `ManagedRuleGroupStatement` , for example for use inside a `NotStatement` or `OrStatement` . It can only be referenced as a top-level statement within a rule.
               
               > You are charged additional fees when you use the AWS WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet` , the AWS WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet` , or the AWS WAF Fraud Control account creation fraud prevention (ACFP) managed rule group `AWSManagedRulesACFPRuleSet` . For more information, see [AWS WAF Pricing](https://docs.aws.amazon.com/waf/pricing/) .
        :param 'WebAclNotStatement' not_statement: A logical rule statement used to negate the results of another rule statement. You provide one `Statement` within the `NotStatement` .
        :param 'WebAclOrStatement' or_statement: A logical rule statement used to combine other rule statements with OR logic. You provide more than one `Statement` within the `OrStatement` .
        :param 'WebAclRateBasedStatement' rate_based_statement: A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
               
               > If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute. 
               
               You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.
               
               Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.
               
               For example, assume the rule evaluates web requests with the following IP address and HTTP method values:
               
               - IP address 10.1.1.1, HTTP method POST
               - IP address 10.1.1.1, HTTP method GET
               - IP address 127.0.0.0, HTTP method POST
               - IP address 10.1.1.1, HTTP method GET
               
               The rule would create different aggregation instances according to your aggregation criteria, for example:
               
               - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:
               
               - IP address 10.1.1.1: count 3
               - IP address 127.0.0.0: count 1
               - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:
               
               - HTTP method POST: count 2
               - HTTP method GET: count 2
               - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:
               
               - IP address 10.1.1.1, HTTP method POST: count 1
               - IP address 10.1.1.1, HTTP method GET: count 2
               - IP address 127.0.0.0, HTTP method POST: count 1
               
               For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.
               
               You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.
               
               You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement` . You can define a `RateBasedStatement` inside a web ACL and inside a rule group.
               
               For additional information about the options, see [Rate limiting web requests using rate-based rules](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html) in the *AWS WAF Developer Guide* .
               
               If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call `GetRateBasedStatementManagedKeys` . This option is not available for other aggregation configurations.
               
               AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
        :param 'WebAclRegexMatchStatement' regex_match_statement: A rule statement used to search web request components for a match against a single regular expression.
        :param 'WebAclRegexPatternSetReferenceStatement' regex_pattern_set_reference_statement: A rule statement used to search web request components for matches with regular expressions. To use this, create a `RegexPatternSet` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
               
               Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        :param 'WebAclRuleGroupReferenceStatement' rule_group_reference_statement: A rule statement used to run the rules that are defined in a `RuleGroup` . To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.
               
               You cannot nest a `RuleGroupReferenceStatement` , for example for use inside a `NotStatement` or `OrStatement` . You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.
        :param 'WebAclSizeConstraintStatement' size_constraint_statement: A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.
               
               If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see `Body` and `JsonBody` settings for the `FieldToMatch` data type.
               
               If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
        :param 'WebAclSqliMatchStatement' sqli_match_statement: A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
        :param 'WebAclXssMatchStatement' xss_match_statement: A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
        """
        if and_statement is not None:
            pulumi.set(__self__, "and_statement", and_statement)
        if byte_match_statement is not None:
            pulumi.set(__self__, "byte_match_statement", byte_match_statement)
        if geo_match_statement is not None:
            pulumi.set(__self__, "geo_match_statement", geo_match_statement)
        if ip_set_reference_statement is not None:
            pulumi.set(__self__, "ip_set_reference_statement", ip_set_reference_statement)
        if label_match_statement is not None:
            pulumi.set(__self__, "label_match_statement", label_match_statement)
        if managed_rule_group_statement is not None:
            pulumi.set(__self__, "managed_rule_group_statement", managed_rule_group_statement)
        if not_statement is not None:
            pulumi.set(__self__, "not_statement", not_statement)
        if or_statement is not None:
            pulumi.set(__self__, "or_statement", or_statement)
        if rate_based_statement is not None:
            pulumi.set(__self__, "rate_based_statement", rate_based_statement)
        if regex_match_statement is not None:
            pulumi.set(__self__, "regex_match_statement", regex_match_statement)
        if regex_pattern_set_reference_statement is not None:
            pulumi.set(__self__, "regex_pattern_set_reference_statement", regex_pattern_set_reference_statement)
        if rule_group_reference_statement is not None:
            pulumi.set(__self__, "rule_group_reference_statement", rule_group_reference_statement)
        if size_constraint_statement is not None:
            pulumi.set(__self__, "size_constraint_statement", size_constraint_statement)
        if sqli_match_statement is not None:
            pulumi.set(__self__, "sqli_match_statement", sqli_match_statement)
        if xss_match_statement is not None:
            pulumi.set(__self__, "xss_match_statement", xss_match_statement)

    @property
    @pulumi.getter(name="andStatement")
    def and_statement(self) -> Optional['outputs.WebAclAndStatement']:
        """
        A logical rule statement used to combine other rule statements with AND logic. You provide more than one `Statement` within the `AndStatement` .
        """
        return pulumi.get(self, "and_statement")

    @property
    @pulumi.getter(name="byteMatchStatement")
    def byte_match_statement(self) -> Optional['outputs.WebAclByteMatchStatement']:
        """
        A rule statement that defines a string match search for AWS WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
        """
        return pulumi.get(self, "byte_match_statement")

    @property
    @pulumi.getter(name="geoMatchStatement")
    def geo_match_statement(self) -> Optional['outputs.WebAclGeoMatchStatement']:
        """
        A rule statement that labels web requests by country and region and that matches against web requests based on country code. A geo match rule labels every request that it inspects regardless of whether it finds a match.

        - To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the `CountryCodes` array.
        - Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.

        AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match `ForwardedIPConfig` .

        If you use the web request origin, the label formats are `awswaf:clientip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:clientip:geo:country:<ISO country code>` .

        If you use a forwarded IP address, the label formats are `awswaf:forwardedip:geo:region:<ISO country code>-<ISO region code>` and `awswaf:forwardedip:geo:country:<ISO country code>` .

        For additional details, see [Geographic match rule statement](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html) in the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html) .
        """
        return pulumi.get(self, "geo_match_statement")

    @property
    @pulumi.getter(name="ipSetReferenceStatement")
    def ip_set_reference_statement(self) -> Optional['outputs.WebAclIpSetReferenceStatement']:
        """
        A rule statement used to detect web requests coming from particular IP addresses or address ranges. To use this, create an `IPSet` that specifies the addresses you want to detect, then use the ARN of that set in this statement.

        Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        """
        return pulumi.get(self, "ip_set_reference_statement")

    @property
    @pulumi.getter(name="labelMatchStatement")
    def label_match_statement(self) -> Optional['outputs.WebAclLabelMatchStatement']:
        """
        A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.

        The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
        """
        return pulumi.get(self, "label_match_statement")

    @property
    @pulumi.getter(name="managedRuleGroupStatement")
    def managed_rule_group_statement(self) -> Optional['outputs.WebAclManagedRuleGroupStatement']:
        """
        A rule statement used to run the rules that are defined in a managed rule group. To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names through the API call `ListAvailableManagedRuleGroups` .

        You cannot nest a `ManagedRuleGroupStatement` , for example for use inside a `NotStatement` or `OrStatement` . It can only be referenced as a top-level statement within a rule.

        > You are charged additional fees when you use the AWS WAF Bot Control managed rule group `AWSManagedRulesBotControlRuleSet` , the AWS WAF Fraud Control account takeover prevention (ATP) managed rule group `AWSManagedRulesATPRuleSet` , or the AWS WAF Fraud Control account creation fraud prevention (ACFP) managed rule group `AWSManagedRulesACFPRuleSet` . For more information, see [AWS WAF Pricing](https://docs.aws.amazon.com/waf/pricing/) .
        """
        return pulumi.get(self, "managed_rule_group_statement")

    @property
    @pulumi.getter(name="notStatement")
    def not_statement(self) -> Optional['outputs.WebAclNotStatement']:
        """
        A logical rule statement used to negate the results of another rule statement. You provide one `Statement` within the `NotStatement` .
        """
        return pulumi.get(self, "not_statement")

    @property
    @pulumi.getter(name="orStatement")
    def or_statement(self) -> Optional['outputs.WebAclOrStatement']:
        """
        A logical rule statement used to combine other rule statements with OR logic. You provide more than one `Statement` within the `OrStatement` .
        """
        return pulumi.get(self, "or_statement")

    @property
    @pulumi.getter(name="rateBasedStatement")
    def rate_based_statement(self) -> Optional['outputs.WebAclRateBasedStatement']:
        """
        A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate. The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.

        > If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute. 

        You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.

        Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.

        For example, assume the rule evaluates web requests with the following IP address and HTTP method values:

        - IP address 10.1.1.1, HTTP method POST
        - IP address 10.1.1.1, HTTP method GET
        - IP address 127.0.0.0, HTTP method POST
        - IP address 10.1.1.1, HTTP method GET

        The rule would create different aggregation instances according to your aggregation criteria, for example:

        - If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:

        - IP address 10.1.1.1: count 3
        - IP address 127.0.0.0: count 1
        - If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:

        - HTTP method POST: count 2
        - HTTP method GET: count 2
        - If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:

        - IP address 10.1.1.1, HTTP method POST: count 1
        - IP address 10.1.1.1, HTTP method GET: count 2
        - IP address 127.0.0.0, HTTP method POST: count 1

        For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.

        You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.

        You cannot nest a `RateBasedStatement` inside another statement, for example inside a `NotStatement` or `OrStatement` . You can define a `RateBasedStatement` inside a web ACL and inside a rule group.

        For additional information about the options, see [Rate limiting web requests using rate-based rules](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html) in the *AWS WAF Developer Guide* .

        If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call `GetRateBasedStatementManagedKeys` . This option is not available for other aggregation configurations.

        AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
        """
        return pulumi.get(self, "rate_based_statement")

    @property
    @pulumi.getter(name="regexMatchStatement")
    def regex_match_statement(self) -> Optional['outputs.WebAclRegexMatchStatement']:
        """
        A rule statement used to search web request components for a match against a single regular expression.
        """
        return pulumi.get(self, "regex_match_statement")

    @property
    @pulumi.getter(name="regexPatternSetReferenceStatement")
    def regex_pattern_set_reference_statement(self) -> Optional['outputs.WebAclRegexPatternSetReferenceStatement']:
        """
        A rule statement used to search web request components for matches with regular expressions. To use this, create a `RegexPatternSet` that specifies the expressions that you want to detect, then use the ARN of that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.

        Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
        """
        return pulumi.get(self, "regex_pattern_set_reference_statement")

    @property
    @pulumi.getter(name="ruleGroupReferenceStatement")
    def rule_group_reference_statement(self) -> Optional['outputs.WebAclRuleGroupReferenceStatement']:
        """
        A rule statement used to run the rules that are defined in a `RuleGroup` . To use this, create a rule group with your rules, then provide the ARN of the rule group in this statement.

        You cannot nest a `RuleGroupReferenceStatement` , for example for use inside a `NotStatement` or `OrStatement` . You cannot use a rule group reference statement inside another rule group. You can only reference a rule group as a top-level statement within a rule that you define in a web ACL.
        """
        return pulumi.get(self, "rule_group_reference_statement")

    @property
    @pulumi.getter(name="sizeConstraintStatement")
    def size_constraint_statement(self) -> Optional['outputs.WebAclSizeConstraintStatement']:
        """
        A rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). For example, you can use a size constraint statement to look for query strings that are longer than 100 bytes.

        If you configure AWS WAF to inspect the request body, AWS WAF inspects only the number of bytes in the body up to the limit for the web ACL and protected resource type. If you know that the request body for your web requests should never exceed the inspection limit, you can use a size constraint statement to block requests that have a larger request body size. For more information about the inspection limits, see `Body` and `JsonBody` settings for the `FieldToMatch` data type.

        If you choose URI for the value of Part of the request to filter on, the slash (/) in the URI counts as one character. For example, the URI `/logo.jpg` is nine characters long.
        """
        return pulumi.get(self, "size_constraint_statement")

    @property
    @pulumi.getter(name="sqliMatchStatement")
    def sqli_match_statement(self) -> Optional['outputs.WebAclSqliMatchStatement']:
        """
        A rule statement that inspects for malicious SQL code. Attackers insert malicious SQL code into web requests to do things like modify your database or extract data from it.
        """
        return pulumi.get(self, "sqli_match_statement")

    @property
    @pulumi.getter(name="xssMatchStatement")
    def xss_match_statement(self) -> Optional['outputs.WebAclXssMatchStatement']:
        """
        A rule statement that inspects for cross-site scripting (XSS) attacks. In XSS attacks, the attacker uses vulnerabilities in a benign website as a vehicle to inject malicious client-site scripts into other legitimate web browsers.
        """
        return pulumi.get(self, "xss_match_statement")


@pulumi.output_type
class WebAclTextTransformation(dict):
    """
    Text Transformation on the Search String before match.
    """
    def __init__(__self__, *,
                 priority: builtins.int,
                 type: 'WebAclTextTransformationType'):
        """
        Text Transformation on the Search String before match.
        :param builtins.int priority: Sets the relative processing order for multiple transformations. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
        :param 'WebAclTextTransformationType' type: For detailed descriptions of each of the transformation types, see [Text transformations](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html) in the *AWS WAF Developer Guide* .
        """
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def priority(self) -> builtins.int:
        """
        Sets the relative processing order for multiple transformations. AWS WAF processes all transformations, from lowest priority to highest, before inspecting the transformed content. The priorities don't need to be consecutive, but they must all be different.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def type(self) -> 'WebAclTextTransformationType':
        """
        For detailed descriptions of each of the transformation types, see [Text transformations](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-transformation.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WebAclUriFragment(dict):
    """
    The path component of the URI Fragment. This is the part of a web request that identifies a fragment uri, for example, /abcd#introduction
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fallbackBehavior":
            suggest = "fallback_behavior"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclUriFragment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclUriFragment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclUriFragment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fallback_behavior: Optional['WebAclUriFragmentFallbackBehavior'] = None):
        """
        The path component of the URI Fragment. This is the part of a web request that identifies a fragment uri, for example, /abcd#introduction
        :param 'WebAclUriFragmentFallbackBehavior' fallback_behavior: What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:
               
               - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
               - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
               - `NO_MATCH` - Treat the web request as not matching the rule statement.
               
               If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
               
               Example JSON: `{ "UriFragment": { "FallbackBehavior": "MATCH"} }`
               
               > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        """
        if fallback_behavior is not None:
            pulumi.set(__self__, "fallback_behavior", fallback_behavior)

    @property
    @pulumi.getter(name="fallbackBehavior")
    def fallback_behavior(self) -> Optional['WebAclUriFragmentFallbackBehavior']:
        """
        What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:

        - `EVALUATE_AS_STRING` - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.
        - `MATCH` - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.
        - `NO_MATCH` - Treat the web request as not matching the rule statement.

        If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.

        Example JSON: `{ "UriFragment": { "FallbackBehavior": "MATCH"} }`

        > AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see [JSON body](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "fallback_behavior")


@pulumi.output_type
class WebAclVisibilityConfig(dict):
    """
    Visibility Metric of the WebACL.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudWatchMetricsEnabled":
            suggest = "cloud_watch_metrics_enabled"
        elif key == "metricName":
            suggest = "metric_name"
        elif key == "sampledRequestsEnabled":
            suggest = "sampled_requests_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclVisibilityConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclVisibilityConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclVisibilityConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_watch_metrics_enabled: builtins.bool,
                 metric_name: builtins.str,
                 sampled_requests_enabled: builtins.bool):
        """
        Visibility Metric of the WebACL.
        :param builtins.bool cloud_watch_metrics_enabled: Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics) in the *AWS WAF Developer Guide* .
               
               For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information,
               see [The web ACL default action](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html) in the *AWS WAF Developer Guide* .
        :param builtins.str metric_name: A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example `All` and `Default_Action` .
        :param builtins.bool sampled_requests_enabled: Indicates whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
               
               If you configure data protection for the web ACL, the protection applies to the web ACL's sampled web request data.
               
               > Request sampling doesn't provide a field redaction option, and any field redaction that you specify in your logging configuration doesn't affect sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.
        """
        pulumi.set(__self__, "cloud_watch_metrics_enabled", cloud_watch_metrics_enabled)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "sampled_requests_enabled", sampled_requests_enabled)

    @property
    @pulumi.getter(name="cloudWatchMetricsEnabled")
    def cloud_watch_metrics_enabled(self) -> builtins.bool:
        """
        Indicates whether the associated resource sends metrics to Amazon CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics) in the *AWS WAF Developer Guide* .

        For web ACLs, the metrics are for web requests that have the web ACL default action applied. AWS WAF applies the default action to web requests that pass the inspection of all rules in the web ACL without being either allowed or blocked. For more information,
        see [The web ACL default action](https://docs.aws.amazon.com/waf/latest/developerguide/web-acl-default-action.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "cloud_watch_metrics_enabled")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> builtins.str:
        """
        A name of the Amazon CloudWatch metric dimension. The name can contain only the characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from one to 128 characters long. It can't contain whitespace or metric names that are reserved for AWS WAF , for example `All` and `Default_Action` .
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="sampledRequestsEnabled")
    def sampled_requests_enabled(self) -> builtins.bool:
        """
        Indicates whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.

        If you configure data protection for the web ACL, the protection applies to the web ACL's sampled web request data.

        > Request sampling doesn't provide a field redaction option, and any field redaction that you specify in your logging configuration doesn't affect sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.
        """
        return pulumi.get(self, "sampled_requests_enabled")


@pulumi.output_type
class WebAclXssMatchStatement(dict):
    """
    Xss Match Statement.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldToMatch":
            suggest = "field_to_match"
        elif key == "textTransformations":
            suggest = "text_transformations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAclXssMatchStatement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAclXssMatchStatement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAclXssMatchStatement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_to_match: 'outputs.WebAclFieldToMatch',
                 text_transformations: Sequence['outputs.WebAclTextTransformation']):
        """
        Xss Match Statement.
        :param 'WebAclFieldToMatch' field_to_match: The part of the web request that you want AWS WAF to inspect.
        :param Sequence['WebAclTextTransformation'] text_transformations: Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        pulumi.set(__self__, "field_to_match", field_to_match)
        pulumi.set(__self__, "text_transformations", text_transformations)

    @property
    @pulumi.getter(name="fieldToMatch")
    def field_to_match(self) -> 'outputs.WebAclFieldToMatch':
        """
        The part of the web request that you want AWS WAF to inspect.
        """
        return pulumi.get(self, "field_to_match")

    @property
    @pulumi.getter(name="textTransformations")
    def text_transformations(self) -> Sequence['outputs.WebAclTextTransformation']:
        """
        Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by `FieldToMatch` , starting from the lowest priority setting, before inspecting the content for a match.
        """
        return pulumi.get(self, "text_transformations")


