# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetRuleGroupResult',
    'AwaitableGetRuleGroupResult',
    'get_rule_group',
    'get_rule_group_output',
]

@pulumi.output_type
class GetRuleGroupResult:
    def __init__(__self__, arn=None, available_labels=None, capacity=None, consumed_labels=None, custom_response_bodies=None, description=None, id=None, label_namespace=None, rules=None, tags=None, visibility_config=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if available_labels and not isinstance(available_labels, list):
            raise TypeError("Expected argument 'available_labels' to be a list")
        pulumi.set(__self__, "available_labels", available_labels)
        if capacity and not isinstance(capacity, int):
            raise TypeError("Expected argument 'capacity' to be a int")
        pulumi.set(__self__, "capacity", capacity)
        if consumed_labels and not isinstance(consumed_labels, list):
            raise TypeError("Expected argument 'consumed_labels' to be a list")
        pulumi.set(__self__, "consumed_labels", consumed_labels)
        if custom_response_bodies and not isinstance(custom_response_bodies, dict):
            raise TypeError("Expected argument 'custom_response_bodies' to be a dict")
        pulumi.set(__self__, "custom_response_bodies", custom_response_bodies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if label_namespace and not isinstance(label_namespace, str):
            raise TypeError("Expected argument 'label_namespace' to be a str")
        pulumi.set(__self__, "label_namespace", label_namespace)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if visibility_config and not isinstance(visibility_config, dict):
            raise TypeError("Expected argument 'visibility_config' to be a dict")
        pulumi.set(__self__, "visibility_config", visibility_config)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the rule group.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="availableLabels")
    def available_labels(self) -> Optional[Sequence['outputs.RuleGroupLabelSummary']]:
        """
        Collection of Available Labels.
        """
        return pulumi.get(self, "available_labels")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[builtins.int]:
        """
        The web ACL capacity units (WCUs) required for this rule group.

        When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, AWS WAF enforces this limit.

        AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="consumedLabels")
    def consumed_labels(self) -> Optional[Sequence['outputs.RuleGroupLabelSummary']]:
        """
        Collection of Consumed Labels.
        """
        return pulumi.get(self, "consumed_labels")

    @property
    @pulumi.getter(name="customResponseBodies")
    def custom_response_bodies(self) -> Optional[Mapping[str, 'outputs.RuleGroupCustomResponseBody']]:
        """
        A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.

        For information about customizing web requests and responses, see [Customizing web requests and responses in AWS WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the *AWS WAF Developer Guide* .

        For information about the limits on count and size for custom request and response settings, see [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the *AWS WAF Developer Guide* .
        """
        return pulumi.get(self, "custom_response_bodies")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        A description of the rule group that helps with identification.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the rule group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="labelNamespace")
    def label_namespace(self) -> Optional[builtins.str]:
        """
        The label namespace prefix for this rule group. All labels added by rules in this rule group have this prefix.

        The syntax for the label namespace prefix for a rule group is the following: `awswaf:<account ID>:rule group:<rule group name>:`

        When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.
        """
        return pulumi.get(self, "label_namespace")

    @property
    @pulumi.getter
    def rules(self) -> Optional[Sequence['outputs.RuleGroupRule']]:
        """
        Collection of Rules.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key:value pairs associated with an AWS resource. The key:value pair can be anything you define. Typically, the tag key represents a category (such as "environment") and the tag value represents a specific value within that category (such as "test," "development," or "production"). You can add up to 50 tags to each AWS resource.

        > To modify tags on existing resources, use the AWS WAF APIs or command line interface. With AWS CloudFormation , you can only add tags to AWS WAF resources during resource creation.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="visibilityConfig")
    def visibility_config(self) -> Optional['outputs.RuleGroupVisibilityConfig']:
        """
        Defines and enables Amazon CloudWatch metrics and web request sample collection.
        """
        return pulumi.get(self, "visibility_config")


class AwaitableGetRuleGroupResult(GetRuleGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRuleGroupResult(
            arn=self.arn,
            available_labels=self.available_labels,
            capacity=self.capacity,
            consumed_labels=self.consumed_labels,
            custom_response_bodies=self.custom_response_bodies,
            description=self.description,
            id=self.id,
            label_namespace=self.label_namespace,
            rules=self.rules,
            tags=self.tags,
            visibility_config=self.visibility_config)


def get_rule_group(id: Optional[builtins.str] = None,
                   name: Optional[builtins.str] = None,
                   scope: Optional['RuleGroupScope'] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRuleGroupResult:
    """
    Contains the Rules that identify the requests that you want to allow, block, or count. In a RuleGroup, you also specify a default action (ALLOW or BLOCK), and the action for each Rule that you add to a RuleGroup, for example, block requests from specified IP addresses or block requests from specified referrers. You also associate the RuleGroup with a CloudFront distribution to identify the requests that you want AWS WAF to filter. If you add more than one Rule to a RuleGroup, a request needs to match only one of the specifications to be allowed, blocked, or counted.


    :param builtins.str id: The ID of the rule group.
    :param builtins.str name: The name of the rule group. You cannot change the name of a rule group after you create it.
    :param 'RuleGroupScope' scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use `CLOUDFRONT` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are `CLOUDFRONT` and `REGIONAL` .
           
           > For `CLOUDFRONT` , you must create your WAFv2 resources in the US East (N. Virginia) Region, `us-east-1` .
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:wafv2:getRuleGroup', __args__, opts=opts, typ=GetRuleGroupResult).value

    return AwaitableGetRuleGroupResult(
        arn=pulumi.get(__ret__, 'arn'),
        available_labels=pulumi.get(__ret__, 'available_labels'),
        capacity=pulumi.get(__ret__, 'capacity'),
        consumed_labels=pulumi.get(__ret__, 'consumed_labels'),
        custom_response_bodies=pulumi.get(__ret__, 'custom_response_bodies'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        label_namespace=pulumi.get(__ret__, 'label_namespace'),
        rules=pulumi.get(__ret__, 'rules'),
        tags=pulumi.get(__ret__, 'tags'),
        visibility_config=pulumi.get(__ret__, 'visibility_config'))
def get_rule_group_output(id: Optional[pulumi.Input[builtins.str]] = None,
                          name: Optional[pulumi.Input[builtins.str]] = None,
                          scope: Optional[pulumi.Input['RuleGroupScope']] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRuleGroupResult]:
    """
    Contains the Rules that identify the requests that you want to allow, block, or count. In a RuleGroup, you also specify a default action (ALLOW or BLOCK), and the action for each Rule that you add to a RuleGroup, for example, block requests from specified IP addresses or block requests from specified referrers. You also associate the RuleGroup with a CloudFront distribution to identify the requests that you want AWS WAF to filter. If you add more than one Rule to a RuleGroup, a request needs to match only one of the specifications to be allowed, blocked, or counted.


    :param builtins.str id: The ID of the rule group.
    :param builtins.str name: The name of the rule group. You cannot change the name of a rule group after you create it.
    :param 'RuleGroupScope' scope: Specifies whether this is for an Amazon CloudFront distribution or for a regional application. For an AWS Amplify application, use `CLOUDFRONT` . A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, an AWS AppSync GraphQL API, an Amazon Cognito user pool, an AWS App Runner service, or an AWS Verified Access instance. Valid Values are `CLOUDFRONT` and `REGIONAL` .
           
           > For `CLOUDFRONT` , you must create your WAFv2 resources in the US East (N. Virginia) Region, `us-east-1` .
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['scope'] = scope
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:wafv2:getRuleGroup', __args__, opts=opts, typ=GetRuleGroupResult)
    return __ret__.apply(lambda __response__: GetRuleGroupResult(
        arn=pulumi.get(__response__, 'arn'),
        available_labels=pulumi.get(__response__, 'available_labels'),
        capacity=pulumi.get(__response__, 'capacity'),
        consumed_labels=pulumi.get(__response__, 'consumed_labels'),
        custom_response_bodies=pulumi.get(__response__, 'custom_response_bodies'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        label_namespace=pulumi.get(__response__, 'label_namespace'),
        rules=pulumi.get(__response__, 'rules'),
        tags=pulumi.get(__response__, 'tags'),
        visibility_config=pulumi.get(__response__, 'visibility_config')))
