# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs

__all__ = ['ServiceNetworkResourceAssociationArgs', 'ServiceNetworkResourceAssociation']

@pulumi.input_type
class ServiceNetworkResourceAssociationArgs:
    def __init__(__self__, *,
                 resource_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a ServiceNetworkResourceAssociation resource.
        :param pulumi.Input[builtins.str] resource_configuration_id: The ID of the resource configuration associated with the service network.
        :param pulumi.Input[builtins.str] service_network_id: The ID of the service network associated with the resource configuration.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: A key-value pair to associate with a resource.
        """
        if resource_configuration_id is not None:
            pulumi.set(__self__, "resource_configuration_id", resource_configuration_id)
        if service_network_id is not None:
            pulumi.set(__self__, "service_network_id", service_network_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="resourceConfigurationId")
    def resource_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the resource configuration associated with the service network.
        """
        return pulumi.get(self, "resource_configuration_id")

    @resource_configuration_id.setter
    def resource_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_configuration_id", value)

    @property
    @pulumi.getter(name="serviceNetworkId")
    def service_network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the service network associated with the resource configuration.
        """
        return pulumi.get(self, "service_network_id")

    @service_network_id.setter
    def service_network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_network_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:vpclattice:ServiceNetworkResourceAssociation")
class ServiceNetworkResourceAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        VpcLattice ServiceNetworkResourceAssociation CFN resource

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] resource_configuration_id: The ID of the resource configuration associated with the service network.
        :param pulumi.Input[builtins.str] service_network_id: The ID of the service network associated with the resource configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: A key-value pair to associate with a resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServiceNetworkResourceAssociationArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        VpcLattice ServiceNetworkResourceAssociation CFN resource

        :param str resource_name: The name of the resource.
        :param ServiceNetworkResourceAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceNetworkResourceAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 resource_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_id: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceNetworkResourceAssociationArgs.__new__(ServiceNetworkResourceAssociationArgs)

            __props__.__dict__["resource_configuration_id"] = resource_configuration_id
            __props__.__dict__["service_network_id"] = service_network_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["resourceConfigurationId", "serviceNetworkId"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ServiceNetworkResourceAssociation, __self__).__init__(
            'aws-native:vpclattice:ServiceNetworkResourceAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServiceNetworkResourceAssociation':
        """
        Get an existing ServiceNetworkResourceAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServiceNetworkResourceAssociationArgs.__new__(ServiceNetworkResourceAssociationArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["resource_configuration_id"] = None
        __props__.__dict__["service_network_id"] = None
        __props__.__dict__["tags"] = None
        return ServiceNetworkResourceAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the association between the service network and resource configuration.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="resourceConfigurationId")
    def resource_configuration_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the resource configuration associated with the service network.
        """
        return pulumi.get(self, "resource_configuration_id")

    @property
    @pulumi.getter(name="serviceNetworkId")
    def service_network_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID of the service network associated with the resource configuration.
        """
        return pulumi.get(self, "service_network_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")

