# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'ListenerDefaultAction',
    'ListenerFixedResponse',
    'ListenerForward',
    'ListenerWeightedTargetGroup',
    'ResourceConfigurationDefinition0Properties',
    'ResourceConfigurationDefinition1Properties',
    'ResourceConfigurationDefinition2Properties',
    'ResourceConfigurationDnsResource',
    'RuleAction',
    'RuleFixedResponse',
    'RuleForward',
    'RuleHeaderMatch',
    'RuleHeaderMatchType',
    'RuleHttpMatch',
    'RuleMatch',
    'RulePathMatch',
    'RulePathMatchType',
    'RuleWeightedTargetGroup',
    'ServiceDnsEntry',
    'ServiceNetworkServiceAssociationDnsEntry',
    'ServiceNetworkSharingConfig',
    'TargetGroupConfig',
    'TargetGroupHealthCheckConfig',
    'TargetGroupMatcher',
    'TargetGroupTarget',
]

@pulumi.output_type
class ListenerDefaultAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedResponse":
            suggest = "fixed_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerDefaultAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerDefaultAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_response: Optional['outputs.ListenerFixedResponse'] = None,
                 forward: Optional['outputs.ListenerForward'] = None):
        """
        :param 'ListenerFixedResponse' fixed_response: Describes an action that returns a custom HTTP response.
        :param 'ListenerForward' forward: Describes a forward action. You can use forward actions to route requests to one or more target groups.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.ListenerFixedResponse']:
        """
        Describes an action that returns a custom HTTP response.
        """
        return pulumi.get(self, "fixed_response")

    @property
    @pulumi.getter
    def forward(self) -> Optional['outputs.ListenerForward']:
        """
        Describes a forward action. You can use forward actions to route requests to one or more target groups.
        """
        return pulumi.get(self, "forward")


@pulumi.output_type
class ListenerFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: builtins.int):
        """
        :param builtins.int status_code: The HTTP response code. Only `404` and `500` status codes are supported.
        """
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> builtins.int:
        """
        The HTTP response code. Only `404` and `500` status codes are supported.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class ListenerForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.ListenerWeightedTargetGroup']):
        """
        :param Sequence['ListenerWeightedTargetGroup'] target_groups: The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
               
               The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.ListenerWeightedTargetGroup']:
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class ListenerWeightedTargetGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroupIdentifier":
            suggest = "target_group_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ListenerWeightedTargetGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ListenerWeightedTargetGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ListenerWeightedTargetGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_group_identifier: builtins.str,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str target_group_identifier: The ID of the target group.
        :param builtins.int weight: Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> builtins.str:
        """
        The ID of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ResourceConfigurationDefinition0Properties(dict):
    """
    Identifies the resource configuration in one of the following ways:

    - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
    - *Domain name* - Any domain name that is publicly resolvable.
    - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipResource":
            suggest = "ip_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationDefinition0Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationDefinition0Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationDefinition0Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_resource: builtins.str):
        """
        Identifies the resource configuration in one of the following ways:

        - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
        - *Domain name* - Any domain name that is publicly resolvable.
        - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
        """
        pulumi.set(__self__, "ip_resource", ip_resource)

    @property
    @pulumi.getter(name="ipResource")
    def ip_resource(self) -> builtins.str:
        return pulumi.get(self, "ip_resource")


@pulumi.output_type
class ResourceConfigurationDefinition1Properties(dict):
    """
    Identifies the resource configuration in one of the following ways:

    - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
    - *Domain name* - Any domain name that is publicly resolvable.
    - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "arnResource":
            suggest = "arn_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationDefinition1Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationDefinition1Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationDefinition1Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arn_resource: builtins.str):
        """
        Identifies the resource configuration in one of the following ways:

        - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
        - *Domain name* - Any domain name that is publicly resolvable.
        - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
        """
        pulumi.set(__self__, "arn_resource", arn_resource)

    @property
    @pulumi.getter(name="arnResource")
    def arn_resource(self) -> builtins.str:
        return pulumi.get(self, "arn_resource")


@pulumi.output_type
class ResourceConfigurationDefinition2Properties(dict):
    """
    Identifies the resource configuration in one of the following ways:

    - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
    - *Domain name* - Any domain name that is publicly resolvable.
    - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsResource":
            suggest = "dns_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationDefinition2Properties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationDefinition2Properties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationDefinition2Properties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_resource: 'outputs.ResourceConfigurationDnsResource'):
        """
        Identifies the resource configuration in one of the following ways:

        - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
        - *Domain name* - Any domain name that is publicly resolvable.
        - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
        """
        pulumi.set(__self__, "dns_resource", dns_resource)

    @property
    @pulumi.getter(name="dnsResource")
    def dns_resource(self) -> 'outputs.ResourceConfigurationDnsResource':
        return pulumi.get(self, "dns_resource")


@pulumi.output_type
class ResourceConfigurationDnsResource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "ipAddressType":
            suggest = "ip_address_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResourceConfigurationDnsResource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResourceConfigurationDnsResource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResourceConfigurationDnsResource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: builtins.str,
                 ip_address_type: 'ResourceConfigurationDnsResourceIpAddressType'):
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "ip_address_type", ip_address_type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> builtins.str:
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> 'ResourceConfigurationDnsResourceIpAddressType':
        return pulumi.get(self, "ip_address_type")


@pulumi.output_type
class RuleAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fixedResponse":
            suggest = "fixed_response"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fixed_response: Optional['outputs.RuleFixedResponse'] = None,
                 forward: Optional['outputs.RuleForward'] = None):
        """
        :param 'RuleFixedResponse' fixed_response: The fixed response action. The rule returns a custom HTTP response.
        :param 'RuleForward' forward: The forward action. Traffic that matches the rule is forwarded to the specified target groups.
        """
        if fixed_response is not None:
            pulumi.set(__self__, "fixed_response", fixed_response)
        if forward is not None:
            pulumi.set(__self__, "forward", forward)

    @property
    @pulumi.getter(name="fixedResponse")
    def fixed_response(self) -> Optional['outputs.RuleFixedResponse']:
        """
        The fixed response action. The rule returns a custom HTTP response.
        """
        return pulumi.get(self, "fixed_response")

    @property
    @pulumi.getter
    def forward(self) -> Optional['outputs.RuleForward']:
        """
        The forward action. Traffic that matches the rule is forwarded to the specified target groups.
        """
        return pulumi.get(self, "forward")


@pulumi.output_type
class RuleFixedResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusCode":
            suggest = "status_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleFixedResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleFixedResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleFixedResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status_code: builtins.int):
        """
        :param builtins.int status_code: The HTTP response code. Only `404` and `500` status codes are supported.
        """
        pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> builtins.int:
        """
        The HTTP response code. Only `404` and `500` status codes are supported.
        """
        return pulumi.get(self, "status_code")


@pulumi.output_type
class RuleForward(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroups":
            suggest = "target_groups"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleForward. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleForward.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleForward.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_groups: Sequence['outputs.RuleWeightedTargetGroup']):
        """
        :param Sequence['RuleWeightedTargetGroup'] target_groups: The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.
               
               The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        pulumi.set(__self__, "target_groups", target_groups)

    @property
    @pulumi.getter(name="targetGroups")
    def target_groups(self) -> Sequence['outputs.RuleWeightedTargetGroup']:
        """
        The target groups. Traffic matching the rule is forwarded to the specified target groups. With forward actions, you can assign a weight that controls the prioritization and selection of each target group. This means that requests are distributed to individual target groups based on their weights. For example, if two target groups have the same weight, each target group receives half of the traffic.

        The default value is 1. This means that if only one target group is provided, there is no need to set the weight; 100% of the traffic goes to that target group.
        """
        return pulumi.get(self, "target_groups")


@pulumi.output_type
class RuleHeaderMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleHeaderMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleHeaderMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleHeaderMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match: 'outputs.RuleHeaderMatchType',
                 name: builtins.str,
                 case_sensitive: Optional[builtins.bool] = None):
        """
        :param 'RuleHeaderMatchType' match: The header match type.
        :param builtins.str name: The name of the header.
        :param builtins.bool case_sensitive: Indicates whether the match is case sensitive.
        """
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "name", name)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter
    def match(self) -> 'outputs.RuleHeaderMatchType':
        """
        The header match type.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the header.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        """
        Indicates whether the match is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class RuleHeaderMatchType(dict):
    def __init__(__self__, *,
                 contains: Optional[builtins.str] = None,
                 exact: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str contains: A contains type match.
        :param builtins.str exact: An exact type match.
        :param builtins.str prefix: A prefix type match. Matches the value with the prefix.
        """
        if contains is not None:
            pulumi.set(__self__, "contains", contains)
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def contains(self) -> Optional[builtins.str]:
        """
        A contains type match.
        """
        return pulumi.get(self, "contains")

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        An exact type match.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        A prefix type match. Matches the value with the prefix.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class RuleHttpMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "headerMatches":
            suggest = "header_matches"
        elif key == "pathMatch":
            suggest = "path_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleHttpMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleHttpMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleHttpMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header_matches: Optional[Sequence['outputs.RuleHeaderMatch']] = None,
                 method: Optional['RuleHttpMatchMethod'] = None,
                 path_match: Optional['outputs.RulePathMatch'] = None):
        """
        :param Sequence['RuleHeaderMatch'] header_matches: The header matches. Matches incoming requests with rule based on request header value before applying rule action.
        :param 'RuleHttpMatchMethod' method: The HTTP method type.
        :param 'RulePathMatch' path_match: The path match.
        """
        if header_matches is not None:
            pulumi.set(__self__, "header_matches", header_matches)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if path_match is not None:
            pulumi.set(__self__, "path_match", path_match)

    @property
    @pulumi.getter(name="headerMatches")
    def header_matches(self) -> Optional[Sequence['outputs.RuleHeaderMatch']]:
        """
        The header matches. Matches incoming requests with rule based on request header value before applying rule action.
        """
        return pulumi.get(self, "header_matches")

    @property
    @pulumi.getter
    def method(self) -> Optional['RuleHttpMatchMethod']:
        """
        The HTTP method type.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="pathMatch")
    def path_match(self) -> Optional['outputs.RulePathMatch']:
        """
        The path match.
        """
        return pulumi.get(self, "path_match")


@pulumi.output_type
class RuleMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpMatch":
            suggest = "http_match"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_match: 'outputs.RuleHttpMatch'):
        """
        :param 'RuleHttpMatch' http_match: The HTTP criteria that a rule must match.
        """
        pulumi.set(__self__, "http_match", http_match)

    @property
    @pulumi.getter(name="httpMatch")
    def http_match(self) -> 'outputs.RuleHttpMatch':
        """
        The HTTP criteria that a rule must match.
        """
        return pulumi.get(self, "http_match")


@pulumi.output_type
class RulePathMatch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulePathMatch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulePathMatch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulePathMatch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 match: 'outputs.RulePathMatchType',
                 case_sensitive: Optional[builtins.bool] = None):
        """
        :param 'RulePathMatchType' match: The type of path match.
        :param builtins.bool case_sensitive: Indicates whether the match is case sensitive.
        """
        pulumi.set(__self__, "match", match)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter
    def match(self) -> 'outputs.RulePathMatchType':
        """
        The type of path match.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[builtins.bool]:
        """
        Indicates whether the match is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")


@pulumi.output_type
class RulePathMatchType(dict):
    def __init__(__self__, *,
                 exact: Optional[builtins.str] = None,
                 prefix: Optional[builtins.str] = None):
        """
        :param builtins.str exact: An exact match of the path.
        :param builtins.str prefix: A prefix match of the path.
        """
        if exact is not None:
            pulumi.set(__self__, "exact", exact)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def exact(self) -> Optional[builtins.str]:
        """
        An exact match of the path.
        """
        return pulumi.get(self, "exact")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[builtins.str]:
        """
        A prefix match of the path.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class RuleWeightedTargetGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetGroupIdentifier":
            suggest = "target_group_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleWeightedTargetGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleWeightedTargetGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleWeightedTargetGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_group_identifier: builtins.str,
                 weight: Optional[builtins.int] = None):
        """
        :param builtins.str target_group_identifier: The ID of the target group.
        :param builtins.int weight: Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        pulumi.set(__self__, "target_group_identifier", target_group_identifier)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="targetGroupIdentifier")
    def target_group_identifier(self) -> builtins.str:
        """
        The ID of the target group.
        """
        return pulumi.get(self, "target_group_identifier")

    @property
    @pulumi.getter
    def weight(self) -> Optional[builtins.int]:
        """
        Only required if you specify multiple target groups for a forward action. The weight determines how requests are distributed to the target group. For example, if you specify two target groups, each with a weight of 10, each target group receives half the requests. If you specify two target groups, one with a weight of 10 and the other with a weight of 20, the target group with a weight of 20 receives twice as many requests as the other target group. If there's only one target group specified, then the default value is 100.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ServiceDnsEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceDnsEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceDnsEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceDnsEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[builtins.str] = None,
                 hosted_zone_id: Optional[builtins.str] = None):
        """
        :param builtins.str domain_name: The domain name of the service.
        :param builtins.str hosted_zone_id: The ID of the hosted zone.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[builtins.str]:
        """
        The domain name of the service.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[builtins.str]:
        """
        The ID of the hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class ServiceNetworkServiceAssociationDnsEntry(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainName":
            suggest = "domain_name"
        elif key == "hostedZoneId":
            suggest = "hosted_zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkServiceAssociationDnsEntry. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkServiceAssociationDnsEntry.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkServiceAssociationDnsEntry.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name: Optional[builtins.str] = None,
                 hosted_zone_id: Optional[builtins.str] = None):
        """
        :param builtins.str domain_name: The domain name of the service.
        :param builtins.str hosted_zone_id: The ID of the hosted zone.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if hosted_zone_id is not None:
            pulumi.set(__self__, "hosted_zone_id", hosted_zone_id)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[builtins.str]:
        """
        The domain name of the service.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="hostedZoneId")
    def hosted_zone_id(self) -> Optional[builtins.str]:
        """
        The ID of the hosted zone.
        """
        return pulumi.get(self, "hosted_zone_id")


@pulumi.output_type
class ServiceNetworkSharingConfig(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool):
        """
        :param builtins.bool enabled: Specify if the service network should be enabled for sharing.
        """
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specify if the service network should be enabled for sharing.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class TargetGroupConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheck":
            suggest = "health_check"
        elif key == "ipAddressType":
            suggest = "ip_address_type"
        elif key == "lambdaEventStructureVersion":
            suggest = "lambda_event_structure_version"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "vpcIdentifier":
            suggest = "vpc_identifier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check: Optional['outputs.TargetGroupHealthCheckConfig'] = None,
                 ip_address_type: Optional['TargetGroupConfigIpAddressType'] = None,
                 lambda_event_structure_version: Optional['TargetGroupConfigLambdaEventStructureVersion'] = None,
                 port: Optional[builtins.int] = None,
                 protocol: Optional['TargetGroupConfigProtocol'] = None,
                 protocol_version: Optional['TargetGroupConfigProtocolVersion'] = None,
                 vpc_identifier: Optional[builtins.str] = None):
        """
        :param 'TargetGroupHealthCheckConfig' health_check: The health check configuration. Not supported if the target group type is `LAMBDA` or `ALB` .
        :param 'TargetGroupConfigIpAddressType' ip_address_type: The type of IP address used for the target group. Supported only if the target group type is `IP` . The default is `IPV4` .
        :param 'TargetGroupConfigLambdaEventStructureVersion' lambda_event_structure_version: The version of the event structure that your Lambda function receives. Supported only if the target group type is `LAMBDA` . The default is `V1` .
        :param builtins.int port: The port on which the targets are listening. For HTTP, the default is 80. For HTTPS, the default is 443. Not supported if the target group type is `LAMBDA` .
        :param 'TargetGroupConfigProtocol' protocol: The protocol to use for routing traffic to the targets. The default is the protocol of the target group. Not supported if the target group type is `LAMBDA` .
        :param 'TargetGroupConfigProtocolVersion' protocol_version: The protocol version. The default is `HTTP1` . Not supported if the target group type is `LAMBDA` .
        :param builtins.str vpc_identifier: The ID of the VPC. Not supported if the target group type is `LAMBDA` .
        """
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if lambda_event_structure_version is not None:
            pulumi.set(__self__, "lambda_event_structure_version", lambda_event_structure_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if vpc_identifier is not None:
            pulumi.set(__self__, "vpc_identifier", vpc_identifier)

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.TargetGroupHealthCheckConfig']:
        """
        The health check configuration. Not supported if the target group type is `LAMBDA` or `ALB` .
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional['TargetGroupConfigIpAddressType']:
        """
        The type of IP address used for the target group. Supported only if the target group type is `IP` . The default is `IPV4` .
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="lambdaEventStructureVersion")
    def lambda_event_structure_version(self) -> Optional['TargetGroupConfigLambdaEventStructureVersion']:
        """
        The version of the event structure that your Lambda function receives. Supported only if the target group type is `LAMBDA` . The default is `V1` .
        """
        return pulumi.get(self, "lambda_event_structure_version")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port on which the targets are listening. For HTTP, the default is 80. For HTTPS, the default is 443. Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['TargetGroupConfigProtocol']:
        """
        The protocol to use for routing traffic to the targets. The default is the protocol of the target group. Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional['TargetGroupConfigProtocolVersion']:
        """
        The protocol version. The default is `HTTP1` . Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="vpcIdentifier")
    def vpc_identifier(self) -> Optional[builtins.str]:
        """
        The ID of the VPC. Not supported if the target group type is `LAMBDA` .
        """
        return pulumi.get(self, "vpc_identifier")


@pulumi.output_type
class TargetGroupHealthCheckConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckIntervalSeconds":
            suggest = "health_check_interval_seconds"
        elif key == "healthCheckTimeoutSeconds":
            suggest = "health_check_timeout_seconds"
        elif key == "healthyThresholdCount":
            suggest = "healthy_threshold_count"
        elif key == "protocolVersion":
            suggest = "protocol_version"
        elif key == "unhealthyThresholdCount":
            suggest = "unhealthy_threshold_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupHealthCheckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupHealthCheckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupHealthCheckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[builtins.bool] = None,
                 health_check_interval_seconds: Optional[builtins.int] = None,
                 health_check_timeout_seconds: Optional[builtins.int] = None,
                 healthy_threshold_count: Optional[builtins.int] = None,
                 matcher: Optional['outputs.TargetGroupMatcher'] = None,
                 path: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 protocol: Optional['TargetGroupHealthCheckConfigProtocol'] = None,
                 protocol_version: Optional['TargetGroupHealthCheckConfigProtocolVersion'] = None,
                 unhealthy_threshold_count: Optional[builtins.int] = None):
        """
        :param builtins.bool enabled: Indicates whether health checking is enabled.
        :param builtins.int health_check_interval_seconds: The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        :param builtins.int health_check_timeout_seconds: The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
        :param builtins.int healthy_threshold_count: The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        :param 'TargetGroupMatcher' matcher: The codes to use when checking for a successful response from a target.
        :param builtins.str path: The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2` , specify a valid URI (for example, `/path?query` ). The default path is `/` . Health checks are not supported if the protocol version is `gRPC` , however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
        :param builtins.int port: The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        :param 'TargetGroupHealthCheckConfigProtocol' protocol: The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS` . The default is `HTTP` .
        :param 'TargetGroupHealthCheckConfigProtocolVersion' protocol_version: The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2` .
        :param builtins.int unhealthy_threshold_count: The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_timeout_seconds is not None:
            pulumi.set(__self__, "health_check_timeout_seconds", health_check_timeout_seconds)
        if healthy_threshold_count is not None:
            pulumi.set(__self__, "healthy_threshold_count", healthy_threshold_count)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if protocol_version is not None:
            pulumi.set(__self__, "protocol_version", protocol_version)
        if unhealthy_threshold_count is not None:
            pulumi.set(__self__, "unhealthy_threshold_count", unhealthy_threshold_count)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Indicates whether health checking is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[builtins.int]:
        """
        The approximate amount of time, in seconds, between health checks of an individual target. The range is 5–300 seconds. The default is 30 seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @property
    @pulumi.getter(name="healthCheckTimeoutSeconds")
    def health_check_timeout_seconds(self) -> Optional[builtins.int]:
        """
        The amount of time, in seconds, to wait before reporting a target as unhealthy. The range is 1–120 seconds. The default is 5 seconds.
        """
        return pulumi.get(self, "health_check_timeout_seconds")

    @property
    @pulumi.getter(name="healthyThresholdCount")
    def healthy_threshold_count(self) -> Optional[builtins.int]:
        """
        The number of consecutive successful health checks required before considering an unhealthy target healthy. The range is 2–10. The default is 5.
        """
        return pulumi.get(self, "healthy_threshold_count")

    @property
    @pulumi.getter
    def matcher(self) -> Optional['outputs.TargetGroupMatcher']:
        """
        The codes to use when checking for a successful response from a target.
        """
        return pulumi.get(self, "matcher")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The destination for health checks on the targets. If the protocol version is `HTTP/1.1` or `HTTP/2` , specify a valid URI (for example, `/path?query` ). The default path is `/` . Health checks are not supported if the protocol version is `gRPC` , however, you can choose `HTTP/1.1` or `HTTP/2` and specify a valid URI.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port used when performing health checks on targets. The default setting is the port that a target receives traffic on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional['TargetGroupHealthCheckConfigProtocol']:
        """
        The protocol used when performing health checks on targets. The possible protocols are `HTTP` and `HTTPS` . The default is `HTTP` .
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolVersion")
    def protocol_version(self) -> Optional['TargetGroupHealthCheckConfigProtocolVersion']:
        """
        The protocol version used when performing health checks on targets. The possible protocol versions are `HTTP1` and `HTTP2` .
        """
        return pulumi.get(self, "protocol_version")

    @property
    @pulumi.getter(name="unhealthyThresholdCount")
    def unhealthy_threshold_count(self) -> Optional[builtins.int]:
        """
        The number of consecutive failed health checks required before considering a target unhealthy. The range is 2–10. The default is 2.
        """
        return pulumi.get(self, "unhealthy_threshold_count")


@pulumi.output_type
class TargetGroupMatcher(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpCode":
            suggest = "http_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TargetGroupMatcher. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TargetGroupMatcher.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TargetGroupMatcher.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_code: builtins.str):
        """
        :param builtins.str http_code: The HTTP code to use when checking for a successful response from a target.
        """
        pulumi.set(__self__, "http_code", http_code)

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> builtins.str:
        """
        The HTTP code to use when checking for a successful response from a target.
        """
        return pulumi.get(self, "http_code")


@pulumi.output_type
class TargetGroupTarget(dict):
    def __init__(__self__, *,
                 id: builtins.str,
                 port: Optional[builtins.int] = None):
        """
        :param builtins.str id: The ID of the target. If the target group type is `INSTANCE` , this is an instance ID. If the target group type is `IP` , this is an IP address. If the target group type is `LAMBDA` , this is the ARN of a Lambda function. If the target group type is `ALB` , this is the ARN of an Application Load Balancer.
        :param builtins.int port: The port on which the target is listening. For HTTP, the default is 80. For HTTPS, the default is 443.
        """
        pulumi.set(__self__, "id", id)
        if port is not None:
            pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the target. If the target group type is `INSTANCE` , this is an instance ID. If the target group type is `IP` , this is an IP address. If the target group type is `LAMBDA` , this is the ARN of a Lambda function. If the target group type is `ALB` , this is the ARN of an Application Load Balancer.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The port on which the target is listening. For HTTP, the default is 80. For HTTPS, the default is 443.
        """
        return pulumi.get(self, "port")


