# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetServiceNetworkResourceAssociationResult',
    'AwaitableGetServiceNetworkResourceAssociationResult',
    'get_service_network_resource_association',
    'get_service_network_resource_association_output',
]

@pulumi.output_type
class GetServiceNetworkResourceAssociationResult:
    def __init__(__self__, arn=None, id=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the association.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the association between the service network and resource configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        A key-value pair to associate with a resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceNetworkResourceAssociationResult(GetServiceNetworkResourceAssociationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceNetworkResourceAssociationResult(
            arn=self.arn,
            id=self.id,
            tags=self.tags)


def get_service_network_resource_association(arn: Optional[builtins.str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceNetworkResourceAssociationResult:
    """
    VpcLattice ServiceNetworkResourceAssociation CFN resource


    :param builtins.str arn: The Amazon Resource Name (ARN) of the association.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:vpclattice:getServiceNetworkResourceAssociation', __args__, opts=opts, typ=GetServiceNetworkResourceAssociationResult).value

    return AwaitableGetServiceNetworkResourceAssociationResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_network_resource_association_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceNetworkResourceAssociationResult]:
    """
    VpcLattice ServiceNetworkResourceAssociation CFN resource


    :param builtins.str arn: The Amazon Resource Name (ARN) of the association.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:vpclattice:getServiceNetworkResourceAssociation', __args__, opts=opts, typ=GetServiceNetworkResourceAssociationResult)
    return __ret__.apply(lambda __response__: GetServiceNetworkResourceAssociationResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
