# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetServiceResult',
    'AwaitableGetServiceResult',
    'get_service',
    'get_service_output',
]

@pulumi.output_type
class GetServiceResult:
    def __init__(__self__, arn=None, auth_type=None, certificate_arn=None, created_at=None, dns_entry=None, id=None, last_updated_at=None, status=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if auth_type and not isinstance(auth_type, str):
            raise TypeError("Expected argument 'auth_type' to be a str")
        pulumi.set(__self__, "auth_type", auth_type)
        if certificate_arn and not isinstance(certificate_arn, str):
            raise TypeError("Expected argument 'certificate_arn' to be a str")
        pulumi.set(__self__, "certificate_arn", certificate_arn)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if dns_entry and not isinstance(dns_entry, dict):
            raise TypeError("Expected argument 'dns_entry' to be a dict")
        pulumi.set(__self__, "dns_entry", dns_entry)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if last_updated_at and not isinstance(last_updated_at, str):
            raise TypeError("Expected argument 'last_updated_at' to be a str")
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the service.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional['ServiceAuthType']:
        """
        The type of IAM policy.

        - `NONE` : The resource does not use an IAM policy. This is the default.
        - `AWS_IAM` : The resource uses an IAM policy. When this type is used, auth is enabled and an auth policy is required.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="certificateArn")
    def certificate_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the certificate.
        """
        return pulumi.get(self, "certificate_arn")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The date and time that the service was created, specified in ISO-8601 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dnsEntry")
    def dns_entry(self) -> Optional['outputs.ServiceDnsEntry']:
        """
        The DNS information of the service.
        """
        return pulumi.get(self, "dns_entry")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> Optional[builtins.str]:
        """
        The date and time that the service was last updated, specified in ISO-8601 format.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter
    def status(self) -> Optional['ServiceStatus']:
        """
        The status of the service.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for the service.
        """
        return pulumi.get(self, "tags")


class AwaitableGetServiceResult(GetServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceResult(
            arn=self.arn,
            auth_type=self.auth_type,
            certificate_arn=self.certificate_arn,
            created_at=self.created_at,
            dns_entry=self.dns_entry,
            id=self.id,
            last_updated_at=self.last_updated_at,
            status=self.status,
            tags=self.tags)


def get_service(arn: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceResult:
    """
    A service is any software application that can run on instances containers, or serverless functions within an account or virtual private cloud (VPC).


    :param builtins.str arn: The Amazon Resource Name (ARN) of the service.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:vpclattice:getService', __args__, opts=opts, typ=GetServiceResult).value

    return AwaitableGetServiceResult(
        arn=pulumi.get(__ret__, 'arn'),
        auth_type=pulumi.get(__ret__, 'auth_type'),
        certificate_arn=pulumi.get(__ret__, 'certificate_arn'),
        created_at=pulumi.get(__ret__, 'created_at'),
        dns_entry=pulumi.get(__ret__, 'dns_entry'),
        id=pulumi.get(__ret__, 'id'),
        last_updated_at=pulumi.get(__ret__, 'last_updated_at'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_service_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceResult]:
    """
    A service is any software application that can run on instances containers, or serverless functions within an account or virtual private cloud (VPC).


    :param builtins.str arn: The Amazon Resource Name (ARN) of the service.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:vpclattice:getService', __args__, opts=opts, typ=GetServiceResult)
    return __ret__.apply(lambda __response__: GetServiceResult(
        arn=pulumi.get(__response__, 'arn'),
        auth_type=pulumi.get(__response__, 'auth_type'),
        certificate_arn=pulumi.get(__response__, 'certificate_arn'),
        created_at=pulumi.get(__response__, 'created_at'),
        dns_entry=pulumi.get(__response__, 'dns_entry'),
        id=pulumi.get(__response__, 'id'),
        last_updated_at=pulumi.get(__response__, 'last_updated_at'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
