# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetResourceGatewayResult',
    'AwaitableGetResourceGatewayResult',
    'get_resource_gateway',
    'get_resource_gateway_output',
]

@pulumi.output_type
class GetResourceGatewayResult:
    def __init__(__self__, arn=None, id=None, security_group_ids=None, tags=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_group_ids and not isinstance(security_group_ids, list):
            raise TypeError("Expected argument 'security_group_ids' to be a list")
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resource gateway.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the resource gateway.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        The ID of one or more security groups to associate with the endpoint network interface.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for the resource gateway.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceGatewayResult(GetResourceGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceGatewayResult(
            arn=self.arn,
            id=self.id,
            security_group_ids=self.security_group_ids,
            tags=self.tags)


def get_resource_gateway(arn: Optional[builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceGatewayResult:
    """
    Creates a resource gateway for a service.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the resource gateway.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:vpclattice:getResourceGateway', __args__, opts=opts, typ=GetResourceGatewayResult).value

    return AwaitableGetResourceGatewayResult(
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        security_group_ids=pulumi.get(__ret__, 'security_group_ids'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_gateway_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceGatewayResult]:
    """
    Creates a resource gateway for a service.


    :param builtins.str arn: The Amazon Resource Name (ARN) of the resource gateway.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:vpclattice:getResourceGateway', __args__, opts=opts, typ=GetResourceGatewayResult)
    return __ret__.apply(lambda __response__: GetResourceGatewayResult(
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        security_group_ids=pulumi.get(__response__, 'security_group_ids'),
        tags=pulumi.get(__response__, 'tags')))
