# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetResourceConfigurationResult',
    'AwaitableGetResourceConfigurationResult',
    'get_resource_configuration',
    'get_resource_configuration_output',
]

@pulumi.output_type
class GetResourceConfigurationResult:
    def __init__(__self__, allow_association_to_sharable_service_network=None, arn=None, id=None, name=None, port_ranges=None, resource_configuration_definition=None, tags=None):
        if allow_association_to_sharable_service_network and not isinstance(allow_association_to_sharable_service_network, bool):
            raise TypeError("Expected argument 'allow_association_to_sharable_service_network' to be a bool")
        pulumi.set(__self__, "allow_association_to_sharable_service_network", allow_association_to_sharable_service_network)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if port_ranges and not isinstance(port_ranges, list):
            raise TypeError("Expected argument 'port_ranges' to be a list")
        pulumi.set(__self__, "port_ranges", port_ranges)
        if resource_configuration_definition and not isinstance(resource_configuration_definition, dict):
            raise TypeError("Expected argument 'resource_configuration_definition' to be a dict")
        pulumi.set(__self__, "resource_configuration_definition", resource_configuration_definition)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allowAssociationToSharableServiceNetwork")
    def allow_association_to_sharable_service_network(self) -> Optional[builtins.bool]:
        """
        Specifies whether the resource configuration can be associated with a sharable service network.
        """
        return pulumi.get(self, "allow_association_to_sharable_service_network")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the resource configuration.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the resource configuration.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the resource configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[Sequence[builtins.str]]:
        """
        (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a resource configuration (for example: 1-65535). You can separate port ranges using commas (for example: 1,2,22-30).
        """
        return pulumi.get(self, "port_ranges")

    @property
    @pulumi.getter(name="resourceConfigurationDefinition")
    def resource_configuration_definition(self) -> Optional[Any]:
        """
        Identifies the resource configuration in one of the following ways:

        - *Amazon Resource Name (ARN)* - Supported resource-types that are provisioned by AWS services, such as RDS databases, can be identified by their ARN.
        - *Domain name* - Any domain name that is publicly resolvable.
        - *IP address* - For IPv4 and IPv6, only IP addresses in the VPC are supported.
        """
        return pulumi.get(self, "resource_configuration_definition")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags for the resource configuration.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResourceConfigurationResult(GetResourceConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResourceConfigurationResult(
            allow_association_to_sharable_service_network=self.allow_association_to_sharable_service_network,
            arn=self.arn,
            id=self.id,
            name=self.name,
            port_ranges=self.port_ranges,
            resource_configuration_definition=self.resource_configuration_definition,
            tags=self.tags)


def get_resource_configuration(arn: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResourceConfigurationResult:
    """
    VpcLattice ResourceConfiguration CFN resource


    :param builtins.str arn: The Amazon Resource Name (ARN) of the resource configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:vpclattice:getResourceConfiguration', __args__, opts=opts, typ=GetResourceConfigurationResult).value

    return AwaitableGetResourceConfigurationResult(
        allow_association_to_sharable_service_network=pulumi.get(__ret__, 'allow_association_to_sharable_service_network'),
        arn=pulumi.get(__ret__, 'arn'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        port_ranges=pulumi.get(__ret__, 'port_ranges'),
        resource_configuration_definition=pulumi.get(__ret__, 'resource_configuration_definition'),
        tags=pulumi.get(__ret__, 'tags'))
def get_resource_configuration_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResourceConfigurationResult]:
    """
    VpcLattice ResourceConfiguration CFN resource


    :param builtins.str arn: The Amazon Resource Name (ARN) of the resource configuration.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:vpclattice:getResourceConfiguration', __args__, opts=opts, typ=GetResourceConfigurationResult)
    return __ret__.apply(lambda __response__: GetResourceConfigurationResult(
        allow_association_to_sharable_service_network=pulumi.get(__response__, 'allow_association_to_sharable_service_network'),
        arn=pulumi.get(__response__, 'arn'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        port_ranges=pulumi.get(__response__, 'port_ranges'),
        resource_configuration_definition=pulumi.get(__response__, 'resource_configuration_definition'),
        tags=pulumi.get(__response__, 'tags')))
