# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = ['AccessLogSubscriptionArgs', 'AccessLogSubscription']

@pulumi.input_type
class AccessLogSubscriptionArgs:
    def __init__(__self__, *,
                 destination_arn: pulumi.Input[builtins.str],
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_log_type: Optional[pulumi.Input['AccessLogSubscriptionServiceNetworkLogType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a AccessLogSubscription resource.
        :param pulumi.Input[builtins.str] destination_arn: The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
        :param pulumi.Input[builtins.str] resource_identifier: The ID or ARN of the service network or service.
        :param pulumi.Input['AccessLogSubscriptionServiceNetworkLogType'] service_network_log_type: Log type of the service network.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags for the access log subscription.
        """
        pulumi.set(__self__, "destination_arn", destination_arn)
        if resource_identifier is not None:
            pulumi.set(__self__, "resource_identifier", resource_identifier)
        if service_network_log_type is not None:
            pulumi.set(__self__, "service_network_log_type", service_network_log_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> pulumi.Input[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
        """
        return pulumi.get(self, "destination_arn")

    @destination_arn.setter
    def destination_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination_arn", value)

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID or ARN of the service network or service.
        """
        return pulumi.get(self, "resource_identifier")

    @resource_identifier.setter
    def resource_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_identifier", value)

    @property
    @pulumi.getter(name="serviceNetworkLogType")
    def service_network_log_type(self) -> Optional[pulumi.Input['AccessLogSubscriptionServiceNetworkLogType']]:
        """
        Log type of the service network.
        """
        return pulumi.get(self, "service_network_log_type")

    @service_network_log_type.setter
    def service_network_log_type(self, value: Optional[pulumi.Input['AccessLogSubscriptionServiceNetworkLogType']]):
        pulumi.set(self, "service_network_log_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags for the access log subscription.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:vpclattice:AccessLogSubscription")
class AccessLogSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_arn: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_log_type: Optional[pulumi.Input['AccessLogSubscriptionServiceNetworkLogType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner will only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination_arn: The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
        :param pulumi.Input[builtins.str] resource_identifier: The ID or ARN of the service network or service.
        :param pulumi.Input['AccessLogSubscriptionServiceNetworkLogType'] service_network_log_type: Log type of the service network.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags for the access log subscription.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessLogSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose. The service network owner can use the access logs to audit the services in the network. The service network owner will only see access logs from clients and services that are associated with their service network. Access log entries represent traffic originated from VPCs associated with that network.

        :param str resource_name: The name of the resource.
        :param AccessLogSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessLogSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_arn: Optional[pulumi.Input[builtins.str]] = None,
                 resource_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 service_network_log_type: Optional[pulumi.Input['AccessLogSubscriptionServiceNetworkLogType']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessLogSubscriptionArgs.__new__(AccessLogSubscriptionArgs)

            if destination_arn is None and not opts.urn:
                raise TypeError("Missing required property 'destination_arn'")
            __props__.__dict__["destination_arn"] = destination_arn
            __props__.__dict__["resource_identifier"] = resource_identifier
            __props__.__dict__["service_network_log_type"] = service_network_log_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
            __props__.__dict__["aws_id"] = None
            __props__.__dict__["resource_arn"] = None
            __props__.__dict__["resource_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["resourceIdentifier"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(AccessLogSubscription, __self__).__init__(
            'aws-native:vpclattice:AccessLogSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'AccessLogSubscription':
        """
        Get an existing AccessLogSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AccessLogSubscriptionArgs.__new__(AccessLogSubscriptionArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["aws_id"] = None
        __props__.__dict__["destination_arn"] = None
        __props__.__dict__["resource_arn"] = None
        __props__.__dict__["resource_id"] = None
        __props__.__dict__["resource_identifier"] = None
        __props__.__dict__["service_network_log_type"] = None
        __props__.__dict__["tags"] = None
        return AccessLogSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the access log subscription.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="awsId")
    def aws_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the access log subscription.
        """
        return pulumi.get(self, "aws_id")

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the destination. The supported destination types are CloudWatch Log groups, Kinesis Data Firehose delivery streams, and Amazon S3 buckets.
        """
        return pulumi.get(self, "destination_arn")

    @property
    @pulumi.getter(name="resourceArn")
    def resource_arn(self) -> pulumi.Output[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the access log subscription.
        """
        return pulumi.get(self, "resource_arn")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the service network or service.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceIdentifier")
    def resource_identifier(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The ID or ARN of the service network or service.
        """
        return pulumi.get(self, "resource_identifier")

    @property
    @pulumi.getter(name="serviceNetworkLogType")
    def service_network_log_type(self) -> pulumi.Output[Optional['AccessLogSubscriptionServiceNetworkLogType']]:
        """
        Log type of the service network.
        """
        return pulumi.get(self, "service_network_log_type")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags for the access log subscription.
        """
        return pulumi.get(self, "tags")

