# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetDomainResult',
    'AwaitableGetDomainResult',
    'get_domain',
    'get_domain_output',
]

@pulumi.output_type
class GetDomainResult:
    def __init__(__self__, description=None, domain_id=None, name=None, server_side_encryption_configuration=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if server_side_encryption_configuration and not isinstance(server_side_encryption_configuration, dict):
            raise TypeError("Expected argument 'server_side_encryption_configuration' to be a dict")
        pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the domain.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[builtins.str]:
        """
        The identifier of the domain.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name for the domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional['outputs.DomainServerSideEncryptionConfiguration']:
        """
        The server-side encryption configuration containing the KMS key identifier you want Voice ID to use to encrypt your data.
        """
        return pulumi.get(self, "server_side_encryption_configuration")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        The tags used to organize, track, or control access for this resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetDomainResult(GetDomainResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainResult(
            description=self.description,
            domain_id=self.domain_id,
            name=self.name,
            server_side_encryption_configuration=self.server_side_encryption_configuration,
            tags=self.tags)


def get_domain(domain_id: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainResult:
    """
    The AWS::VoiceID::Domain resource specifies an Amazon VoiceID Domain.


    :param builtins.str domain_id: The identifier of the domain.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:voiceid:getDomain', __args__, opts=opts, typ=GetDomainResult).value

    return AwaitableGetDomainResult(
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        name=pulumi.get(__ret__, 'name'),
        server_side_encryption_configuration=pulumi.get(__ret__, 'server_side_encryption_configuration'),
        tags=pulumi.get(__ret__, 'tags'))
def get_domain_output(domain_id: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainResult]:
    """
    The AWS::VoiceID::Domain resource specifies an Amazon VoiceID Domain.


    :param builtins.str domain_id: The identifier of the domain.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:voiceid:getDomain', __args__, opts=opts, typ=GetDomainResult)
    return __ret__.apply(lambda __response__: GetDomainResult(
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        name=pulumi.get(__response__, 'name'),
        server_side_encryption_configuration=pulumi.get(__response__, 'server_side_encryption_configuration'),
        tags=pulumi.get(__response__, 'tags')))
