# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['PolicyStoreArgs', 'PolicyStore']

@pulumi.input_type
class PolicyStoreArgs:
    def __init__(__self__, *,
                 validation_settings: pulumi.Input['PolicyStoreValidationSettingsArgs'],
                 deletion_protection: Optional[pulumi.Input['PolicyStoreDeletionProtectionArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input['PolicyStoreSchemaDefinitionArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a PolicyStore resource.
        :param pulumi.Input['PolicyStoreValidationSettingsArgs'] validation_settings: Specifies the validation setting for this policy store.
               
               Currently, the only valid and required value is `Mode` .
               
               > We recommend that you turn on `STRICT` mode only after you define a schema. If a schema doesn't exist, then `STRICT` mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) . Then, when you have a schema defined, use [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) again to turn validation back on.
        :param pulumi.Input['PolicyStoreDeletionProtectionArgs'] deletion_protection: Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.
               
               The default state is `DISABLED` .
        :param pulumi.Input[builtins.str] description: Descriptive text that you can provide to help with identification of the current policy store.
        :param pulumi.Input['PolicyStoreSchemaDefinitionArgs'] schema: Creates or updates the policy schema in a policy store. Cedar can use the schema to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The tags to add to the policy store
        """
        pulumi.set(__self__, "validation_settings", validation_settings)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Input['PolicyStoreValidationSettingsArgs']:
        """
        Specifies the validation setting for this policy store.

        Currently, the only valid and required value is `Mode` .

        > We recommend that you turn on `STRICT` mode only after you define a schema. If a schema doesn't exist, then `STRICT` mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) . Then, when you have a schema defined, use [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) again to turn validation back on.
        """
        return pulumi.get(self, "validation_settings")

    @validation_settings.setter
    def validation_settings(self, value: pulumi.Input['PolicyStoreValidationSettingsArgs']):
        pulumi.set(self, "validation_settings", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input['PolicyStoreDeletionProtectionArgs']]:
        """
        Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.

        The default state is `DISABLED` .
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input['PolicyStoreDeletionProtectionArgs']]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Descriptive text that you can provide to help with identification of the current policy store.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input['PolicyStoreSchemaDefinitionArgs']]:
        """
        Creates or updates the policy schema in a policy store. Cedar can use the schema to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input['PolicyStoreSchemaDefinitionArgs']]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The tags to add to the policy store
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:verifiedpermissions:PolicyStore")
class PolicyStore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[Union['PolicyStoreDeletionProtectionArgs', 'PolicyStoreDeletionProtectionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[Union['PolicyStoreSchemaDefinitionArgs', 'PolicyStoreSchemaDefinitionArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 validation_settings: Optional[pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']]] = None,
                 __props__=None):
        """
        Represents a policy store that you can place schema, policies, and policy templates in to validate authorization requests

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_policy_store = aws_native.verifiedpermissions.PolicyStore("myPolicyStore",
            schema={
                "cedar_json": "{\\"PhotoApp\\":{\\"commonTypes\\":{\\"PersonType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"age\\":{\\"type\\":\\"Long\\"},\\"name\\":{\\"type\\":\\"String\\"}}},\\"ContextType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"ip\\":{\\"type\\":\\"Extension\\",\\"name\\":\\"ipaddr\\",\\"required\\":false},\\"authenticated\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}}},\\"entityTypes\\":{\\"User\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"userId\\":{\\"type\\":\\"String\\"},\\"personInformation\\":{\\"type\\":\\"PersonType\\"}}},\\"memberOfTypes\\":[\\"UserGroup\\"]},\\"UserGroup\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Photo\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"account\\":{\\"type\\":\\"Entity\\",\\"name\\":\\"Account\\",\\"required\\":true},\\"private\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}},\\"memberOfTypes\\":[\\"Album\\",\\"Account\\"]},\\"Album\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Account\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}}},\\"actions\\":{\\"viewPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"createPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"listPhotos\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}}}}}",
            },
            validation_settings={
                "mode": aws_native.verifiedpermissions.PolicyStoreValidationMode.STRICT,
            })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['PolicyStoreDeletionProtectionArgs', 'PolicyStoreDeletionProtectionArgsDict']] deletion_protection: Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.
               
               The default state is `DISABLED` .
        :param pulumi.Input[builtins.str] description: Descriptive text that you can provide to help with identification of the current policy store.
        :param pulumi.Input[Union['PolicyStoreSchemaDefinitionArgs', 'PolicyStoreSchemaDefinitionArgsDict']] schema: Creates or updates the policy schema in a policy store. Cedar can use the schema to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The tags to add to the policy store
        :param pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']] validation_settings: Specifies the validation setting for this policy store.
               
               Currently, the only valid and required value is `Mode` .
               
               > We recommend that you turn on `STRICT` mode only after you define a schema. If a schema doesn't exist, then `STRICT` mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) . Then, when you have a schema defined, use [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) again to turn validation back on.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyStoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a policy store that you can place schema, policies, and policy templates in to validate authorization requests

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_policy_store = aws_native.verifiedpermissions.PolicyStore("myPolicyStore",
            schema={
                "cedar_json": "{\\"PhotoApp\\":{\\"commonTypes\\":{\\"PersonType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"age\\":{\\"type\\":\\"Long\\"},\\"name\\":{\\"type\\":\\"String\\"}}},\\"ContextType\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"ip\\":{\\"type\\":\\"Extension\\",\\"name\\":\\"ipaddr\\",\\"required\\":false},\\"authenticated\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}}},\\"entityTypes\\":{\\"User\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"userId\\":{\\"type\\":\\"String\\"},\\"personInformation\\":{\\"type\\":\\"PersonType\\"}}},\\"memberOfTypes\\":[\\"UserGroup\\"]},\\"UserGroup\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Photo\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{\\"account\\":{\\"type\\":\\"Entity\\",\\"name\\":\\"Account\\",\\"required\\":true},\\"private\\":{\\"type\\":\\"Boolean\\",\\"required\\":true}}},\\"memberOfTypes\\":[\\"Album\\",\\"Account\\"]},\\"Album\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}},\\"Account\\":{\\"shape\\":{\\"type\\":\\"Record\\",\\"attributes\\":{}}}},\\"actions\\":{\\"viewPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"createPhoto\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}},\\"listPhotos\\":{\\"appliesTo\\":{\\"principalTypes\\":[\\"User\\",\\"UserGroup\\"],\\"resourceTypes\\":[\\"Photo\\"],\\"context\\":{\\"type\\":\\"ContextType\\"}}}}}}",
            },
            validation_settings={
                "mode": aws_native.verifiedpermissions.PolicyStoreValidationMode.STRICT,
            })

        ```

        :param str resource_name: The name of the resource.
        :param PolicyStoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyStoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[Union['PolicyStoreDeletionProtectionArgs', 'PolicyStoreDeletionProtectionArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 schema: Optional[pulumi.Input[Union['PolicyStoreSchemaDefinitionArgs', 'PolicyStoreSchemaDefinitionArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 validation_settings: Optional[pulumi.Input[Union['PolicyStoreValidationSettingsArgs', 'PolicyStoreValidationSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyStoreArgs.__new__(PolicyStoreArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["schema"] = schema
            __props__.__dict__["tags"] = tags
            if validation_settings is None and not opts.urn:
                raise TypeError("Missing required property 'validation_settings'")
            __props__.__dict__["validation_settings"] = validation_settings
            __props__.__dict__["arn"] = None
            __props__.__dict__["policy_store_id"] = None
        super(PolicyStore, __self__).__init__(
            'aws-native:verifiedpermissions:PolicyStore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'PolicyStore':
        """
        Get an existing PolicyStore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = PolicyStoreArgs.__new__(PolicyStoreArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["deletion_protection"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["policy_store_id"] = None
        __props__.__dict__["schema"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["validation_settings"] = None
        return PolicyStore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        The [Amazon Resource Name (ARN)](https://docs.aws.amazon.com//general/latest/gr/aws-arns-and-namespaces.html) of the new or updated policy store.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional['outputs.PolicyStoreDeletionProtection']]:
        """
        Specifies whether the policy store can be deleted. If enabled, the policy store can't be deleted.

        The default state is `DISABLED` .
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Descriptive text that you can provide to help with identification of the current policy store.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="policyStoreId")
    def policy_store_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique ID of the new or updated policy store.
        """
        return pulumi.get(self, "policy_store_id")

    @property
    @pulumi.getter
    def schema(self) -> pulumi.Output[Optional['outputs.PolicyStoreSchemaDefinition']]:
        """
        Creates or updates the policy schema in a policy store. Cedar can use the schema to validate any Cedar policies and policy templates submitted to the policy store. Any changes to the schema validate only policies and templates submitted after the schema change. Existing policies and templates are not re-evaluated against the changed schema. If you later update a policy, then it is evaluated against the new schema at that time.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The tags to add to the policy store
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="validationSettings")
    def validation_settings(self) -> pulumi.Output['outputs.PolicyStoreValidationSettings']:
        """
        Specifies the validation setting for this policy store.

        Currently, the only valid and required value is `Mode` .

        > We recommend that you turn on `STRICT` mode only after you define a schema. If a schema doesn't exist, then `STRICT` mode causes any policy to fail validation, and Verified Permissions rejects the policy. You can turn off validation by using the [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) . Then, when you have a schema defined, use [UpdatePolicyStore](https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore) again to turn validation back on.
        """
        return pulumi.get(self, "validation_settings")

