# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPolicyTemplateResult',
    'AwaitableGetPolicyTemplateResult',
    'get_policy_template',
    'get_policy_template_output',
]

@pulumi.output_type
class GetPolicyTemplateResult:
    def __init__(__self__, description=None, policy_template_id=None, statement=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if policy_template_id and not isinstance(policy_template_id, str):
            raise TypeError("Expected argument 'policy_template_id' to be a str")
        pulumi.set(__self__, "policy_template_id", policy_template_id)
        if statement and not isinstance(statement, str):
            raise TypeError("Expected argument 'statement' to be a str")
        pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description to attach to the new or updated policy template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="policyTemplateId")
    def policy_template_id(self) -> Optional[builtins.str]:
        """
        The unique identifier of the new or modified policy template.
        """
        return pulumi.get(self, "policy_template_id")

    @property
    @pulumi.getter
    def statement(self) -> Optional[builtins.str]:
        """
        Specifies the content that you want to use for the new policy template, written in the Cedar policy language.
        """
        return pulumi.get(self, "statement")


class AwaitableGetPolicyTemplateResult(GetPolicyTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPolicyTemplateResult(
            description=self.description,
            policy_template_id=self.policy_template_id,
            statement=self.statement)


def get_policy_template(policy_store_id: Optional[builtins.str] = None,
                        policy_template_id: Optional[builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPolicyTemplateResult:
    """
    Definition of AWS::VerifiedPermissions::PolicyTemplate Resource Type


    :param builtins.str policy_store_id: The unique identifier of the policy store that contains the template.
    :param builtins.str policy_template_id: The unique identifier of the new or modified policy template.
    """
    __args__ = dict()
    __args__['policyStoreId'] = policy_store_id
    __args__['policyTemplateId'] = policy_template_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:verifiedpermissions:getPolicyTemplate', __args__, opts=opts, typ=GetPolicyTemplateResult).value

    return AwaitableGetPolicyTemplateResult(
        description=pulumi.get(__ret__, 'description'),
        policy_template_id=pulumi.get(__ret__, 'policy_template_id'),
        statement=pulumi.get(__ret__, 'statement'))
def get_policy_template_output(policy_store_id: Optional[pulumi.Input[builtins.str]] = None,
                               policy_template_id: Optional[pulumi.Input[builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPolicyTemplateResult]:
    """
    Definition of AWS::VerifiedPermissions::PolicyTemplate Resource Type


    :param builtins.str policy_store_id: The unique identifier of the policy store that contains the template.
    :param builtins.str policy_template_id: The unique identifier of the new or modified policy template.
    """
    __args__ = dict()
    __args__['policyStoreId'] = policy_store_id
    __args__['policyTemplateId'] = policy_template_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:verifiedpermissions:getPolicyTemplate', __args__, opts=opts, typ=GetPolicyTemplateResult)
    return __ret__.apply(lambda __response__: GetPolicyTemplateResult(
        description=pulumi.get(__response__, 'description'),
        policy_template_id=pulumi.get(__response__, 'policy_template_id'),
        statement=pulumi.get(__response__, 'statement')))
