# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['WebAppArgs', 'WebApp']

@pulumi.input_type
class WebAppArgs:
    def __init__(__self__, *,
                 identity_provider_details: pulumi.Input['WebAppIdentityProviderDetailsArgs'],
                 access_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 web_app_customization: Optional[pulumi.Input['WebAppCustomizationArgs']] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input['WebAppEndpointPolicy']] = None,
                 web_app_units: Optional[pulumi.Input['WebAppUnitsPropertiesArgs']] = None):
        """
        The set of arguments for constructing a WebApp resource.
        :param pulumi.Input['WebAppIdentityProviderDetailsArgs'] identity_provider_details: You can provide a structure that contains the details for the identity provider to use with your web app.
               
               For more details about this parameter, see [Configure your identity provider for Transfer Family web apps](https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html) .
        :param pulumi.Input[builtins.str] access_endpoint: The AccessEndpoint is the URL that you provide to your users for them to interact with the Transfer Family web app. You can specify a custom URL or use the default value.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Key-value pairs that can be used to group and search for web apps.
        :param pulumi.Input['WebAppCustomizationArgs'] web_app_customization: A structure that contains the customization fields for the web app. You can provide a title, logo, and icon to customize the appearance of your web app.
        :param pulumi.Input['WebAppEndpointPolicy'] web_app_endpoint_policy: Setting for the type of endpoint policy for the web app. The default value is `STANDARD` .
               
               If your web app was created in an AWS GovCloud (US) Region , the value of this parameter can be `FIPS` , which indicates the web app endpoint is FIPS-compliant.
        :param pulumi.Input['WebAppUnitsPropertiesArgs'] web_app_units: A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if access_endpoint is not None:
            pulumi.set(__self__, "access_endpoint", access_endpoint)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if web_app_customization is not None:
            pulumi.set(__self__, "web_app_customization", web_app_customization)
        if web_app_endpoint_policy is not None:
            pulumi.set(__self__, "web_app_endpoint_policy", web_app_endpoint_policy)
        if web_app_units is not None:
            pulumi.set(__self__, "web_app_units", web_app_units)

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Input['WebAppIdentityProviderDetailsArgs']:
        """
        You can provide a structure that contains the details for the identity provider to use with your web app.

        For more details about this parameter, see [Configure your identity provider for Transfer Family web apps](https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html) .
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: pulumi.Input['WebAppIdentityProviderDetailsArgs']):
        pulumi.set(self, "identity_provider_details", value)

    @property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AccessEndpoint is the URL that you provide to your users for them to interact with the Transfer Family web app. You can specify a custom URL or use the default value.
        """
        return pulumi.get(self, "access_endpoint")

    @access_endpoint.setter
    def access_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "access_endpoint", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Key-value pairs that can be used to group and search for web apps.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="webAppCustomization")
    def web_app_customization(self) -> Optional[pulumi.Input['WebAppCustomizationArgs']]:
        """
        A structure that contains the customization fields for the web app. You can provide a title, logo, and icon to customize the appearance of your web app.
        """
        return pulumi.get(self, "web_app_customization")

    @web_app_customization.setter
    def web_app_customization(self, value: Optional[pulumi.Input['WebAppCustomizationArgs']]):
        pulumi.set(self, "web_app_customization", value)

    @property
    @pulumi.getter(name="webAppEndpointPolicy")
    def web_app_endpoint_policy(self) -> Optional[pulumi.Input['WebAppEndpointPolicy']]:
        """
        Setting for the type of endpoint policy for the web app. The default value is `STANDARD` .

        If your web app was created in an AWS GovCloud (US) Region , the value of this parameter can be `FIPS` , which indicates the web app endpoint is FIPS-compliant.
        """
        return pulumi.get(self, "web_app_endpoint_policy")

    @web_app_endpoint_policy.setter
    def web_app_endpoint_policy(self, value: Optional[pulumi.Input['WebAppEndpointPolicy']]):
        pulumi.set(self, "web_app_endpoint_policy", value)

    @property
    @pulumi.getter(name="webAppUnits")
    def web_app_units(self) -> Optional[pulumi.Input['WebAppUnitsPropertiesArgs']]:
        """
        A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        return pulumi.get(self, "web_app_units")

    @web_app_units.setter
    def web_app_units(self, value: Optional[pulumi.Input['WebAppUnitsPropertiesArgs']]):
        pulumi.set(self, "web_app_units", value)


@pulumi.type_token("aws-native:transfer:WebApp")
class WebApp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 web_app_customization: Optional[pulumi.Input[Union['WebAppCustomizationArgs', 'WebAppCustomizationArgsDict']]] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input['WebAppEndpointPolicy']] = None,
                 web_app_units: Optional[pulumi.Input[Union['WebAppUnitsPropertiesArgs', 'WebAppUnitsPropertiesArgsDict']]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Transfer::WebApp

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] access_endpoint: The AccessEndpoint is the URL that you provide to your users for them to interact with the Transfer Family web app. You can specify a custom URL or use the default value.
        :param pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']] identity_provider_details: You can provide a structure that contains the details for the identity provider to use with your web app.
               
               For more details about this parameter, see [Configure your identity provider for Transfer Family web apps](https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html) .
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Key-value pairs that can be used to group and search for web apps.
        :param pulumi.Input[Union['WebAppCustomizationArgs', 'WebAppCustomizationArgsDict']] web_app_customization: A structure that contains the customization fields for the web app. You can provide a title, logo, and icon to customize the appearance of your web app.
        :param pulumi.Input['WebAppEndpointPolicy'] web_app_endpoint_policy: Setting for the type of endpoint policy for the web app. The default value is `STANDARD` .
               
               If your web app was created in an AWS GovCloud (US) Region , the value of this parameter can be `FIPS` , which indicates the web app endpoint is FIPS-compliant.
        :param pulumi.Input[Union['WebAppUnitsPropertiesArgs', 'WebAppUnitsPropertiesArgsDict']] web_app_units: A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WebAppArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Transfer::WebApp

        :param str resource_name: The name of the resource.
        :param WebAppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WebAppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 identity_provider_details: Optional[pulumi.Input[Union['WebAppIdentityProviderDetailsArgs', 'WebAppIdentityProviderDetailsArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 web_app_customization: Optional[pulumi.Input[Union['WebAppCustomizationArgs', 'WebAppCustomizationArgsDict']]] = None,
                 web_app_endpoint_policy: Optional[pulumi.Input['WebAppEndpointPolicy']] = None,
                 web_app_units: Optional[pulumi.Input[Union['WebAppUnitsPropertiesArgs', 'WebAppUnitsPropertiesArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WebAppArgs.__new__(WebAppArgs)

            __props__.__dict__["access_endpoint"] = access_endpoint
            if identity_provider_details is None and not opts.urn:
                raise TypeError("Missing required property 'identity_provider_details'")
            __props__.__dict__["identity_provider_details"] = identity_provider_details
            __props__.__dict__["tags"] = tags
            __props__.__dict__["web_app_customization"] = web_app_customization
            __props__.__dict__["web_app_endpoint_policy"] = web_app_endpoint_policy
            __props__.__dict__["web_app_units"] = web_app_units
            __props__.__dict__["arn"] = None
            __props__.__dict__["web_app_id"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["identityProviderDetails.instanceArn", "webAppEndpointPolicy"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(WebApp, __self__).__init__(
            'aws-native:transfer:WebApp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WebApp':
        """
        Get an existing WebApp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = WebAppArgs.__new__(WebAppArgs)

        __props__.__dict__["access_endpoint"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["identity_provider_details"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["web_app_customization"] = None
        __props__.__dict__["web_app_endpoint_policy"] = None
        __props__.__dict__["web_app_id"] = None
        __props__.__dict__["web_app_units"] = None
        return WebApp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The AccessEndpoint is the URL that you provide to your users for them to interact with the Transfer Family web app. You can specify a custom URL or use the default value.
        """
        return pulumi.get(self, "access_endpoint")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the unique Amazon Resource Name (ARN) for the web app.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Output['outputs.WebAppIdentityProviderDetails']:
        """
        You can provide a structure that contains the details for the identity provider to use with your web app.

        For more details about this parameter, see [Configure your identity provider for Transfer Family web apps](https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html) .
        """
        return pulumi.get(self, "identity_provider_details")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Key-value pairs that can be used to group and search for web apps.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="webAppCustomization")
    def web_app_customization(self) -> pulumi.Output[Optional['outputs.WebAppCustomization']]:
        """
        A structure that contains the customization fields for the web app. You can provide a title, logo, and icon to customize the appearance of your web app.
        """
        return pulumi.get(self, "web_app_customization")

    @property
    @pulumi.getter(name="webAppEndpointPolicy")
    def web_app_endpoint_policy(self) -> pulumi.Output[Optional['WebAppEndpointPolicy']]:
        """
        Setting for the type of endpoint policy for the web app. The default value is `STANDARD` .

        If your web app was created in an AWS GovCloud (US) Region , the value of this parameter can be `FIPS` , which indicates the web app endpoint is FIPS-compliant.
        """
        return pulumi.get(self, "web_app_endpoint_policy")

    @property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> pulumi.Output[builtins.str]:
        """
        A unique identifier for the web app.
        """
        return pulumi.get(self, "web_app_id")

    @property
    @pulumi.getter(name="webAppUnits")
    def web_app_units(self) -> pulumi.Output[Optional['outputs.WebAppUnitsProperties']]:
        """
        A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        return pulumi.get(self, "web_app_units")

