# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ServerArgs', 'Server']

@pulumi.input_type
class ServerArgs:
    def __init__(__self__, *,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input['ServerDomain']] = None,
                 endpoint_details: Optional[pulumi.Input['ServerEndpointDetailsArgs']] = None,
                 endpoint_type: Optional[pulumi.Input['ServerEndpointType']] = None,
                 identity_provider_details: Optional[pulumi.Input['ServerIdentityProviderDetailsArgs']] = None,
                 identity_provider_type: Optional[pulumi.Input['ServerIdentityProviderType']] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[builtins.str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_details: Optional[pulumi.Input['ServerProtocolDetailsArgs']] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]]] = None,
                 s3_storage_options: Optional[pulumi.Input['ServerS3StorageOptionsArgs']] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None,
                 workflow_details: Optional[pulumi.Input['ServerWorkflowDetailsArgs']] = None):
        """
        The set of arguments for constructing a Server resource.
        :param pulumi.Input[builtins.str] certificate: The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS` .
               
               To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the *AWS Certificate Manager User Guide* .
               
               To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .
               
               To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the *AWS Certificate Manager User Guide* .
               
               Certificates with the following cryptographic algorithms and key sizes are supported:
               
               - 2048-bit RSA (RSA_2048)
               - 4096-bit RSA (RSA_4096)
               - Elliptic Prime Curve 256 bit (EC_prime256v1)
               - Elliptic Prime Curve 384 bit (EC_secp384r1)
               - Elliptic Prime Curve 521 bit (EC_secp521r1)
               
               > The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
        :param pulumi.Input['ServerDomain'] domain: Specifies the domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.
        :param pulumi.Input['ServerEndpointDetailsArgs'] endpoint_details: The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
        :param pulumi.Input['ServerEndpointType'] endpoint_type: The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
               
               > After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your AWS account if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your AWS account on or before May 19, 2021, you will not be affected. After this date, use `EndpointType` = `VPC` .
               > 
               > For more information, see [Discontinuing the use of VPC_ENDPOINT](https://docs.aws.amazon.com//transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint) .
               > 
               > It is recommended that you use `VPC` as the `EndpointType` . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT` .
        :param pulumi.Input['ServerIdentityProviderDetailsArgs'] identity_provider_details: Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` , `AWS _LAMBDA` or `API_GATEWAY` . Accepts an array containing all of the information required to use a directory in `AWS_DIRECTORY_SERVICE` or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when `IdentityProviderType` is set to `SERVICE_MANAGED` .
        :param pulumi.Input['ServerIdentityProviderType'] identity_provider_type: The mode of authentication for a server. The default value is `SERVICE_MANAGED` , which allows you to store and access user credentials within the AWS Transfer Family service.
               
               Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in AWS Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.
               
               Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.
               
               Use the `AWS_LAMBDA` value to directly use an AWS Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter for the `IdentityProviderDetails` data type.
        :param pulumi.Input[builtins.str] logging_role: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, you can view user activity in your CloudWatch logs.
        :param pulumi.Input[builtins.str] post_authentication_login_banner: Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.
               
               > The SFTP protocol does not support post-authentication display banners.
        :param pulumi.Input[builtins.str] pre_authentication_login_banner: Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:
               
               `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
        :param pulumi.Input['ServerProtocolDetailsArgs'] protocol_details: The protocol settings that are configured for your server.
               
               - To indicate passive mode (for FTP and FTPS protocols), use the `PassiveIp` parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
               - To ignore the error that is generated when the client attempts to use the `SETSTAT` command on a file that you are uploading to an Amazon S3 bucket, use the `SetStatOption` parameter. To have the AWS Transfer Family server ignore the `SETSTAT` command and upload files without needing to make any changes to your SFTP client, set the value to `ENABLE_NO_OP` . If you set the `SetStatOption` parameter to `ENABLE_NO_OP` , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a `SETSTAT` call.
               - To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the `TlsSessionResumptionMode` parameter.
               - `As2Transports` indicates the transport method for the AS2 messages. Currently, only HTTP is supported.
               
               The `Protocols` parameter is an array of strings.
               
               *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        :param pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]] protocols: Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:
               
               - `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
               - `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
               - `FTP` (File Transfer Protocol): Unencrypted file transfer
               - `AS2` (Applicability Statement 2): used for transporting structured business-to-business data
               
               > - If you select `FTPS` , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
               > - If `Protocol` includes either `FTP` or `FTPS` , then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be either `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
               > - If `Protocol` includes `FTP` , then `AddressAllocationIds` cannot be associated.
               > - If `Protocol` is set only to `SFTP` , the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set any of the supported identity types: `SERVICE_MANAGED` , `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
               > - If `Protocol` includes `AS2` , then the `EndpointType` must be `VPC` , and domain must be Amazon S3. 
               
               The `Protocols` parameter is an array of strings.
               
               *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        :param pulumi.Input['ServerS3StorageOptionsArgs'] s3_storage_options: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
               
               By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        :param pulumi.Input[builtins.str] security_policy_name: Specifies the name of the security policy for the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] structured_log_destinations: Specifies the log groups to which your server logs are sent.
               
               To specify a log group, you must provide the ARN for an existing log group. In this case, the format of the log group is as follows:
               
               `arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*`
               
               For example, `arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*`
               
               If you have previously specified a log group for a server, you can clear it, and in effect turn off structured logging, by providing an empty value for this parameter in an `update-server` call. For example:
               
               `update-server --server-id s-1234567890abcdef0 --structured-log-destinations`
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: Key-value pairs that can be used to group and search for servers.
        :param pulumi.Input['ServerWorkflowDetailsArgs'] workflow_details: Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
               
               In addition to a workflow to execute when a file is uploaded completely, `WorkflowDetails` can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
        """
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if endpoint_details is not None:
            pulumi.set(__self__, "endpoint_details", endpoint_details)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if identity_provider_details is not None:
            pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if identity_provider_type is not None:
            pulumi.set(__self__, "identity_provider_type", identity_provider_type)
        if logging_role is not None:
            pulumi.set(__self__, "logging_role", logging_role)
        if post_authentication_login_banner is not None:
            pulumi.set(__self__, "post_authentication_login_banner", post_authentication_login_banner)
        if pre_authentication_login_banner is not None:
            pulumi.set(__self__, "pre_authentication_login_banner", pre_authentication_login_banner)
        if protocol_details is not None:
            pulumi.set(__self__, "protocol_details", protocol_details)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if s3_storage_options is not None:
            pulumi.set(__self__, "s3_storage_options", s3_storage_options)
        if security_policy_name is not None:
            pulumi.set(__self__, "security_policy_name", security_policy_name)
        if structured_log_destinations is not None:
            pulumi.set(__self__, "structured_log_destinations", structured_log_destinations)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if workflow_details is not None:
            pulumi.set(__self__, "workflow_details", workflow_details)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS` .

        To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the *AWS Certificate Manager User Guide* .

        To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .

        To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the *AWS Certificate Manager User Guide* .

        Certificates with the following cryptographic algorithms and key sizes are supported:

        - 2048-bit RSA (RSA_2048)
        - 4096-bit RSA (RSA_4096)
        - Elliptic Prime Curve 256 bit (EC_prime256v1)
        - Elliptic Prime Curve 384 bit (EC_secp384r1)
        - Elliptic Prime Curve 521 bit (EC_secp521r1)

        > The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input['ServerDomain']]:
        """
        Specifies the domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input['ServerDomain']]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="endpointDetails")
    def endpoint_details(self) -> Optional[pulumi.Input['ServerEndpointDetailsArgs']]:
        """
        The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
        """
        return pulumi.get(self, "endpoint_details")

    @endpoint_details.setter
    def endpoint_details(self, value: Optional[pulumi.Input['ServerEndpointDetailsArgs']]):
        pulumi.set(self, "endpoint_details", value)

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[pulumi.Input['ServerEndpointType']]:
        """
        The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.

        > After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your AWS account if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your AWS account on or before May 19, 2021, you will not be affected. After this date, use `EndpointType` = `VPC` .
        > 
        > For more information, see [Discontinuing the use of VPC_ENDPOINT](https://docs.aws.amazon.com//transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint) .
        > 
        > It is recommended that you use `VPC` as the `EndpointType` . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT` .
        """
        return pulumi.get(self, "endpoint_type")

    @endpoint_type.setter
    def endpoint_type(self, value: Optional[pulumi.Input['ServerEndpointType']]):
        pulumi.set(self, "endpoint_type", value)

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> Optional[pulumi.Input['ServerIdentityProviderDetailsArgs']]:
        """
        Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` , `AWS _LAMBDA` or `API_GATEWAY` . Accepts an array containing all of the information required to use a directory in `AWS_DIRECTORY_SERVICE` or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when `IdentityProviderType` is set to `SERVICE_MANAGED` .
        """
        return pulumi.get(self, "identity_provider_details")

    @identity_provider_details.setter
    def identity_provider_details(self, value: Optional[pulumi.Input['ServerIdentityProviderDetailsArgs']]):
        pulumi.set(self, "identity_provider_details", value)

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> Optional[pulumi.Input['ServerIdentityProviderType']]:
        """
        The mode of authentication for a server. The default value is `SERVICE_MANAGED` , which allows you to store and access user credentials within the AWS Transfer Family service.

        Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in AWS Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.

        Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.

        Use the `AWS_LAMBDA` value to directly use an AWS Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter for the `IdentityProviderDetails` data type.
        """
        return pulumi.get(self, "identity_provider_type")

    @identity_provider_type.setter
    def identity_provider_type(self, value: Optional[pulumi.Input['ServerIdentityProviderType']]):
        pulumi.set(self, "identity_provider_type", value)

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, you can view user activity in your CloudWatch logs.
        """
        return pulumi.get(self, "logging_role")

    @logging_role.setter
    def logging_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging_role", value)

    @property
    @pulumi.getter(name="postAuthenticationLoginBanner")
    def post_authentication_login_banner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.

        > The SFTP protocol does not support post-authentication display banners.
        """
        return pulumi.get(self, "post_authentication_login_banner")

    @post_authentication_login_banner.setter
    def post_authentication_login_banner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "post_authentication_login_banner", value)

    @property
    @pulumi.getter(name="preAuthenticationLoginBanner")
    def pre_authentication_login_banner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:

        `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
        """
        return pulumi.get(self, "pre_authentication_login_banner")

    @pre_authentication_login_banner.setter
    def pre_authentication_login_banner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pre_authentication_login_banner", value)

    @property
    @pulumi.getter(name="protocolDetails")
    def protocol_details(self) -> Optional[pulumi.Input['ServerProtocolDetailsArgs']]:
        """
        The protocol settings that are configured for your server.

        - To indicate passive mode (for FTP and FTPS protocols), use the `PassiveIp` parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
        - To ignore the error that is generated when the client attempts to use the `SETSTAT` command on a file that you are uploading to an Amazon S3 bucket, use the `SetStatOption` parameter. To have the AWS Transfer Family server ignore the `SETSTAT` command and upload files without needing to make any changes to your SFTP client, set the value to `ENABLE_NO_OP` . If you set the `SetStatOption` parameter to `ENABLE_NO_OP` , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a `SETSTAT` call.
        - To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the `TlsSessionResumptionMode` parameter.
        - `As2Transports` indicates the transport method for the AS2 messages. Currently, only HTTP is supported.

        The `Protocols` parameter is an array of strings.

        *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        """
        return pulumi.get(self, "protocol_details")

    @protocol_details.setter
    def protocol_details(self, value: Optional[pulumi.Input['ServerProtocolDetailsArgs']]):
        pulumi.set(self, "protocol_details", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]]]:
        """
        Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:

        - `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
        - `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
        - `FTP` (File Transfer Protocol): Unencrypted file transfer
        - `AS2` (Applicability Statement 2): used for transporting structured business-to-business data

        > - If you select `FTPS` , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
        > - If `Protocol` includes either `FTP` or `FTPS` , then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be either `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
        > - If `Protocol` includes `FTP` , then `AddressAllocationIds` cannot be associated.
        > - If `Protocol` is set only to `SFTP` , the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set any of the supported identity types: `SERVICE_MANAGED` , `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
        > - If `Protocol` includes `AS2` , then the `EndpointType` must be `VPC` , and domain must be Amazon S3. 

        The `Protocols` parameter is an array of strings.

        *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="s3StorageOptions")
    def s3_storage_options(self) -> Optional[pulumi.Input['ServerS3StorageOptionsArgs']]:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.

        By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "s3_storage_options")

    @s3_storage_options.setter
    def s3_storage_options(self, value: Optional[pulumi.Input['ServerS3StorageOptionsArgs']]):
        pulumi.set(self, "s3_storage_options", value)

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the name of the security policy for the server.
        """
        return pulumi.get(self, "security_policy_name")

    @security_policy_name.setter
    def security_policy_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_policy_name", value)

    @property
    @pulumi.getter(name="structuredLogDestinations")
    def structured_log_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Specifies the log groups to which your server logs are sent.

        To specify a log group, you must provide the ARN for an existing log group. In this case, the format of the log group is as follows:

        `arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*`

        For example, `arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*`

        If you have previously specified a log group for a server, you can clear it, and in effect turn off structured logging, by providing an empty value for this parameter in an `update-server` call. For example:

        `update-server --server-id s-1234567890abcdef0 --structured-log-destinations`
        """
        return pulumi.get(self, "structured_log_destinations")

    @structured_log_destinations.setter
    def structured_log_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "structured_log_destinations", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        Key-value pairs that can be used to group and search for servers.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="workflowDetails")
    def workflow_details(self) -> Optional[pulumi.Input['ServerWorkflowDetailsArgs']]:
        """
        Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.

        In addition to a workflow to execute when a file is uploaded completely, `WorkflowDetails` can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
        """
        return pulumi.get(self, "workflow_details")

    @workflow_details.setter
    def workflow_details(self, value: Optional[pulumi.Input['ServerWorkflowDetailsArgs']]):
        pulumi.set(self, "workflow_details", value)


@pulumi.type_token("aws-native:transfer:Server")
class Server(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input['ServerDomain']] = None,
                 endpoint_details: Optional[pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']]] = None,
                 endpoint_type: Optional[pulumi.Input['ServerEndpointType']] = None,
                 identity_provider_details: Optional[pulumi.Input[Union['ServerIdentityProviderDetailsArgs', 'ServerIdentityProviderDetailsArgsDict']]] = None,
                 identity_provider_type: Optional[pulumi.Input['ServerIdentityProviderType']] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[builtins.str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_details: Optional[pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]]] = None,
                 s3_storage_options: Optional[pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']]] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workflow_details: Optional[pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']]] = None,
                 __props__=None):
        """
        Definition of AWS::Transfer::Server Resource Type

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_transfer_server = aws_native.transfer.Server("myTransferServer",
            endpoint_details={
                "address_allocation_ids": [
                    "AddressAllocationId-1",
                    "AddressAllocationId-2",
                ],
                "subnet_ids": [
                    "SubnetId-1",
                    "SubnetId-2",
                ],
                "vpc_id": "VpcId",
            },
            endpoint_type=aws_native.transfer.ServerEndpointType.VPC,
            logging_role="Logging-Role-ARN",
            protocols=[aws_native.transfer.ServerProtocol.SFTP],
            security_policy_name="Security-Policy-Name",
            identity_provider_details={
                "invocation_role": "Invocation-Role-ARN",
                "url": "API_GATEWAY-Invocation-URL",
            },
            identity_provider_type=aws_native.transfer.ServerIdentityProviderType.API_GATEWAY,
            tags=[{
                "key": "KeyName",
                "value": "ValueName",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_transfer_server = aws_native.transfer.Server("myTransferServer",
            endpoint_details={
                "address_allocation_ids": [
                    "AddressAllocationId-1",
                    "AddressAllocationId-2",
                ],
                "subnet_ids": [
                    "SubnetId-1",
                    "SubnetId-2",
                ],
                "vpc_id": "VpcId",
            },
            endpoint_type=aws_native.transfer.ServerEndpointType.VPC,
            logging_role="Logging-Role-ARN",
            protocols=[aws_native.transfer.ServerProtocol.SFTP],
            security_policy_name="Security-Policy-Name",
            identity_provider_details={
                "invocation_role": "Invocation-Role-ARN",
                "url": "API_GATEWAY-Invocation-URL",
            },
            identity_provider_type=aws_native.transfer.ServerIdentityProviderType.API_GATEWAY,
            tags=[{
                "key": "KeyName",
                "value": "ValueName",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        transfer_workflow = aws_native.transfer.Workflow("transferWorkflow",
            description="Transfer Family Workflows Blog",
            steps=[
                {
                    "type": aws_native.transfer.WorkflowStepType.COPY,
                    "copy_step_details": {
                        "name": "copyToUserKey",
                        "destination_file_location": {
                            "s3_file_location": {
                                "bucket": "archived-records",
                                "key": "${transfer:UserName}/",
                            },
                        },
                        "overwrite_existing": aws_native.transfer.WorkflowStepCopyStepDetailsPropertiesOverwriteExisting.TRUE,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.TAG,
                    "tag_step_details": {
                        "name": "tagFileForArchive",
                        "tags": [{
                            "key": "Archive",
                            "value": "yes",
                        }],
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.CUSTOM,
                    "custom_step_details": {
                        "name": "transferExtract",
                        "target": "arn:${AWS::Partition}:lambda:${AWS::Region}:${AWS::AccountId}:function:my-function-name",
                        "timeout_seconds": 60,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.DELETE,
                    "delete_step_details": {
                        "name": "DeleteInputFile",
                        "source_file_location": "${original.file}",
                    },
                },
            ],
            tags=[{
                "key": "Name",
                "value": "TransferFamilyWorkflows",
            }])
        sftp_server = aws_native.transfer.Server("sftpServer", workflow_details={
            "on_upload": [{
                "execution_role": "your-workflow-execution-role-arn",
                "workflow_id": transfer_workflow.workflow_id,
            }],
        })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        transfer_workflow = aws_native.transfer.Workflow("transferWorkflow",
            description="Transfer Family Workflows Blog",
            steps=[
                {
                    "type": aws_native.transfer.WorkflowStepType.COPY,
                    "copy_step_details": {
                        "name": "copyToUserKey",
                        "destination_file_location": {
                            "s3_file_location": {
                                "bucket": "archived-records",
                                "key": "${transfer:UserName}/",
                            },
                        },
                        "overwrite_existing": aws_native.transfer.WorkflowStepCopyStepDetailsPropertiesOverwriteExisting.TRUE,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.TAG,
                    "tag_step_details": {
                        "name": "tagFileForArchive",
                        "tags": [{
                            "key": "Archive",
                            "value": "yes",
                        }],
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.CUSTOM,
                    "custom_step_details": {
                        "name": "transferExtract",
                        "target": "arn:${AWS::Partition}:lambda:${AWS::Region}:${AWS::AccountId}:function:my-function-name",
                        "timeout_seconds": 60,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.DELETE,
                    "delete_step_details": {
                        "name": "DeleteInputFile",
                        "source_file_location": "${original.file}",
                    },
                },
            ],
            tags=[{
                "key": "Name",
                "value": "TransferFamilyWorkflows",
            }])
        sftp_server = aws_native.transfer.Server("sftpServer", workflow_details={
            "on_upload": [{
                "execution_role": "your-workflow-execution-role-arn",
                "workflow_id": transfer_workflow.workflow_id,
            }],
        })

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] certificate: The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS` .
               
               To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the *AWS Certificate Manager User Guide* .
               
               To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .
               
               To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the *AWS Certificate Manager User Guide* .
               
               Certificates with the following cryptographic algorithms and key sizes are supported:
               
               - 2048-bit RSA (RSA_2048)
               - 4096-bit RSA (RSA_4096)
               - Elliptic Prime Curve 256 bit (EC_prime256v1)
               - Elliptic Prime Curve 384 bit (EC_secp384r1)
               - Elliptic Prime Curve 521 bit (EC_secp521r1)
               
               > The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
        :param pulumi.Input['ServerDomain'] domain: Specifies the domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.
        :param pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']] endpoint_details: The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
        :param pulumi.Input['ServerEndpointType'] endpoint_type: The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
               
               > After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your AWS account if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your AWS account on or before May 19, 2021, you will not be affected. After this date, use `EndpointType` = `VPC` .
               > 
               > For more information, see [Discontinuing the use of VPC_ENDPOINT](https://docs.aws.amazon.com//transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint) .
               > 
               > It is recommended that you use `VPC` as the `EndpointType` . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT` .
        :param pulumi.Input[Union['ServerIdentityProviderDetailsArgs', 'ServerIdentityProviderDetailsArgsDict']] identity_provider_details: Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` , `AWS _LAMBDA` or `API_GATEWAY` . Accepts an array containing all of the information required to use a directory in `AWS_DIRECTORY_SERVICE` or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when `IdentityProviderType` is set to `SERVICE_MANAGED` .
        :param pulumi.Input['ServerIdentityProviderType'] identity_provider_type: The mode of authentication for a server. The default value is `SERVICE_MANAGED` , which allows you to store and access user credentials within the AWS Transfer Family service.
               
               Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in AWS Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.
               
               Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.
               
               Use the `AWS_LAMBDA` value to directly use an AWS Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter for the `IdentityProviderDetails` data type.
        :param pulumi.Input[builtins.str] logging_role: The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, you can view user activity in your CloudWatch logs.
        :param pulumi.Input[builtins.str] post_authentication_login_banner: Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.
               
               > The SFTP protocol does not support post-authentication display banners.
        :param pulumi.Input[builtins.str] pre_authentication_login_banner: Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:
               
               `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
        :param pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']] protocol_details: The protocol settings that are configured for your server.
               
               - To indicate passive mode (for FTP and FTPS protocols), use the `PassiveIp` parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
               - To ignore the error that is generated when the client attempts to use the `SETSTAT` command on a file that you are uploading to an Amazon S3 bucket, use the `SetStatOption` parameter. To have the AWS Transfer Family server ignore the `SETSTAT` command and upload files without needing to make any changes to your SFTP client, set the value to `ENABLE_NO_OP` . If you set the `SetStatOption` parameter to `ENABLE_NO_OP` , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a `SETSTAT` call.
               - To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the `TlsSessionResumptionMode` parameter.
               - `As2Transports` indicates the transport method for the AS2 messages. Currently, only HTTP is supported.
               
               The `Protocols` parameter is an array of strings.
               
               *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        :param pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]] protocols: Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:
               
               - `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
               - `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
               - `FTP` (File Transfer Protocol): Unencrypted file transfer
               - `AS2` (Applicability Statement 2): used for transporting structured business-to-business data
               
               > - If you select `FTPS` , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
               > - If `Protocol` includes either `FTP` or `FTPS` , then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be either `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
               > - If `Protocol` includes `FTP` , then `AddressAllocationIds` cannot be associated.
               > - If `Protocol` is set only to `SFTP` , the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set any of the supported identity types: `SERVICE_MANAGED` , `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
               > - If `Protocol` includes `AS2` , then the `EndpointType` must be `VPC` , and domain must be Amazon S3. 
               
               The `Protocols` parameter is an array of strings.
               
               *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        :param pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']] s3_storage_options: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
               
               By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        :param pulumi.Input[builtins.str] security_policy_name: Specifies the name of the security policy for the server.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] structured_log_destinations: Specifies the log groups to which your server logs are sent.
               
               To specify a log group, you must provide the ARN for an existing log group. In this case, the format of the log group is as follows:
               
               `arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*`
               
               For example, `arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*`
               
               If you have previously specified a log group for a server, you can clear it, and in effect turn off structured logging, by providing an empty value for this parameter in an `update-server` call. For example:
               
               `update-server --server-id s-1234567890abcdef0 --structured-log-destinations`
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: Key-value pairs that can be used to group and search for servers.
        :param pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']] workflow_details: Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
               
               In addition to a workflow to execute when a file is uploaded completely, `WorkflowDetails` can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ServerArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::Transfer::Server Resource Type

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_transfer_server = aws_native.transfer.Server("myTransferServer",
            endpoint_details={
                "address_allocation_ids": [
                    "AddressAllocationId-1",
                    "AddressAllocationId-2",
                ],
                "subnet_ids": [
                    "SubnetId-1",
                    "SubnetId-2",
                ],
                "vpc_id": "VpcId",
            },
            endpoint_type=aws_native.transfer.ServerEndpointType.VPC,
            logging_role="Logging-Role-ARN",
            protocols=[aws_native.transfer.ServerProtocol.SFTP],
            security_policy_name="Security-Policy-Name",
            identity_provider_details={
                "invocation_role": "Invocation-Role-ARN",
                "url": "API_GATEWAY-Invocation-URL",
            },
            identity_provider_type=aws_native.transfer.ServerIdentityProviderType.API_GATEWAY,
            tags=[{
                "key": "KeyName",
                "value": "ValueName",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_transfer_server = aws_native.transfer.Server("myTransferServer",
            endpoint_details={
                "address_allocation_ids": [
                    "AddressAllocationId-1",
                    "AddressAllocationId-2",
                ],
                "subnet_ids": [
                    "SubnetId-1",
                    "SubnetId-2",
                ],
                "vpc_id": "VpcId",
            },
            endpoint_type=aws_native.transfer.ServerEndpointType.VPC,
            logging_role="Logging-Role-ARN",
            protocols=[aws_native.transfer.ServerProtocol.SFTP],
            security_policy_name="Security-Policy-Name",
            identity_provider_details={
                "invocation_role": "Invocation-Role-ARN",
                "url": "API_GATEWAY-Invocation-URL",
            },
            identity_provider_type=aws_native.transfer.ServerIdentityProviderType.API_GATEWAY,
            tags=[{
                "key": "KeyName",
                "value": "ValueName",
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        transfer_workflow = aws_native.transfer.Workflow("transferWorkflow",
            description="Transfer Family Workflows Blog",
            steps=[
                {
                    "type": aws_native.transfer.WorkflowStepType.COPY,
                    "copy_step_details": {
                        "name": "copyToUserKey",
                        "destination_file_location": {
                            "s3_file_location": {
                                "bucket": "archived-records",
                                "key": "${transfer:UserName}/",
                            },
                        },
                        "overwrite_existing": aws_native.transfer.WorkflowStepCopyStepDetailsPropertiesOverwriteExisting.TRUE,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.TAG,
                    "tag_step_details": {
                        "name": "tagFileForArchive",
                        "tags": [{
                            "key": "Archive",
                            "value": "yes",
                        }],
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.CUSTOM,
                    "custom_step_details": {
                        "name": "transferExtract",
                        "target": "arn:${AWS::Partition}:lambda:${AWS::Region}:${AWS::AccountId}:function:my-function-name",
                        "timeout_seconds": 60,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.DELETE,
                    "delete_step_details": {
                        "name": "DeleteInputFile",
                        "source_file_location": "${original.file}",
                    },
                },
            ],
            tags=[{
                "key": "Name",
                "value": "TransferFamilyWorkflows",
            }])
        sftp_server = aws_native.transfer.Server("sftpServer", workflow_details={
            "on_upload": [{
                "execution_role": "your-workflow-execution-role-arn",
                "workflow_id": transfer_workflow.workflow_id,
            }],
        })

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        transfer_workflow = aws_native.transfer.Workflow("transferWorkflow",
            description="Transfer Family Workflows Blog",
            steps=[
                {
                    "type": aws_native.transfer.WorkflowStepType.COPY,
                    "copy_step_details": {
                        "name": "copyToUserKey",
                        "destination_file_location": {
                            "s3_file_location": {
                                "bucket": "archived-records",
                                "key": "${transfer:UserName}/",
                            },
                        },
                        "overwrite_existing": aws_native.transfer.WorkflowStepCopyStepDetailsPropertiesOverwriteExisting.TRUE,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.TAG,
                    "tag_step_details": {
                        "name": "tagFileForArchive",
                        "tags": [{
                            "key": "Archive",
                            "value": "yes",
                        }],
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.CUSTOM,
                    "custom_step_details": {
                        "name": "transferExtract",
                        "target": "arn:${AWS::Partition}:lambda:${AWS::Region}:${AWS::AccountId}:function:my-function-name",
                        "timeout_seconds": 60,
                    },
                },
                {
                    "type": aws_native.transfer.WorkflowStepType.DELETE,
                    "delete_step_details": {
                        "name": "DeleteInputFile",
                        "source_file_location": "${original.file}",
                    },
                },
            ],
            tags=[{
                "key": "Name",
                "value": "TransferFamilyWorkflows",
            }])
        sftp_server = aws_native.transfer.Server("sftpServer", workflow_details={
            "on_upload": [{
                "execution_role": "your-workflow-execution-role-arn",
                "workflow_id": transfer_workflow.workflow_id,
            }],
        })

        ```

        :param str resource_name: The name of the resource.
        :param ServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate: Optional[pulumi.Input[builtins.str]] = None,
                 domain: Optional[pulumi.Input['ServerDomain']] = None,
                 endpoint_details: Optional[pulumi.Input[Union['ServerEndpointDetailsArgs', 'ServerEndpointDetailsArgsDict']]] = None,
                 endpoint_type: Optional[pulumi.Input['ServerEndpointType']] = None,
                 identity_provider_details: Optional[pulumi.Input[Union['ServerIdentityProviderDetailsArgs', 'ServerIdentityProviderDetailsArgsDict']]] = None,
                 identity_provider_type: Optional[pulumi.Input['ServerIdentityProviderType']] = None,
                 logging_role: Optional[pulumi.Input[builtins.str]] = None,
                 post_authentication_login_banner: Optional[pulumi.Input[builtins.str]] = None,
                 pre_authentication_login_banner: Optional[pulumi.Input[builtins.str]] = None,
                 protocol_details: Optional[pulumi.Input[Union['ServerProtocolDetailsArgs', 'ServerProtocolDetailsArgsDict']]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input['ServerProtocol']]]] = None,
                 s3_storage_options: Optional[pulumi.Input[Union['ServerS3StorageOptionsArgs', 'ServerS3StorageOptionsArgsDict']]] = None,
                 security_policy_name: Optional[pulumi.Input[builtins.str]] = None,
                 structured_log_destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 workflow_details: Optional[pulumi.Input[Union['ServerWorkflowDetailsArgs', 'ServerWorkflowDetailsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerArgs.__new__(ServerArgs)

            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["domain"] = domain
            __props__.__dict__["endpoint_details"] = endpoint_details
            __props__.__dict__["endpoint_type"] = endpoint_type
            __props__.__dict__["identity_provider_details"] = identity_provider_details
            __props__.__dict__["identity_provider_type"] = identity_provider_type
            __props__.__dict__["logging_role"] = logging_role
            __props__.__dict__["post_authentication_login_banner"] = post_authentication_login_banner
            __props__.__dict__["pre_authentication_login_banner"] = pre_authentication_login_banner
            __props__.__dict__["protocol_details"] = protocol_details
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["s3_storage_options"] = s3_storage_options
            __props__.__dict__["security_policy_name"] = security_policy_name
            __props__.__dict__["structured_log_destinations"] = structured_log_destinations
            __props__.__dict__["tags"] = tags
            __props__.__dict__["workflow_details"] = workflow_details
            __props__.__dict__["arn"] = None
            __props__.__dict__["as2_service_managed_egress_ip_addresses"] = None
            __props__.__dict__["server_id"] = None
            __props__.__dict__["state"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["domain", "identityProviderType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Server, __self__).__init__(
            'aws-native:transfer:Server',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Server':
        """
        Get an existing Server resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ServerArgs.__new__(ServerArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["as2_service_managed_egress_ip_addresses"] = None
        __props__.__dict__["certificate"] = None
        __props__.__dict__["domain"] = None
        __props__.__dict__["endpoint_details"] = None
        __props__.__dict__["endpoint_type"] = None
        __props__.__dict__["identity_provider_details"] = None
        __props__.__dict__["identity_provider_type"] = None
        __props__.__dict__["logging_role"] = None
        __props__.__dict__["post_authentication_login_banner"] = None
        __props__.__dict__["pre_authentication_login_banner"] = None
        __props__.__dict__["protocol_details"] = None
        __props__.__dict__["protocols"] = None
        __props__.__dict__["s3_storage_options"] = None
        __props__.__dict__["security_policy_name"] = None
        __props__.__dict__["server_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["structured_log_destinations"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["workflow_details"] = None
        return Server(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the unique Amazon Resource Name (ARN) of the server.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2ServiceManagedEgressIpAddresses")
    def as2_service_managed_egress_ip_addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of egress IP addresses of this server. These IP addresses are only relevant for servers that use the AS2 protocol. They are used for sending asynchronous MDNs. These IP addresses are assigned automatically when you create an AS2 server. Additionally, if you update an existing server and add the AS2 protocol, static IP addresses are assigned as well.
        """
        return pulumi.get(self, "as2_service_managed_egress_ip_addresses")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS` .

        To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the *AWS Certificate Manager User Guide* .

        To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .

        To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the *AWS Certificate Manager User Guide* .

        Certificates with the following cryptographic algorithms and key sizes are supported:

        - 2048-bit RSA (RSA_2048)
        - 4096-bit RSA (RSA_4096)
        - Elliptic Prime Curve 256 bit (EC_prime256v1)
        - Elliptic Prime Curve 384 bit (EC_secp384r1)
        - Elliptic Prime Curve 521 bit (EC_secp521r1)

        > The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[Optional['ServerDomain']]:
        """
        Specifies the domain of the storage system that is used for file transfers. There are two domains available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The default value is S3.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="endpointDetails")
    def endpoint_details(self) -> pulumi.Output[Optional['outputs.ServerEndpointDetails']]:
        """
        The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
        """
        return pulumi.get(self, "endpoint_details")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> pulumi.Output[Optional['ServerEndpointType']]:
        """
        The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.

        > After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your AWS account if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your AWS account on or before May 19, 2021, you will not be affected. After this date, use `EndpointType` = `VPC` .
        > 
        > For more information, see [Discontinuing the use of VPC_ENDPOINT](https://docs.aws.amazon.com//transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint) .
        > 
        > It is recommended that you use `VPC` as the `EndpointType` . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT` .
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> pulumi.Output[Optional['outputs.ServerIdentityProviderDetails']]:
        """
        Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` , `AWS _LAMBDA` or `API_GATEWAY` . Accepts an array containing all of the information required to use a directory in `AWS_DIRECTORY_SERVICE` or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when `IdentityProviderType` is set to `SERVICE_MANAGED` .
        """
        return pulumi.get(self, "identity_provider_details")

    @property
    @pulumi.getter(name="identityProviderType")
    def identity_provider_type(self) -> pulumi.Output[Optional['ServerIdentityProviderType']]:
        """
        The mode of authentication for a server. The default value is `SERVICE_MANAGED` , which allows you to store and access user credentials within the AWS Transfer Family service.

        Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in AWS Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in AWS using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.

        Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.

        Use the `AWS_LAMBDA` value to directly use an AWS Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter for the `IdentityProviderDetails` data type.
        """
        return pulumi.get(self, "identity_provider_type")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, you can view user activity in your CloudWatch logs.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter(name="postAuthenticationLoginBanner")
    def post_authentication_login_banner(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.

        > The SFTP protocol does not support post-authentication display banners.
        """
        return pulumi.get(self, "post_authentication_login_banner")

    @property
    @pulumi.getter(name="preAuthenticationLoginBanner")
    def pre_authentication_login_banner(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:

        `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
        """
        return pulumi.get(self, "pre_authentication_login_banner")

    @property
    @pulumi.getter(name="protocolDetails")
    def protocol_details(self) -> pulumi.Output[Optional['outputs.ServerProtocolDetails']]:
        """
        The protocol settings that are configured for your server.

        - To indicate passive mode (for FTP and FTPS protocols), use the `PassiveIp` parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
        - To ignore the error that is generated when the client attempts to use the `SETSTAT` command on a file that you are uploading to an Amazon S3 bucket, use the `SetStatOption` parameter. To have the AWS Transfer Family server ignore the `SETSTAT` command and upload files without needing to make any changes to your SFTP client, set the value to `ENABLE_NO_OP` . If you set the `SetStatOption` parameter to `ENABLE_NO_OP` , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a `SETSTAT` call.
        - To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the `TlsSessionResumptionMode` parameter.
        - `As2Transports` indicates the transport method for the AS2 messages. Currently, only HTTP is supported.

        The `Protocols` parameter is an array of strings.

        *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        """
        return pulumi.get(self, "protocol_details")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Optional[Sequence['ServerProtocol']]]:
        """
        Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:

        - `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
        - `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
        - `FTP` (File Transfer Protocol): Unencrypted file transfer
        - `AS2` (Applicability Statement 2): used for transporting structured business-to-business data

        > - If you select `FTPS` , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
        > - If `Protocol` includes either `FTP` or `FTPS` , then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be either `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
        > - If `Protocol` includes `FTP` , then `AddressAllocationIds` cannot be associated.
        > - If `Protocol` is set only to `SFTP` , the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set any of the supported identity types: `SERVICE_MANAGED` , `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
        > - If `Protocol` includes `AS2` , then the `EndpointType` must be `VPC` , and domain must be Amazon S3. 

        The `Protocols` parameter is an array of strings.

        *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="s3StorageOptions")
    def s3_storage_options(self) -> pulumi.Output[Optional['outputs.ServerS3StorageOptions']]:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.

        By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "s3_storage_options")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Specifies the name of the security policy for the server.
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the unique system-assigned identifier for a server that you instantiate.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output['ServerState']:
        """
        The condition of the server that was described. A value of `ONLINE` indicates that the server can accept jobs and transfer files. A `State` value of `OFFLINE` means that the server cannot perform file transfer operations.

        The states of `STARTING` and `STOPPING` indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `START_FAILED` or `STOP_FAILED` can indicate an error condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="structuredLogDestinations")
    def structured_log_destinations(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Specifies the log groups to which your server logs are sent.

        To specify a log group, you must provide the ARN for an existing log group. In this case, the format of the log group is as follows:

        `arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*`

        For example, `arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*`

        If you have previously specified a log group for a server, you can clear it, and in effect turn off structured logging, by providing an empty value for this parameter in an `update-server` call. For example:

        `update-server --server-id s-1234567890abcdef0 --structured-log-destinations`
        """
        return pulumi.get(self, "structured_log_destinations")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        Key-value pairs that can be used to group and search for servers.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workflowDetails")
    def workflow_details(self) -> pulumi.Output[Optional['outputs.ServerWorkflowDetails']]:
        """
        Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.

        In addition to a workflow to execute when a file is uploaded completely, `WorkflowDetails` can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
        """
        return pulumi.get(self, "workflow_details")

