# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'As2ConfigProperties',
    'CustomDirectoriesProperties',
    'ServerEndpointDetails',
    'ServerIdentityProviderDetails',
    'ServerProtocolDetails',
    'ServerS3StorageOptions',
    'ServerWorkflowDetail',
    'ServerWorkflowDetails',
    'SftpConfigProperties',
    'UserHomeDirectoryMapEntry',
    'UserPosixProfile',
    'WebAppCustomization',
    'WebAppIdentityProviderDetails',
    'WebAppUnitsProperties',
    'WorkflowEfsInputFileLocation',
    'WorkflowInputFileLocation',
    'WorkflowS3FileLocation',
    'WorkflowS3InputFileLocation',
    'WorkflowS3Tag',
    'WorkflowStep',
    'WorkflowStepCopyStepDetailsProperties',
    'WorkflowStepCustomStepDetailsProperties',
    'WorkflowStepDecryptStepDetailsProperties',
    'WorkflowStepDeleteStepDetailsProperties',
    'WorkflowStepTagStepDetailsProperties',
]

@pulumi.output_type
class As2ConfigProperties(dict):
    """
    Configuration for an AS2 connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuthSecretId":
            suggest = "basic_auth_secret_id"
        elif key == "encryptionAlgorithm":
            suggest = "encryption_algorithm"
        elif key == "localProfileId":
            suggest = "local_profile_id"
        elif key == "mdnResponse":
            suggest = "mdn_response"
        elif key == "mdnSigningAlgorithm":
            suggest = "mdn_signing_algorithm"
        elif key == "messageSubject":
            suggest = "message_subject"
        elif key == "partnerProfileId":
            suggest = "partner_profile_id"
        elif key == "preserveContentType":
            suggest = "preserve_content_type"
        elif key == "signingAlgorithm":
            suggest = "signing_algorithm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in As2ConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        As2ConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        As2ConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth_secret_id: Optional[builtins.str] = None,
                 compression: Optional['ConnectorAs2ConfigPropertiesCompression'] = None,
                 encryption_algorithm: Optional['ConnectorAs2ConfigPropertiesEncryptionAlgorithm'] = None,
                 local_profile_id: Optional[builtins.str] = None,
                 mdn_response: Optional['ConnectorAs2ConfigPropertiesMdnResponse'] = None,
                 mdn_signing_algorithm: Optional['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm'] = None,
                 message_subject: Optional[builtins.str] = None,
                 partner_profile_id: Optional[builtins.str] = None,
                 preserve_content_type: Optional['ConnectorAs2ConfigPropertiesPreserveContentType'] = None,
                 signing_algorithm: Optional['ConnectorAs2ConfigPropertiesSigningAlgorithm'] = None):
        """
        Configuration for an AS2 connector.
        :param builtins.str basic_auth_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        :param 'ConnectorAs2ConfigPropertiesCompression' compression: Compression setting for this AS2 connector configuration.
        :param 'ConnectorAs2ConfigPropertiesEncryptionAlgorithm' encryption_algorithm: Encryption algorithm for this AS2 connector configuration.
        :param builtins.str local_profile_id: A unique identifier for the local profile.
        :param 'ConnectorAs2ConfigPropertiesMdnResponse' mdn_response: MDN Response setting for this AS2 connector configuration.
        :param 'ConnectorAs2ConfigPropertiesMdnSigningAlgorithm' mdn_signing_algorithm: MDN Signing algorithm for this AS2 connector configuration.
        :param builtins.str message_subject: The message subject for this AS2 connector configuration.
        :param builtins.str partner_profile_id: A unique identifier for the partner profile.
        :param 'ConnectorAs2ConfigPropertiesPreserveContentType' preserve_content_type: Specifies whether to use the AWS S3 object content-type as the content-type for the AS2 message.
        :param 'ConnectorAs2ConfigPropertiesSigningAlgorithm' signing_algorithm: Signing algorithm for this AS2 connector configuration.
        """
        if basic_auth_secret_id is not None:
            pulumi.set(__self__, "basic_auth_secret_id", basic_auth_secret_id)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if local_profile_id is not None:
            pulumi.set(__self__, "local_profile_id", local_profile_id)
        if mdn_response is not None:
            pulumi.set(__self__, "mdn_response", mdn_response)
        if mdn_signing_algorithm is not None:
            pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        if message_subject is not None:
            pulumi.set(__self__, "message_subject", message_subject)
        if partner_profile_id is not None:
            pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        if preserve_content_type is not None:
            pulumi.set(__self__, "preserve_content_type", preserve_content_type)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="basicAuthSecretId")
    def basic_auth_secret_id(self) -> Optional[builtins.str]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        """
        return pulumi.get(self, "basic_auth_secret_id")

    @property
    @pulumi.getter
    def compression(self) -> Optional['ConnectorAs2ConfigPropertiesCompression']:
        """
        Compression setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']:
        """
        Encryption algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "encryption_algorithm")

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> Optional['ConnectorAs2ConfigPropertiesMdnResponse']:
        """
        MDN Response setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_response")

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> Optional['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']:
        """
        MDN Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> Optional[builtins.str]:
        """
        The message subject for this AS2 connector configuration.
        """
        return pulumi.get(self, "message_subject")

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @property
    @pulumi.getter(name="preserveContentType")
    def preserve_content_type(self) -> Optional['ConnectorAs2ConfigPropertiesPreserveContentType']:
        """
        Specifies whether to use the AWS S3 object content-type as the content-type for the AS2 message.
        """
        return pulumi.get(self, "preserve_content_type")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional['ConnectorAs2ConfigPropertiesSigningAlgorithm']:
        """
        Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "signing_algorithm")


@pulumi.output_type
class CustomDirectoriesProperties(dict):
    """
    Specifies a separate directory for each type of file to store for an AS2 message.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failedFilesDirectory":
            suggest = "failed_files_directory"
        elif key == "mdnFilesDirectory":
            suggest = "mdn_files_directory"
        elif key == "payloadFilesDirectory":
            suggest = "payload_files_directory"
        elif key == "statusFilesDirectory":
            suggest = "status_files_directory"
        elif key == "temporaryFilesDirectory":
            suggest = "temporary_files_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDirectoriesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDirectoriesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDirectoriesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failed_files_directory: builtins.str,
                 mdn_files_directory: builtins.str,
                 payload_files_directory: builtins.str,
                 status_files_directory: builtins.str,
                 temporary_files_directory: builtins.str):
        """
        Specifies a separate directory for each type of file to store for an AS2 message.
        :param builtins.str failed_files_directory: Specifies a location to store the failed files for an AS2 message.
        :param builtins.str mdn_files_directory: Specifies a location to store the MDN file for an AS2 message.
        :param builtins.str payload_files_directory: Specifies a location to store the payload file for an AS2 message.
        :param builtins.str status_files_directory: Specifies a location to store the status file for an AS2 message.
        :param builtins.str temporary_files_directory: Specifies a location to store the temporary processing file for an AS2 message.
        """
        pulumi.set(__self__, "failed_files_directory", failed_files_directory)
        pulumi.set(__self__, "mdn_files_directory", mdn_files_directory)
        pulumi.set(__self__, "payload_files_directory", payload_files_directory)
        pulumi.set(__self__, "status_files_directory", status_files_directory)
        pulumi.set(__self__, "temporary_files_directory", temporary_files_directory)

    @property
    @pulumi.getter(name="failedFilesDirectory")
    def failed_files_directory(self) -> builtins.str:
        """
        Specifies a location to store the failed files for an AS2 message.
        """
        return pulumi.get(self, "failed_files_directory")

    @property
    @pulumi.getter(name="mdnFilesDirectory")
    def mdn_files_directory(self) -> builtins.str:
        """
        Specifies a location to store the MDN file for an AS2 message.
        """
        return pulumi.get(self, "mdn_files_directory")

    @property
    @pulumi.getter(name="payloadFilesDirectory")
    def payload_files_directory(self) -> builtins.str:
        """
        Specifies a location to store the payload file for an AS2 message.
        """
        return pulumi.get(self, "payload_files_directory")

    @property
    @pulumi.getter(name="statusFilesDirectory")
    def status_files_directory(self) -> builtins.str:
        """
        Specifies a location to store the status file for an AS2 message.
        """
        return pulumi.get(self, "status_files_directory")

    @property
    @pulumi.getter(name="temporaryFilesDirectory")
    def temporary_files_directory(self) -> builtins.str:
        """
        Specifies a location to store the temporary processing file for an AS2 message.
        """
        return pulumi.get(self, "temporary_files_directory")


@pulumi.output_type
class ServerEndpointDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressAllocationIds":
            suggest = "address_allocation_ids"
        elif key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "vpcEndpointId":
            suggest = "vpc_endpoint_id"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerEndpointDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerEndpointDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerEndpointDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_allocation_ids: Optional[Sequence[builtins.str]] = None,
                 security_group_ids: Optional[Sequence[builtins.str]] = None,
                 subnet_ids: Optional[Sequence[builtins.str]] = None,
                 vpc_endpoint_id: Optional[builtins.str] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] address_allocation_ids: A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
               
               An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the `allocationId` field from the Amazon EC2 [Address](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html) data type. One way to retrieve this value is by calling the EC2 [DescribeAddresses](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html) API.
               
               This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see [Create an internet-facing endpoint for your server](https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint) .
               
               > This property can only be set as follows:
               > 
               > - `EndpointType` must be set to `VPC`
               > - The Transfer Family server must be offline.
               > - You cannot set this parameter for Transfer Family servers that use the FTP protocol.
               > - The server must already have `SubnetIds` populated ( `SubnetIds` and `AddressAllocationIds` cannot be updated simultaneously).
               > - `AddressAllocationIds` can't contain duplicates, and must be equal in length to `SubnetIds` . For example, if you have three subnet IDs, you must also specify three address allocation IDs.
               > - Call the `UpdateServer` API to set or change this parameter.
        :param Sequence[builtins.str] security_group_ids: A list of security groups IDs that are available to attach to your server's endpoint.
               
               > This property can only be set when `EndpointType` is set to `VPC` .
               > 
               > You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC` . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
        :param Sequence[builtins.str] subnet_ids: A list of subnet IDs that are required to host your server endpoint in your VPC.
               
               > This property can only be set when `EndpointType` is set to `VPC` .
        :param builtins.str vpc_endpoint_id: The ID of the VPC endpoint.
               
               > This property can only be set when `EndpointType` is set to `VPC_ENDPOINT` .
        :param builtins.str vpc_id: The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.
               
               > This property can only be set when `EndpointType` is set to `VPC` .
        """
        if address_allocation_ids is not None:
            pulumi.set(__self__, "address_allocation_ids", address_allocation_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressAllocationIds")
    def address_allocation_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.

        An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the `allocationId` field from the Amazon EC2 [Address](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html) data type. One way to retrieve this value is by calling the EC2 [DescribeAddresses](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html) API.

        This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see [Create an internet-facing endpoint for your server](https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint) .

        > This property can only be set as follows:
        > 
        > - `EndpointType` must be set to `VPC`
        > - The Transfer Family server must be offline.
        > - You cannot set this parameter for Transfer Family servers that use the FTP protocol.
        > - The server must already have `SubnetIds` populated ( `SubnetIds` and `AddressAllocationIds` cannot be updated simultaneously).
        > - `AddressAllocationIds` can't contain duplicates, and must be equal in length to `SubnetIds` . For example, if you have three subnet IDs, you must also specify three address allocation IDs.
        > - Call the `UpdateServer` API to set or change this parameter.
        """
        return pulumi.get(self, "address_allocation_ids")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of security groups IDs that are available to attach to your server's endpoint.

        > This property can only be set when `EndpointType` is set to `VPC` .
        > 
        > You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC` . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of subnet IDs that are required to host your server endpoint in your VPC.

        > This property can only be set when `EndpointType` is set to `VPC` .
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[builtins.str]:
        """
        The ID of the VPC endpoint.

        > This property can only be set when `EndpointType` is set to `VPC_ENDPOINT` .
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.

        > This property can only be set when `EndpointType` is set to `VPC` .
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ServerIdentityProviderDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryId":
            suggest = "directory_id"
        elif key == "invocationRole":
            suggest = "invocation_role"
        elif key == "sftpAuthenticationMethods":
            suggest = "sftp_authentication_methods"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerIdentityProviderDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerIdentityProviderDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerIdentityProviderDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_id: Optional[builtins.str] = None,
                 function: Optional[builtins.str] = None,
                 invocation_role: Optional[builtins.str] = None,
                 sftp_authentication_methods: Optional['ServerSftpAuthenticationMethods'] = None,
                 url: Optional[builtins.str] = None):
        """
        :param builtins.str directory_id: The identifier of the AWS Directory Service directory that you want to use as your identity provider.
        :param builtins.str function: The ARN for a Lambda function to use for the Identity provider.
        :param builtins.str invocation_role: This parameter is only applicable if your `IdentityProviderType` is `API_GATEWAY` . Provides the type of `InvocationRole` used to authenticate the user account.
        :param 'ServerSftpAuthenticationMethods' sftp_authentication_methods: For SFTP-enabled servers, and for custom identity providers *only* , you can specify whether to authenticate using a password, SSH key pair, or both.
               
               - `PASSWORD` - users must provide their password to connect.
               - `PUBLIC_KEY` - users must provide their private key to connect.
               - `PUBLIC_KEY_OR_PASSWORD` - users can authenticate with either their password or their key. This is the default value.
               - `PUBLIC_KEY_AND_PASSWORD` - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.
        :param builtins.str url: Provides the location of the service endpoint used to authenticate users.
        """
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if invocation_role is not None:
            pulumi.set(__self__, "invocation_role", invocation_role)
        if sftp_authentication_methods is not None:
            pulumi.set(__self__, "sftp_authentication_methods", sftp_authentication_methods)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[builtins.str]:
        """
        The identifier of the AWS Directory Service directory that you want to use as your identity provider.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter
    def function(self) -> Optional[builtins.str]:
        """
        The ARN for a Lambda function to use for the Identity provider.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> Optional[builtins.str]:
        """
        This parameter is only applicable if your `IdentityProviderType` is `API_GATEWAY` . Provides the type of `InvocationRole` used to authenticate the user account.
        """
        return pulumi.get(self, "invocation_role")

    @property
    @pulumi.getter(name="sftpAuthenticationMethods")
    def sftp_authentication_methods(self) -> Optional['ServerSftpAuthenticationMethods']:
        """
        For SFTP-enabled servers, and for custom identity providers *only* , you can specify whether to authenticate using a password, SSH key pair, or both.

        - `PASSWORD` - users must provide their password to connect.
        - `PUBLIC_KEY` - users must provide their private key to connect.
        - `PUBLIC_KEY_OR_PASSWORD` - users can authenticate with either their password or their key. This is the default value.
        - `PUBLIC_KEY_AND_PASSWORD` - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.
        """
        return pulumi.get(self, "sftp_authentication_methods")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        Provides the location of the service endpoint used to authenticate users.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class ServerProtocolDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "as2Transports":
            suggest = "as2_transports"
        elif key == "passiveIp":
            suggest = "passive_ip"
        elif key == "setStatOption":
            suggest = "set_stat_option"
        elif key == "tlsSessionResumptionMode":
            suggest = "tls_session_resumption_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerProtocolDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerProtocolDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerProtocolDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 as2_transports: Optional[Sequence['ServerAs2Transport']] = None,
                 passive_ip: Optional[builtins.str] = None,
                 set_stat_option: Optional['ServerSetStatOption'] = None,
                 tls_session_resumption_mode: Optional['ServerTlsSessionResumptionMode'] = None):
        """
        :param Sequence['ServerAs2Transport'] as2_transports: List of `As2Transport` objects.
        :param builtins.str passive_ip: Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
               
               `aws transfer update-server --protocol-details PassiveIp=0.0.0.0`
               
               Replace `0.0.0.0` in the example above with the actual IP address you want to use.
               
               > If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family](https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/) . 
               
               *Special values*
               
               The `AUTO` and `0.0.0.0` are special values for the `PassiveIp` parameter. The value `PassiveIp=AUTO` is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. `PassiveIp=0.0.0.0` has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the `PassiveIp` parameter. This reduces the effectiveness of having High Availability. In this case, you can specify `PassiveIp=0.0.0.0` . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the `PassiveIp=0.0.0.0` response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the `PassiveIp=0.0.0.0` response.
        :param 'ServerSetStatOption' set_stat_option: Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.
               
               Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
               
               Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption` `ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.
               
               > If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT` , you can use Amazon EFS as backend storage with Transfer Family.
        :param 'ServerTlsSessionResumptionMode' tls_session_resumption_mode: A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer` , it is set to `ENFORCED` by default.
               
               - `DISABLED` : the server does not process TLS session resumption client requests and creates a new TLS session for each request.
               - `ENABLED` : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
               - `ENFORCED` : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED` , test your clients.
               
               > Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
        """
        if as2_transports is not None:
            pulumi.set(__self__, "as2_transports", as2_transports)
        if passive_ip is not None:
            pulumi.set(__self__, "passive_ip", passive_ip)
        if set_stat_option is not None:
            pulumi.set(__self__, "set_stat_option", set_stat_option)
        if tls_session_resumption_mode is not None:
            pulumi.set(__self__, "tls_session_resumption_mode", tls_session_resumption_mode)

    @property
    @pulumi.getter(name="as2Transports")
    def as2_transports(self) -> Optional[Sequence['ServerAs2Transport']]:
        """
        List of `As2Transport` objects.
        """
        return pulumi.get(self, "as2_transports")

    @property
    @pulumi.getter(name="passiveIp")
    def passive_ip(self) -> Optional[builtins.str]:
        """
        Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:

        `aws transfer update-server --protocol-details PassiveIp=0.0.0.0`

        Replace `0.0.0.0` in the example above with the actual IP address you want to use.

        > If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family](https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/) . 

        *Special values*

        The `AUTO` and `0.0.0.0` are special values for the `PassiveIp` parameter. The value `PassiveIp=AUTO` is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. `PassiveIp=0.0.0.0` has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the `PassiveIp` parameter. This reduces the effectiveness of having High Availability. In this case, you can specify `PassiveIp=0.0.0.0` . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the `PassiveIp=0.0.0.0` response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the `PassiveIp=0.0.0.0` response.
        """
        return pulumi.get(self, "passive_ip")

    @property
    @pulumi.getter(name="setStatOption")
    def set_stat_option(self) -> Optional['ServerSetStatOption']:
        """
        Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.

        Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.

        Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption` `ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.

        > If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT` , you can use Amazon EFS as backend storage with Transfer Family.
        """
        return pulumi.get(self, "set_stat_option")

    @property
    @pulumi.getter(name="tlsSessionResumptionMode")
    def tls_session_resumption_mode(self) -> Optional['ServerTlsSessionResumptionMode']:
        """
        A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer` , it is set to `ENFORCED` by default.

        - `DISABLED` : the server does not process TLS session resumption client requests and creates a new TLS session for each request.
        - `ENABLED` : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
        - `ENFORCED` : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED` , test your clients.

        > Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
        """
        return pulumi.get(self, "tls_session_resumption_mode")


@pulumi.output_type
class ServerS3StorageOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryListingOptimization":
            suggest = "directory_listing_optimization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerS3StorageOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerS3StorageOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerS3StorageOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_listing_optimization: Optional['ServerDirectoryListingOptimization'] = None):
        """
        :param 'ServerDirectoryListingOptimization' directory_listing_optimization: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
               
               By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        if directory_listing_optimization is not None:
            pulumi.set(__self__, "directory_listing_optimization", directory_listing_optimization)

    @property
    @pulumi.getter(name="directoryListingOptimization")
    def directory_listing_optimization(self) -> Optional['ServerDirectoryListingOptimization']:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.

        By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "directory_listing_optimization")


@pulumi.output_type
class ServerWorkflowDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionRole":
            suggest = "execution_role"
        elif key == "workflowId":
            suggest = "workflow_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerWorkflowDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerWorkflowDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerWorkflowDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_role: builtins.str,
                 workflow_id: builtins.str):
        """
        :param builtins.str execution_role: Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources
        :param builtins.str workflow_id: A unique identifier for the workflow.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> builtins.str:
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources
        """
        return pulumi.get(self, "execution_role")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> builtins.str:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")


@pulumi.output_type
class ServerWorkflowDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onPartialUpload":
            suggest = "on_partial_upload"
        elif key == "onUpload":
            suggest = "on_upload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServerWorkflowDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServerWorkflowDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServerWorkflowDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_partial_upload: Optional[Sequence['outputs.ServerWorkflowDetail']] = None,
                 on_upload: Optional[Sequence['outputs.ServerWorkflowDetail']] = None):
        """
        :param Sequence['ServerWorkflowDetail'] on_partial_upload: A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server that executes whenever there is a partial upload.
               
               A *partial upload* occurs when a file is open when the session disconnects.
               
               > `OnPartialUpload` can contain a maximum of one `WorkflowDetail` object.
        :param Sequence['ServerWorkflowDetail'] on_upload: A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
               
               To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.
               
               `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`
               
               > `OnUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        if on_partial_upload is not None:
            pulumi.set(__self__, "on_partial_upload", on_partial_upload)
        if on_upload is not None:
            pulumi.set(__self__, "on_upload", on_upload)

    @property
    @pulumi.getter(name="onPartialUpload")
    def on_partial_upload(self) -> Optional[Sequence['outputs.ServerWorkflowDetail']]:
        """
        A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server that executes whenever there is a partial upload.

        A *partial upload* occurs when a file is open when the session disconnects.

        > `OnPartialUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        return pulumi.get(self, "on_partial_upload")

    @property
    @pulumi.getter(name="onUpload")
    def on_upload(self) -> Optional[Sequence['outputs.ServerWorkflowDetail']]:
        """
        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.

        To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.

        `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`

        > `OnUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        return pulumi.get(self, "on_upload")


@pulumi.output_type
class SftpConfigProperties(dict):
    """
    Configuration for an SFTP connector.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trustedHostKeys":
            suggest = "trusted_host_keys"
        elif key == "userSecretId":
            suggest = "user_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SftpConfigProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SftpConfigProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SftpConfigProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trusted_host_keys: Optional[Sequence[builtins.str]] = None,
                 user_secret_id: Optional[builtins.str] = None):
        """
        Configuration for an SFTP connector.
        :param Sequence[builtins.str] trusted_host_keys: List of public host keys, for the external server to which you are connecting.
        :param builtins.str user_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        if trusted_host_keys is not None:
            pulumi.set(__self__, "trusted_host_keys", trusted_host_keys)
        if user_secret_id is not None:
            pulumi.set(__self__, "user_secret_id", user_secret_id)

    @property
    @pulumi.getter(name="trustedHostKeys")
    def trusted_host_keys(self) -> Optional[Sequence[builtins.str]]:
        """
        List of public host keys, for the external server to which you are connecting.
        """
        return pulumi.get(self, "trusted_host_keys")

    @property
    @pulumi.getter(name="userSecretId")
    def user_secret_id(self) -> Optional[builtins.str]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        return pulumi.get(self, "user_secret_id")


@pulumi.output_type
class UserHomeDirectoryMapEntry(dict):
    def __init__(__self__, *,
                 entry: builtins.str,
                 target: builtins.str,
                 type: Optional['UserMapType'] = None):
        """
        :param builtins.str entry: Represents an entry for `HomeDirectoryMappings` .
        :param builtins.str target: Represents the map target that is used in a `HomeDirectoryMapEntry` .
        :param 'UserMapType' type: Specifies the type of mapping. Set the type to `FILE` if you want the mapping to point to a file, or `DIRECTORY` for the directory to point to a directory.
               
               > By default, home directory mappings have a `Type` of `DIRECTORY` when you create a Transfer Family server. You would need to explicitly set `Type` to `FILE` if you want a mapping to have a file target.
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def entry(self) -> builtins.str:
        """
        Represents an entry for `HomeDirectoryMappings` .
        """
        return pulumi.get(self, "entry")

    @property
    @pulumi.getter
    def target(self) -> builtins.str:
        """
        Represents the map target that is used in a `HomeDirectoryMapEntry` .
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def type(self) -> Optional['UserMapType']:
        """
        Specifies the type of mapping. Set the type to `FILE` if you want the mapping to point to a file, or `DIRECTORY` for the directory to point to a directory.

        > By default, home directory mappings have a `Type` of `DIRECTORY` when you create a Transfer Family server. You would need to explicitly set `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class UserPosixProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secondaryGids":
            suggest = "secondary_gids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserPosixProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserPosixProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserPosixProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: builtins.float,
                 uid: builtins.float,
                 secondary_gids: Optional[Sequence[builtins.float]] = None):
        """
        :param builtins.float gid: The POSIX group ID used for all EFS operations by this user.
        :param builtins.float uid: The POSIX user ID used for all EFS operations by this user.
        :param Sequence[builtins.float] secondary_gids: The secondary POSIX group IDs used for all EFS operations by this user.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> builtins.float:
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def uid(self) -> builtins.float:
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[Sequence[builtins.float]]:
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
        return pulumi.get(self, "secondary_gids")


@pulumi.output_type
class WebAppCustomization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "faviconFile":
            suggest = "favicon_file"
        elif key == "logoFile":
            suggest = "logo_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAppCustomization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAppCustomization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAppCustomization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 favicon_file: Optional[builtins.str] = None,
                 logo_file: Optional[builtins.str] = None,
                 title: Optional[builtins.str] = None):
        """
        :param builtins.str favicon_file: Specifies a favicon to display in the browser tab.
        :param builtins.str logo_file: Specifies a logo to display on the web app.
        :param builtins.str title: Specifies a title to display on the web app.
        """
        if favicon_file is not None:
            pulumi.set(__self__, "favicon_file", favicon_file)
        if logo_file is not None:
            pulumi.set(__self__, "logo_file", logo_file)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="faviconFile")
    def favicon_file(self) -> Optional[builtins.str]:
        """
        Specifies a favicon to display in the browser tab.
        """
        return pulumi.get(self, "favicon_file")

    @property
    @pulumi.getter(name="logoFile")
    def logo_file(self) -> Optional[builtins.str]:
        """
        Specifies a logo to display on the web app.
        """
        return pulumi.get(self, "logo_file")

    @property
    @pulumi.getter
    def title(self) -> Optional[builtins.str]:
        """
        Specifies a title to display on the web app.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class WebAppIdentityProviderDetails(dict):
    """
    You can provide a structure that contains the details for the identity provider to use with your web app.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationArn":
            suggest = "application_arn"
        elif key == "instanceArn":
            suggest = "instance_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WebAppIdentityProviderDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WebAppIdentityProviderDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WebAppIdentityProviderDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_arn: Optional[builtins.str] = None,
                 instance_arn: Optional[builtins.str] = None,
                 role: Optional[builtins.str] = None):
        """
        You can provide a structure that contains the details for the identity provider to use with your web app.
        :param builtins.str application_arn: The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
        :param builtins.str instance_arn: The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
        :param builtins.str role: The IAM role in IAM Identity Center used for the web app.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if instance_arn is not None:
            pulumi.set(__self__, "instance_arn", instance_arn)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        The IAM role in IAM Identity Center used for the web app.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class WebAppUnitsProperties(dict):
    """
    A union that contains the value for number of concurrent connections or the user sessions on your web app.
    """
    def __init__(__self__, *,
                 provisioned: builtins.int):
        """
        A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        pulumi.set(__self__, "provisioned", provisioned)

    @property
    @pulumi.getter
    def provisioned(self) -> builtins.int:
        return pulumi.get(self, "provisioned")


@pulumi.output_type
class WorkflowEfsInputFileLocation(dict):
    """
    Specifies the details for an EFS file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileSystemId":
            suggest = "file_system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowEfsInputFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowEfsInputFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowEfsInputFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_system_id: Optional[builtins.str] = None,
                 path: Optional[builtins.str] = None):
        """
        Specifies the details for an EFS file.
        :param builtins.str file_system_id: Specifies the EFS filesystem that contains the file.
        :param builtins.str path: The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[builtins.str]:
        """
        Specifies the EFS filesystem that contains the file.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter
    def path(self) -> Optional[builtins.str]:
        """
        The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class WorkflowInputFileLocation(dict):
    """
    Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "efsFileLocation":
            suggest = "efs_file_location"
        elif key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowInputFileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowInputFileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowInputFileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 efs_file_location: Optional['outputs.WorkflowEfsInputFileLocation'] = None,
                 s3_file_location: Optional['outputs.WorkflowS3InputFileLocation'] = None):
        """
        Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional['outputs.WorkflowEfsInputFileLocation']:
        return pulumi.get(self, "efs_file_location")

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowS3InputFileLocation']:
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowS3FileLocation(dict):
    """
    Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3FileLocation":
            suggest = "s3_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowS3FileLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowS3FileLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowS3FileLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_file_location: Optional['outputs.WorkflowS3InputFileLocation'] = None):
        """
        Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
        :param 'WorkflowS3InputFileLocation' s3_file_location: Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional['outputs.WorkflowS3InputFileLocation']:
        """
        Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
        return pulumi.get(self, "s3_file_location")


@pulumi.output_type
class WorkflowS3InputFileLocation(dict):
    """
    Specifies the details for a S3 file.
    """
    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 key: Optional[builtins.str] = None):
        """
        Specifies the details for a S3 file.
        :param builtins.str bucket: Specifies the S3 bucket that contains the file.
        :param builtins.str key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        Specifies the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> Optional[builtins.str]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class WorkflowS3Tag(dict):
    """
    Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
    """
    def __init__(__self__, *,
                 key: builtins.str,
                 value: builtins.str):
        """
        Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
        :param builtins.str key: The name assigned to the tag that you create.
        :param builtins.str value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        The name assigned to the tag that you create.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkflowStep(dict):
    """
    The basic building block of a workflow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "copyStepDetails":
            suggest = "copy_step_details"
        elif key == "customStepDetails":
            suggest = "custom_step_details"
        elif key == "decryptStepDetails":
            suggest = "decrypt_step_details"
        elif key == "deleteStepDetails":
            suggest = "delete_step_details"
        elif key == "tagStepDetails":
            suggest = "tag_step_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStep. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStep.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStep.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 copy_step_details: Optional['outputs.WorkflowStepCopyStepDetailsProperties'] = None,
                 custom_step_details: Optional['outputs.WorkflowStepCustomStepDetailsProperties'] = None,
                 decrypt_step_details: Optional['outputs.WorkflowStepDecryptStepDetailsProperties'] = None,
                 delete_step_details: Optional['outputs.WorkflowStepDeleteStepDetailsProperties'] = None,
                 tag_step_details: Optional['outputs.WorkflowStepTagStepDetailsProperties'] = None,
                 type: Optional['WorkflowStepType'] = None):
        """
        The basic building block of a workflow.
        :param 'WorkflowStepCopyStepDetailsProperties' copy_step_details: Details for a step that performs a file copy.
        :param 'WorkflowStepCustomStepDetailsProperties' custom_step_details: Details for a step that invokes a lambda function.
        :param 'WorkflowStepDecryptStepDetailsProperties' decrypt_step_details: Details for a step that performs a file decryption.
        :param 'WorkflowStepDeleteStepDetailsProperties' delete_step_details: Details for a step that deletes the file.
        :param 'WorkflowStepTagStepDetailsProperties' tag_step_details: Details for a step that creates one or more tags.
        """
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional['outputs.WorkflowStepCopyStepDetailsProperties']:
        """
        Details for a step that performs a file copy.
        """
        return pulumi.get(self, "copy_step_details")

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional['outputs.WorkflowStepCustomStepDetailsProperties']:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional['outputs.WorkflowStepDecryptStepDetailsProperties']:
        """
        Details for a step that performs a file decryption.
        """
        return pulumi.get(self, "decrypt_step_details")

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional['outputs.WorkflowStepDeleteStepDetailsProperties']:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional['outputs.WorkflowStepTagStepDetailsProperties']:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")

    @property
    @pulumi.getter
    def type(self) -> Optional['WorkflowStepType']:
        return pulumi.get(self, "type")


@pulumi.output_type
class WorkflowStepCopyStepDetailsProperties(dict):
    """
    Details for a step that performs a file copy.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCopyStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCopyStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCopyStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_file_location: Optional['outputs.WorkflowS3FileLocation'] = None,
                 name: Optional[builtins.str] = None,
                 overwrite_existing: Optional['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting'] = None,
                 source_file_location: Optional[builtins.str] = None):
        """
        Details for a step that performs a file copy.
        :param builtins.str name: The name of the step, used as an identifier.
        :param 'WorkflowStepCopyStepDetailsPropertiesOverwriteExisting' overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param builtins.str source_file_location: Specifies which file to use as input to the workflow step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional['outputs.WorkflowS3FileLocation']:
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[builtins.str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepCustomStepDetailsProperties(dict):
    """
    Details for a step that invokes a lambda function.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepCustomStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepCustomStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepCustomStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 source_file_location: Optional[builtins.str] = None,
                 target: Optional[builtins.str] = None,
                 timeout_seconds: Optional[builtins.int] = None):
        """
        Details for a step that invokes a lambda function.
        :param builtins.str name: The name of the step, used as an identifier.
        :param builtins.str source_file_location: Specifies which file to use as input to the workflow step.
        :param builtins.str target: The ARN for the lambda function that is being called.
        :param builtins.int timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[builtins.str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def target(self) -> Optional[builtins.str]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class WorkflowStepDecryptStepDetailsProperties(dict):
    """
    Details for a step that performs a file decryption.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationFileLocation":
            suggest = "destination_file_location"
        elif key == "overwriteExisting":
            suggest = "overwrite_existing"
        elif key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDecryptStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDecryptStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDecryptStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_file_location: 'outputs.WorkflowInputFileLocation',
                 type: 'WorkflowStepDecryptStepDetailsPropertiesType',
                 name: Optional[builtins.str] = None,
                 overwrite_existing: Optional['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting'] = None,
                 source_file_location: Optional[builtins.str] = None):
        """
        Details for a step that performs a file decryption.
        :param 'WorkflowStepDecryptStepDetailsPropertiesType' type: Specifies which encryption method to use.
        :param builtins.str name: The name of the step, used as an identifier.
        :param 'WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting' overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param builtins.str source_file_location: Specifies which file to use as input to the workflow step.
        """
        pulumi.set(__self__, "destination_file_location", destination_file_location)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> 'outputs.WorkflowInputFileLocation':
        return pulumi.get(self, "destination_file_location")

    @property
    @pulumi.getter
    def type(self) -> 'WorkflowStepDecryptStepDetailsPropertiesType':
        """
        Specifies which encryption method to use.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[builtins.str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepDeleteStepDetailsProperties(dict):
    """
    Details for a step that deletes the file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepDeleteStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepDeleteStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepDeleteStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 source_file_location: Optional[builtins.str] = None):
        """
        Details for a step that deletes the file.
        :param builtins.str name: The name of the step, used as an identifier.
        :param builtins.str source_file_location: Specifies which file to use as input to the workflow step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[builtins.str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")


@pulumi.output_type
class WorkflowStepTagStepDetailsProperties(dict):
    """
    Details for a step that creates one or more tags.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFileLocation":
            suggest = "source_file_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowStepTagStepDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowStepTagStepDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowStepTagStepDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[builtins.str] = None,
                 source_file_location: Optional[builtins.str] = None,
                 tags: Optional[Sequence['outputs.WorkflowS3Tag']] = None):
        """
        Details for a step that creates one or more tags.
        :param builtins.str name: The name of the step, used as an identifier.
        :param builtins.str source_file_location: Specifies which file to use as input to the workflow step.
        :param Sequence['WorkflowS3Tag'] tags: Array that contains from 1 to 10 key/value pairs.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[builtins.str]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.WorkflowS3Tag']]:
        """
        Array that contains from 1 to 10 key/value pairs.
        """
        return pulumi.get(self, "tags")


