# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from .. import outputs as _root_outputs

__all__ = [
    'GetWorkflowResult',
    'AwaitableGetWorkflowResult',
    'get_workflow',
    'get_workflow_output',
]

@pulumi.output_type
class GetWorkflowResult:
    def __init__(__self__, arn=None, tags=None, workflow_id=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if workflow_id and not isinstance(workflow_id, str):
            raise TypeError("Expected argument 'workflow_id' to be a str")
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Specifies the unique Amazon Resource Name (ARN) for the workflow.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key-value pairs that can be used to group and search for workflows. Tags are metadata attached to workflows for any purpose.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")


class AwaitableGetWorkflowResult(GetWorkflowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkflowResult(
            arn=self.arn,
            tags=self.tags,
            workflow_id=self.workflow_id)


def get_workflow(workflow_id: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkflowResult:
    """
    Resource Type definition for AWS::Transfer::Workflow


    :param builtins.str workflow_id: A unique identifier for the workflow.
    """
    __args__ = dict()
    __args__['workflowId'] = workflow_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:transfer:getWorkflow', __args__, opts=opts, typ=GetWorkflowResult).value

    return AwaitableGetWorkflowResult(
        arn=pulumi.get(__ret__, 'arn'),
        tags=pulumi.get(__ret__, 'tags'),
        workflow_id=pulumi.get(__ret__, 'workflow_id'))
def get_workflow_output(workflow_id: Optional[pulumi.Input[builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkflowResult]:
    """
    Resource Type definition for AWS::Transfer::Workflow


    :param builtins.str workflow_id: A unique identifier for the workflow.
    """
    __args__ = dict()
    __args__['workflowId'] = workflow_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:transfer:getWorkflow', __args__, opts=opts, typ=GetWorkflowResult)
    return __ret__.apply(lambda __response__: GetWorkflowResult(
        arn=pulumi.get(__response__, 'arn'),
        tags=pulumi.get(__response__, 'tags'),
        workflow_id=pulumi.get(__response__, 'workflow_id')))
