# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs

__all__ = [
    'GetWebAppResult',
    'AwaitableGetWebAppResult',
    'get_web_app',
    'get_web_app_output',
]

@pulumi.output_type
class GetWebAppResult:
    def __init__(__self__, access_endpoint=None, arn=None, identity_provider_details=None, tags=None, web_app_customization=None, web_app_id=None, web_app_units=None):
        if access_endpoint and not isinstance(access_endpoint, str):
            raise TypeError("Expected argument 'access_endpoint' to be a str")
        pulumi.set(__self__, "access_endpoint", access_endpoint)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if identity_provider_details and not isinstance(identity_provider_details, dict):
            raise TypeError("Expected argument 'identity_provider_details' to be a dict")
        pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if web_app_customization and not isinstance(web_app_customization, dict):
            raise TypeError("Expected argument 'web_app_customization' to be a dict")
        pulumi.set(__self__, "web_app_customization", web_app_customization)
        if web_app_id and not isinstance(web_app_id, str):
            raise TypeError("Expected argument 'web_app_id' to be a str")
        pulumi.set(__self__, "web_app_id", web_app_id)
        if web_app_units and not isinstance(web_app_units, dict):
            raise TypeError("Expected argument 'web_app_units' to be a dict")
        pulumi.set(__self__, "web_app_units", web_app_units)

    @property
    @pulumi.getter(name="accessEndpoint")
    def access_endpoint(self) -> Optional[builtins.str]:
        """
        The AccessEndpoint is the URL that you provide to your users for them to interact with the Transfer Family web app. You can specify a custom URL or use the default value.
        """
        return pulumi.get(self, "access_endpoint")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Specifies the unique Amazon Resource Name (ARN) for the web app.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> Optional['outputs.WebAppIdentityProviderDetails']:
        """
        You can provide a structure that contains the details for the identity provider to use with your web app.

        For more details about this parameter, see [Configure your identity provider for Transfer Family web apps](https://docs.aws.amazon.com//transfer/latest/userguide/webapp-identity-center.html) .
        """
        return pulumi.get(self, "identity_provider_details")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key-value pairs that can be used to group and search for web apps.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="webAppCustomization")
    def web_app_customization(self) -> Optional['outputs.WebAppCustomization']:
        """
        A structure that contains the customization fields for the web app. You can provide a title, logo, and icon to customize the appearance of your web app.
        """
        return pulumi.get(self, "web_app_customization")

    @property
    @pulumi.getter(name="webAppId")
    def web_app_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the web app.
        """
        return pulumi.get(self, "web_app_id")

    @property
    @pulumi.getter(name="webAppUnits")
    def web_app_units(self) -> Optional['outputs.WebAppUnitsProperties']:
        """
        A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        return pulumi.get(self, "web_app_units")


class AwaitableGetWebAppResult(GetWebAppResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWebAppResult(
            access_endpoint=self.access_endpoint,
            arn=self.arn,
            identity_provider_details=self.identity_provider_details,
            tags=self.tags,
            web_app_customization=self.web_app_customization,
            web_app_id=self.web_app_id,
            web_app_units=self.web_app_units)


def get_web_app(arn: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWebAppResult:
    """
    Resource Type definition for AWS::Transfer::WebApp


    :param builtins.str arn: Specifies the unique Amazon Resource Name (ARN) for the web app.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:transfer:getWebApp', __args__, opts=opts, typ=GetWebAppResult).value

    return AwaitableGetWebAppResult(
        access_endpoint=pulumi.get(__ret__, 'access_endpoint'),
        arn=pulumi.get(__ret__, 'arn'),
        identity_provider_details=pulumi.get(__ret__, 'identity_provider_details'),
        tags=pulumi.get(__ret__, 'tags'),
        web_app_customization=pulumi.get(__ret__, 'web_app_customization'),
        web_app_id=pulumi.get(__ret__, 'web_app_id'),
        web_app_units=pulumi.get(__ret__, 'web_app_units'))
def get_web_app_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWebAppResult]:
    """
    Resource Type definition for AWS::Transfer::WebApp


    :param builtins.str arn: Specifies the unique Amazon Resource Name (ARN) for the web app.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:transfer:getWebApp', __args__, opts=opts, typ=GetWebAppResult)
    return __ret__.apply(lambda __response__: GetWebAppResult(
        access_endpoint=pulumi.get(__response__, 'access_endpoint'),
        arn=pulumi.get(__response__, 'arn'),
        identity_provider_details=pulumi.get(__response__, 'identity_provider_details'),
        tags=pulumi.get(__response__, 'tags'),
        web_app_customization=pulumi.get(__response__, 'web_app_customization'),
        web_app_id=pulumi.get(__response__, 'web_app_id'),
        web_app_units=pulumi.get(__response__, 'web_app_units')))
