# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetServerResult',
    'AwaitableGetServerResult',
    'get_server',
    'get_server_output',
]

@pulumi.output_type
class GetServerResult:
    def __init__(__self__, arn=None, as2_service_managed_egress_ip_addresses=None, certificate=None, endpoint_details=None, endpoint_type=None, identity_provider_details=None, logging_role=None, post_authentication_login_banner=None, pre_authentication_login_banner=None, protocol_details=None, protocols=None, s3_storage_options=None, security_policy_name=None, server_id=None, state=None, structured_log_destinations=None, tags=None, workflow_details=None):
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if as2_service_managed_egress_ip_addresses and not isinstance(as2_service_managed_egress_ip_addresses, list):
            raise TypeError("Expected argument 'as2_service_managed_egress_ip_addresses' to be a list")
        pulumi.set(__self__, "as2_service_managed_egress_ip_addresses", as2_service_managed_egress_ip_addresses)
        if certificate and not isinstance(certificate, str):
            raise TypeError("Expected argument 'certificate' to be a str")
        pulumi.set(__self__, "certificate", certificate)
        if endpoint_details and not isinstance(endpoint_details, dict):
            raise TypeError("Expected argument 'endpoint_details' to be a dict")
        pulumi.set(__self__, "endpoint_details", endpoint_details)
        if endpoint_type and not isinstance(endpoint_type, str):
            raise TypeError("Expected argument 'endpoint_type' to be a str")
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if identity_provider_details and not isinstance(identity_provider_details, dict):
            raise TypeError("Expected argument 'identity_provider_details' to be a dict")
        pulumi.set(__self__, "identity_provider_details", identity_provider_details)
        if logging_role and not isinstance(logging_role, str):
            raise TypeError("Expected argument 'logging_role' to be a str")
        pulumi.set(__self__, "logging_role", logging_role)
        if post_authentication_login_banner and not isinstance(post_authentication_login_banner, str):
            raise TypeError("Expected argument 'post_authentication_login_banner' to be a str")
        pulumi.set(__self__, "post_authentication_login_banner", post_authentication_login_banner)
        if pre_authentication_login_banner and not isinstance(pre_authentication_login_banner, str):
            raise TypeError("Expected argument 'pre_authentication_login_banner' to be a str")
        pulumi.set(__self__, "pre_authentication_login_banner", pre_authentication_login_banner)
        if protocol_details and not isinstance(protocol_details, dict):
            raise TypeError("Expected argument 'protocol_details' to be a dict")
        pulumi.set(__self__, "protocol_details", protocol_details)
        if protocols and not isinstance(protocols, list):
            raise TypeError("Expected argument 'protocols' to be a list")
        pulumi.set(__self__, "protocols", protocols)
        if s3_storage_options and not isinstance(s3_storage_options, dict):
            raise TypeError("Expected argument 's3_storage_options' to be a dict")
        pulumi.set(__self__, "s3_storage_options", s3_storage_options)
        if security_policy_name and not isinstance(security_policy_name, str):
            raise TypeError("Expected argument 'security_policy_name' to be a str")
        pulumi.set(__self__, "security_policy_name", security_policy_name)
        if server_id and not isinstance(server_id, str):
            raise TypeError("Expected argument 'server_id' to be a str")
        pulumi.set(__self__, "server_id", server_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if structured_log_destinations and not isinstance(structured_log_destinations, list):
            raise TypeError("Expected argument 'structured_log_destinations' to be a list")
        pulumi.set(__self__, "structured_log_destinations", structured_log_destinations)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if workflow_details and not isinstance(workflow_details, dict):
            raise TypeError("Expected argument 'workflow_details' to be a dict")
        pulumi.set(__self__, "workflow_details", workflow_details)

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Specifies the unique Amazon Resource Name (ARN) of the server.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2ServiceManagedEgressIpAddresses")
    def as2_service_managed_egress_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of egress IP addresses of this server. These IP addresses are only relevant for servers that use the AS2 protocol. They are used for sending asynchronous MDNs. These IP addresses are assigned automatically when you create an AS2 server. Additionally, if you update an existing server and add the AS2 protocol, static IP addresses are assigned as well.
        """
        return pulumi.get(self, "as2_service_managed_egress_ip_addresses")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Certificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS` .

        To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the *AWS Certificate Manager User Guide* .

        To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *AWS Certificate Manager User Guide* .

        To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the *AWS Certificate Manager User Guide* .

        Certificates with the following cryptographic algorithms and key sizes are supported:

        - 2048-bit RSA (RSA_2048)
        - 4096-bit RSA (RSA_4096)
        - Elliptic Prime Curve 256 bit (EC_prime256v1)
        - Elliptic Prime Curve 384 bit (EC_secp384r1)
        - Elliptic Prime Curve 521 bit (EC_secp521r1)

        > The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="endpointDetails")
    def endpoint_details(self) -> Optional['outputs.ServerEndpointDetails']:
        """
        The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
        """
        return pulumi.get(self, "endpoint_details")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional['ServerEndpointType']:
        """
        The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.

        > After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your AWS account if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your AWS account on or before May 19, 2021, you will not be affected. After this date, use `EndpointType` = `VPC` .
        > 
        > For more information, see [Discontinuing the use of VPC_ENDPOINT](https://docs.aws.amazon.com//transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint) .
        > 
        > It is recommended that you use `VPC` as the `EndpointType` . With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT` .
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="identityProviderDetails")
    def identity_provider_details(self) -> Optional['outputs.ServerIdentityProviderDetails']:
        """
        Required when `IdentityProviderType` is set to `AWS_DIRECTORY_SERVICE` , `AWS _LAMBDA` or `API_GATEWAY` . Accepts an array containing all of the information required to use a directory in `AWS_DIRECTORY_SERVICE` or invoke a customer-supplied authentication API, including the API Gateway URL. Cannot be specified when `IdentityProviderType` is set to `SERVICE_MANAGED` .
        """
        return pulumi.get(self, "identity_provider_details")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, you can view user activity in your CloudWatch logs.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter(name="postAuthenticationLoginBanner")
    def post_authentication_login_banner(self) -> Optional[builtins.str]:
        """
        Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.

        > The SFTP protocol does not support post-authentication display banners.
        """
        return pulumi.get(self, "post_authentication_login_banner")

    @property
    @pulumi.getter(name="preAuthenticationLoginBanner")
    def pre_authentication_login_banner(self) -> Optional[builtins.str]:
        """
        Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:

        `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
        """
        return pulumi.get(self, "pre_authentication_login_banner")

    @property
    @pulumi.getter(name="protocolDetails")
    def protocol_details(self) -> Optional['outputs.ServerProtocolDetails']:
        """
        The protocol settings that are configured for your server.

        - To indicate passive mode (for FTP and FTPS protocols), use the `PassiveIp` parameter. Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
        - To ignore the error that is generated when the client attempts to use the `SETSTAT` command on a file that you are uploading to an Amazon S3 bucket, use the `SetStatOption` parameter. To have the AWS Transfer Family server ignore the `SETSTAT` command and upload files without needing to make any changes to your SFTP client, set the value to `ENABLE_NO_OP` . If you set the `SetStatOption` parameter to `ENABLE_NO_OP` , Transfer Family generates a log entry to Amazon CloudWatch Logs, so that you can determine when the client is making a `SETSTAT` call.
        - To determine whether your AWS Transfer Family server resumes recent, negotiated sessions through a unique session ID, use the `TlsSessionResumptionMode` parameter.
        - `As2Transports` indicates the transport method for the AS2 messages. Currently, only HTTP is supported.

        The `Protocols` parameter is an array of strings.

        *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        """
        return pulumi.get(self, "protocol_details")

    @property
    @pulumi.getter
    def protocols(self) -> Optional[Sequence['ServerProtocol']]:
        """
        Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:

        - `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
        - `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
        - `FTP` (File Transfer Protocol): Unencrypted file transfer
        - `AS2` (Applicability Statement 2): used for transporting structured business-to-business data

        > - If you select `FTPS` , you must choose a certificate stored in AWS Certificate Manager (ACM) which is used to identify your server when clients connect to it over FTPS.
        > - If `Protocol` includes either `FTP` or `FTPS` , then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be either `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
        > - If `Protocol` includes `FTP` , then `AddressAllocationIds` cannot be associated.
        > - If `Protocol` is set only to `SFTP` , the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set any of the supported identity types: `SERVICE_MANAGED` , `AWS_DIRECTORY_SERVICE` , `AWS_LAMBDA` , or `API_GATEWAY` .
        > - If `Protocol` includes `AS2` , then the `EndpointType` must be `VPC` , and domain must be Amazon S3. 

        The `Protocols` parameter is an array of strings.

        *Allowed values* : One or more of `SFTP` , `FTPS` , `FTP` , `AS2`
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="s3StorageOptions")
    def s3_storage_options(self) -> Optional['outputs.ServerS3StorageOptions']:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.

        By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "s3_storage_options")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[builtins.str]:
        """
        Specifies the name of the security policy for the server.
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> Optional[builtins.str]:
        """
        Specifies the unique system-assigned identifier for a server that you instantiate.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter
    def state(self) -> Optional['ServerState']:
        """
        The condition of the server that was described. A value of `ONLINE` indicates that the server can accept jobs and transfer files. A `State` value of `OFFLINE` means that the server cannot perform file transfer operations.

        The states of `STARTING` and `STOPPING` indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `START_FAILED` or `STOP_FAILED` can indicate an error condition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="structuredLogDestinations")
    def structured_log_destinations(self) -> Optional[Sequence[builtins.str]]:
        """
        Specifies the log groups to which your server logs are sent.

        To specify a log group, you must provide the ARN for an existing log group. In this case, the format of the log group is as follows:

        `arn:aws:logs:region-name:amazon-account-id:log-group:log-group-name:*`

        For example, `arn:aws:logs:us-east-1:111122223333:log-group:mytestgroup:*`

        If you have previously specified a log group for a server, you can clear it, and in effect turn off structured logging, by providing an empty value for this parameter in an `update-server` call. For example:

        `update-server --server-id s-1234567890abcdef0 --structured-log-destinations`
        """
        return pulumi.get(self, "structured_log_destinations")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key-value pairs that can be used to group and search for servers.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="workflowDetails")
    def workflow_details(self) -> Optional['outputs.ServerWorkflowDetails']:
        """
        Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.

        In addition to a workflow to execute when a file is uploaded completely, `WorkflowDetails` can also contain a workflow ID (and execution role) for a workflow to execute on partial upload. A partial upload occurs when a file is open when the session disconnects.
        """
        return pulumi.get(self, "workflow_details")


class AwaitableGetServerResult(GetServerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerResult(
            arn=self.arn,
            as2_service_managed_egress_ip_addresses=self.as2_service_managed_egress_ip_addresses,
            certificate=self.certificate,
            endpoint_details=self.endpoint_details,
            endpoint_type=self.endpoint_type,
            identity_provider_details=self.identity_provider_details,
            logging_role=self.logging_role,
            post_authentication_login_banner=self.post_authentication_login_banner,
            pre_authentication_login_banner=self.pre_authentication_login_banner,
            protocol_details=self.protocol_details,
            protocols=self.protocols,
            s3_storage_options=self.s3_storage_options,
            security_policy_name=self.security_policy_name,
            server_id=self.server_id,
            state=self.state,
            structured_log_destinations=self.structured_log_destinations,
            tags=self.tags,
            workflow_details=self.workflow_details)


def get_server(arn: Optional[builtins.str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerResult:
    """
    Definition of AWS::Transfer::Server Resource Type


    :param builtins.str arn: Specifies the unique Amazon Resource Name (ARN) of the server.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:transfer:getServer', __args__, opts=opts, typ=GetServerResult).value

    return AwaitableGetServerResult(
        arn=pulumi.get(__ret__, 'arn'),
        as2_service_managed_egress_ip_addresses=pulumi.get(__ret__, 'as2_service_managed_egress_ip_addresses'),
        certificate=pulumi.get(__ret__, 'certificate'),
        endpoint_details=pulumi.get(__ret__, 'endpoint_details'),
        endpoint_type=pulumi.get(__ret__, 'endpoint_type'),
        identity_provider_details=pulumi.get(__ret__, 'identity_provider_details'),
        logging_role=pulumi.get(__ret__, 'logging_role'),
        post_authentication_login_banner=pulumi.get(__ret__, 'post_authentication_login_banner'),
        pre_authentication_login_banner=pulumi.get(__ret__, 'pre_authentication_login_banner'),
        protocol_details=pulumi.get(__ret__, 'protocol_details'),
        protocols=pulumi.get(__ret__, 'protocols'),
        s3_storage_options=pulumi.get(__ret__, 's3_storage_options'),
        security_policy_name=pulumi.get(__ret__, 'security_policy_name'),
        server_id=pulumi.get(__ret__, 'server_id'),
        state=pulumi.get(__ret__, 'state'),
        structured_log_destinations=pulumi.get(__ret__, 'structured_log_destinations'),
        tags=pulumi.get(__ret__, 'tags'),
        workflow_details=pulumi.get(__ret__, 'workflow_details'))
def get_server_output(arn: Optional[pulumi.Input[builtins.str]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerResult]:
    """
    Definition of AWS::Transfer::Server Resource Type


    :param builtins.str arn: Specifies the unique Amazon Resource Name (ARN) of the server.
    """
    __args__ = dict()
    __args__['arn'] = arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:transfer:getServer', __args__, opts=opts, typ=GetServerResult)
    return __ret__.apply(lambda __response__: GetServerResult(
        arn=pulumi.get(__response__, 'arn'),
        as2_service_managed_egress_ip_addresses=pulumi.get(__response__, 'as2_service_managed_egress_ip_addresses'),
        certificate=pulumi.get(__response__, 'certificate'),
        endpoint_details=pulumi.get(__response__, 'endpoint_details'),
        endpoint_type=pulumi.get(__response__, 'endpoint_type'),
        identity_provider_details=pulumi.get(__response__, 'identity_provider_details'),
        logging_role=pulumi.get(__response__, 'logging_role'),
        post_authentication_login_banner=pulumi.get(__response__, 'post_authentication_login_banner'),
        pre_authentication_login_banner=pulumi.get(__response__, 'pre_authentication_login_banner'),
        protocol_details=pulumi.get(__response__, 'protocol_details'),
        protocols=pulumi.get(__response__, 'protocols'),
        s3_storage_options=pulumi.get(__response__, 's3_storage_options'),
        security_policy_name=pulumi.get(__response__, 'security_policy_name'),
        server_id=pulumi.get(__response__, 'server_id'),
        state=pulumi.get(__response__, 'state'),
        structured_log_destinations=pulumi.get(__response__, 'structured_log_destinations'),
        tags=pulumi.get(__response__, 'tags'),
        workflow_details=pulumi.get(__response__, 'workflow_details')))
