# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import outputs as _root_outputs
from ._enums import *

__all__ = [
    'GetConnectorResult',
    'AwaitableGetConnectorResult',
    'get_connector',
    'get_connector_output',
]

@pulumi.output_type
class GetConnectorResult:
    def __init__(__self__, access_role=None, arn=None, as2_config=None, connector_id=None, logging_role=None, security_policy_name=None, service_managed_egress_ip_addresses=None, sftp_config=None, tags=None, url=None):
        if access_role and not isinstance(access_role, str):
            raise TypeError("Expected argument 'access_role' to be a str")
        pulumi.set(__self__, "access_role", access_role)
        if arn and not isinstance(arn, str):
            raise TypeError("Expected argument 'arn' to be a str")
        pulumi.set(__self__, "arn", arn)
        if as2_config and not isinstance(as2_config, dict):
            raise TypeError("Expected argument 'as2_config' to be a dict")
        pulumi.set(__self__, "as2_config", as2_config)
        if connector_id and not isinstance(connector_id, str):
            raise TypeError("Expected argument 'connector_id' to be a str")
        pulumi.set(__self__, "connector_id", connector_id)
        if logging_role and not isinstance(logging_role, str):
            raise TypeError("Expected argument 'logging_role' to be a str")
        pulumi.set(__self__, "logging_role", logging_role)
        if security_policy_name and not isinstance(security_policy_name, str):
            raise TypeError("Expected argument 'security_policy_name' to be a str")
        pulumi.set(__self__, "security_policy_name", security_policy_name)
        if service_managed_egress_ip_addresses and not isinstance(service_managed_egress_ip_addresses, list):
            raise TypeError("Expected argument 'service_managed_egress_ip_addresses' to be a list")
        pulumi.set(__self__, "service_managed_egress_ip_addresses", service_managed_egress_ip_addresses)
        if sftp_config and not isinstance(sftp_config, dict):
            raise TypeError("Expected argument 'sftp_config' to be a dict")
        pulumi.set(__self__, "sftp_config", sftp_config)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="accessRole")
    def access_role(self) -> Optional[builtins.str]:
        """
        Specifies the access role for the connector.
        """
        return pulumi.get(self, "access_role")

    @property
    @pulumi.getter
    def arn(self) -> Optional[builtins.str]:
        """
        Specifies the unique Amazon Resource Name (ARN) for the connector.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="as2Config")
    def as2_config(self) -> Optional['outputs.As2ConfigProperties']:
        """
        Configuration for an AS2 connector.
        """
        return pulumi.get(self, "as2_config")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[builtins.str]:
        """
        A unique identifier for the connector.
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="loggingRole")
    def logging_role(self) -> Optional[builtins.str]:
        """
        Specifies the logging role for the connector.
        """
        return pulumi.get(self, "logging_role")

    @property
    @pulumi.getter(name="securityPolicyName")
    def security_policy_name(self) -> Optional[builtins.str]:
        """
        Security policy for SFTP Connector
        """
        return pulumi.get(self, "security_policy_name")

    @property
    @pulumi.getter(name="serviceManagedEgressIpAddresses")
    def service_managed_egress_ip_addresses(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of egress IP addresses of this connector. These IP addresses are assigned automatically when you create the connector.
        """
        return pulumi.get(self, "service_managed_egress_ip_addresses")

    @property
    @pulumi.getter(name="sftpConfig")
    def sftp_config(self) -> Optional['outputs.SftpConfigProperties']:
        """
        Configuration for an SFTP connector.
        """
        return pulumi.get(self, "sftp_config")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['_root_outputs.Tag']]:
        """
        Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors for any purpose.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def url(self) -> Optional[builtins.str]:
        """
        URL for Connector
        """
        return pulumi.get(self, "url")


class AwaitableGetConnectorResult(GetConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorResult(
            access_role=self.access_role,
            arn=self.arn,
            as2_config=self.as2_config,
            connector_id=self.connector_id,
            logging_role=self.logging_role,
            security_policy_name=self.security_policy_name,
            service_managed_egress_ip_addresses=self.service_managed_egress_ip_addresses,
            sftp_config=self.sftp_config,
            tags=self.tags,
            url=self.url)


def get_connector(connector_id: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorResult:
    """
    Resource Type definition for AWS::Transfer::Connector


    :param builtins.str connector_id: A unique identifier for the connector.
    """
    __args__ = dict()
    __args__['connectorId'] = connector_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:transfer:getConnector', __args__, opts=opts, typ=GetConnectorResult).value

    return AwaitableGetConnectorResult(
        access_role=pulumi.get(__ret__, 'access_role'),
        arn=pulumi.get(__ret__, 'arn'),
        as2_config=pulumi.get(__ret__, 'as2_config'),
        connector_id=pulumi.get(__ret__, 'connector_id'),
        logging_role=pulumi.get(__ret__, 'logging_role'),
        security_policy_name=pulumi.get(__ret__, 'security_policy_name'),
        service_managed_egress_ip_addresses=pulumi.get(__ret__, 'service_managed_egress_ip_addresses'),
        sftp_config=pulumi.get(__ret__, 'sftp_config'),
        tags=pulumi.get(__ret__, 'tags'),
        url=pulumi.get(__ret__, 'url'))
def get_connector_output(connector_id: Optional[pulumi.Input[builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConnectorResult]:
    """
    Resource Type definition for AWS::Transfer::Connector


    :param builtins.str connector_id: A unique identifier for the connector.
    """
    __args__ = dict()
    __args__['connectorId'] = connector_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:transfer:getConnector', __args__, opts=opts, typ=GetConnectorResult)
    return __ret__.apply(lambda __response__: GetConnectorResult(
        access_role=pulumi.get(__response__, 'access_role'),
        arn=pulumi.get(__response__, 'arn'),
        as2_config=pulumi.get(__response__, 'as2_config'),
        connector_id=pulumi.get(__response__, 'connector_id'),
        logging_role=pulumi.get(__response__, 'logging_role'),
        security_policy_name=pulumi.get(__response__, 'security_policy_name'),
        service_managed_egress_ip_addresses=pulumi.get(__response__, 'service_managed_egress_ip_addresses'),
        sftp_config=pulumi.get(__response__, 'sftp_config'),
        tags=pulumi.get(__response__, 'tags'),
        url=pulumi.get(__response__, 'url')))
