# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'As2ConfigPropertiesArgs',
    'As2ConfigPropertiesArgsDict',
    'CustomDirectoriesPropertiesArgs',
    'CustomDirectoriesPropertiesArgsDict',
    'ServerEndpointDetailsArgs',
    'ServerEndpointDetailsArgsDict',
    'ServerIdentityProviderDetailsArgs',
    'ServerIdentityProviderDetailsArgsDict',
    'ServerProtocolDetailsArgs',
    'ServerProtocolDetailsArgsDict',
    'ServerS3StorageOptionsArgs',
    'ServerS3StorageOptionsArgsDict',
    'ServerWorkflowDetailsArgs',
    'ServerWorkflowDetailsArgsDict',
    'ServerWorkflowDetailArgs',
    'ServerWorkflowDetailArgsDict',
    'SftpConfigPropertiesArgs',
    'SftpConfigPropertiesArgsDict',
    'UserHomeDirectoryMapEntryArgs',
    'UserHomeDirectoryMapEntryArgsDict',
    'UserPosixProfileArgs',
    'UserPosixProfileArgsDict',
    'WebAppCustomizationArgs',
    'WebAppCustomizationArgsDict',
    'WebAppIdentityProviderDetailsArgs',
    'WebAppIdentityProviderDetailsArgsDict',
    'WebAppUnitsPropertiesArgs',
    'WebAppUnitsPropertiesArgsDict',
    'WorkflowEfsInputFileLocationArgs',
    'WorkflowEfsInputFileLocationArgsDict',
    'WorkflowInputFileLocationArgs',
    'WorkflowInputFileLocationArgsDict',
    'WorkflowS3FileLocationArgs',
    'WorkflowS3FileLocationArgsDict',
    'WorkflowS3InputFileLocationArgs',
    'WorkflowS3InputFileLocationArgsDict',
    'WorkflowS3TagArgs',
    'WorkflowS3TagArgsDict',
    'WorkflowStepCopyStepDetailsPropertiesArgs',
    'WorkflowStepCopyStepDetailsPropertiesArgsDict',
    'WorkflowStepCustomStepDetailsPropertiesArgs',
    'WorkflowStepCustomStepDetailsPropertiesArgsDict',
    'WorkflowStepDecryptStepDetailsPropertiesArgs',
    'WorkflowStepDecryptStepDetailsPropertiesArgsDict',
    'WorkflowStepDeleteStepDetailsPropertiesArgs',
    'WorkflowStepDeleteStepDetailsPropertiesArgsDict',
    'WorkflowStepTagStepDetailsPropertiesArgs',
    'WorkflowStepTagStepDetailsPropertiesArgsDict',
    'WorkflowStepArgs',
    'WorkflowStepArgsDict',
]

MYPY = False

if not MYPY:
    class As2ConfigPropertiesArgsDict(TypedDict):
        """
        Configuration for an AS2 connector.
        """
        basic_auth_secret_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        """
        compression: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']]
        """
        Compression setting for this AS2 connector configuration.
        """
        encryption_algorithm: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']]
        """
        Encryption algorithm for this AS2 connector configuration.
        """
        local_profile_id: NotRequired[pulumi.Input[builtins.str]]
        """
        A unique identifier for the local profile.
        """
        mdn_response: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']]
        """
        MDN Response setting for this AS2 connector configuration.
        """
        mdn_signing_algorithm: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']]
        """
        MDN Signing algorithm for this AS2 connector configuration.
        """
        message_subject: NotRequired[pulumi.Input[builtins.str]]
        """
        The message subject for this AS2 connector configuration.
        """
        partner_profile_id: NotRequired[pulumi.Input[builtins.str]]
        """
        A unique identifier for the partner profile.
        """
        preserve_content_type: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesPreserveContentType']]
        """
        Specifies whether to use the AWS S3 object content-type as the content-type for the AS2 message.
        """
        signing_algorithm: NotRequired[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']]
        """
        Signing algorithm for this AS2 connector configuration.
        """
elif False:
    As2ConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class As2ConfigPropertiesArgs:
    def __init__(__self__, *,
                 basic_auth_secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 compression: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']] = None,
                 encryption_algorithm: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']] = None,
                 local_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 mdn_response: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']] = None,
                 mdn_signing_algorithm: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']] = None,
                 message_subject: Optional[pulumi.Input[builtins.str]] = None,
                 partner_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 preserve_content_type: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesPreserveContentType']] = None,
                 signing_algorithm: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']] = None):
        """
        Configuration for an AS2 connector.
        :param pulumi.Input[builtins.str] basic_auth_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        :param pulumi.Input['ConnectorAs2ConfigPropertiesCompression'] compression: Compression setting for this AS2 connector configuration.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm'] encryption_algorithm: Encryption algorithm for this AS2 connector configuration.
        :param pulumi.Input[builtins.str] local_profile_id: A unique identifier for the local profile.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse'] mdn_response: MDN Response setting for this AS2 connector configuration.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm'] mdn_signing_algorithm: MDN Signing algorithm for this AS2 connector configuration.
        :param pulumi.Input[builtins.str] message_subject: The message subject for this AS2 connector configuration.
        :param pulumi.Input[builtins.str] partner_profile_id: A unique identifier for the partner profile.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesPreserveContentType'] preserve_content_type: Specifies whether to use the AWS S3 object content-type as the content-type for the AS2 message.
        :param pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm'] signing_algorithm: Signing algorithm for this AS2 connector configuration.
        """
        if basic_auth_secret_id is not None:
            pulumi.set(__self__, "basic_auth_secret_id", basic_auth_secret_id)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if encryption_algorithm is not None:
            pulumi.set(__self__, "encryption_algorithm", encryption_algorithm)
        if local_profile_id is not None:
            pulumi.set(__self__, "local_profile_id", local_profile_id)
        if mdn_response is not None:
            pulumi.set(__self__, "mdn_response", mdn_response)
        if mdn_signing_algorithm is not None:
            pulumi.set(__self__, "mdn_signing_algorithm", mdn_signing_algorithm)
        if message_subject is not None:
            pulumi.set(__self__, "message_subject", message_subject)
        if partner_profile_id is not None:
            pulumi.set(__self__, "partner_profile_id", partner_profile_id)
        if preserve_content_type is not None:
            pulumi.set(__self__, "preserve_content_type", preserve_content_type)
        if signing_algorithm is not None:
            pulumi.set(__self__, "signing_algorithm", signing_algorithm)

    @property
    @pulumi.getter(name="basicAuthSecretId")
    def basic_auth_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the credentials for Basic authentication. If empty, Basic authentication is disabled for the AS2 connector
        """
        return pulumi.get(self, "basic_auth_secret_id")

    @basic_auth_secret_id.setter
    def basic_auth_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "basic_auth_secret_id", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']]:
        """
        Compression setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesCompression']]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="encryptionAlgorithm")
    def encryption_algorithm(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']]:
        """
        Encryption algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "encryption_algorithm")

    @encryption_algorithm.setter
    def encryption_algorithm(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesEncryptionAlgorithm']]):
        pulumi.set(self, "encryption_algorithm", value)

    @property
    @pulumi.getter(name="localProfileId")
    def local_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the local profile.
        """
        return pulumi.get(self, "local_profile_id")

    @local_profile_id.setter
    def local_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_profile_id", value)

    @property
    @pulumi.getter(name="mdnResponse")
    def mdn_response(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']]:
        """
        MDN Response setting for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_response")

    @mdn_response.setter
    def mdn_response(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnResponse']]):
        pulumi.set(self, "mdn_response", value)

    @property
    @pulumi.getter(name="mdnSigningAlgorithm")
    def mdn_signing_algorithm(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']]:
        """
        MDN Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "mdn_signing_algorithm")

    @mdn_signing_algorithm.setter
    def mdn_signing_algorithm(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesMdnSigningAlgorithm']]):
        pulumi.set(self, "mdn_signing_algorithm", value)

    @property
    @pulumi.getter(name="messageSubject")
    def message_subject(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message subject for this AS2 connector configuration.
        """
        return pulumi.get(self, "message_subject")

    @message_subject.setter
    def message_subject(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_subject", value)

    @property
    @pulumi.getter(name="partnerProfileId")
    def partner_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique identifier for the partner profile.
        """
        return pulumi.get(self, "partner_profile_id")

    @partner_profile_id.setter
    def partner_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partner_profile_id", value)

    @property
    @pulumi.getter(name="preserveContentType")
    def preserve_content_type(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesPreserveContentType']]:
        """
        Specifies whether to use the AWS S3 object content-type as the content-type for the AS2 message.
        """
        return pulumi.get(self, "preserve_content_type")

    @preserve_content_type.setter
    def preserve_content_type(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesPreserveContentType']]):
        pulumi.set(self, "preserve_content_type", value)

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> Optional[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']]:
        """
        Signing algorithm for this AS2 connector configuration.
        """
        return pulumi.get(self, "signing_algorithm")

    @signing_algorithm.setter
    def signing_algorithm(self, value: Optional[pulumi.Input['ConnectorAs2ConfigPropertiesSigningAlgorithm']]):
        pulumi.set(self, "signing_algorithm", value)


if not MYPY:
    class CustomDirectoriesPropertiesArgsDict(TypedDict):
        """
        Specifies a separate directory for each type of file to store for an AS2 message.
        """
        failed_files_directory: pulumi.Input[builtins.str]
        """
        Specifies a location to store the failed files for an AS2 message.
        """
        mdn_files_directory: pulumi.Input[builtins.str]
        """
        Specifies a location to store the MDN file for an AS2 message.
        """
        payload_files_directory: pulumi.Input[builtins.str]
        """
        Specifies a location to store the payload file for an AS2 message.
        """
        status_files_directory: pulumi.Input[builtins.str]
        """
        Specifies a location to store the status file for an AS2 message.
        """
        temporary_files_directory: pulumi.Input[builtins.str]
        """
        Specifies a location to store the temporary processing file for an AS2 message.
        """
elif False:
    CustomDirectoriesPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class CustomDirectoriesPropertiesArgs:
    def __init__(__self__, *,
                 failed_files_directory: pulumi.Input[builtins.str],
                 mdn_files_directory: pulumi.Input[builtins.str],
                 payload_files_directory: pulumi.Input[builtins.str],
                 status_files_directory: pulumi.Input[builtins.str],
                 temporary_files_directory: pulumi.Input[builtins.str]):
        """
        Specifies a separate directory for each type of file to store for an AS2 message.
        :param pulumi.Input[builtins.str] failed_files_directory: Specifies a location to store the failed files for an AS2 message.
        :param pulumi.Input[builtins.str] mdn_files_directory: Specifies a location to store the MDN file for an AS2 message.
        :param pulumi.Input[builtins.str] payload_files_directory: Specifies a location to store the payload file for an AS2 message.
        :param pulumi.Input[builtins.str] status_files_directory: Specifies a location to store the status file for an AS2 message.
        :param pulumi.Input[builtins.str] temporary_files_directory: Specifies a location to store the temporary processing file for an AS2 message.
        """
        pulumi.set(__self__, "failed_files_directory", failed_files_directory)
        pulumi.set(__self__, "mdn_files_directory", mdn_files_directory)
        pulumi.set(__self__, "payload_files_directory", payload_files_directory)
        pulumi.set(__self__, "status_files_directory", status_files_directory)
        pulumi.set(__self__, "temporary_files_directory", temporary_files_directory)

    @property
    @pulumi.getter(name="failedFilesDirectory")
    def failed_files_directory(self) -> pulumi.Input[builtins.str]:
        """
        Specifies a location to store the failed files for an AS2 message.
        """
        return pulumi.get(self, "failed_files_directory")

    @failed_files_directory.setter
    def failed_files_directory(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "failed_files_directory", value)

    @property
    @pulumi.getter(name="mdnFilesDirectory")
    def mdn_files_directory(self) -> pulumi.Input[builtins.str]:
        """
        Specifies a location to store the MDN file for an AS2 message.
        """
        return pulumi.get(self, "mdn_files_directory")

    @mdn_files_directory.setter
    def mdn_files_directory(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "mdn_files_directory", value)

    @property
    @pulumi.getter(name="payloadFilesDirectory")
    def payload_files_directory(self) -> pulumi.Input[builtins.str]:
        """
        Specifies a location to store the payload file for an AS2 message.
        """
        return pulumi.get(self, "payload_files_directory")

    @payload_files_directory.setter
    def payload_files_directory(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "payload_files_directory", value)

    @property
    @pulumi.getter(name="statusFilesDirectory")
    def status_files_directory(self) -> pulumi.Input[builtins.str]:
        """
        Specifies a location to store the status file for an AS2 message.
        """
        return pulumi.get(self, "status_files_directory")

    @status_files_directory.setter
    def status_files_directory(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "status_files_directory", value)

    @property
    @pulumi.getter(name="temporaryFilesDirectory")
    def temporary_files_directory(self) -> pulumi.Input[builtins.str]:
        """
        Specifies a location to store the temporary processing file for an AS2 message.
        """
        return pulumi.get(self, "temporary_files_directory")

    @temporary_files_directory.setter
    def temporary_files_directory(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "temporary_files_directory", value)


if not MYPY:
    class ServerEndpointDetailsArgsDict(TypedDict):
        address_allocation_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.

        An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the `allocationId` field from the Amazon EC2 [Address](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html) data type. One way to retrieve this value is by calling the EC2 [DescribeAddresses](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html) API.

        This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see [Create an internet-facing endpoint for your server](https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint) .

        > This property can only be set as follows:
        > 
        > - `EndpointType` must be set to `VPC`
        > - The Transfer Family server must be offline.
        > - You cannot set this parameter for Transfer Family servers that use the FTP protocol.
        > - The server must already have `SubnetIds` populated ( `SubnetIds` and `AddressAllocationIds` cannot be updated simultaneously).
        > - `AddressAllocationIds` can't contain duplicates, and must be equal in length to `SubnetIds` . For example, if you have three subnet IDs, you must also specify three address allocation IDs.
        > - Call the `UpdateServer` API to set or change this parameter.
        """
        security_group_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of security groups IDs that are available to attach to your server's endpoint.

        > This property can only be set when `EndpointType` is set to `VPC` .
        > 
        > You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC` . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
        """
        subnet_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of subnet IDs that are required to host your server endpoint in your VPC.

        > This property can only be set when `EndpointType` is set to `VPC` .
        """
        vpc_endpoint_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The ID of the VPC endpoint.

        > This property can only be set when `EndpointType` is set to `VPC_ENDPOINT` .
        """
        vpc_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.

        > This property can only be set when `EndpointType` is set to `VPC` .
        """
elif False:
    ServerEndpointDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerEndpointDetailsArgs:
    def __init__(__self__, *,
                 address_allocation_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vpc_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] address_allocation_ids: A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
               
               An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the `allocationId` field from the Amazon EC2 [Address](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html) data type. One way to retrieve this value is by calling the EC2 [DescribeAddresses](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html) API.
               
               This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see [Create an internet-facing endpoint for your server](https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint) .
               
               > This property can only be set as follows:
               > 
               > - `EndpointType` must be set to `VPC`
               > - The Transfer Family server must be offline.
               > - You cannot set this parameter for Transfer Family servers that use the FTP protocol.
               > - The server must already have `SubnetIds` populated ( `SubnetIds` and `AddressAllocationIds` cannot be updated simultaneously).
               > - `AddressAllocationIds` can't contain duplicates, and must be equal in length to `SubnetIds` . For example, if you have three subnet IDs, you must also specify three address allocation IDs.
               > - Call the `UpdateServer` API to set or change this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] security_group_ids: A list of security groups IDs that are available to attach to your server's endpoint.
               
               > This property can only be set when `EndpointType` is set to `VPC` .
               > 
               > You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC` . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] subnet_ids: A list of subnet IDs that are required to host your server endpoint in your VPC.
               
               > This property can only be set when `EndpointType` is set to `VPC` .
        :param pulumi.Input[builtins.str] vpc_endpoint_id: The ID of the VPC endpoint.
               
               > This property can only be set when `EndpointType` is set to `VPC_ENDPOINT` .
        :param pulumi.Input[builtins.str] vpc_id: The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.
               
               > This property can only be set when `EndpointType` is set to `VPC` .
        """
        if address_allocation_ids is not None:
            pulumi.set(__self__, "address_allocation_ids", address_allocation_ids)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if vpc_endpoint_id is not None:
            pulumi.set(__self__, "vpc_endpoint_id", vpc_endpoint_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="addressAllocationIds")
    def address_allocation_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.

        An address allocation ID corresponds to the allocation ID of an Elastic IP address. This value can be retrieved from the `allocationId` field from the Amazon EC2 [Address](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_Address.html) data type. One way to retrieve this value is by calling the EC2 [DescribeAddresses](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeAddresses.html) API.

        This parameter is optional. Set this parameter if you want to make your VPC endpoint public-facing. For details, see [Create an internet-facing endpoint for your server](https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#create-internet-facing-endpoint) .

        > This property can only be set as follows:
        > 
        > - `EndpointType` must be set to `VPC`
        > - The Transfer Family server must be offline.
        > - You cannot set this parameter for Transfer Family servers that use the FTP protocol.
        > - The server must already have `SubnetIds` populated ( `SubnetIds` and `AddressAllocationIds` cannot be updated simultaneously).
        > - `AddressAllocationIds` can't contain duplicates, and must be equal in length to `SubnetIds` . For example, if you have three subnet IDs, you must also specify three address allocation IDs.
        > - Call the `UpdateServer` API to set or change this parameter.
        """
        return pulumi.get(self, "address_allocation_ids")

    @address_allocation_ids.setter
    def address_allocation_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "address_allocation_ids", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of security groups IDs that are available to attach to your server's endpoint.

        > This property can only be set when `EndpointType` is set to `VPC` .
        > 
        > You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC` . To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of subnet IDs that are required to host your server endpoint in your VPC.

        > This property can only be set when `EndpointType` is set to `VPC` .
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="vpcEndpointId")
    def vpc_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the VPC endpoint.

        > This property can only be set when `EndpointType` is set to `VPC_ENDPOINT` .
        """
        return pulumi.get(self, "vpc_endpoint_id")

    @vpc_endpoint_id.setter
    def vpc_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The VPC ID of the virtual private cloud in which the server's endpoint will be hosted.

        > This property can only be set when `EndpointType` is set to `VPC` .
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class ServerIdentityProviderDetailsArgsDict(TypedDict):
        directory_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The identifier of the AWS Directory Service directory that you want to use as your identity provider.
        """
        function: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN for a Lambda function to use for the Identity provider.
        """
        invocation_role: NotRequired[pulumi.Input[builtins.str]]
        """
        This parameter is only applicable if your `IdentityProviderType` is `API_GATEWAY` . Provides the type of `InvocationRole` used to authenticate the user account.
        """
        sftp_authentication_methods: NotRequired[pulumi.Input['ServerSftpAuthenticationMethods']]
        """
        For SFTP-enabled servers, and for custom identity providers *only* , you can specify whether to authenticate using a password, SSH key pair, or both.

        - `PASSWORD` - users must provide their password to connect.
        - `PUBLIC_KEY` - users must provide their private key to connect.
        - `PUBLIC_KEY_OR_PASSWORD` - users can authenticate with either their password or their key. This is the default value.
        - `PUBLIC_KEY_AND_PASSWORD` - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.
        """
        url: NotRequired[pulumi.Input[builtins.str]]
        """
        Provides the location of the service endpoint used to authenticate users.
        """
elif False:
    ServerIdentityProviderDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerIdentityProviderDetailsArgs:
    def __init__(__self__, *,
                 directory_id: Optional[pulumi.Input[builtins.str]] = None,
                 function: Optional[pulumi.Input[builtins.str]] = None,
                 invocation_role: Optional[pulumi.Input[builtins.str]] = None,
                 sftp_authentication_methods: Optional[pulumi.Input['ServerSftpAuthenticationMethods']] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] directory_id: The identifier of the AWS Directory Service directory that you want to use as your identity provider.
        :param pulumi.Input[builtins.str] function: The ARN for a Lambda function to use for the Identity provider.
        :param pulumi.Input[builtins.str] invocation_role: This parameter is only applicable if your `IdentityProviderType` is `API_GATEWAY` . Provides the type of `InvocationRole` used to authenticate the user account.
        :param pulumi.Input['ServerSftpAuthenticationMethods'] sftp_authentication_methods: For SFTP-enabled servers, and for custom identity providers *only* , you can specify whether to authenticate using a password, SSH key pair, or both.
               
               - `PASSWORD` - users must provide their password to connect.
               - `PUBLIC_KEY` - users must provide their private key to connect.
               - `PUBLIC_KEY_OR_PASSWORD` - users can authenticate with either their password or their key. This is the default value.
               - `PUBLIC_KEY_AND_PASSWORD` - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.
        :param pulumi.Input[builtins.str] url: Provides the location of the service endpoint used to authenticate users.
        """
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if invocation_role is not None:
            pulumi.set(__self__, "invocation_role", invocation_role)
        if sftp_authentication_methods is not None:
            pulumi.set(__self__, "sftp_authentication_methods", sftp_authentication_methods)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The identifier of the AWS Directory Service directory that you want to use as your identity provider.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for a Lambda function to use for the Identity provider.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This parameter is only applicable if your `IdentityProviderType` is `API_GATEWAY` . Provides the type of `InvocationRole` used to authenticate the user account.
        """
        return pulumi.get(self, "invocation_role")

    @invocation_role.setter
    def invocation_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "invocation_role", value)

    @property
    @pulumi.getter(name="sftpAuthenticationMethods")
    def sftp_authentication_methods(self) -> Optional[pulumi.Input['ServerSftpAuthenticationMethods']]:
        """
        For SFTP-enabled servers, and for custom identity providers *only* , you can specify whether to authenticate using a password, SSH key pair, or both.

        - `PASSWORD` - users must provide their password to connect.
        - `PUBLIC_KEY` - users must provide their private key to connect.
        - `PUBLIC_KEY_OR_PASSWORD` - users can authenticate with either their password or their key. This is the default value.
        - `PUBLIC_KEY_AND_PASSWORD` - users must provide both their private key and their password to connect. The server checks the key first, and then if the key is valid, the system prompts for a password. If the private key provided does not match the public key that is stored, authentication fails.
        """
        return pulumi.get(self, "sftp_authentication_methods")

    @sftp_authentication_methods.setter
    def sftp_authentication_methods(self, value: Optional[pulumi.Input['ServerSftpAuthenticationMethods']]):
        pulumi.set(self, "sftp_authentication_methods", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provides the location of the service endpoint used to authenticate users.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)


if not MYPY:
    class ServerProtocolDetailsArgsDict(TypedDict):
        as2_transports: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServerAs2Transport']]]]
        """
        List of `As2Transport` objects.
        """
        passive_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:

        `aws transfer update-server --protocol-details PassiveIp=0.0.0.0`

        Replace `0.0.0.0` in the example above with the actual IP address you want to use.

        > If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family](https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/) . 

        *Special values*

        The `AUTO` and `0.0.0.0` are special values for the `PassiveIp` parameter. The value `PassiveIp=AUTO` is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. `PassiveIp=0.0.0.0` has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the `PassiveIp` parameter. This reduces the effectiveness of having High Availability. In this case, you can specify `PassiveIp=0.0.0.0` . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the `PassiveIp=0.0.0.0` response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the `PassiveIp=0.0.0.0` response.
        """
        set_stat_option: NotRequired[pulumi.Input['ServerSetStatOption']]
        """
        Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.

        Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.

        Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption` `ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.

        > If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT` , you can use Amazon EFS as backend storage with Transfer Family.
        """
        tls_session_resumption_mode: NotRequired[pulumi.Input['ServerTlsSessionResumptionMode']]
        """
        A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer` , it is set to `ENFORCED` by default.

        - `DISABLED` : the server does not process TLS session resumption client requests and creates a new TLS session for each request.
        - `ENABLED` : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
        - `ENFORCED` : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED` , test your clients.

        > Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
        """
elif False:
    ServerProtocolDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerProtocolDetailsArgs:
    def __init__(__self__, *,
                 as2_transports: Optional[pulumi.Input[Sequence[pulumi.Input['ServerAs2Transport']]]] = None,
                 passive_ip: Optional[pulumi.Input[builtins.str]] = None,
                 set_stat_option: Optional[pulumi.Input['ServerSetStatOption']] = None,
                 tls_session_resumption_mode: Optional[pulumi.Input['ServerTlsSessionResumptionMode']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServerAs2Transport']]] as2_transports: List of `As2Transport` objects.
        :param pulumi.Input[builtins.str] passive_ip: Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
               
               `aws transfer update-server --protocol-details PassiveIp=0.0.0.0`
               
               Replace `0.0.0.0` in the example above with the actual IP address you want to use.
               
               > If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family](https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/) . 
               
               *Special values*
               
               The `AUTO` and `0.0.0.0` are special values for the `PassiveIp` parameter. The value `PassiveIp=AUTO` is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. `PassiveIp=0.0.0.0` has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the `PassiveIp` parameter. This reduces the effectiveness of having High Availability. In this case, you can specify `PassiveIp=0.0.0.0` . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the `PassiveIp=0.0.0.0` response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the `PassiveIp=0.0.0.0` response.
        :param pulumi.Input['ServerSetStatOption'] set_stat_option: Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.
               
               Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
               
               Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption` `ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.
               
               > If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT` , you can use Amazon EFS as backend storage with Transfer Family.
        :param pulumi.Input['ServerTlsSessionResumptionMode'] tls_session_resumption_mode: A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer` , it is set to `ENFORCED` by default.
               
               - `DISABLED` : the server does not process TLS session resumption client requests and creates a new TLS session for each request.
               - `ENABLED` : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
               - `ENFORCED` : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED` , test your clients.
               
               > Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
        """
        if as2_transports is not None:
            pulumi.set(__self__, "as2_transports", as2_transports)
        if passive_ip is not None:
            pulumi.set(__self__, "passive_ip", passive_ip)
        if set_stat_option is not None:
            pulumi.set(__self__, "set_stat_option", set_stat_option)
        if tls_session_resumption_mode is not None:
            pulumi.set(__self__, "tls_session_resumption_mode", tls_session_resumption_mode)

    @property
    @pulumi.getter(name="as2Transports")
    def as2_transports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerAs2Transport']]]]:
        """
        List of `As2Transport` objects.
        """
        return pulumi.get(self, "as2_transports")

    @as2_transports.setter
    def as2_transports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerAs2Transport']]]]):
        pulumi.set(self, "as2_transports", value)

    @property
    @pulumi.getter(name="passiveIp")
    def passive_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:

        `aws transfer update-server --protocol-details PassiveIp=0.0.0.0`

        Replace `0.0.0.0` in the example above with the actual IP address you want to use.

        > If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with AWS Transfer Family](https://docs.aws.amazon.com/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/) . 

        *Special values*

        The `AUTO` and `0.0.0.0` are special values for the `PassiveIp` parameter. The value `PassiveIp=AUTO` is assigned by default to FTP and FTPS type servers. In this case, the server automatically responds with one of the endpoint IPs within the PASV response. `PassiveIp=0.0.0.0` has a more unique application for its usage. For example, if you have a High Availability (HA) Network Load Balancer (NLB) environment, where you have 3 subnets, you can only specify a single IP address using the `PassiveIp` parameter. This reduces the effectiveness of having High Availability. In this case, you can specify `PassiveIp=0.0.0.0` . This tells the client to use the same IP address as the Control connection and utilize all AZs for their connections. Note, however, that not all FTP clients support the `PassiveIp=0.0.0.0` response. FileZilla and WinSCP do support it. If you are using other clients, check to see if your client supports the `PassiveIp=0.0.0.0` response.
        """
        return pulumi.get(self, "passive_ip")

    @passive_ip.setter
    def passive_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "passive_ip", value)

    @property
    @pulumi.getter(name="setStatOption")
    def set_stat_option(self) -> Optional[pulumi.Input['ServerSetStatOption']]:
        """
        Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.

        Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.

        Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption` `ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.

        > If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT` , you can use Amazon EFS as backend storage with Transfer Family.
        """
        return pulumi.get(self, "set_stat_option")

    @set_stat_option.setter
    def set_stat_option(self, value: Optional[pulumi.Input['ServerSetStatOption']]):
        pulumi.set(self, "set_stat_option", value)

    @property
    @pulumi.getter(name="tlsSessionResumptionMode")
    def tls_session_resumption_mode(self) -> Optional[pulumi.Input['ServerTlsSessionResumptionMode']]:
        """
        A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer` , it is set to `ENFORCED` by default.

        - `DISABLED` : the server does not process TLS session resumption client requests and creates a new TLS session for each request.
        - `ENABLED` : the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
        - `ENFORCED` : the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED` , test your clients.

        > Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
        """
        return pulumi.get(self, "tls_session_resumption_mode")

    @tls_session_resumption_mode.setter
    def tls_session_resumption_mode(self, value: Optional[pulumi.Input['ServerTlsSessionResumptionMode']]):
        pulumi.set(self, "tls_session_resumption_mode", value)


if not MYPY:
    class ServerS3StorageOptionsArgsDict(TypedDict):
        directory_listing_optimization: NotRequired[pulumi.Input['ServerDirectoryListingOptimization']]
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.

        By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
elif False:
    ServerS3StorageOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerS3StorageOptionsArgs:
    def __init__(__self__, *,
                 directory_listing_optimization: Optional[pulumi.Input['ServerDirectoryListingOptimization']] = None):
        """
        :param pulumi.Input['ServerDirectoryListingOptimization'] directory_listing_optimization: Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
               
               By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        if directory_listing_optimization is not None:
            pulumi.set(__self__, "directory_listing_optimization", directory_listing_optimization)

    @property
    @pulumi.getter(name="directoryListingOptimization")
    def directory_listing_optimization(self) -> Optional[pulumi.Input['ServerDirectoryListingOptimization']]:
        """
        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.

        By default, home directory mappings have a `TYPE` of `DIRECTORY` . If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "directory_listing_optimization")

    @directory_listing_optimization.setter
    def directory_listing_optimization(self, value: Optional[pulumi.Input['ServerDirectoryListingOptimization']]):
        pulumi.set(self, "directory_listing_optimization", value)


if not MYPY:
    class ServerWorkflowDetailsArgsDict(TypedDict):
        on_partial_upload: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgsDict']]]]
        """
        A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server that executes whenever there is a partial upload.

        A *partial upload* occurs when a file is open when the session disconnects.

        > `OnPartialUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        on_upload: NotRequired[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgsDict']]]]
        """
        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.

        To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.

        `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`

        > `OnUpload` can contain a maximum of one `WorkflowDetail` object.
        """
elif False:
    ServerWorkflowDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerWorkflowDetailsArgs:
    def __init__(__self__, *,
                 on_partial_upload: Optional[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]]] = None,
                 on_upload: Optional[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]] on_partial_upload: A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server that executes whenever there is a partial upload.
               
               A *partial upload* occurs when a file is open when the session disconnects.
               
               > `OnPartialUpload` can contain a maximum of one `WorkflowDetail` object.
        :param pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]] on_upload: A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.
               
               To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.
               
               `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`
               
               > `OnUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        if on_partial_upload is not None:
            pulumi.set(__self__, "on_partial_upload", on_partial_upload)
        if on_upload is not None:
            pulumi.set(__self__, "on_upload", on_upload)

    @property
    @pulumi.getter(name="onPartialUpload")
    def on_partial_upload(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]]]:
        """
        A trigger that starts a workflow if a file is only partially uploaded. You can attach a workflow to a server that executes whenever there is a partial upload.

        A *partial upload* occurs when a file is open when the session disconnects.

        > `OnPartialUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        return pulumi.get(self, "on_partial_upload")

    @on_partial_upload.setter
    def on_partial_upload(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]]]):
        pulumi.set(self, "on_partial_upload", value)

    @property
    @pulumi.getter(name="onUpload")
    def on_upload(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]]]:
        """
        A trigger that starts a workflow: the workflow begins to execute after a file is uploaded.

        To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.

        `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`

        > `OnUpload` can contain a maximum of one `WorkflowDetail` object.
        """
        return pulumi.get(self, "on_upload")

    @on_upload.setter
    def on_upload(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServerWorkflowDetailArgs']]]]):
        pulumi.set(self, "on_upload", value)


if not MYPY:
    class ServerWorkflowDetailArgsDict(TypedDict):
        execution_role: pulumi.Input[builtins.str]
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources
        """
        workflow_id: pulumi.Input[builtins.str]
        """
        A unique identifier for the workflow.
        """
elif False:
    ServerWorkflowDetailArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ServerWorkflowDetailArgs:
    def __init__(__self__, *,
                 execution_role: pulumi.Input[builtins.str],
                 workflow_id: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] execution_role: Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources
        :param pulumi.Input[builtins.str] workflow_id: A unique identifier for the workflow.
        """
        pulumi.set(__self__, "execution_role", execution_role)
        pulumi.set(__self__, "workflow_id", workflow_id)

    @property
    @pulumi.getter(name="executionRole")
    def execution_role(self) -> pulumi.Input[builtins.str]:
        """
        Includes the necessary permissions for S3, EFS, and Lambda operations that Transfer can assume, so that all workflow steps can operate on the required resources
        """
        return pulumi.get(self, "execution_role")

    @execution_role.setter
    def execution_role(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "execution_role", value)

    @property
    @pulumi.getter(name="workflowId")
    def workflow_id(self) -> pulumi.Input[builtins.str]:
        """
        A unique identifier for the workflow.
        """
        return pulumi.get(self, "workflow_id")

    @workflow_id.setter
    def workflow_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workflow_id", value)


if not MYPY:
    class SftpConfigPropertiesArgsDict(TypedDict):
        """
        Configuration for an SFTP connector.
        """
        trusted_host_keys: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        List of public host keys, for the external server to which you are connecting.
        """
        user_secret_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
elif False:
    SftpConfigPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SftpConfigPropertiesArgs:
    def __init__(__self__, *,
                 trusted_host_keys: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_secret_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Configuration for an SFTP connector.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trusted_host_keys: List of public host keys, for the external server to which you are connecting.
        :param pulumi.Input[builtins.str] user_secret_id: ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        if trusted_host_keys is not None:
            pulumi.set(__self__, "trusted_host_keys", trusted_host_keys)
        if user_secret_id is not None:
            pulumi.set(__self__, "user_secret_id", user_secret_id)

    @property
    @pulumi.getter(name="trustedHostKeys")
    def trusted_host_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of public host keys, for the external server to which you are connecting.
        """
        return pulumi.get(self, "trusted_host_keys")

    @trusted_host_keys.setter
    def trusted_host_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trusted_host_keys", value)

    @property
    @pulumi.getter(name="userSecretId")
    def user_secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ARN or name of the secret in AWS Secrets Manager which contains the SFTP user's private keys or passwords.
        """
        return pulumi.get(self, "user_secret_id")

    @user_secret_id.setter
    def user_secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_secret_id", value)


if not MYPY:
    class UserHomeDirectoryMapEntryArgsDict(TypedDict):
        entry: pulumi.Input[builtins.str]
        """
        Represents an entry for `HomeDirectoryMappings` .
        """
        target: pulumi.Input[builtins.str]
        """
        Represents the map target that is used in a `HomeDirectoryMapEntry` .
        """
        type: NotRequired[pulumi.Input['UserMapType']]
        """
        Specifies the type of mapping. Set the type to `FILE` if you want the mapping to point to a file, or `DIRECTORY` for the directory to point to a directory.

        > By default, home directory mappings have a `Type` of `DIRECTORY` when you create a Transfer Family server. You would need to explicitly set `Type` to `FILE` if you want a mapping to have a file target.
        """
elif False:
    UserHomeDirectoryMapEntryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserHomeDirectoryMapEntryArgs:
    def __init__(__self__, *,
                 entry: pulumi.Input[builtins.str],
                 target: pulumi.Input[builtins.str],
                 type: Optional[pulumi.Input['UserMapType']] = None):
        """
        :param pulumi.Input[builtins.str] entry: Represents an entry for `HomeDirectoryMappings` .
        :param pulumi.Input[builtins.str] target: Represents the map target that is used in a `HomeDirectoryMapEntry` .
        :param pulumi.Input['UserMapType'] type: Specifies the type of mapping. Set the type to `FILE` if you want the mapping to point to a file, or `DIRECTORY` for the directory to point to a directory.
               
               > By default, home directory mappings have a `Type` of `DIRECTORY` when you create a Transfer Family server. You would need to explicitly set `Type` to `FILE` if you want a mapping to have a file target.
        """
        pulumi.set(__self__, "entry", entry)
        pulumi.set(__self__, "target", target)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Input[builtins.str]:
        """
        Represents an entry for `HomeDirectoryMappings` .
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[builtins.str]:
        """
        Represents the map target that is used in a `HomeDirectoryMapEntry` .
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['UserMapType']]:
        """
        Specifies the type of mapping. Set the type to `FILE` if you want the mapping to point to a file, or `DIRECTORY` for the directory to point to a directory.

        > By default, home directory mappings have a `Type` of `DIRECTORY` when you create a Transfer Family server. You would need to explicitly set `Type` to `FILE` if you want a mapping to have a file target.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['UserMapType']]):
        pulumi.set(self, "type", value)


if not MYPY:
    class UserPosixProfileArgsDict(TypedDict):
        gid: pulumi.Input[builtins.float]
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        uid: pulumi.Input[builtins.float]
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        secondary_gids: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]]
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
elif False:
    UserPosixProfileArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class UserPosixProfileArgs:
    def __init__(__self__, *,
                 gid: pulumi.Input[builtins.float],
                 uid: pulumi.Input[builtins.float],
                 secondary_gids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]] = None):
        """
        :param pulumi.Input[builtins.float] gid: The POSIX group ID used for all EFS operations by this user.
        :param pulumi.Input[builtins.float] uid: The POSIX user ID used for all EFS operations by this user.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.float]]] secondary_gids: The secondary POSIX group IDs used for all EFS operations by this user.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "uid", uid)
        if secondary_gids is not None:
            pulumi.set(__self__, "secondary_gids", secondary_gids)

    @property
    @pulumi.getter
    def gid(self) -> pulumi.Input[builtins.float]:
        """
        The POSIX group ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "gid")

    @gid.setter
    def gid(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "gid", value)

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Input[builtins.float]:
        """
        The POSIX user ID used for all EFS operations by this user.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: pulumi.Input[builtins.float]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="secondaryGids")
    def secondary_gids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]]:
        """
        The secondary POSIX group IDs used for all EFS operations by this user.
        """
        return pulumi.get(self, "secondary_gids")

    @secondary_gids.setter
    def secondary_gids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.float]]]]):
        pulumi.set(self, "secondary_gids", value)


if not MYPY:
    class WebAppCustomizationArgsDict(TypedDict):
        favicon_file: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies a favicon to display in the browser tab.
        """
        logo_file: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies a logo to display on the web app.
        """
        title: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies a title to display on the web app.
        """
elif False:
    WebAppCustomizationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WebAppCustomizationArgs:
    def __init__(__self__, *,
                 favicon_file: Optional[pulumi.Input[builtins.str]] = None,
                 logo_file: Optional[pulumi.Input[builtins.str]] = None,
                 title: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] favicon_file: Specifies a favicon to display in the browser tab.
        :param pulumi.Input[builtins.str] logo_file: Specifies a logo to display on the web app.
        :param pulumi.Input[builtins.str] title: Specifies a title to display on the web app.
        """
        if favicon_file is not None:
            pulumi.set(__self__, "favicon_file", favicon_file)
        if logo_file is not None:
            pulumi.set(__self__, "logo_file", logo_file)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="faviconFile")
    def favicon_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a favicon to display in the browser tab.
        """
        return pulumi.get(self, "favicon_file")

    @favicon_file.setter
    def favicon_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "favicon_file", value)

    @property
    @pulumi.getter(name="logoFile")
    def logo_file(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a logo to display on the web app.
        """
        return pulumi.get(self, "logo_file")

    @logo_file.setter
    def logo_file(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logo_file", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a title to display on the web app.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "title", value)


if not MYPY:
    class WebAppIdentityProviderDetailsArgsDict(TypedDict):
        """
        You can provide a structure that contains the details for the identity provider to use with your web app.
        """
        application_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
        """
        instance_arn: NotRequired[pulumi.Input[builtins.str]]
        """
        The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
        """
        role: NotRequired[pulumi.Input[builtins.str]]
        """
        The IAM role in IAM Identity Center used for the web app.
        """
elif False:
    WebAppIdentityProviderDetailsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WebAppIdentityProviderDetailsArgs:
    def __init__(__self__, *,
                 application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 role: Optional[pulumi.Input[builtins.str]] = None):
        """
        You can provide a structure that contains the details for the identity provider to use with your web app.
        :param pulumi.Input[builtins.str] application_arn: The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
        :param pulumi.Input[builtins.str] instance_arn: The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
        :param pulumi.Input[builtins.str] role: The IAM role in IAM Identity Center used for the web app.
        """
        if application_arn is not None:
            pulumi.set(__self__, "application_arn", application_arn)
        if instance_arn is not None:
            pulumi.set(__self__, "instance_arn", instance_arn)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you create your web app.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IAM role in IAM Identity Center used for the web app.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "role", value)


if not MYPY:
    class WebAppUnitsPropertiesArgsDict(TypedDict):
        """
        A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        provisioned: pulumi.Input[builtins.int]
elif False:
    WebAppUnitsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WebAppUnitsPropertiesArgs:
    def __init__(__self__, *,
                 provisioned: pulumi.Input[builtins.int]):
        """
        A union that contains the value for number of concurrent connections or the user sessions on your web app.
        """
        pulumi.set(__self__, "provisioned", provisioned)

    @property
    @pulumi.getter
    def provisioned(self) -> pulumi.Input[builtins.int]:
        return pulumi.get(self, "provisioned")

    @provisioned.setter
    def provisioned(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "provisioned", value)


if not MYPY:
    class WorkflowEfsInputFileLocationArgsDict(TypedDict):
        """
        Specifies the details for an EFS file.
        """
        file_system_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the EFS filesystem that contains the file.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
elif False:
    WorkflowEfsInputFileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowEfsInputFileLocationArgs:
    def __init__(__self__, *,
                 file_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies the details for an EFS file.
        :param pulumi.Input[builtins.str] file_system_id: Specifies the EFS filesystem that contains the file.
        :param pulumi.Input[builtins.str] path: The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        if file_system_id is not None:
            pulumi.set(__self__, "file_system_id", file_system_id)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the EFS filesystem that contains the file.
        """
        return pulumi.get(self, "file_system_id")

    @file_system_id.setter
    def file_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "file_system_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name assigned to the file when it was created in EFS. You use the object path to retrieve the object.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class WorkflowInputFileLocationArgsDict(TypedDict):
        """
        Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
        """
        efs_file_location: NotRequired[pulumi.Input['WorkflowEfsInputFileLocationArgsDict']]
        s3_file_location: NotRequired[pulumi.Input['WorkflowS3InputFileLocationArgsDict']]
elif False:
    WorkflowInputFileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowInputFileLocationArgs:
    def __init__(__self__, *,
                 efs_file_location: Optional[pulumi.Input['WorkflowEfsInputFileLocationArgs']] = None,
                 s3_file_location: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']] = None):
        """
        Specifies the location for the file being decrypted. Only applicable for the Decrypt type of workflow steps.
        """
        if efs_file_location is not None:
            pulumi.set(__self__, "efs_file_location", efs_file_location)
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="efsFileLocation")
    def efs_file_location(self) -> Optional[pulumi.Input['WorkflowEfsInputFileLocationArgs']]:
        return pulumi.get(self, "efs_file_location")

    @efs_file_location.setter
    def efs_file_location(self, value: Optional[pulumi.Input['WorkflowEfsInputFileLocationArgs']]):
        pulumi.set(self, "efs_file_location", value)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]:
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


if not MYPY:
    class WorkflowS3FileLocationArgsDict(TypedDict):
        """
        Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
        """
        s3_file_location: NotRequired[pulumi.Input['WorkflowS3InputFileLocationArgsDict']]
        """
        Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
elif False:
    WorkflowS3FileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowS3FileLocationArgs:
    def __init__(__self__, *,
                 s3_file_location: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']] = None):
        """
        Specifies the location for the file being copied. Only applicable for the Copy type of workflow steps.
        :param pulumi.Input['WorkflowS3InputFileLocationArgs'] s3_file_location: Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
        if s3_file_location is not None:
            pulumi.set(__self__, "s3_file_location", s3_file_location)

    @property
    @pulumi.getter(name="s3FileLocation")
    def s3_file_location(self) -> Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]:
        """
        Specifies the details for the file location for the file that's being used in the workflow. Only applicable if you are using Amazon S3 storage.
        """
        return pulumi.get(self, "s3_file_location")

    @s3_file_location.setter
    def s3_file_location(self, value: Optional[pulumi.Input['WorkflowS3InputFileLocationArgs']]):
        pulumi.set(self, "s3_file_location", value)


if not MYPY:
    class WorkflowS3InputFileLocationArgsDict(TypedDict):
        """
        Specifies the details for a S3 file.
        """
        bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies the S3 bucket that contains the file.
        """
        key: NotRequired[pulumi.Input[builtins.str]]
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
elif False:
    WorkflowS3InputFileLocationArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowS3InputFileLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[builtins.str]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None):
        """
        Specifies the details for a S3 file.
        :param pulumi.Input[builtins.str] bucket: Specifies the S3 bucket that contains the file.
        :param pulumi.Input[builtins.str] key: The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the S3 bucket that contains the file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)


if not MYPY:
    class WorkflowS3TagArgsDict(TypedDict):
        """
        Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
        """
        key: pulumi.Input[builtins.str]
        """
        The name assigned to the tag that you create.
        """
        value: pulumi.Input[builtins.str]
        """
        The value that corresponds to the key.
        """
elif False:
    WorkflowS3TagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowS3TagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[builtins.str],
                 value: pulumi.Input[builtins.str]):
        """
        Specifies the key-value pair that are assigned to a file during the execution of a Tagging step.
        :param pulumi.Input[builtins.str] key: The name assigned to the tag that you create.
        :param pulumi.Input[builtins.str] value: The value that corresponds to the key.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[builtins.str]:
        """
        The name assigned to the tag that you create.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The value that corresponds to the key.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class WorkflowStepCopyStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that performs a file copy.
        """
        destination_file_location: NotRequired[pulumi.Input['WorkflowS3FileLocationArgsDict']]
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the step, used as an identifier.
        """
        overwrite_existing: NotRequired[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']]
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        source_file_location: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies which file to use as input to the workflow step.
        """
elif False:
    WorkflowStepCopyStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepCopyStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 destination_file_location: Optional[pulumi.Input['WorkflowS3FileLocationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 overwrite_existing: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']] = None,
                 source_file_location: Optional[pulumi.Input[builtins.str]] = None):
        """
        Details for a step that performs a file copy.
        :param pulumi.Input[builtins.str] name: The name of the step, used as an identifier.
        :param pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting'] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param pulumi.Input[builtins.str] source_file_location: Specifies which file to use as input to the workflow step.
        """
        if destination_file_location is not None:
            pulumi.set(__self__, "destination_file_location", destination_file_location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> Optional[pulumi.Input['WorkflowS3FileLocationArgs']]:
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: Optional[pulumi.Input['WorkflowS3FileLocationArgs']]):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesOverwriteExisting']]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_file_location", value)


if not MYPY:
    class WorkflowStepCustomStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that invokes a lambda function.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the step, used as an identifier.
        """
        source_file_location: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies which file to use as input to the workflow step.
        """
        target: NotRequired[pulumi.Input[builtins.str]]
        """
        The ARN for the lambda function that is being called.
        """
        timeout_seconds: NotRequired[pulumi.Input[builtins.int]]
        """
        Timeout, in seconds, for the step.
        """
elif False:
    WorkflowStepCustomStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepCustomStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_file_location: Optional[pulumi.Input[builtins.str]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 timeout_seconds: Optional[pulumi.Input[builtins.int]] = None):
        """
        Details for a step that invokes a lambda function.
        :param pulumi.Input[builtins.str] name: The name of the step, used as an identifier.
        :param pulumi.Input[builtins.str] source_file_location: Specifies which file to use as input to the workflow step.
        :param pulumi.Input[builtins.str] target: The ARN for the lambda function that is being called.
        :param pulumi.Input[builtins.int] timeout_seconds: Timeout, in seconds, for the step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARN for the lambda function that is being called.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Timeout, in seconds, for the step.
        """
        return pulumi.get(self, "timeout_seconds")

    @timeout_seconds.setter
    def timeout_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout_seconds", value)


if not MYPY:
    class WorkflowStepDecryptStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that performs a file decryption.
        """
        destination_file_location: pulumi.Input['WorkflowInputFileLocationArgsDict']
        type: pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType']
        """
        Specifies which encryption method to use.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the step, used as an identifier.
        """
        overwrite_existing: NotRequired[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']]
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        source_file_location: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies which file to use as input to the workflow step.
        """
elif False:
    WorkflowStepDecryptStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepDecryptStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 destination_file_location: pulumi.Input['WorkflowInputFileLocationArgs'],
                 type: pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType'],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 overwrite_existing: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']] = None,
                 source_file_location: Optional[pulumi.Input[builtins.str]] = None):
        """
        Details for a step that performs a file decryption.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType'] type: Specifies which encryption method to use.
        :param pulumi.Input[builtins.str] name: The name of the step, used as an identifier.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting'] overwrite_existing: A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        :param pulumi.Input[builtins.str] source_file_location: Specifies which file to use as input to the workflow step.
        """
        pulumi.set(__self__, "destination_file_location", destination_file_location)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite_existing is not None:
            pulumi.set(__self__, "overwrite_existing", overwrite_existing)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter(name="destinationFileLocation")
    def destination_file_location(self) -> pulumi.Input['WorkflowInputFileLocationArgs']:
        return pulumi.get(self, "destination_file_location")

    @destination_file_location.setter
    def destination_file_location(self, value: pulumi.Input['WorkflowInputFileLocationArgs']):
        pulumi.set(self, "destination_file_location", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType']:
        """
        Specifies which encryption method to use.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overwriteExisting")
    def overwrite_existing(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']]:
        """
        A flag that indicates whether or not to overwrite an existing file of the same name. The default is FALSE.
        """
        return pulumi.get(self, "overwrite_existing")

    @overwrite_existing.setter
    def overwrite_existing(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesOverwriteExisting']]):
        pulumi.set(self, "overwrite_existing", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_file_location", value)


if not MYPY:
    class WorkflowStepDeleteStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that deletes the file.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the step, used as an identifier.
        """
        source_file_location: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies which file to use as input to the workflow step.
        """
elif False:
    WorkflowStepDeleteStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepDeleteStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_file_location: Optional[pulumi.Input[builtins.str]] = None):
        """
        Details for a step that deletes the file.
        :param pulumi.Input[builtins.str] name: The name of the step, used as an identifier.
        :param pulumi.Input[builtins.str] source_file_location: Specifies which file to use as input to the workflow step.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_file_location", value)


if not MYPY:
    class WorkflowStepTagStepDetailsPropertiesArgsDict(TypedDict):
        """
        Details for a step that creates one or more tags.
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the step, used as an identifier.
        """
        source_file_location: NotRequired[pulumi.Input[builtins.str]]
        """
        Specifies which file to use as input to the workflow step.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgsDict']]]]
        """
        Array that contains from 1 to 10 key/value pairs.
        """
elif False:
    WorkflowStepTagStepDetailsPropertiesArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepTagStepDetailsPropertiesArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 source_file_location: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]]] = None):
        """
        Details for a step that creates one or more tags.
        :param pulumi.Input[builtins.str] name: The name of the step, used as an identifier.
        :param pulumi.Input[builtins.str] source_file_location: Specifies which file to use as input to the workflow step.
        :param pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]] tags: Array that contains from 1 to 10 key/value pairs.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source_file_location is not None:
            pulumi.set(__self__, "source_file_location", source_file_location)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the step, used as an identifier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sourceFileLocation")
    def source_file_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies which file to use as input to the workflow step.
        """
        return pulumi.get(self, "source_file_location")

    @source_file_location.setter
    def source_file_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_file_location", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]]]:
        """
        Array that contains from 1 to 10 key/value pairs.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WorkflowS3TagArgs']]]]):
        pulumi.set(self, "tags", value)


if not MYPY:
    class WorkflowStepArgsDict(TypedDict):
        """
        The basic building block of a workflow.
        """
        copy_step_details: NotRequired[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgsDict']]
        """
        Details for a step that performs a file copy.
        """
        custom_step_details: NotRequired[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgsDict']]
        """
        Details for a step that invokes a lambda function.
        """
        decrypt_step_details: NotRequired[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgsDict']]
        """
        Details for a step that performs a file decryption.
        """
        delete_step_details: NotRequired[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgsDict']]
        """
        Details for a step that deletes the file.
        """
        tag_step_details: NotRequired[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgsDict']]
        """
        Details for a step that creates one or more tags.
        """
        type: NotRequired[pulumi.Input['WorkflowStepType']]
elif False:
    WorkflowStepArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkflowStepArgs:
    def __init__(__self__, *,
                 copy_step_details: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs']] = None,
                 custom_step_details: Optional[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs']] = None,
                 decrypt_step_details: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs']] = None,
                 delete_step_details: Optional[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs']] = None,
                 tag_step_details: Optional[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs']] = None,
                 type: Optional[pulumi.Input['WorkflowStepType']] = None):
        """
        The basic building block of a workflow.
        :param pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs'] copy_step_details: Details for a step that performs a file copy.
        :param pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs'] custom_step_details: Details for a step that invokes a lambda function.
        :param pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs'] decrypt_step_details: Details for a step that performs a file decryption.
        :param pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs'] delete_step_details: Details for a step that deletes the file.
        :param pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs'] tag_step_details: Details for a step that creates one or more tags.
        """
        if copy_step_details is not None:
            pulumi.set(__self__, "copy_step_details", copy_step_details)
        if custom_step_details is not None:
            pulumi.set(__self__, "custom_step_details", custom_step_details)
        if decrypt_step_details is not None:
            pulumi.set(__self__, "decrypt_step_details", decrypt_step_details)
        if delete_step_details is not None:
            pulumi.set(__self__, "delete_step_details", delete_step_details)
        if tag_step_details is not None:
            pulumi.set(__self__, "tag_step_details", tag_step_details)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="copyStepDetails")
    def copy_step_details(self) -> Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs']]:
        """
        Details for a step that performs a file copy.
        """
        return pulumi.get(self, "copy_step_details")

    @copy_step_details.setter
    def copy_step_details(self, value: Optional[pulumi.Input['WorkflowStepCopyStepDetailsPropertiesArgs']]):
        pulumi.set(self, "copy_step_details", value)

    @property
    @pulumi.getter(name="customStepDetails")
    def custom_step_details(self) -> Optional[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs']]:
        """
        Details for a step that invokes a lambda function.
        """
        return pulumi.get(self, "custom_step_details")

    @custom_step_details.setter
    def custom_step_details(self, value: Optional[pulumi.Input['WorkflowStepCustomStepDetailsPropertiesArgs']]):
        pulumi.set(self, "custom_step_details", value)

    @property
    @pulumi.getter(name="decryptStepDetails")
    def decrypt_step_details(self) -> Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs']]:
        """
        Details for a step that performs a file decryption.
        """
        return pulumi.get(self, "decrypt_step_details")

    @decrypt_step_details.setter
    def decrypt_step_details(self, value: Optional[pulumi.Input['WorkflowStepDecryptStepDetailsPropertiesArgs']]):
        pulumi.set(self, "decrypt_step_details", value)

    @property
    @pulumi.getter(name="deleteStepDetails")
    def delete_step_details(self) -> Optional[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs']]:
        """
        Details for a step that deletes the file.
        """
        return pulumi.get(self, "delete_step_details")

    @delete_step_details.setter
    def delete_step_details(self, value: Optional[pulumi.Input['WorkflowStepDeleteStepDetailsPropertiesArgs']]):
        pulumi.set(self, "delete_step_details", value)

    @property
    @pulumi.getter(name="tagStepDetails")
    def tag_step_details(self) -> Optional[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs']]:
        """
        Details for a step that creates one or more tags.
        """
        return pulumi.get(self, "tag_step_details")

    @tag_step_details.setter
    def tag_step_details(self, value: Optional[pulumi.Input['WorkflowStepTagStepDetailsPropertiesArgs']]):
        pulumi.set(self, "tag_step_details", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input['WorkflowStepType']]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input['WorkflowStepType']]):
        pulumi.set(self, "type", value)


