# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'LogDeliveryConfigurationProperties',
    'LogDeliveryConfigurationPropertiesS3ConfigurationProperties',
    'MagneticStoreWritePropertiesProperties',
    'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties',
    'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties',
    'RetentionPropertiesProperties',
    'ScheduledQueryDimensionMapping',
    'ScheduledQueryErrorReportConfiguration',
    'ScheduledQueryMixedMeasureMapping',
    'ScheduledQueryMultiMeasureAttributeMapping',
    'ScheduledQueryMultiMeasureMappings',
    'ScheduledQueryNotificationConfiguration',
    'ScheduledQueryS3Configuration',
    'ScheduledQueryScheduleConfiguration',
    'ScheduledQuerySnsConfiguration',
    'ScheduledQueryTargetConfiguration',
    'ScheduledQueryTimestreamConfiguration',
    'SchemaProperties',
    'TablePartitionKey',
]

@pulumi.output_type
class LogDeliveryConfigurationProperties(dict):
    """
    Configuration for sending logs to customer account from the InfluxDB instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Configuration":
            suggest = "s3_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_configuration: 'outputs.LogDeliveryConfigurationPropertiesS3ConfigurationProperties'):
        """
        Configuration for sending logs to customer account from the InfluxDB instance.
        :param 'LogDeliveryConfigurationPropertiesS3ConfigurationProperties' s3_configuration: S3 configuration for sending logs to customer account from the InfluxDB instance.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.LogDeliveryConfigurationPropertiesS3ConfigurationProperties':
        """
        S3 configuration for sending logs to customer account from the InfluxDB instance.
        """
        return pulumi.get(self, "s3_configuration")


@pulumi.output_type
class LogDeliveryConfigurationPropertiesS3ConfigurationProperties(dict):
    """
    S3 configuration for sending logs to customer account from the InfluxDB instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LogDeliveryConfigurationPropertiesS3ConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LogDeliveryConfigurationPropertiesS3ConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LogDeliveryConfigurationPropertiesS3ConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 enabled: builtins.bool):
        """
        S3 configuration for sending logs to customer account from the InfluxDB instance.
        :param builtins.str bucket_name: The bucket name for logs to be sent from the InfluxDB instance
        :param builtins.bool enabled: Specifies whether logging to customer specified bucket is enabled.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The bucket name for logs to be sent from the InfluxDB instance
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Specifies whether logging to customer specified bucket is enabled.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class MagneticStoreWritePropertiesProperties(dict):
    """
    The properties that determine whether magnetic store writes are enabled.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableMagneticStoreWrites":
            suggest = "enable_magnetic_store_writes"
        elif key == "magneticStoreRejectedDataLocation":
            suggest = "magnetic_store_rejected_data_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MagneticStoreWritePropertiesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MagneticStoreWritePropertiesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MagneticStoreWritePropertiesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_magnetic_store_writes: builtins.bool,
                 magnetic_store_rejected_data_location: Optional['outputs.MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties'] = None):
        """
        The properties that determine whether magnetic store writes are enabled.
        :param builtins.bool enable_magnetic_store_writes: Boolean flag indicating whether magnetic store writes are enabled.
        :param 'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties' magnetic_store_rejected_data_location: Location to store information about records that were asynchronously rejected during magnetic store writes.
        """
        pulumi.set(__self__, "enable_magnetic_store_writes", enable_magnetic_store_writes)
        if magnetic_store_rejected_data_location is not None:
            pulumi.set(__self__, "magnetic_store_rejected_data_location", magnetic_store_rejected_data_location)

    @property
    @pulumi.getter(name="enableMagneticStoreWrites")
    def enable_magnetic_store_writes(self) -> builtins.bool:
        """
        Boolean flag indicating whether magnetic store writes are enabled.
        """
        return pulumi.get(self, "enable_magnetic_store_writes")

    @property
    @pulumi.getter(name="magneticStoreRejectedDataLocation")
    def magnetic_store_rejected_data_location(self) -> Optional['outputs.MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties']:
        """
        Location to store information about records that were asynchronously rejected during magnetic store writes.
        """
        return pulumi.get(self, "magnetic_store_rejected_data_location")


@pulumi.output_type
class MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties(dict):
    """
    Location to store information about records that were asynchronously rejected during magnetic store writes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Configuration":
            suggest = "s3_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_configuration: Optional['outputs.MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties'] = None):
        """
        Location to store information about records that were asynchronously rejected during magnetic store writes.
        :param 'MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties' s3_configuration: S3 configuration for location to store rejections from magnetic store writes
        """
        if s3_configuration is not None:
            pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> Optional['outputs.MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties']:
        """
        S3 configuration for location to store rejections from magnetic store writes
        """
        return pulumi.get(self, "s3_configuration")


@pulumi.output_type
class MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties(dict):
    """
    S3 configuration for location to store rejections from magnetic store writes
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "objectKeyPrefix":
            suggest = "object_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MagneticStoreWritePropertiesPropertiesMagneticStoreRejectedDataLocationPropertiesS3ConfigurationProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 encryption_option: builtins.str,
                 kms_key_id: Optional[builtins.str] = None,
                 object_key_prefix: Optional[builtins.str] = None):
        """
        S3 configuration for location to store rejections from magnetic store writes
        :param builtins.str bucket_name: The bucket name used to store the data.
        :param builtins.str encryption_option: Either SSE_KMS or SSE_S3.
        :param builtins.str kms_key_id: Must be provided if SSE_KMS is specified as the encryption option
        :param builtins.str object_key_prefix: String used to prefix all data in the bucket.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "encryption_option", encryption_option)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        The bucket name used to store the data.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> builtins.str:
        """
        Either SSE_KMS or SSE_S3.
        """
        return pulumi.get(self, "encryption_option")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[builtins.str]:
        """
        Must be provided if SSE_KMS is specified as the encryption option
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[builtins.str]:
        """
        String used to prefix all data in the bucket.
        """
        return pulumi.get(self, "object_key_prefix")


@pulumi.output_type
class RetentionPropertiesProperties(dict):
    """
    The retention duration of the memory store and the magnetic store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "magneticStoreRetentionPeriodInDays":
            suggest = "magnetic_store_retention_period_in_days"
        elif key == "memoryStoreRetentionPeriodInHours":
            suggest = "memory_store_retention_period_in_hours"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RetentionPropertiesProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RetentionPropertiesProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RetentionPropertiesProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 magnetic_store_retention_period_in_days: Optional[builtins.str] = None,
                 memory_store_retention_period_in_hours: Optional[builtins.str] = None):
        """
        The retention duration of the memory store and the magnetic store.
        :param builtins.str magnetic_store_retention_period_in_days: The duration for which data must be stored in the magnetic store.
        :param builtins.str memory_store_retention_period_in_hours: The duration for which data must be stored in the memory store.
        """
        if magnetic_store_retention_period_in_days is not None:
            pulumi.set(__self__, "magnetic_store_retention_period_in_days", magnetic_store_retention_period_in_days)
        if memory_store_retention_period_in_hours is not None:
            pulumi.set(__self__, "memory_store_retention_period_in_hours", memory_store_retention_period_in_hours)

    @property
    @pulumi.getter(name="magneticStoreRetentionPeriodInDays")
    def magnetic_store_retention_period_in_days(self) -> Optional[builtins.str]:
        """
        The duration for which data must be stored in the magnetic store.
        """
        return pulumi.get(self, "magnetic_store_retention_period_in_days")

    @property
    @pulumi.getter(name="memoryStoreRetentionPeriodInHours")
    def memory_store_retention_period_in_hours(self) -> Optional[builtins.str]:
        """
        The duration for which data must be stored in the memory store.
        """
        return pulumi.get(self, "memory_store_retention_period_in_hours")


@pulumi.output_type
class ScheduledQueryDimensionMapping(dict):
    """
    This type is used to map column(s) from the query result to a dimension in the destination table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dimensionValueType":
            suggest = "dimension_value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryDimensionMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryDimensionMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryDimensionMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dimension_value_type: 'ScheduledQueryDimensionValueType',
                 name: builtins.str):
        """
        This type is used to map column(s) from the query result to a dimension in the destination table.
        """
        pulumi.set(__self__, "dimension_value_type", dimension_value_type)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="dimensionValueType")
    def dimension_value_type(self) -> 'ScheduledQueryDimensionValueType':
        return pulumi.get(self, "dimension_value_type")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")


@pulumi.output_type
class ScheduledQueryErrorReportConfiguration(dict):
    """
    Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Configuration":
            suggest = "s3_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryErrorReportConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryErrorReportConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryErrorReportConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_configuration: 'outputs.ScheduledQueryS3Configuration'):
        """
        Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the query results.
        :param 'ScheduledQueryS3Configuration' s3_configuration: The S3 configuration for the error reports.
        """
        pulumi.set(__self__, "s3_configuration", s3_configuration)

    @property
    @pulumi.getter(name="s3Configuration")
    def s3_configuration(self) -> 'outputs.ScheduledQueryS3Configuration':
        """
        The S3 configuration for the error reports.
        """
        return pulumi.get(self, "s3_configuration")


@pulumi.output_type
class ScheduledQueryMixedMeasureMapping(dict):
    """
    MixedMeasureMappings are mappings that can be used to ingest data into a mixture of narrow and multi measures in the derived table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureValueType":
            suggest = "measure_value_type"
        elif key == "measureName":
            suggest = "measure_name"
        elif key == "multiMeasureAttributeMappings":
            suggest = "multi_measure_attribute_mappings"
        elif key == "sourceColumn":
            suggest = "source_column"
        elif key == "targetMeasureName":
            suggest = "target_measure_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryMixedMeasureMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryMixedMeasureMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryMixedMeasureMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_value_type: 'ScheduledQueryMixedMeasureMappingMeasureValueType',
                 measure_name: Optional[builtins.str] = None,
                 multi_measure_attribute_mappings: Optional[Sequence['outputs.ScheduledQueryMultiMeasureAttributeMapping']] = None,
                 source_column: Optional[builtins.str] = None,
                 target_measure_name: Optional[builtins.str] = None):
        """
        MixedMeasureMappings are mappings that can be used to ingest data into a mixture of narrow and multi measures in the derived table.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        if measure_name is not None:
            pulumi.set(__self__, "measure_name", measure_name)
        if multi_measure_attribute_mappings is not None:
            pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        if source_column is not None:
            pulumi.set(__self__, "source_column", source_column)
        if target_measure_name is not None:
            pulumi.set(__self__, "target_measure_name", target_measure_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> 'ScheduledQueryMixedMeasureMappingMeasureValueType':
        return pulumi.get(self, "measure_value_type")

    @property
    @pulumi.getter(name="measureName")
    def measure_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "measure_name")

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> Optional[Sequence['outputs.ScheduledQueryMultiMeasureAttributeMapping']]:
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> Optional[builtins.str]:
        return pulumi.get(self, "source_column")

    @property
    @pulumi.getter(name="targetMeasureName")
    def target_measure_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_measure_name")


@pulumi.output_type
class ScheduledQueryMultiMeasureAttributeMapping(dict):
    """
    An attribute mapping to be used for mapping query results to ingest data for multi-measure attributes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "measureValueType":
            suggest = "measure_value_type"
        elif key == "sourceColumn":
            suggest = "source_column"
        elif key == "targetMultiMeasureAttributeName":
            suggest = "target_multi_measure_attribute_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryMultiMeasureAttributeMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryMultiMeasureAttributeMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryMultiMeasureAttributeMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 measure_value_type: 'ScheduledQueryMultiMeasureAttributeMappingMeasureValueType',
                 source_column: builtins.str,
                 target_multi_measure_attribute_name: Optional[builtins.str] = None):
        """
        An attribute mapping to be used for mapping query results to ingest data for multi-measure attributes.
        """
        pulumi.set(__self__, "measure_value_type", measure_value_type)
        pulumi.set(__self__, "source_column", source_column)
        if target_multi_measure_attribute_name is not None:
            pulumi.set(__self__, "target_multi_measure_attribute_name", target_multi_measure_attribute_name)

    @property
    @pulumi.getter(name="measureValueType")
    def measure_value_type(self) -> 'ScheduledQueryMultiMeasureAttributeMappingMeasureValueType':
        return pulumi.get(self, "measure_value_type")

    @property
    @pulumi.getter(name="sourceColumn")
    def source_column(self) -> builtins.str:
        return pulumi.get(self, "source_column")

    @property
    @pulumi.getter(name="targetMultiMeasureAttributeName")
    def target_multi_measure_attribute_name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "target_multi_measure_attribute_name")


@pulumi.output_type
class ScheduledQueryMultiMeasureMappings(dict):
    """
    Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided. MultiMeasureMappings can be used to ingest data as multi measures in the derived table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "multiMeasureAttributeMappings":
            suggest = "multi_measure_attribute_mappings"
        elif key == "targetMultiMeasureName":
            suggest = "target_multi_measure_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryMultiMeasureMappings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryMultiMeasureMappings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryMultiMeasureMappings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 multi_measure_attribute_mappings: Sequence['outputs.ScheduledQueryMultiMeasureAttributeMapping'],
                 target_multi_measure_name: Optional[builtins.str] = None):
        """
        Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided. MultiMeasureMappings can be used to ingest data as multi measures in the derived table.
        :param Sequence['ScheduledQueryMultiMeasureAttributeMapping'] multi_measure_attribute_mappings: Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
        :param builtins.str target_multi_measure_name: The name of the target multi-measure name in the derived table. This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
        """
        pulumi.set(__self__, "multi_measure_attribute_mappings", multi_measure_attribute_mappings)
        if target_multi_measure_name is not None:
            pulumi.set(__self__, "target_multi_measure_name", target_multi_measure_name)

    @property
    @pulumi.getter(name="multiMeasureAttributeMappings")
    def multi_measure_attribute_mappings(self) -> Sequence['outputs.ScheduledQueryMultiMeasureAttributeMapping']:
        """
        Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
        """
        return pulumi.get(self, "multi_measure_attribute_mappings")

    @property
    @pulumi.getter(name="targetMultiMeasureName")
    def target_multi_measure_name(self) -> Optional[builtins.str]:
        """
        The name of the target multi-measure name in the derived table. This input is required when measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
        """
        return pulumi.get(self, "target_multi_measure_name")


@pulumi.output_type
class ScheduledQueryNotificationConfiguration(dict):
    """
    Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "snsConfiguration":
            suggest = "sns_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sns_configuration: 'outputs.ScheduledQuerySnsConfiguration'):
        """
        Notification configuration for the scheduled query. A notification is sent by Timestream when a query run finishes, when the state is updated or when you delete it.
        :param 'ScheduledQuerySnsConfiguration' sns_configuration: Details on SNS configuration.
        """
        pulumi.set(__self__, "sns_configuration", sns_configuration)

    @property
    @pulumi.getter(name="snsConfiguration")
    def sns_configuration(self) -> 'outputs.ScheduledQuerySnsConfiguration':
        """
        Details on SNS configuration.
        """
        return pulumi.get(self, "sns_configuration")


@pulumi.output_type
class ScheduledQueryS3Configuration(dict):
    """
    Details on S3 location for error reports that result from running a query.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "encryptionOption":
            suggest = "encryption_option"
        elif key == "objectKeyPrefix":
            suggest = "object_key_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryS3Configuration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryS3Configuration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryS3Configuration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: builtins.str,
                 encryption_option: Optional['ScheduledQueryEncryptionOption'] = None,
                 object_key_prefix: Optional[builtins.str] = None):
        """
        Details on S3 location for error reports that result from running a query.
        :param builtins.str bucket_name: Name of the S3 bucket under which error reports will be created.
        :param 'ScheduledQueryEncryptionOption' encryption_option: Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
        :param builtins.str object_key_prefix: Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if encryption_option is not None:
            pulumi.set(__self__, "encryption_option", encryption_option)
        if object_key_prefix is not None:
            pulumi.set(__self__, "object_key_prefix", object_key_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> builtins.str:
        """
        Name of the S3 bucket under which error reports will be created.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="encryptionOption")
    def encryption_option(self) -> Optional['ScheduledQueryEncryptionOption']:
        """
        Encryption at rest options for the error reports. If no encryption option is specified, Timestream will choose SSE_S3 as default.
        """
        return pulumi.get(self, "encryption_option")

    @property
    @pulumi.getter(name="objectKeyPrefix")
    def object_key_prefix(self) -> Optional[builtins.str]:
        """
        Prefix for the error report key. Timestream by default adds the following prefix to the error report path.
        """
        return pulumi.get(self, "object_key_prefix")


@pulumi.output_type
class ScheduledQueryScheduleConfiguration(dict):
    """
    Configuration for when the scheduled query is executed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryScheduleConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryScheduleConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryScheduleConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: builtins.str):
        """
        Configuration for when the scheduled query is executed.
        :param builtins.str schedule_expression: An expression that denotes when to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
        pulumi.set(__self__, "schedule_expression", schedule_expression)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> builtins.str:
        """
        An expression that denotes when to trigger the scheduled query run. This can be a cron expression or a rate expression.
        """
        return pulumi.get(self, "schedule_expression")


@pulumi.output_type
class ScheduledQuerySnsConfiguration(dict):
    """
    SNS configuration for notification upon scheduled query execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicArn":
            suggest = "topic_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQuerySnsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQuerySnsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQuerySnsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_arn: builtins.str):
        """
        SNS configuration for notification upon scheduled query execution.
        :param builtins.str topic_arn: SNS topic ARN that the scheduled query status notifications will be sent to.
        """
        pulumi.set(__self__, "topic_arn", topic_arn)

    @property
    @pulumi.getter(name="topicArn")
    def topic_arn(self) -> builtins.str:
        """
        SNS topic ARN that the scheduled query status notifications will be sent to.
        """
        return pulumi.get(self, "topic_arn")


@pulumi.output_type
class ScheduledQueryTargetConfiguration(dict):
    """
    Configuration of target store where scheduled query results are written to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "timestreamConfiguration":
            suggest = "timestream_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTargetConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTargetConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTargetConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 timestream_configuration: 'outputs.ScheduledQueryTimestreamConfiguration'):
        """
        Configuration of target store where scheduled query results are written to.
        :param 'ScheduledQueryTimestreamConfiguration' timestream_configuration: Configuration needed to write data into the Timestream database and table.
        """
        pulumi.set(__self__, "timestream_configuration", timestream_configuration)

    @property
    @pulumi.getter(name="timestreamConfiguration")
    def timestream_configuration(self) -> 'outputs.ScheduledQueryTimestreamConfiguration':
        """
        Configuration needed to write data into the Timestream database and table.
        """
        return pulumi.get(self, "timestream_configuration")


@pulumi.output_type
class ScheduledQueryTimestreamConfiguration(dict):
    """
    Configuration needed to write data into the Timestream database and table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseName":
            suggest = "database_name"
        elif key == "dimensionMappings":
            suggest = "dimension_mappings"
        elif key == "tableName":
            suggest = "table_name"
        elif key == "timeColumn":
            suggest = "time_column"
        elif key == "measureNameColumn":
            suggest = "measure_name_column"
        elif key == "mixedMeasureMappings":
            suggest = "mixed_measure_mappings"
        elif key == "multiMeasureMappings":
            suggest = "multi_measure_mappings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScheduledQueryTimestreamConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScheduledQueryTimestreamConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScheduledQueryTimestreamConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_name: builtins.str,
                 dimension_mappings: Sequence['outputs.ScheduledQueryDimensionMapping'],
                 table_name: builtins.str,
                 time_column: builtins.str,
                 measure_name_column: Optional[builtins.str] = None,
                 mixed_measure_mappings: Optional[Sequence['outputs.ScheduledQueryMixedMeasureMapping']] = None,
                 multi_measure_mappings: Optional['outputs.ScheduledQueryMultiMeasureMappings'] = None):
        """
        Configuration needed to write data into the Timestream database and table.
        :param builtins.str database_name: Name of Timestream database to which the query result will be written.
        :param Sequence['ScheduledQueryDimensionMapping'] dimension_mappings: This is to allow mapping column(s) from the query result to the dimension in the destination table.
        :param builtins.str table_name: Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        :param builtins.str time_column: Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        :param builtins.str measure_name_column: Name of the measure column. Also see `MultiMeasureMappings` and `MixedMeasureMappings` for how measure name properties on those relate to `MeasureNameColumn` .
        :param Sequence['ScheduledQueryMixedMeasureMapping'] mixed_measure_mappings: Specifies how to map measures to multi-measure records.
        :param 'ScheduledQueryMultiMeasureMappings' multi_measure_mappings: Multi-measure mappings.
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "dimension_mappings", dimension_mappings)
        pulumi.set(__self__, "table_name", table_name)
        pulumi.set(__self__, "time_column", time_column)
        if measure_name_column is not None:
            pulumi.set(__self__, "measure_name_column", measure_name_column)
        if mixed_measure_mappings is not None:
            pulumi.set(__self__, "mixed_measure_mappings", mixed_measure_mappings)
        if multi_measure_mappings is not None:
            pulumi.set(__self__, "multi_measure_mappings", multi_measure_mappings)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> builtins.str:
        """
        Name of Timestream database to which the query result will be written.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dimensionMappings")
    def dimension_mappings(self) -> Sequence['outputs.ScheduledQueryDimensionMapping']:
        """
        This is to allow mapping column(s) from the query result to the dimension in the destination table.
        """
        return pulumi.get(self, "dimension_mappings")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> builtins.str:
        """
        Name of Timestream table that the query result will be written to. The table should be within the same database that is provided in Timestream configuration.
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="timeColumn")
    def time_column(self) -> builtins.str:
        """
        Column from query result that should be used as the time column in destination table. Column type for this should be TIMESTAMP.
        """
        return pulumi.get(self, "time_column")

    @property
    @pulumi.getter(name="measureNameColumn")
    def measure_name_column(self) -> Optional[builtins.str]:
        """
        Name of the measure column. Also see `MultiMeasureMappings` and `MixedMeasureMappings` for how measure name properties on those relate to `MeasureNameColumn` .
        """
        return pulumi.get(self, "measure_name_column")

    @property
    @pulumi.getter(name="mixedMeasureMappings")
    def mixed_measure_mappings(self) -> Optional[Sequence['outputs.ScheduledQueryMixedMeasureMapping']]:
        """
        Specifies how to map measures to multi-measure records.
        """
        return pulumi.get(self, "mixed_measure_mappings")

    @property
    @pulumi.getter(name="multiMeasureMappings")
    def multi_measure_mappings(self) -> Optional['outputs.ScheduledQueryMultiMeasureMappings']:
        """
        Multi-measure mappings.
        """
        return pulumi.get(self, "multi_measure_mappings")


@pulumi.output_type
class SchemaProperties(dict):
    """
    A Schema specifies the expected data model of the table.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compositePartitionKey":
            suggest = "composite_partition_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 composite_partition_key: Optional[Sequence['outputs.TablePartitionKey']] = None):
        """
        A Schema specifies the expected data model of the table.
        :param Sequence['TablePartitionKey'] composite_partition_key: A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
        """
        if composite_partition_key is not None:
            pulumi.set(__self__, "composite_partition_key", composite_partition_key)

    @property
    @pulumi.getter(name="compositePartitionKey")
    def composite_partition_key(self) -> Optional[Sequence['outputs.TablePartitionKey']]:
        """
        A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
        """
        return pulumi.get(self, "composite_partition_key")


@pulumi.output_type
class TablePartitionKey(dict):
    """
    An attribute used in partitioning data in a table. There are two types of partition keys: dimension keys and measure keys. A dimension key partitions data on a dimension name, while a measure key partitions data on the measure name.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enforcementInRecord":
            suggest = "enforcement_in_record"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TablePartitionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TablePartitionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TablePartitionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'TablePartitionKeyType',
                 enforcement_in_record: Optional['TablePartitionKeyEnforcementLevel'] = None,
                 name: Optional[builtins.str] = None):
        """
        An attribute used in partitioning data in a table. There are two types of partition keys: dimension keys and measure keys. A dimension key partitions data on a dimension name, while a measure key partitions data on the measure name.
        """
        pulumi.set(__self__, "type", type)
        if enforcement_in_record is not None:
            pulumi.set(__self__, "enforcement_in_record", enforcement_in_record)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> 'TablePartitionKeyType':
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="enforcementInRecord")
    def enforcement_in_record(self) -> Optional['TablePartitionKeyEnforcementLevel']:
        return pulumi.get(self, "enforcement_in_record")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        return pulumi.get(self, "name")


