# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationComponentInfo',
    'ApplicationCredential',
]

@pulumi.output_type
class ApplicationComponentInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentType":
            suggest = "component_type"
        elif key == "ec2InstanceId":
            suggest = "ec2_instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationComponentInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationComponentInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationComponentInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_type: Optional['ApplicationComponentInfoComponentType'] = None,
                 ec2_instance_id: Optional[builtins.str] = None,
                 sid: Optional[builtins.str] = None):
        """
        :param 'ApplicationComponentInfoComponentType' component_type: This string is the type of the component.
               
               Accepted value is `WD` .
        :param builtins.str ec2_instance_id: This is the Amazon EC2 instance on which your SAP component is running.
               
               Accepted values are alphanumeric.
        :param builtins.str sid: This string is the SAP System ID of the component.
               
               Accepted values are alphanumeric.
        """
        if component_type is not None:
            pulumi.set(__self__, "component_type", component_type)
        if ec2_instance_id is not None:
            pulumi.set(__self__, "ec2_instance_id", ec2_instance_id)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> Optional['ApplicationComponentInfoComponentType']:
        """
        This string is the type of the component.

        Accepted value is `WD` .
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter(name="ec2InstanceId")
    def ec2_instance_id(self) -> Optional[builtins.str]:
        """
        This is the Amazon EC2 instance on which your SAP component is running.

        Accepted values are alphanumeric.
        """
        return pulumi.get(self, "ec2_instance_id")

    @property
    @pulumi.getter
    def sid(self) -> Optional[builtins.str]:
        """
        This string is the SAP System ID of the component.

        Accepted values are alphanumeric.
        """
        return pulumi.get(self, "sid")


@pulumi.output_type
class ApplicationCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "databaseName":
            suggest = "database_name"
        elif key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: Optional['ApplicationCredentialCredentialType'] = None,
                 database_name: Optional[builtins.str] = None,
                 secret_id: Optional[builtins.str] = None):
        """
        :param 'ApplicationCredentialCredentialType' credential_type: The type of the application credentials.
        :param builtins.str database_name: The name of the SAP HANA database.
        :param builtins.str secret_id: The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional['ApplicationCredentialCredentialType']:
        """
        The type of the application credentials.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[builtins.str]:
        """
        The name of the SAP HANA database.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[builtins.str]:
        """
        The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
        return pulumi.get(self, "secret_id")


