# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ApplicationComponentInfoArgs',
    'ApplicationComponentInfoArgsDict',
    'ApplicationCredentialArgs',
    'ApplicationCredentialArgsDict',
]

MYPY = False

if not MYPY:
    class ApplicationComponentInfoArgsDict(TypedDict):
        component_type: NotRequired[pulumi.Input['ApplicationComponentInfoComponentType']]
        """
        This string is the type of the component.

        Accepted value is `WD` .
        """
        ec2_instance_id: NotRequired[pulumi.Input[builtins.str]]
        """
        This is the Amazon EC2 instance on which your SAP component is running.

        Accepted values are alphanumeric.
        """
        sid: NotRequired[pulumi.Input[builtins.str]]
        """
        This string is the SAP System ID of the component.

        Accepted values are alphanumeric.
        """
elif False:
    ApplicationComponentInfoArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationComponentInfoArgs:
    def __init__(__self__, *,
                 component_type: Optional[pulumi.Input['ApplicationComponentInfoComponentType']] = None,
                 ec2_instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 sid: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ApplicationComponentInfoComponentType'] component_type: This string is the type of the component.
               
               Accepted value is `WD` .
        :param pulumi.Input[builtins.str] ec2_instance_id: This is the Amazon EC2 instance on which your SAP component is running.
               
               Accepted values are alphanumeric.
        :param pulumi.Input[builtins.str] sid: This string is the SAP System ID of the component.
               
               Accepted values are alphanumeric.
        """
        if component_type is not None:
            pulumi.set(__self__, "component_type", component_type)
        if ec2_instance_id is not None:
            pulumi.set(__self__, "ec2_instance_id", ec2_instance_id)
        if sid is not None:
            pulumi.set(__self__, "sid", sid)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> Optional[pulumi.Input['ApplicationComponentInfoComponentType']]:
        """
        This string is the type of the component.

        Accepted value is `WD` .
        """
        return pulumi.get(self, "component_type")

    @component_type.setter
    def component_type(self, value: Optional[pulumi.Input['ApplicationComponentInfoComponentType']]):
        pulumi.set(self, "component_type", value)

    @property
    @pulumi.getter(name="ec2InstanceId")
    def ec2_instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is the Amazon EC2 instance on which your SAP component is running.

        Accepted values are alphanumeric.
        """
        return pulumi.get(self, "ec2_instance_id")

    @ec2_instance_id.setter
    def ec2_instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ec2_instance_id", value)

    @property
    @pulumi.getter
    def sid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This string is the SAP System ID of the component.

        Accepted values are alphanumeric.
        """
        return pulumi.get(self, "sid")

    @sid.setter
    def sid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sid", value)


if not MYPY:
    class ApplicationCredentialArgsDict(TypedDict):
        credential_type: NotRequired[pulumi.Input['ApplicationCredentialCredentialType']]
        """
        The type of the application credentials.
        """
        database_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the SAP HANA database.
        """
        secret_id: NotRequired[pulumi.Input[builtins.str]]
        """
        The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
elif False:
    ApplicationCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ApplicationCredentialArgs:
    def __init__(__self__, *,
                 credential_type: Optional[pulumi.Input['ApplicationCredentialCredentialType']] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ApplicationCredentialCredentialType'] credential_type: The type of the application credentials.
        :param pulumi.Input[builtins.str] database_name: The name of the SAP HANA database.
        :param pulumi.Input[builtins.str] secret_id: The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input['ApplicationCredentialCredentialType']]:
        """
        The type of the application credentials.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input['ApplicationCredentialCredentialType']]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the SAP HANA database.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The secret ID created in AWS Secrets Manager to store the credentials of the SAP application.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_id", value)


