# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'CanaryArtifactConfig',
    'CanaryBaseScreenshot',
    'CanaryCode',
    'CanaryRetryConfig',
    'CanaryRunConfig',
    'CanaryS3Encryption',
    'CanarySchedule',
    'CanaryVisualReference',
    'CanaryVpcConfig',
]

@pulumi.output_type
class CanaryArtifactConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Encryption":
            suggest = "s3_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryArtifactConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryArtifactConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryArtifactConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 s3_encryption: Optional['outputs.CanaryS3Encryption'] = None):
        """
        :param 'CanaryS3Encryption' s3_encryption: Encryption configuration for uploading artifacts to S3
        """
        if s3_encryption is not None:
            pulumi.set(__self__, "s3_encryption", s3_encryption)

    @property
    @pulumi.getter(name="s3Encryption")
    def s3_encryption(self) -> Optional['outputs.CanaryS3Encryption']:
        """
        Encryption configuration for uploading artifacts to S3
        """
        return pulumi.get(self, "s3_encryption")


@pulumi.output_type
class CanaryBaseScreenshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "screenshotName":
            suggest = "screenshot_name"
        elif key == "ignoreCoordinates":
            suggest = "ignore_coordinates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryBaseScreenshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryBaseScreenshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryBaseScreenshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 screenshot_name: builtins.str,
                 ignore_coordinates: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str screenshot_name: Name of the screenshot to be used as base reference for visual testing
        :param Sequence[builtins.str] ignore_coordinates: List of coordinates of rectangles to be ignored during visual testing
        """
        pulumi.set(__self__, "screenshot_name", screenshot_name)
        if ignore_coordinates is not None:
            pulumi.set(__self__, "ignore_coordinates", ignore_coordinates)

    @property
    @pulumi.getter(name="screenshotName")
    def screenshot_name(self) -> builtins.str:
        """
        Name of the screenshot to be used as base reference for visual testing
        """
        return pulumi.get(self, "screenshot_name")

    @property
    @pulumi.getter(name="ignoreCoordinates")
    def ignore_coordinates(self) -> Optional[Sequence[builtins.str]]:
        """
        List of coordinates of rectangles to be ignored during visual testing
        """
        return pulumi.get(self, "ignore_coordinates")


@pulumi.output_type
class CanaryCode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "s3Bucket":
            suggest = "s3_bucket"
        elif key == "s3Key":
            suggest = "s3_key"
        elif key == "s3ObjectVersion":
            suggest = "s3_object_version"
        elif key == "sourceLocationArn":
            suggest = "source_location_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryCode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryCode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryCode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 handler: builtins.str,
                 s3_bucket: Optional[builtins.str] = None,
                 s3_key: Optional[builtins.str] = None,
                 s3_object_version: Optional[builtins.str] = None,
                 script: Optional[builtins.str] = None,
                 source_location_arn: Optional[builtins.str] = None):
        """
        :param builtins.str handler: The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4` , the handler must be specified as `*fileName* .handler` . For `syn-python-selenium-1.1` , `syn-nodejs.puppeteer-3.4` , and later runtimes, the handler can be specified as `*fileName* . *functionName*` , or you can specify a folder where canary scripts reside as `*folder* / *fileName* . *functionName*` .
        :param builtins.str s3_bucket: If your canary script is located in S3, specify the bucket name here. The bucket must already exist.
        :param builtins.str s3_key: The Amazon S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html) .
        :param builtins.str s3_object_version: The Amazon S3 version ID of your script.
        :param builtins.str script: If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text. It can be up to 5 MB.
        :param builtins.str source_location_arn: The ARN of the Lambda layer where Synthetics stores the canary script code.
        """
        pulumi.set(__self__, "handler", handler)
        if s3_bucket is not None:
            pulumi.set(__self__, "s3_bucket", s3_bucket)
        if s3_key is not None:
            pulumi.set(__self__, "s3_key", s3_key)
        if s3_object_version is not None:
            pulumi.set(__self__, "s3_object_version", s3_object_version)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if source_location_arn is not None:
            pulumi.set(__self__, "source_location_arn", source_location_arn)

    @property
    @pulumi.getter
    def handler(self) -> builtins.str:
        """
        The entry point to use for the source code when running the canary. For canaries that use the `syn-python-selenium-1.0` runtime or a `syn-nodejs.puppeteer` runtime earlier than `syn-nodejs.puppeteer-3.4` , the handler must be specified as `*fileName* .handler` . For `syn-python-selenium-1.1` , `syn-nodejs.puppeteer-3.4` , and later runtimes, the handler can be specified as `*fileName* . *functionName*` , or you can specify a folder where canary scripts reside as `*folder* / *fileName* . *functionName*` .
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="s3Bucket")
    def s3_bucket(self) -> Optional[builtins.str]:
        """
        If your canary script is located in S3, specify the bucket name here. The bucket must already exist.
        """
        return pulumi.get(self, "s3_bucket")

    @property
    @pulumi.getter(name="s3Key")
    def s3_key(self) -> Optional[builtins.str]:
        """
        The Amazon S3 key of your script. For more information, see [Working with Amazon S3 Objects](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html) .
        """
        return pulumi.get(self, "s3_key")

    @property
    @pulumi.getter(name="s3ObjectVersion")
    def s3_object_version(self) -> Optional[builtins.str]:
        """
        The Amazon S3 version ID of your script.
        """
        return pulumi.get(self, "s3_object_version")

    @property
    @pulumi.getter
    def script(self) -> Optional[builtins.str]:
        """
        If you input your canary script directly into the canary instead of referring to an S3 location, the value of this parameter is the script in plain text. It can be up to 5 MB.
        """
        return pulumi.get(self, "script")

    @property
    @pulumi.getter(name="sourceLocationArn")
    def source_location_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Lambda layer where Synthetics stores the canary script code.
        """
        return pulumi.get(self, "source_location_arn")


@pulumi.output_type
class CanaryRetryConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxRetries":
            suggest = "max_retries"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryRetryConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryRetryConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryRetryConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_retries: builtins.int):
        """
        :param builtins.int max_retries: maximum times the canary will be retried upon the scheduled run failure
        """
        pulumi.set(__self__, "max_retries", max_retries)

    @property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> builtins.int:
        """
        maximum times the canary will be retried upon the scheduled run failure
        """
        return pulumi.get(self, "max_retries")


@pulumi.output_type
class CanaryRunConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activeTracing":
            suggest = "active_tracing"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "memoryInMb":
            suggest = "memory_in_mb"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryRunConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryRunConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryRunConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 active_tracing: Optional[builtins.bool] = None,
                 environment_variables: Optional[Mapping[str, builtins.str]] = None,
                 memory_in_mb: Optional[builtins.int] = None,
                 timeout_in_seconds: Optional[builtins.int] = None):
        """
        :param builtins.bool active_tracing: Enable active tracing if set to true
        :param Mapping[str, builtins.str] environment_variables: Environment variable key-value pairs.
        :param builtins.int memory_in_mb: Provide maximum memory available for canary in MB
        :param builtins.int timeout_in_seconds: Provide maximum canary timeout per run in seconds
        """
        if active_tracing is not None:
            pulumi.set(__self__, "active_tracing", active_tracing)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if memory_in_mb is not None:
            pulumi.set(__self__, "memory_in_mb", memory_in_mb)
        if timeout_in_seconds is not None:
            pulumi.set(__self__, "timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="activeTracing")
    def active_tracing(self) -> Optional[builtins.bool]:
        """
        Enable active tracing if set to true
        """
        return pulumi.get(self, "active_tracing")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Environment variable key-value pairs.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="memoryInMb")
    def memory_in_mb(self) -> Optional[builtins.int]:
        """
        Provide maximum memory available for canary in MB
        """
        return pulumi.get(self, "memory_in_mb")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[builtins.int]:
        """
        Provide maximum canary timeout per run in seconds
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class CanaryS3Encryption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionMode":
            suggest = "encryption_mode"
        elif key == "kmsKeyArn":
            suggest = "kms_key_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryS3Encryption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryS3Encryption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryS3Encryption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_mode: Optional[builtins.str] = None,
                 kms_key_arn: Optional[builtins.str] = None):
        """
        :param builtins.str encryption_mode: Encryption mode for encrypting artifacts when uploading to S3. Valid values: SSE_S3 and SSE_KMS.
        :param builtins.str kms_key_arn: KMS key Arn for encrypting artifacts when uploading to S3. You must specify KMS key Arn for SSE_KMS encryption mode only.
        """
        if encryption_mode is not None:
            pulumi.set(__self__, "encryption_mode", encryption_mode)
        if kms_key_arn is not None:
            pulumi.set(__self__, "kms_key_arn", kms_key_arn)

    @property
    @pulumi.getter(name="encryptionMode")
    def encryption_mode(self) -> Optional[builtins.str]:
        """
        Encryption mode for encrypting artifacts when uploading to S3. Valid values: SSE_S3 and SSE_KMS.
        """
        return pulumi.get(self, "encryption_mode")

    @property
    @pulumi.getter(name="kmsKeyArn")
    def kms_key_arn(self) -> Optional[builtins.str]:
        """
        KMS key Arn for encrypting artifacts when uploading to S3. You must specify KMS key Arn for SSE_KMS encryption mode only.
        """
        return pulumi.get(self, "kms_key_arn")


@pulumi.output_type
class CanarySchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInSeconds":
            suggest = "duration_in_seconds"
        elif key == "retryConfig":
            suggest = "retry_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanarySchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanarySchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanarySchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expression: builtins.str,
                 duration_in_seconds: Optional[builtins.str] = None,
                 retry_config: Optional['outputs.CanaryRetryConfig'] = None):
        """
        :param builtins.str expression: A `rate` expression or a `cron` expression that defines how often the canary is to run.
               
               For a rate expression, The syntax is `rate( *number unit* )` . *unit* can be `minute` , `minutes` , or `hour` .
               
               For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)` .
               
               Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.
               
               Use `cron( *expression* )` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html) .
        :param builtins.str duration_in_seconds: How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
        :param 'CanaryRetryConfig' retry_config: Provide canary auto retry configuration
        """
        pulumi.set(__self__, "expression", expression)
        if duration_in_seconds is not None:
            pulumi.set(__self__, "duration_in_seconds", duration_in_seconds)
        if retry_config is not None:
            pulumi.set(__self__, "retry_config", retry_config)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        A `rate` expression or a `cron` expression that defines how often the canary is to run.

        For a rate expression, The syntax is `rate( *number unit* )` . *unit* can be `minute` , `minutes` , or `hour` .

        For example, `rate(1 minute)` runs the canary once a minute, `rate(10 minutes)` runs it once every 10 minutes, and `rate(1 hour)` runs it once every hour. You can specify a frequency between `rate(1 minute)` and `rate(1 hour)` .

        Specifying `rate(0 minute)` or `rate(0 hour)` is a special value that causes the canary to run only once when it is started.

        Use `cron( *expression* )` to specify a cron expression. You can't schedule a canary to wait for more than a year before running. For information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html) .
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter(name="durationInSeconds")
    def duration_in_seconds(self) -> Optional[builtins.str]:
        """
        How long, in seconds, for the canary to continue making regular runs according to the schedule in the `Expression` value. If you specify 0, the canary continues making runs until you stop it. If you omit this field, the default of 0 is used.
        """
        return pulumi.get(self, "duration_in_seconds")

    @property
    @pulumi.getter(name="retryConfig")
    def retry_config(self) -> Optional['outputs.CanaryRetryConfig']:
        """
        Provide canary auto retry configuration
        """
        return pulumi.get(self, "retry_config")


@pulumi.output_type
class CanaryVisualReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseCanaryRunId":
            suggest = "base_canary_run_id"
        elif key == "baseScreenshots":
            suggest = "base_screenshots"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryVisualReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryVisualReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryVisualReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_canary_run_id: builtins.str,
                 base_screenshots: Optional[Sequence['outputs.CanaryBaseScreenshot']] = None):
        """
        :param builtins.str base_canary_run_id: Canary run id to be used as base reference for visual testing
        :param Sequence['CanaryBaseScreenshot'] base_screenshots: List of screenshots used as base reference for visual testing
        """
        pulumi.set(__self__, "base_canary_run_id", base_canary_run_id)
        if base_screenshots is not None:
            pulumi.set(__self__, "base_screenshots", base_screenshots)

    @property
    @pulumi.getter(name="baseCanaryRunId")
    def base_canary_run_id(self) -> builtins.str:
        """
        Canary run id to be used as base reference for visual testing
        """
        return pulumi.get(self, "base_canary_run_id")

    @property
    @pulumi.getter(name="baseScreenshots")
    def base_screenshots(self) -> Optional[Sequence['outputs.CanaryBaseScreenshot']]:
        """
        List of screenshots used as base reference for visual testing
        """
        return pulumi.get(self, "base_screenshots")


@pulumi.output_type
class CanaryVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupIds":
            suggest = "security_group_ids"
        elif key == "subnetIds":
            suggest = "subnet_ids"
        elif key == "ipv6AllowedForDualStack":
            suggest = "ipv6_allowed_for_dual_stack"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CanaryVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CanaryVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CanaryVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_ids: Sequence[builtins.str],
                 subnet_ids: Sequence[builtins.str],
                 ipv6_allowed_for_dual_stack: Optional[builtins.bool] = None,
                 vpc_id: Optional[builtins.str] = None):
        """
        :param Sequence[builtins.str] security_group_ids: The IDs of the security groups for this canary.
        :param Sequence[builtins.str] subnet_ids: The IDs of the subnets where this canary is to run.
        :param builtins.bool ipv6_allowed_for_dual_stack: Allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets if set to true
        :param builtins.str vpc_id: The ID of the VPC where this canary is to run.
        """
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if ipv6_allowed_for_dual_stack is not None:
            pulumi.set(__self__, "ipv6_allowed_for_dual_stack", ipv6_allowed_for_dual_stack)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the security groups for this canary.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[builtins.str]:
        """
        The IDs of the subnets where this canary is to run.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="ipv6AllowedForDualStack")
    def ipv6_allowed_for_dual_stack(self) -> Optional[builtins.bool]:
        """
        Allow outbound IPv6 traffic on VPC canaries that are connected to dual-stack subnets if set to true
        """
        return pulumi.get(self, "ipv6_allowed_for_dual_stack")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[builtins.str]:
        """
        The ID of the VPC where this canary is to run.
        """
        return pulumi.get(self, "vpc_id")


