# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'GetSlackChannelConfigurationResult',
    'AwaitableGetSlackChannelConfigurationResult',
    'get_slack_channel_configuration',
    'get_slack_channel_configuration_output',
]

@pulumi.output_type
class GetSlackChannelConfigurationResult:
    def __init__(__self__, channel_name=None, channel_role_arn=None, notify_on_add_correspondence_to_case=None, notify_on_case_severity=None, notify_on_create_or_reopen_case=None, notify_on_resolve_case=None):
        if channel_name and not isinstance(channel_name, str):
            raise TypeError("Expected argument 'channel_name' to be a str")
        pulumi.set(__self__, "channel_name", channel_name)
        if channel_role_arn and not isinstance(channel_role_arn, str):
            raise TypeError("Expected argument 'channel_role_arn' to be a str")
        pulumi.set(__self__, "channel_role_arn", channel_role_arn)
        if notify_on_add_correspondence_to_case and not isinstance(notify_on_add_correspondence_to_case, bool):
            raise TypeError("Expected argument 'notify_on_add_correspondence_to_case' to be a bool")
        pulumi.set(__self__, "notify_on_add_correspondence_to_case", notify_on_add_correspondence_to_case)
        if notify_on_case_severity and not isinstance(notify_on_case_severity, str):
            raise TypeError("Expected argument 'notify_on_case_severity' to be a str")
        pulumi.set(__self__, "notify_on_case_severity", notify_on_case_severity)
        if notify_on_create_or_reopen_case and not isinstance(notify_on_create_or_reopen_case, bool):
            raise TypeError("Expected argument 'notify_on_create_or_reopen_case' to be a bool")
        pulumi.set(__self__, "notify_on_create_or_reopen_case", notify_on_create_or_reopen_case)
        if notify_on_resolve_case and not isinstance(notify_on_resolve_case, bool):
            raise TypeError("Expected argument 'notify_on_resolve_case' to be a bool")
        pulumi.set(__self__, "notify_on_resolve_case", notify_on_resolve_case)

    @property
    @pulumi.getter(name="channelName")
    def channel_name(self) -> Optional[builtins.str]:
        """
        The channel name in Slack.
        """
        return pulumi.get(self, "channel_name")

    @property
    @pulumi.getter(name="channelRoleArn")
    def channel_role_arn(self) -> Optional[builtins.str]:
        """
        The Amazon Resource Name (ARN) of an IAM role that grants the AWS Support App access to perform operations for AWS services.
        """
        return pulumi.get(self, "channel_role_arn")

    @property
    @pulumi.getter(name="notifyOnAddCorrespondenceToCase")
    def notify_on_add_correspondence_to_case(self) -> Optional[builtins.bool]:
        """
        Whether to notify when a correspondence is added to a case.
        """
        return pulumi.get(self, "notify_on_add_correspondence_to_case")

    @property
    @pulumi.getter(name="notifyOnCaseSeverity")
    def notify_on_case_severity(self) -> Optional['SlackChannelConfigurationNotifyOnCaseSeverity']:
        """
        The severity level of a support case that a customer wants to get notified for.
        """
        return pulumi.get(self, "notify_on_case_severity")

    @property
    @pulumi.getter(name="notifyOnCreateOrReopenCase")
    def notify_on_create_or_reopen_case(self) -> Optional[builtins.bool]:
        """
        Whether to notify when a case is created or reopened.
        """
        return pulumi.get(self, "notify_on_create_or_reopen_case")

    @property
    @pulumi.getter(name="notifyOnResolveCase")
    def notify_on_resolve_case(self) -> Optional[builtins.bool]:
        """
        Whether to notify when a case is resolved.
        """
        return pulumi.get(self, "notify_on_resolve_case")


class AwaitableGetSlackChannelConfigurationResult(GetSlackChannelConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSlackChannelConfigurationResult(
            channel_name=self.channel_name,
            channel_role_arn=self.channel_role_arn,
            notify_on_add_correspondence_to_case=self.notify_on_add_correspondence_to_case,
            notify_on_case_severity=self.notify_on_case_severity,
            notify_on_create_or_reopen_case=self.notify_on_create_or_reopen_case,
            notify_on_resolve_case=self.notify_on_resolve_case)


def get_slack_channel_configuration(channel_id: Optional[builtins.str] = None,
                                    team_id: Optional[builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSlackChannelConfigurationResult:
    """
    An AWS Support App resource that creates, updates, lists and deletes Slack channel configurations.


    :param builtins.str channel_id: The channel ID in Slack, which identifies a channel within a workspace.
    :param builtins.str team_id: The team ID in Slack, which uniquely identifies a workspace.
    """
    __args__ = dict()
    __args__['channelId'] = channel_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:supportapp:getSlackChannelConfiguration', __args__, opts=opts, typ=GetSlackChannelConfigurationResult).value

    return AwaitableGetSlackChannelConfigurationResult(
        channel_name=pulumi.get(__ret__, 'channel_name'),
        channel_role_arn=pulumi.get(__ret__, 'channel_role_arn'),
        notify_on_add_correspondence_to_case=pulumi.get(__ret__, 'notify_on_add_correspondence_to_case'),
        notify_on_case_severity=pulumi.get(__ret__, 'notify_on_case_severity'),
        notify_on_create_or_reopen_case=pulumi.get(__ret__, 'notify_on_create_or_reopen_case'),
        notify_on_resolve_case=pulumi.get(__ret__, 'notify_on_resolve_case'))
def get_slack_channel_configuration_output(channel_id: Optional[pulumi.Input[builtins.str]] = None,
                                           team_id: Optional[pulumi.Input[builtins.str]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSlackChannelConfigurationResult]:
    """
    An AWS Support App resource that creates, updates, lists and deletes Slack channel configurations.


    :param builtins.str channel_id: The channel ID in Slack, which identifies a channel within a workspace.
    :param builtins.str team_id: The team ID in Slack, which uniquely identifies a workspace.
    """
    __args__ = dict()
    __args__['channelId'] = channel_id
    __args__['teamId'] = team_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:supportapp:getSlackChannelConfiguration', __args__, opts=opts, typ=GetSlackChannelConfigurationResult)
    return __ret__.apply(lambda __response__: GetSlackChannelConfigurationResult(
        channel_name=pulumi.get(__response__, 'channel_name'),
        channel_role_arn=pulumi.get(__response__, 'channel_role_arn'),
        notify_on_add_correspondence_to_case=pulumi.get(__response__, 'notify_on_add_correspondence_to_case'),
        notify_on_case_severity=pulumi.get(__response__, 'notify_on_case_severity'),
        notify_on_create_or_reopen_case=pulumi.get(__response__, 'notify_on_create_or_reopen_case'),
        notify_on_resolve_case=pulumi.get(__response__, 'notify_on_resolve_case')))
