# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from .. import _inputs as _root_inputs
from .. import outputs as _root_outputs
from ._enums import *
from ._inputs import *

__all__ = ['ActivityArgs', 'Activity']

@pulumi.input_type
class ActivityArgs:
    def __init__(__self__, *,
                 encryption_configuration: Optional[pulumi.Input['ActivityEncryptionConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]] = None):
        """
        The set of arguments for constructing a Activity resource.
        :param pulumi.Input['ActivityEncryptionConfigurationArgs'] encryption_configuration: Encryption configuration for the activity.
               
               Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a *new Activity* . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an `ActivityAlreadyExists` exception.
               
               To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
        :param pulumi.Input[builtins.str] name: The name of the activity.
               
               A name must *not* contain:
               
               - white space
               - brackets `< > { } [ ]`
               - wildcard characters `? *`
               - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
               - control characters ( `U+0000-001F` , `U+007F-009F` , `U+FFFE-FFFF` )
               - surrogates ( `U+D800-DFFF` )
               - invalid characters ( `U+10FFFF` )
               
               To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
        :param pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]] tags: The list of tags to add to a resource.
               
               Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        """
        if encryption_configuration is not None:
            pulumi.set(__self__, "encryption_configuration", encryption_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> Optional[pulumi.Input['ActivityEncryptionConfigurationArgs']]:
        """
        Encryption configuration for the activity.

        Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a *new Activity* . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an `ActivityAlreadyExists` exception.

        To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
        """
        return pulumi.get(self, "encryption_configuration")

    @encryption_configuration.setter
    def encryption_configuration(self, value: Optional[pulumi.Input['ActivityEncryptionConfigurationArgs']]):
        pulumi.set(self, "encryption_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the activity.

        A name must *not* contain:

        - white space
        - brackets `< > { } [ ]`
        - wildcard characters `? *`
        - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
        - control characters ( `U+0000-001F` , `U+007F-009F` , `U+FFFE-FFFF` )
        - surrogates ( `U+D800-DFFF` )
        - invalid characters ( `U+10FFFF` )

        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]:
        """
        The list of tags to add to a resource.

        Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['_root_inputs.TagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:stepfunctions:Activity")
class Activity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['ActivityEncryptionConfigurationArgs', 'ActivityEncryptionConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        """
        Resource schema for Activity

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_activity = aws_native.stepfunctions.Activity("myActivity",
            name="myActivity",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_activity = aws_native.stepfunctions.Activity("myActivity",
            name="myActivity",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ActivityEncryptionConfigurationArgs', 'ActivityEncryptionConfigurationArgsDict']] encryption_configuration: Encryption configuration for the activity.
               
               Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a *new Activity* . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an `ActivityAlreadyExists` exception.
               
               To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
        :param pulumi.Input[builtins.str] name: The name of the activity.
               
               A name must *not* contain:
               
               - white space
               - brackets `< > { } [ ]`
               - wildcard characters `? *`
               - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
               - control characters ( `U+0000-001F` , `U+007F-009F` , `U+FFFE-FFFF` )
               - surrogates ( `U+D800-DFFF` )
               - invalid characters ( `U+10FFFF` )
               
               To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
        :param pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]] tags: The list of tags to add to a resource.
               
               Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ActivityArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for Activity

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_activity = aws_native.stepfunctions.Activity("myActivity",
            name="myActivity",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        my_activity = aws_native.stepfunctions.Activity("myActivity",
            name="myActivity",
            tags=[
                {
                    "key": "keyname1",
                    "value": "value1",
                },
                {
                    "key": "keyname2",
                    "value": "value2",
                },
            ])

        ```

        :param str resource_name: The name of the resource.
        :param ActivityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActivityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 encryption_configuration: Optional[pulumi.Input[Union['ActivityEncryptionConfigurationArgs', 'ActivityEncryptionConfigurationArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['_root_inputs.TagArgs', '_root_inputs.TagArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActivityArgs.__new__(ActivityArgs)

            __props__.__dict__["encryption_configuration"] = encryption_configuration
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["arn"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["encryptionConfiguration", "name"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Activity, __self__).__init__(
            'aws-native:stepfunctions:Activity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Activity':
        """
        Get an existing Activity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ActivityArgs.__new__(ActivityArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["encryption_configuration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["tags"] = None
        return Activity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[builtins.str]:
        """
        Returns the ARN of the resource.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="encryptionConfiguration")
    def encryption_configuration(self) -> pulumi.Output[Optional['outputs.ActivityEncryptionConfiguration']]:
        """
        Encryption configuration for the activity.

        Activity configuration is immutable, and resource names must be unique. To set customer managed keys for encryption, you must create a *new Activity* . If you attempt to change the configuration in your CFN template for an existing activity, you will receive an `ActivityAlreadyExists` exception.

        To update your activity to include customer managed keys, set a new activity name within your AWS CloudFormation template.
        """
        return pulumi.get(self, "encryption_configuration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the activity.

        A name must *not* contain:

        - white space
        - brackets `< > { } [ ]`
        - wildcard characters `? *`
        - special characters `" # % \\ ^ | ~ ` $ & , ; : /`
        - control characters ( `U+0000-001F` , `U+007F-009F` , `U+FFFE-FFFF` )
        - surrogates ( `U+D800-DFFF` )
        - invalid characters ( `U+10FFFF` )

        To enable logging with CloudWatch Logs, the name should only contain 0-9, A-Z, a-z, - and _.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['_root_outputs.Tag']]]:
        """
        The list of tags to add to a resource.

        Tags may only contain Unicode letters, digits, white space, or these symbols: `_ . : / = + - @` .
        """
        return pulumi.get(self, "tags")

