# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceAccessControlAttributeConfigurationArgs', 'InstanceAccessControlAttributeConfiguration']

@pulumi.input_type
class InstanceAccessControlAttributeConfigurationArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[builtins.str],
                 access_control_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]]] = None,
                 instance_access_control_attribute_configuration: Optional[pulumi.Input['InstanceAccessControlAttributeConfigurationPropertiesArgs']] = None):
        """
        The set of arguments for constructing a InstanceAccessControlAttributeConfiguration resource.
        :param pulumi.Input[builtins.str] instance_arn: The ARN of the AWS SSO instance under which the operation will be executed.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]] access_control_attributes: Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
        :param pulumi.Input['InstanceAccessControlAttributeConfigurationPropertiesArgs'] instance_access_control_attribute_configuration: The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes. We recomend that you use  AccessControlAttributes property instead.
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        if access_control_attributes is not None:
            pulumi.set(__self__, "access_control_attributes", access_control_attributes)
        if instance_access_control_attribute_configuration is not None:
            pulumi.set(__self__, "instance_access_control_attribute_configuration", instance_access_control_attribute_configuration)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the AWS SSO instance under which the operation will be executed.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="accessControlAttributes")
    def access_control_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]]]:
        """
        Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
        """
        return pulumi.get(self, "access_control_attributes")

    @access_control_attributes.setter
    def access_control_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs']]]]):
        pulumi.set(self, "access_control_attributes", value)

    @property
    @pulumi.getter(name="instanceAccessControlAttributeConfiguration")
    def instance_access_control_attribute_configuration(self) -> Optional[pulumi.Input['InstanceAccessControlAttributeConfigurationPropertiesArgs']]:
        """
        The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes. We recomend that you use  AccessControlAttributes property instead.
        """
        return pulumi.get(self, "instance_access_control_attribute_configuration")

    @instance_access_control_attribute_configuration.setter
    def instance_access_control_attribute_configuration(self, value: Optional[pulumi.Input['InstanceAccessControlAttributeConfigurationPropertiesArgs']]):
        pulumi.set(self, "instance_access_control_attribute_configuration", value)


@pulumi.type_token("aws-native:sso:InstanceAccessControlAttributeConfiguration")
class InstanceAccessControlAttributeConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs', 'InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict']]]]] = None,
                 instance_access_control_attribute_configuration: Optional[pulumi.Input[Union['InstanceAccessControlAttributeConfigurationPropertiesArgs', 'InstanceAccessControlAttributeConfigurationPropertiesArgsDict']]] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Resource Type definition for SSO InstanceAccessControlAttributeConfiguration

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        abac = aws_native.sso.InstanceAccessControlAttributeConfiguration("abac",
            instance_arn="arn:aws:sso:::instance/ssoins-instanceId",
            access_control_attributes=[{
                "key": "CostCenter",
                "value": {
                    "source": ["${path:enterprise.costCenter}"],
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        abac = aws_native.sso.InstanceAccessControlAttributeConfiguration("abac",
            instance_arn="arn:aws:sso:::instance/ssoins-instanceId",
            access_control_attributes=[{
                "key": "CostCenter",
                "value": {
                    "source": ["${path:enterprise.costCenter}"],
                },
            }])

        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs', 'InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict']]]] access_control_attributes: Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
        :param pulumi.Input[Union['InstanceAccessControlAttributeConfigurationPropertiesArgs', 'InstanceAccessControlAttributeConfigurationPropertiesArgsDict']] instance_access_control_attribute_configuration: The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes. We recomend that you use  AccessControlAttributes property instead.
        :param pulumi.Input[builtins.str] instance_arn: The ARN of the AWS SSO instance under which the operation will be executed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceAccessControlAttributeConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for SSO InstanceAccessControlAttributeConfiguration

        ## Example Usage
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        abac = aws_native.sso.InstanceAccessControlAttributeConfiguration("abac",
            instance_arn="arn:aws:sso:::instance/ssoins-instanceId",
            access_control_attributes=[{
                "key": "CostCenter",
                "value": {
                    "source": ["${path:enterprise.costCenter}"],
                },
            }])

        ```
        ### Example

        ```python
        import pulumi
        import pulumi_aws_native as aws_native

        abac = aws_native.sso.InstanceAccessControlAttributeConfiguration("abac",
            instance_arn="arn:aws:sso:::instance/ssoins-instanceId",
            access_control_attributes=[{
                "key": "CostCenter",
                "value": {
                    "source": ["${path:enterprise.costCenter}"],
                },
            }])

        ```

        :param str resource_name: The name of the resource.
        :param InstanceAccessControlAttributeConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceAccessControlAttributeConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_control_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAccessControlAttributeConfigurationAccessControlAttributeArgs', 'InstanceAccessControlAttributeConfigurationAccessControlAttributeArgsDict']]]]] = None,
                 instance_access_control_attribute_configuration: Optional[pulumi.Input[Union['InstanceAccessControlAttributeConfigurationPropertiesArgs', 'InstanceAccessControlAttributeConfigurationPropertiesArgsDict']]] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceAccessControlAttributeConfigurationArgs.__new__(InstanceAccessControlAttributeConfigurationArgs)

            __props__.__dict__["access_control_attributes"] = access_control_attributes
            __props__.__dict__["instance_access_control_attribute_configuration"] = instance_access_control_attribute_configuration
            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instanceArn"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(InstanceAccessControlAttributeConfiguration, __self__).__init__(
            'aws-native:sso:InstanceAccessControlAttributeConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InstanceAccessControlAttributeConfiguration':
        """
        Get an existing InstanceAccessControlAttributeConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceAccessControlAttributeConfigurationArgs.__new__(InstanceAccessControlAttributeConfigurationArgs)

        __props__.__dict__["access_control_attributes"] = None
        __props__.__dict__["instance_access_control_attribute_configuration"] = None
        __props__.__dict__["instance_arn"] = None
        return InstanceAccessControlAttributeConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessControlAttributes")
    def access_control_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceAccessControlAttributeConfigurationAccessControlAttribute']]]:
        """
        Lists the attributes that are configured for ABAC in the specified IAM Identity Center instance.
        """
        return pulumi.get(self, "access_control_attributes")

    @property
    @pulumi.getter(name="instanceAccessControlAttributeConfiguration")
    def instance_access_control_attribute_configuration(self) -> pulumi.Output[Optional['outputs.InstanceAccessControlAttributeConfigurationProperties']]:
        """
        The InstanceAccessControlAttributeConfiguration property has been deprecated but is still supported for backwards compatibility purposes. We recomend that you use  AccessControlAttributes property instead.
        """
        return pulumi.get(self, "instance_access_control_attribute_configuration")

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the AWS SSO instance under which the operation will be executed.
        """
        return pulumi.get(self, "instance_arn")

