# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['AssignmentArgs', 'Assignment']

@pulumi.input_type
class AssignmentArgs:
    def __init__(__self__, *,
                 instance_arn: pulumi.Input[builtins.str],
                 permission_set_arn: pulumi.Input[builtins.str],
                 principal_id: pulumi.Input[builtins.str],
                 principal_type: pulumi.Input['AssignmentPrincipalType'],
                 target_id: pulumi.Input[builtins.str],
                 target_type: pulumi.Input['AssignmentTargetType']):
        """
        The set of arguments for constructing a Assignment resource.
        :param pulumi.Input[builtins.str] instance_arn: The sso instance that the permission set is owned.
        :param pulumi.Input[builtins.str] permission_set_arn: The permission set that the assignemt will be assigned
        :param pulumi.Input[builtins.str] principal_id: The assignee's identifier, user id/group id
        :param pulumi.Input['AssignmentPrincipalType'] principal_type: The assignee's type, user/group
        :param pulumi.Input[builtins.str] target_id: The account id to be provisioned.
        :param pulumi.Input['AssignmentTargetType'] target_type: The type of resource to be provsioned to, only aws account now
        """
        pulumi.set(__self__, "instance_arn", instance_arn)
        pulumi.set(__self__, "permission_set_arn", permission_set_arn)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "target_type", target_type)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Input[builtins.str]:
        """
        The sso instance that the permission set is owned.
        """
        return pulumi.get(self, "instance_arn")

    @instance_arn.setter
    def instance_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance_arn", value)

    @property
    @pulumi.getter(name="permissionSetArn")
    def permission_set_arn(self) -> pulumi.Input[builtins.str]:
        """
        The permission set that the assignemt will be assigned
        """
        return pulumi.get(self, "permission_set_arn")

    @permission_set_arn.setter
    def permission_set_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "permission_set_arn", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[builtins.str]:
        """
        The assignee's identifier, user id/group id
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input['AssignmentPrincipalType']:
        """
        The assignee's type, user/group
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input['AssignmentPrincipalType']):
        pulumi.set(self, "principal_type", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[builtins.str]:
        """
        The account id to be provisioned.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Input['AssignmentTargetType']:
        """
        The type of resource to be provsioned to, only aws account now
        """
        return pulumi.get(self, "target_type")

    @target_type.setter
    def target_type(self, value: pulumi.Input['AssignmentTargetType']):
        pulumi.set(self, "target_type", value)


@pulumi.type_token("aws-native:sso:Assignment")
class Assignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permission_set_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input['AssignmentPrincipalType']] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input['AssignmentTargetType']] = None,
                 __props__=None):
        """
        Resource Type definition for SSO assignmet

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] instance_arn: The sso instance that the permission set is owned.
        :param pulumi.Input[builtins.str] permission_set_arn: The permission set that the assignemt will be assigned
        :param pulumi.Input[builtins.str] principal_id: The assignee's identifier, user id/group id
        :param pulumi.Input['AssignmentPrincipalType'] principal_type: The assignee's type, user/group
        :param pulumi.Input[builtins.str] target_id: The account id to be provisioned.
        :param pulumi.Input['AssignmentTargetType'] target_type: The type of resource to be provsioned to, only aws account now
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for SSO assignmet

        :param str resource_name: The name of the resource.
        :param AssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_arn: Optional[pulumi.Input[builtins.str]] = None,
                 permission_set_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input['AssignmentPrincipalType']] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_type: Optional[pulumi.Input['AssignmentTargetType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AssignmentArgs.__new__(AssignmentArgs)

            if instance_arn is None and not opts.urn:
                raise TypeError("Missing required property 'instance_arn'")
            __props__.__dict__["instance_arn"] = instance_arn
            if permission_set_arn is None and not opts.urn:
                raise TypeError("Missing required property 'permission_set_arn'")
            __props__.__dict__["permission_set_arn"] = permission_set_arn
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            if target_type is None and not opts.urn:
                raise TypeError("Missing required property 'target_type'")
            __props__.__dict__["target_type"] = target_type
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["instanceArn", "permissionSetArn", "principalId", "principalType", "targetId", "targetType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Assignment, __self__).__init__(
            'aws-native:sso:Assignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Assignment':
        """
        Get an existing Assignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = AssignmentArgs.__new__(AssignmentArgs)

        __props__.__dict__["instance_arn"] = None
        __props__.__dict__["permission_set_arn"] = None
        __props__.__dict__["principal_id"] = None
        __props__.__dict__["principal_type"] = None
        __props__.__dict__["target_id"] = None
        __props__.__dict__["target_type"] = None
        return Assignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceArn")
    def instance_arn(self) -> pulumi.Output[builtins.str]:
        """
        The sso instance that the permission set is owned.
        """
        return pulumi.get(self, "instance_arn")

    @property
    @pulumi.getter(name="permissionSetArn")
    def permission_set_arn(self) -> pulumi.Output[builtins.str]:
        """
        The permission set that the assignemt will be assigned
        """
        return pulumi.get(self, "permission_set_arn")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[builtins.str]:
        """
        The assignee's identifier, user id/group id
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output['AssignmentPrincipalType']:
        """
        The assignee's type, user/group
        """
        return pulumi.get(self, "principal_type")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[builtins.str]:
        """
        The account id to be provisioned.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> pulumi.Output['AssignmentTargetType']:
        """
        The type of resource to be provsioned to, only aws account now
        """
        return pulumi.get(self, "target_type")

