# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = ['ApplicationAssignmentArgs', 'ApplicationAssignment']

@pulumi.input_type
class ApplicationAssignmentArgs:
    def __init__(__self__, *,
                 application_arn: pulumi.Input[builtins.str],
                 principal_id: pulumi.Input[builtins.str],
                 principal_type: pulumi.Input['ApplicationAssignmentPrincipalType']):
        """
        The set of arguments for constructing a ApplicationAssignment resource.
        :param pulumi.Input[builtins.str] application_arn: The ARN of the application.
        :param pulumi.Input[builtins.str] principal_id: An identifier for an object in IAM Identity Center, such as a user or group
        :param pulumi.Input['ApplicationAssignmentPrincipalType'] principal_type: The entity type for which the assignment will be created.
        """
        pulumi.set(__self__, "application_arn", application_arn)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "principal_type", principal_type)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Input[builtins.str]:
        """
        The ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @application_arn.setter
    def application_arn(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "application_arn", value)

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Input[builtins.str]:
        """
        An identifier for an object in IAM Identity Center, such as a user or group
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "principal_id", value)

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Input['ApplicationAssignmentPrincipalType']:
        """
        The entity type for which the assignment will be created.
        """
        return pulumi.get(self, "principal_type")

    @principal_type.setter
    def principal_type(self, value: pulumi.Input['ApplicationAssignmentPrincipalType']):
        pulumi.set(self, "principal_type", value)


@pulumi.type_token("aws-native:sso:ApplicationAssignment")
class ApplicationAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input['ApplicationAssignmentPrincipalType']] = None,
                 __props__=None):
        """
        Resource Type definition for SSO application access grant to a user or group.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_arn: The ARN of the application.
        :param pulumi.Input[builtins.str] principal_id: An identifier for an object in IAM Identity Center, such as a user or group
        :param pulumi.Input['ApplicationAssignmentPrincipalType'] principal_type: The entity type for which the assignment will be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for SSO application access grant to a user or group.

        :param str resource_name: The name of the resource.
        :param ApplicationAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_arn: Optional[pulumi.Input[builtins.str]] = None,
                 principal_id: Optional[pulumi.Input[builtins.str]] = None,
                 principal_type: Optional[pulumi.Input['ApplicationAssignmentPrincipalType']] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationAssignmentArgs.__new__(ApplicationAssignmentArgs)

            if application_arn is None and not opts.urn:
                raise TypeError("Missing required property 'application_arn'")
            __props__.__dict__["application_arn"] = application_arn
            if principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'principal_id'")
            __props__.__dict__["principal_id"] = principal_id
            if principal_type is None and not opts.urn:
                raise TypeError("Missing required property 'principal_type'")
            __props__.__dict__["principal_type"] = principal_type
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["applicationArn", "principalId", "principalType"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ApplicationAssignment, __self__).__init__(
            'aws-native:sso:ApplicationAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ApplicationAssignment':
        """
        Get an existing ApplicationAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationAssignmentArgs.__new__(ApplicationAssignmentArgs)

        __props__.__dict__["application_arn"] = None
        __props__.__dict__["principal_id"] = None
        __props__.__dict__["principal_type"] = None
        return ApplicationAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationArn")
    def application_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the application.
        """
        return pulumi.get(self, "application_arn")

    @property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> pulumi.Output[builtins.str]:
        """
        An identifier for an object in IAM Identity Center, such as a user or group
        """
        return pulumi.get(self, "principal_id")

    @property
    @pulumi.getter(name="principalType")
    def principal_type(self) -> pulumi.Output['ApplicationAssignmentPrincipalType']:
        """
        The entity type for which the assignment will be created.
        """
        return pulumi.get(self, "principal_type")

