# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from ._enums import *

__all__ = [
    'ConfigurationManagerConfigurationDefinition',
    'ConfigurationManagerStatusSummary',
]

@pulumi.output_type
class ConfigurationManagerConfigurationDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localDeploymentAdministrationRoleArn":
            suggest = "local_deployment_administration_role_arn"
        elif key == "localDeploymentExecutionRoleName":
            suggest = "local_deployment_execution_role_name"
        elif key == "typeVersion":
            suggest = "type_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationManagerConfigurationDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationManagerConfigurationDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationManagerConfigurationDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters: Mapping[str, builtins.str],
                 type: builtins.str,
                 id: Optional[builtins.str] = None,
                 local_deployment_administration_role_arn: Optional[builtins.str] = None,
                 local_deployment_execution_role_name: Optional[builtins.str] = None,
                 type_version: Optional[builtins.str] = None):
        """
        :param Mapping[str, builtins.str] parameters: The parameters for the configuration definition type. Parameters for configuration definitions vary based the configuration type. The following lists outline the parameters for each configuration type.
               
               - **AWS Config Recording (Type: AWS QuickSetupType-CFGRecording)** - - `RecordAllResources`
               
               - Description: (Optional) A boolean value that determines whether all supported resources are recorded. The default value is " `true` ".
               - `ResourceTypesToRecord`
               
               - Description: (Optional) A comma separated list of resource types you want to record.
               - `RecordGlobalResourceTypes`
               
               - Description: (Optional) A boolean value that determines whether global resources are recorded with all resource configurations. The default value is " `false` ".
               - `GlobalResourceTypesRegion`
               
               - Description: (Optional) Determines the AWS Region where global resources are recorded.
               - `UseCustomBucket`
               
               - Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for delivery. The default value is " `false` ".
               - `DeliveryBucketName`
               
               - Description: (Optional) The name of the Amazon S3 bucket you want AWS Config to deliver configuration snapshots and configuration history files to.
               - `DeliveryBucketPrefix`
               
               - Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
               - `NotificationOptions`
               
               - Description: (Optional) Determines the notification configuration for the recorder. The valid values are `NoStreaming` , `UseExistingTopic` , and `CreateTopic` . The default value is `NoStreaming` .
               - `CustomDeliveryTopicAccountId`
               
               - Description: (Optional) The ID of the AWS account where the Amazon SNS topic you want to use for notifications resides. You must specify a value for this parameter if you use the `UseExistingTopic` notification option.
               - `CustomDeliveryTopicName`
               
               - Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify a value for this parameter if you use the `UseExistingTopic` notification option.
               - `RemediationSchedule`
               
               - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(7 days)` , `rate(1 days)` , and `none` . The default value is " `none` ".
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Change Manager (Type: AWS QuickSetupType-SSMChangeMgr)** - - `DelegatedAccountId`
               
               - Description: (Required) The ID of the delegated administrator account.
               - `JobFunction`
               
               - Description: (Required) The name for the Change Manager job function.
               - `PermissionType`
               
               - Description: (Optional) Specifies whether you want to use default administrator permissions for the job function role, or provide a custom IAM policy. The valid values are `CustomPermissions` and `AdminPermissions` . The default value for the parameter is `CustomerPermissions` .
               - `CustomPermissions`
               
               - Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must provide a value for this parameter if you specify `CustomPermissions` for the `PermissionType` parameter.
               - `TargetOrganizationalUnits`
               
               - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Conformance Packs (Type: AWS QuickSetupType-CFGCPacks)** - - `DelegatedAccountId`
               
               - Description: (Optional) The ID of the delegated administrator account. This parameter is required for Organization deployments.
               - `RemediationSchedule`
               
               - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(14 days)` , `rate(2 days)` , and `none` . The default value is " `none` ".
               - `CPackNames`
               
               - Description: (Required) A comma separated list of AWS Config conformance packs.
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Default Host Management Configuration (Type: AWS QuickSetupType-DHMC)** - - `UpdateSSMAgent`
               
               - Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " `true` ".
               - `TargetOrganizationalUnits`
               
               - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) The AWS Regions to deploy the configuration to. For this type, the parameter only accepts a value of `AllRegions` .
               - **DevOps Guru (Type: AWS QuickSetupType-DevOpsGuru)** - - `AnalyseAllResources`
               
               - Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all AWS CloudFormation stacks in the account. The default value is " `false` ".
               - `EnableSnsNotifications`
               
               - Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an insight is created. The default value is " `true` ".
               - `EnableSsmOpsItems`
               
               - Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when an insight is created. The default value is " `true` ".
               - `EnableDriftRemediation`
               
               - Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The default value is " `false` ".
               - `RemediationSchedule`
               
               - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(14 days)` , `rate(1 days)` , and `none` . The default value is " `none` ".
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Distributor (Type: AWS QuickSetupType-Distributor)** - - `PackagesToInstall`
               
               - Description: (Required) A comma separated list of packages you want to install on the target instances. The valid values are `AWSEFSTools` , `AWSCWAgent` , and `AWSEC2LaunchAgent` .
               - `RemediationSchedule`
               
               - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(14 days)` , `rate(2 days)` , and `none` . The default value is " `rate(30 days)` ".
               - `IsPolicyAttachAllowed`
               
               - Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " `false` ".
               - `TargetType`
               
               - Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are `*` , `InstanceIds` , `ResourceGroups` , and `Tags` . Use `*` to target all instances in the account.
               - `TargetInstances`
               
               - Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify `InstanceIds` for the `TargetType` parameter.
               - `TargetTagKey`
               
               - Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
               - `TargetTagValue`
               
               - Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
               - `ResourceGroupName`
               
               - Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify `ResourceGroups` for the `TargetType` parameter.
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Host Management (Type: AWS QuickSetupType-SSMHostMgmt)** - - `UpdateSSMAgent`
               
               - Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " `true` ".
               - `UpdateEc2LaunchAgent`
               
               - Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target instances every month. The default value is " `false` ".
               - `CollectInventory`
               
               - Description: (Optional) A boolean value that determines whether instance metadata is collected on the target instances every 30 minutes. The default value is " `true` ".
               - `ScanInstances`
               
               - Description: (Optional) A boolean value that determines whether the target instances are scanned daily for available patches. The default value is " `true` ".
               - `InstallCloudWatchAgent`
               
               - Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on the target instances. The default value is " `false` ".
               - `UpdateCloudWatchAgent`
               
               - Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the target instances every month. The default value is " `false` ".
               - `IsPolicyAttachAllowed`
               
               - Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " `false` ".
               - `TargetType`
               
               - Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are `*` , `InstanceIds` , `ResourceGroups` , and `Tags` . Use `*` to target all instances in the account.
               - `TargetInstances`
               
               - Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify `InstanceIds` for the `TargetType` parameter.
               - `TargetTagKey`
               
               - Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
               - `TargetTagValue`
               
               - Description: (Optional) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
               - `ResourceGroupName`
               
               - Description: (Optional) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify `ResourceGroups` for the `TargetType` parameter.
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **OpsCenter (Type: AWS QuickSetupType-SSMOpsCenter)** - - `DelegatedAccountId`
               
               - Description: (Required) The ID of the delegated administrator account.
               - `TargetOrganizationalUnits`
               
               - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Patch Policy (Type: AWS QuickSetupType-PatchPolicy)** - - `PatchPolicyName`
               
               - Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2 instances as a tag.
               - `SelectedPatchBaselines`
               
               - Description: (Required) An array of JSON objects containing the information for the patch baselines to include in your patch policy.
               - `PatchBaselineUseDefault`
               
               - Description: (Optional) A value that determines whether the selected patch baselines are all AWS provided. Supported values are `default` and `custom` .
               - `PatchBaselineRegion`
               
               - Description: (Required) The AWS Region where the patch baseline exist.
               - `ConfigurationOptionsPatchOperation`
               
               - Description: (Optional) Determines whether target instances scan for available patches, or scan and install available patches. The valid values are `Scan` and `ScanAndInstall` . The default value for the parameter is `Scan` .
               - `ConfigurationOptionsScanValue`
               
               - Description: (Optional) A cron expression that is used as the schedule for when instances scan for available patches.
               - `ConfigurationOptionsInstallValue`
               
               - Description: (Optional) A cron expression that is used as the schedule for when instances install available patches.
               - `ConfigurationOptionsScanNextInterval`
               
               - Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " `false` ".
               - `ConfigurationOptionsInstallNextInterval`
               
               - Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " `false` ".
               - `RebootOption`
               
               - Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values are `RebootIfNeeded` and `NoReboot` .
               - `IsPolicyAttachAllowed`
               
               - Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " `false` ".
               - `OutputLogEnableS3`
               
               - Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.
               - `OutputS3Location`
               
               - Description: (Optional) Information about the Amazon S3 bucket where you want to store the output details of the request.
               
               - `OutputBucketRegion`
               
               - Description: (Optional) The AWS Region where the Amazon S3 bucket you want to deliver command output to is located.
               - `OutputS3BucketName`
               
               - Description: (Optional) The name of the Amazon S3 bucket you want to deliver command output to.
               - `OutputS3KeyPrefix`
               
               - Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
               - `TargetType`
               
               - Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are `*` , `InstanceIds` , `ResourceGroups` , and `Tags` . Use `*` to target all instances in the account.
               - `TargetInstances`
               
               - Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify `InstanceIds` for the `TargetType` parameter.
               - `TargetTagKey`
               
               - Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
               - `TargetTagValue`
               
               - Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
               - `ResourceGroupName`
               
               - Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify `ResourceGroups` for the `TargetType` parameter.
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Resource Explorer (Type: AWS QuickSetupType-ResourceExplorer)** - - `SelectedAggregatorRegion`
               
               - Description: (Required) The AWS Region where you want to create the aggregator index.
               - `ReplaceExistingAggregator`
               
               - Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in a Region that differs from the value you specify for the `SelectedAggregatorRegion` .
               - `TargetOrganizationalUnits`
               
               - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
               - **Resource Scheduler (Type: AWS QuickSetupType-Scheduler)** - - `TargetTagKey`
               
               - Description: (Required) The tag key assigned to the instances you want to target.
               - `TargetTagValue`
               
               - Description: (Required) The value of the tag key assigned to the instances you want to target.
               - `ICalendarString`
               
               - Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.
               - `TargetAccounts`
               
               - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
               - `TargetOrganizationalUnits`
               
               - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
               - `TargetRegions`
               
               - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        :param builtins.str type: The type of the Quick Setup configuration.
        :param builtins.str id: The ID of the configuration definition.
        :param builtins.str local_deployment_administration_role_arn: The ARN of the IAM role used to administrate local configuration deployments.
               
               > Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than `AWSQuickSetupType-PatchPolicy` . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
        :param builtins.str local_deployment_execution_role_name: The name of the IAM role used to deploy local configurations.
               
               > Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than `AWSQuickSetupType-PatchPolicy` . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
        :param builtins.str type_version: The version of the Quick Setup type used.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if local_deployment_administration_role_arn is not None:
            pulumi.set(__self__, "local_deployment_administration_role_arn", local_deployment_administration_role_arn)
        if local_deployment_execution_role_name is not None:
            pulumi.set(__self__, "local_deployment_execution_role_name", local_deployment_execution_role_name)
        if type_version is not None:
            pulumi.set(__self__, "type_version", type_version)

    @property
    @pulumi.getter
    def parameters(self) -> Mapping[str, builtins.str]:
        """
        The parameters for the configuration definition type. Parameters for configuration definitions vary based the configuration type. The following lists outline the parameters for each configuration type.

        - **AWS Config Recording (Type: AWS QuickSetupType-CFGRecording)** - - `RecordAllResources`

        - Description: (Optional) A boolean value that determines whether all supported resources are recorded. The default value is " `true` ".
        - `ResourceTypesToRecord`

        - Description: (Optional) A comma separated list of resource types you want to record.
        - `RecordGlobalResourceTypes`

        - Description: (Optional) A boolean value that determines whether global resources are recorded with all resource configurations. The default value is " `false` ".
        - `GlobalResourceTypesRegion`

        - Description: (Optional) Determines the AWS Region where global resources are recorded.
        - `UseCustomBucket`

        - Description: (Optional) A boolean value that determines whether a custom Amazon S3 bucket is used for delivery. The default value is " `false` ".
        - `DeliveryBucketName`

        - Description: (Optional) The name of the Amazon S3 bucket you want AWS Config to deliver configuration snapshots and configuration history files to.
        - `DeliveryBucketPrefix`

        - Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
        - `NotificationOptions`

        - Description: (Optional) Determines the notification configuration for the recorder. The valid values are `NoStreaming` , `UseExistingTopic` , and `CreateTopic` . The default value is `NoStreaming` .
        - `CustomDeliveryTopicAccountId`

        - Description: (Optional) The ID of the AWS account where the Amazon SNS topic you want to use for notifications resides. You must specify a value for this parameter if you use the `UseExistingTopic` notification option.
        - `CustomDeliveryTopicName`

        - Description: (Optional) The name of the Amazon SNS topic you want to use for notifications. You must specify a value for this parameter if you use the `UseExistingTopic` notification option.
        - `RemediationSchedule`

        - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(7 days)` , `rate(1 days)` , and `none` . The default value is " `none` ".
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Change Manager (Type: AWS QuickSetupType-SSMChangeMgr)** - - `DelegatedAccountId`

        - Description: (Required) The ID of the delegated administrator account.
        - `JobFunction`

        - Description: (Required) The name for the Change Manager job function.
        - `PermissionType`

        - Description: (Optional) Specifies whether you want to use default administrator permissions for the job function role, or provide a custom IAM policy. The valid values are `CustomPermissions` and `AdminPermissions` . The default value for the parameter is `CustomerPermissions` .
        - `CustomPermissions`

        - Description: (Optional) A JSON string containing the IAM policy you want your job function to use. You must provide a value for this parameter if you specify `CustomPermissions` for the `PermissionType` parameter.
        - `TargetOrganizationalUnits`

        - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Conformance Packs (Type: AWS QuickSetupType-CFGCPacks)** - - `DelegatedAccountId`

        - Description: (Optional) The ID of the delegated administrator account. This parameter is required for Organization deployments.
        - `RemediationSchedule`

        - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(14 days)` , `rate(2 days)` , and `none` . The default value is " `none` ".
        - `CPackNames`

        - Description: (Required) A comma separated list of AWS Config conformance packs.
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) The ID of the root of your Organization. This configuration type doesn't currently support choosing specific OUs. The configuration will be deployed to all the OUs in the Organization.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Default Host Management Configuration (Type: AWS QuickSetupType-DHMC)** - - `UpdateSSMAgent`

        - Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " `true` ".
        - `TargetOrganizationalUnits`

        - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) The AWS Regions to deploy the configuration to. For this type, the parameter only accepts a value of `AllRegions` .
        - **DevOps Guru (Type: AWS QuickSetupType-DevOpsGuru)** - - `AnalyseAllResources`

        - Description: (Optional) A boolean value that determines whether DevOps Guru analyzes all AWS CloudFormation stacks in the account. The default value is " `false` ".
        - `EnableSnsNotifications`

        - Description: (Optional) A boolean value that determines whether DevOps Guru sends notifications when an insight is created. The default value is " `true` ".
        - `EnableSsmOpsItems`

        - Description: (Optional) A boolean value that determines whether DevOps Guru creates an OpsCenter OpsItem when an insight is created. The default value is " `true` ".
        - `EnableDriftRemediation`

        - Description: (Optional) A boolean value that determines whether a drift remediation schedule is used. The default value is " `false` ".
        - `RemediationSchedule`

        - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(14 days)` , `rate(1 days)` , and `none` . The default value is " `none` ".
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Distributor (Type: AWS QuickSetupType-Distributor)** - - `PackagesToInstall`

        - Description: (Required) A comma separated list of packages you want to install on the target instances. The valid values are `AWSEFSTools` , `AWSCWAgent` , and `AWSEC2LaunchAgent` .
        - `RemediationSchedule`

        - Description: (Optional) A rate expression that defines the schedule for drift remediation. The valid values are `rate(30 days)` , `rate(14 days)` , `rate(2 days)` , and `none` . The default value is " `rate(30 days)` ".
        - `IsPolicyAttachAllowed`

        - Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " `false` ".
        - `TargetType`

        - Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are `*` , `InstanceIds` , `ResourceGroups` , and `Tags` . Use `*` to target all instances in the account.
        - `TargetInstances`

        - Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify `InstanceIds` for the `TargetType` parameter.
        - `TargetTagKey`

        - Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
        - `TargetTagValue`

        - Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
        - `ResourceGroupName`

        - Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify `ResourceGroups` for the `TargetType` parameter.
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Host Management (Type: AWS QuickSetupType-SSMHostMgmt)** - - `UpdateSSMAgent`

        - Description: (Optional) A boolean value that determines whether the SSM Agent is updated on the target instances every 2 weeks. The default value is " `true` ".
        - `UpdateEc2LaunchAgent`

        - Description: (Optional) A boolean value that determines whether the EC2 Launch agent is updated on the target instances every month. The default value is " `false` ".
        - `CollectInventory`

        - Description: (Optional) A boolean value that determines whether instance metadata is collected on the target instances every 30 minutes. The default value is " `true` ".
        - `ScanInstances`

        - Description: (Optional) A boolean value that determines whether the target instances are scanned daily for available patches. The default value is " `true` ".
        - `InstallCloudWatchAgent`

        - Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is installed on the target instances. The default value is " `false` ".
        - `UpdateCloudWatchAgent`

        - Description: (Optional) A boolean value that determines whether the Amazon CloudWatch agent is updated on the target instances every month. The default value is " `false` ".
        - `IsPolicyAttachAllowed`

        - Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " `false` ".
        - `TargetType`

        - Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are `*` , `InstanceIds` , `ResourceGroups` , and `Tags` . Use `*` to target all instances in the account.
        - `TargetInstances`

        - Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify `InstanceIds` for the `TargetType` parameter.
        - `TargetTagKey`

        - Description: (Optional) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
        - `TargetTagValue`

        - Description: (Optional) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
        - `ResourceGroupName`

        - Description: (Optional) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify `ResourceGroups` for the `TargetType` parameter.
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **OpsCenter (Type: AWS QuickSetupType-SSMOpsCenter)** - - `DelegatedAccountId`

        - Description: (Required) The ID of the delegated administrator account.
        - `TargetOrganizationalUnits`

        - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Patch Policy (Type: AWS QuickSetupType-PatchPolicy)** - - `PatchPolicyName`

        - Description: (Required) A name for the patch policy. The value you provide is applied to target Amazon EC2 instances as a tag.
        - `SelectedPatchBaselines`

        - Description: (Required) An array of JSON objects containing the information for the patch baselines to include in your patch policy.
        - `PatchBaselineUseDefault`

        - Description: (Optional) A value that determines whether the selected patch baselines are all AWS provided. Supported values are `default` and `custom` .
        - `PatchBaselineRegion`

        - Description: (Required) The AWS Region where the patch baseline exist.
        - `ConfigurationOptionsPatchOperation`

        - Description: (Optional) Determines whether target instances scan for available patches, or scan and install available patches. The valid values are `Scan` and `ScanAndInstall` . The default value for the parameter is `Scan` .
        - `ConfigurationOptionsScanValue`

        - Description: (Optional) A cron expression that is used as the schedule for when instances scan for available patches.
        - `ConfigurationOptionsInstallValue`

        - Description: (Optional) A cron expression that is used as the schedule for when instances install available patches.
        - `ConfigurationOptionsScanNextInterval`

        - Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " `false` ".
        - `ConfigurationOptionsInstallNextInterval`

        - Description: (Optional) A boolean value that determines whether instances should scan for available patches at the next cron interval. The default value is " `false` ".
        - `RebootOption`

        - Description: (Optional) Determines whether instances are rebooted after patches are installed. Valid values are `RebootIfNeeded` and `NoReboot` .
        - `IsPolicyAttachAllowed`

        - Description: (Optional) A boolean value that determines whether Quick Setup attaches policies to instances profiles already associated with the target instances. The default value is " `false` ".
        - `OutputLogEnableS3`

        - Description: (Optional) A boolean value that determines whether command output logs are sent to Amazon S3.
        - `OutputS3Location`

        - Description: (Optional) Information about the Amazon S3 bucket where you want to store the output details of the request.

        - `OutputBucketRegion`

        - Description: (Optional) The AWS Region where the Amazon S3 bucket you want to deliver command output to is located.
        - `OutputS3BucketName`

        - Description: (Optional) The name of the Amazon S3 bucket you want to deliver command output to.
        - `OutputS3KeyPrefix`

        - Description: (Optional) The key prefix you want to use in the custom Amazon S3 bucket.
        - `TargetType`

        - Description: (Optional) Determines how instances are targeted for local account deployments. Don't specify a value for this parameter if you're deploying to OUs. The valid values are `*` , `InstanceIds` , `ResourceGroups` , and `Tags` . Use `*` to target all instances in the account.
        - `TargetInstances`

        - Description: (Optional) A comma separated list of instance IDs. You must provide a value for this parameter if you specify `InstanceIds` for the `TargetType` parameter.
        - `TargetTagKey`

        - Description: (Required) The tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
        - `TargetTagValue`

        - Description: (Required) The value of the tag key assigned to the instances you want to target. You must provide a value for this parameter if you specify `Tags` for the `TargetType` parameter.
        - `ResourceGroupName`

        - Description: (Required) The name of the resource group associated with the instances you want to target. You must provide a value for this parameter if you specify `ResourceGroups` for the `TargetType` parameter.
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Resource Explorer (Type: AWS QuickSetupType-ResourceExplorer)** - - `SelectedAggregatorRegion`

        - Description: (Required) The AWS Region where you want to create the aggregator index.
        - `ReplaceExistingAggregator`

        - Description: (Required) A boolean value that determines whether to demote an existing aggregator if it is in a Region that differs from the value you specify for the `SelectedAggregatorRegion` .
        - `TargetOrganizationalUnits`

        - Description: (Required) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        - **Resource Scheduler (Type: AWS QuickSetupType-Scheduler)** - - `TargetTagKey`

        - Description: (Required) The tag key assigned to the instances you want to target.
        - `TargetTagValue`

        - Description: (Required) The value of the tag key assigned to the instances you want to target.
        - `ICalendarString`

        - Description: (Required) An iCalendar formatted string containing the schedule you want Change Manager to use.
        - `TargetAccounts`

        - Description: (Optional) The ID of the AWS account initiating the configuration deployment. You only need to provide a value for this parameter if you want to deploy the configuration locally. A value must be provided for either `TargetAccounts` or `TargetOrganizationalUnits` .
        - `TargetOrganizationalUnits`

        - Description: (Optional) A comma separated list of organizational units (OUs) you want to deploy the configuration to.
        - `TargetRegions`

        - Description: (Required) A comma separated list of AWS Regions you want to deploy the configuration to.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the Quick Setup configuration.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        The ID of the configuration definition.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localDeploymentAdministrationRoleArn")
    def local_deployment_administration_role_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the IAM role used to administrate local configuration deployments.

        > Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than `AWSQuickSetupType-PatchPolicy` . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
        """
        return pulumi.get(self, "local_deployment_administration_role_arn")

    @property
    @pulumi.getter(name="localDeploymentExecutionRoleName")
    def local_deployment_execution_role_name(self) -> Optional[builtins.str]:
        """
        The name of the IAM role used to deploy local configurations.

        > Although this element is listed as "Required: No", a value can be omitted only for organizational deployments of types other than `AWSQuickSetupType-PatchPolicy` . A value must be provided when you are running an organizational deployment for a patch policy or running any type of deployment for a single account.
        """
        return pulumi.get(self, "local_deployment_execution_role_name")

    @property
    @pulumi.getter(name="typeVersion")
    def type_version(self) -> Optional[builtins.str]:
        """
        The version of the Quick Setup type used.
        """
        return pulumi.get(self, "type_version")


@pulumi.output_type
class ConfigurationManagerStatusSummary(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lastUpdatedAt":
            suggest = "last_updated_at"
        elif key == "statusType":
            suggest = "status_type"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "statusMessage":
            suggest = "status_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigurationManagerStatusSummary. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigurationManagerStatusSummary.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigurationManagerStatusSummary.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 last_updated_at: builtins.str,
                 status_type: 'ConfigurationManagerStatusType',
                 status: Optional['ConfigurationManagerStatus'] = None,
                 status_details: Optional[Mapping[str, builtins.str]] = None,
                 status_message: Optional[builtins.str] = None):
        """
        :param builtins.str last_updated_at: The datetime stamp when the status was last updated.
        :param 'ConfigurationManagerStatusType' status_type: The type of a status summary.
        :param 'ConfigurationManagerStatus' status: The current status.
        :param Mapping[str, builtins.str] status_details: Details about the status.
        :param builtins.str status_message: When applicable, returns an informational message relevant to the current status and status type of the status summary object. We don't recommend implementing parsing logic around this value since the messages returned can vary in format.
        """
        pulumi.set(__self__, "last_updated_at", last_updated_at)
        pulumi.set(__self__, "status_type", status_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_details is not None:
            pulumi.set(__self__, "status_details", status_details)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)

    @property
    @pulumi.getter(name="lastUpdatedAt")
    def last_updated_at(self) -> builtins.str:
        """
        The datetime stamp when the status was last updated.
        """
        return pulumi.get(self, "last_updated_at")

    @property
    @pulumi.getter(name="statusType")
    def status_type(self) -> 'ConfigurationManagerStatusType':
        """
        The type of a status summary.
        """
        return pulumi.get(self, "status_type")

    @property
    @pulumi.getter
    def status(self) -> Optional['ConfigurationManagerStatus']:
        """
        The current status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Details about the status.
        """
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[builtins.str]:
        """
        When applicable, returns an informational message relevant to the current status and status type of the status summary object. We don't recommend implementing parsing logic around this value since the messages returned can vary in format.
        """
        return pulumi.get(self, "status_message")


