# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetConfigurationManagerResult',
    'AwaitableGetConfigurationManagerResult',
    'get_configuration_manager',
    'get_configuration_manager_output',
]

@pulumi.output_type
class GetConfigurationManagerResult:
    def __init__(__self__, configuration_definitions=None, created_at=None, description=None, last_modified_at=None, manager_arn=None, name=None, status_summaries=None, tags=None):
        if configuration_definitions and not isinstance(configuration_definitions, list):
            raise TypeError("Expected argument 'configuration_definitions' to be a list")
        pulumi.set(__self__, "configuration_definitions", configuration_definitions)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if last_modified_at and not isinstance(last_modified_at, str):
            raise TypeError("Expected argument 'last_modified_at' to be a str")
        pulumi.set(__self__, "last_modified_at", last_modified_at)
        if manager_arn and not isinstance(manager_arn, str):
            raise TypeError("Expected argument 'manager_arn' to be a str")
        pulumi.set(__self__, "manager_arn", manager_arn)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status_summaries and not isinstance(status_summaries, list):
            raise TypeError("Expected argument 'status_summaries' to be a list")
        pulumi.set(__self__, "status_summaries", status_summaries)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="configurationDefinitions")
    def configuration_definitions(self) -> Optional[Sequence['outputs.ConfigurationManagerConfigurationDefinition']]:
        """
        The definition of the Quick Setup configuration that the configuration manager deploys.
        """
        return pulumi.get(self, "configuration_definitions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        The datetime stamp when the configuration manager was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        The description of the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> Optional[builtins.str]:
        """
        The datetime stamp when the configuration manager was last updated.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="managerArn")
    def manager_arn(self) -> Optional[builtins.str]:
        """
        The ARN of the Quick Setup configuration.
        """
        return pulumi.get(self, "manager_arn")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> Optional[Sequence['outputs.ConfigurationManagerStatusSummary']]:
        """
        Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses from the configuration definition associated with the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more.
        """
        return pulumi.get(self, "status_summaries")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Key-value pairs of metadata to assign to the configuration manager.
        """
        return pulumi.get(self, "tags")


class AwaitableGetConfigurationManagerResult(GetConfigurationManagerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigurationManagerResult(
            configuration_definitions=self.configuration_definitions,
            created_at=self.created_at,
            description=self.description,
            last_modified_at=self.last_modified_at,
            manager_arn=self.manager_arn,
            name=self.name,
            status_summaries=self.status_summaries,
            tags=self.tags)


def get_configuration_manager(manager_arn: Optional[builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigurationManagerResult:
    """
    Definition of AWS::SSMQuickSetup::ConfigurationManager Resource Type


    :param builtins.str manager_arn: The ARN of the Quick Setup configuration.
    """
    __args__ = dict()
    __args__['managerArn'] = manager_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:ssmquicksetup:getConfigurationManager', __args__, opts=opts, typ=GetConfigurationManagerResult).value

    return AwaitableGetConfigurationManagerResult(
        configuration_definitions=pulumi.get(__ret__, 'configuration_definitions'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        last_modified_at=pulumi.get(__ret__, 'last_modified_at'),
        manager_arn=pulumi.get(__ret__, 'manager_arn'),
        name=pulumi.get(__ret__, 'name'),
        status_summaries=pulumi.get(__ret__, 'status_summaries'),
        tags=pulumi.get(__ret__, 'tags'))
def get_configuration_manager_output(manager_arn: Optional[pulumi.Input[builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetConfigurationManagerResult]:
    """
    Definition of AWS::SSMQuickSetup::ConfigurationManager Resource Type


    :param builtins.str manager_arn: The ARN of the Quick Setup configuration.
    """
    __args__ = dict()
    __args__['managerArn'] = manager_arn
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('aws-native:ssmquicksetup:getConfigurationManager', __args__, opts=opts, typ=GetConfigurationManagerResult)
    return __ret__.apply(lambda __response__: GetConfigurationManagerResult(
        configuration_definitions=pulumi.get(__response__, 'configuration_definitions'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        last_modified_at=pulumi.get(__response__, 'last_modified_at'),
        manager_arn=pulumi.get(__response__, 'manager_arn'),
        name=pulumi.get(__response__, 'name'),
        status_summaries=pulumi.get(__response__, 'status_summaries'),
        tags=pulumi.get(__response__, 'tags')))
