# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['ConfigurationManagerArgs', 'ConfigurationManager']

@pulumi.input_type
class ConfigurationManagerArgs:
    def __init__(__self__, *,
                 configuration_definitions: pulumi.Input[Sequence[pulumi.Input['ConfigurationManagerConfigurationDefinitionArgs']]],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ConfigurationManager resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationManagerConfigurationDefinitionArgs']]] configuration_definitions: The definition of the Quick Setup configuration that the configuration manager deploys.
        :param pulumi.Input[builtins.str] description: The description of the configuration.
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of metadata to assign to the configuration manager.
        """
        pulumi.set(__self__, "configuration_definitions", configuration_definitions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="configurationDefinitions")
    def configuration_definitions(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigurationManagerConfigurationDefinitionArgs']]]:
        """
        The definition of the Quick Setup configuration that the configuration manager deploys.
        """
        return pulumi.get(self, "configuration_definitions")

    @configuration_definitions.setter
    def configuration_definitions(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigurationManagerConfigurationDefinitionArgs']]]):
        pulumi.set(self, "configuration_definitions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the configuration.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Key-value pairs of metadata to assign to the configuration manager.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("aws-native:ssmquicksetup:ConfigurationManager")
class ConfigurationManager(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationManagerConfigurationDefinitionArgs', 'ConfigurationManagerConfigurationDefinitionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Definition of AWS::SSMQuickSetup::ConfigurationManager Resource Type

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationManagerConfigurationDefinitionArgs', 'ConfigurationManagerConfigurationDefinitionArgsDict']]]] configuration_definitions: The definition of the Quick Setup configuration that the configuration manager deploys.
        :param pulumi.Input[builtins.str] description: The description of the configuration.
        :param pulumi.Input[builtins.str] name: The name of the configuration
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: Key-value pairs of metadata to assign to the configuration manager.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigurationManagerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Definition of AWS::SSMQuickSetup::ConfigurationManager Resource Type

        :param str resource_name: The name of the resource.
        :param ConfigurationManagerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigurationManagerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_definitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConfigurationManagerConfigurationDefinitionArgs', 'ConfigurationManagerConfigurationDefinitionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigurationManagerArgs.__new__(ConfigurationManagerArgs)

            if configuration_definitions is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_definitions'")
            __props__.__dict__["configuration_definitions"] = configuration_definitions
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created_at"] = None
            __props__.__dict__["last_modified_at"] = None
            __props__.__dict__["manager_arn"] = None
            __props__.__dict__["status_summaries"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["configurationDefinitions[*].type", "configurationDefinitions[*].typeVersion"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(ConfigurationManager, __self__).__init__(
            'aws-native:ssmquicksetup:ConfigurationManager',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ConfigurationManager':
        """
        Get an existing ConfigurationManager resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ConfigurationManagerArgs.__new__(ConfigurationManagerArgs)

        __props__.__dict__["configuration_definitions"] = None
        __props__.__dict__["created_at"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["last_modified_at"] = None
        __props__.__dict__["manager_arn"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["status_summaries"] = None
        __props__.__dict__["tags"] = None
        return ConfigurationManager(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="configurationDefinitions")
    def configuration_definitions(self) -> pulumi.Output[Sequence['outputs.ConfigurationManagerConfigurationDefinition']]:
        """
        The definition of the Quick Setup configuration that the configuration manager deploys.
        """
        return pulumi.get(self, "configuration_definitions")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The datetime stamp when the configuration manager was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the configuration.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[builtins.str]:
        """
        The datetime stamp when the configuration manager was last updated.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="managerArn")
    def manager_arn(self) -> pulumi.Output[builtins.str]:
        """
        The ARN of the Quick Setup configuration.
        """
        return pulumi.get(self, "manager_arn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the configuration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="statusSummaries")
    def status_summaries(self) -> pulumi.Output[Sequence['outputs.ConfigurationManagerStatusSummary']]:
        """
        Summaries of the state of the configuration manager. These summaries include an aggregate of the statuses from the configuration definition associated with the configuration manager. This includes deployment statuses, association statuses, drift statuses, health checks, and more.
        """
        return pulumi.get(self, "status_summaries")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Key-value pairs of metadata to assign to the configuration manager.
        """
        return pulumi.get(self, "tags")

